/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.client.AllConnectionsInUseException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.internal.cache.tier.sockets.Part;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import org.apache.logging.log4j.Logger;

public class DestroyOp {
    private static final Logger logger = LogService.getLogger();
    public static final int HAS_VERSION_TAG = 1;
    public static final int HAS_ENTRY_NOT_FOUND_PART = 2;
    public static boolean TEST_HOOK_ENTRY_NOT_FOUND;

    public static Object execute(ExecutablePool pool, LocalRegion region, Object key2, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg, boolean prSingleHopEnabled) {
        DestroyOpImpl op;
        block7: {
            ClientMetadataService cms;
            ServerLocation server;
            if (logger.isDebugEnabled()) {
                logger.debug("Preparing DestroyOp for {} operation={}", key2, operation);
            }
            op = new DestroyOpImpl(region, key2, expectedOldValue, operation, event, callbackArg, prSingleHopEnabled);
            if (prSingleHopEnabled && (server = (cms = region.getCache().getClientMetadataService()).getBucketServerLocation(region, Operation.DESTROY, key2, null, callbackArg)) != null) {
                try {
                    PoolImpl poolImpl = (PoolImpl)pool;
                    boolean onlyUseExistingCnx = poolImpl.getMaxConnections() != -1 && poolImpl.getConnectionCount() >= poolImpl.getMaxConnections();
                    return pool.executeOn(server, op, true, onlyUseExistingCnx);
                }
                catch (AllConnectionsInUseException e) {
                }
                catch (ServerConnectivityException e) {
                    if (e instanceof ServerOperationException) {
                        throw e;
                    }
                    cms.removeBucketServerLocation(server);
                }
                catch (BridgeWriterException e) {
                    if (!(e.getCause() instanceof ServerConnectivityException)) break block7;
                    cms.removeBucketServerLocation(server);
                }
            }
        }
        return pool.execute(op);
    }

    public static void execute(Connection con, ExecutablePool pool, String region, Object key2, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg) {
        DestroyOpImpl op = new DestroyOpImpl(region, key2, expectedOldValue, operation, event, callbackArg);
        pool.executeOn(con, (Op)op);
    }

    private DestroyOp() {
    }

    private static class DestroyOpImpl
    extends AbstractOp {
        Object key = null;
        private LocalRegion region;
        private Operation operation;
        private boolean prSingleHopEnabled = false;
        private Object callbackArg;
        private EntryEventImpl event;

        public DestroyOpImpl(LocalRegion region, Object key2, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg, boolean prSingleHopEnabled) {
            super(9, callbackArg != null ? 6 : 5);
            this.key = key2;
            this.region = region;
            this.operation = operation;
            this.prSingleHopEnabled = prSingleHopEnabled;
            this.callbackArg = callbackArg;
            this.event = event;
            this.getMessage().addStringPart(region.getFullPath());
            this.getMessage().addStringOrObjPart(key2);
            this.getMessage().addObjPart(expectedOldValue);
            this.getMessage().addObjPart(operation == Operation.DESTROY ? null : operation);
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        public DestroyOpImpl(String region, Object key2, Object expectedOldValue, Operation operation, EntryEventImpl event, Object callbackArg) {
            super(9, callbackArg != null ? 6 : 5);
            this.key = key2;
            this.event = event;
            this.getMessage().addStringPart(region);
            this.getMessage().addStringOrObjPart(key2);
            this.getMessage().addObjPart(expectedOldValue);
            this.getMessage().addObjPart(operation == Operation.DESTROY ? null : operation);
            this.getMessage().addBytesPart(event.getEventId().calcBytes());
            if (callbackArg != null) {
                this.getMessage().addObjPart(callbackArg);
            }
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Object processResponse(Message msg, Connection con) throws Exception {
            this.processAck(msg, "destroy");
            boolean isReply = msg.getMessageType() == 6;
            int partIdx = 0;
            int flags = 0;
            if (isReply) {
                if (((flags = msg.getPart(partIdx++).getInt()) & 1) != 0) {
                    VersionTag tag = (VersionTag)msg.getPart(partIdx++).getObject();
                    tag.replaceNullIDs((InternalDistributedMember)con.getEndpoint().getMemberId());
                    this.event.setVersionTag(tag);
                    if (logger.isDebugEnabled()) {
                        logger.debug("received Destroy response with {}", tag);
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("received Destroy response with no version tag");
                }
            }
            if (this.prSingleHopEnabled) {
                Part part;
                byte[] bytesReceived;
                byte version = 0;
                if ((bytesReceived = (part = msg.getPart(partIdx++)).getSerializedForm())[0] != 0 && bytesReceived.length == 2 && this.region != null) {
                    ClientMetadataService cms = null;
                    try {
                        cms = this.region.getCache().getClientMetadataService();
                        version = cms.getMetaDataVersion(this.region, Operation.UPDATE, this.key, null, this.callbackArg);
                    }
                    catch (CacheClosedException e) {
                        return null;
                    }
                    if (bytesReceived[0] != version) {
                        cms.scheduleGetPRMetaData(this.region, false, bytesReceived[1]);
                    }
                }
            } else {
                ++partIdx;
            }
            boolean entryNotFound = false;
            if (msg.getMessageType() == 6 && (flags & 2) != 0) {
                boolean bl = entryNotFound = msg.getPart(partIdx++).getInt() == 1;
                if (logger.isDebugEnabled() && (flags & 2) != 0) {
                    logger.debug("destroy response has entryNotFound={}", entryNotFound);
                }
                if (entryNotFound) {
                    TEST_HOOK_ENTRY_NOT_FOUND = true;
                }
            }
            if (this.operation == Operation.REMOVE && entryNotFound) {
                if (logger.isDebugEnabled()) {
                    logger.debug("received REMOVE response from server with entryNotFound={}", entryNotFound);
                }
                return new EntryNotFoundException(LocalizedStrings.AbstractRegionMap_ENTRY_NOT_FOUND_WITH_EXPECTED_VALUE.toLocalizedString());
            }
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 10;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startDestroy();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endDestroySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endDestroy(start, this.hasTimedOut(), this.hasFailed());
        }

        public String toString() {
            return "DestroyOp:" + this.key;
        }
    }
}

