/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.GatewayEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.GatewayEventImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import java.util.List;

public class GatewayBatchOp {
    public static void executeOn(Connection con, ExecutablePool pool, List events, int batchId, boolean earlyAck) {
        GatewayGFEBatchOpImpl op = null;
        op = new GatewayGFEBatchOpImpl(events, batchId, earlyAck, con.getDistributedSystemId());
        pool.executeOn(con, op, true);
    }

    private GatewayBatchOp() {
    }

    private static class GatewayGFEBatchOpImpl
    extends AbstractOp {
        public GatewayGFEBatchOpImpl(List events, int batchId, boolean earlyAck, int dsid) {
            super(19, GatewayGFEBatchOpImpl.calcPartCount(events));
            this.getMessage().setEarlyAck(earlyAck);
            this.getMessage().addIntPart(events.size());
            this.getMessage().addIntPart(batchId);
            for (GatewayEventImpl event : events) {
                int action = event.getAction();
                this.getMessage().addIntPart(action);
                byte posDupByte = (byte)(event.getPossibleDuplicate() ? 1 : 0);
                this.getMessage().addBytesPart(new byte[]{posDupByte});
                if (action < 0 || action > 2) continue;
                String regionName = event.getRegionName();
                EventID eventId = event.getEventId();
                Object key2 = event.getKey();
                GatewayEventCallbackArgument callbackArg = event.getGatewayCallbackArgument();
                this.getMessage().addStringPart(regionName);
                this.getMessage().addObjPart(eventId);
                this.getMessage().addStringOrObjPart(key2);
                if (action != 2) {
                    byte[] value2 = event.getValue();
                    byte valueIsObject = event.getValueIsObject();
                    this.getMessage().addRawPart(value2, valueIsObject == 1);
                }
                if (callbackArg == null) {
                    this.getMessage().addBytesPart(new byte[]{0});
                    continue;
                }
                this.getMessage().addBytesPart(new byte[]{1});
                this.getMessage().addObjPart(callbackArg);
            }
        }

        private static int calcPartCount(List events) {
            int numberOfParts = 2;
            for (GatewayEventImpl event : events) {
                numberOfParts += event.getNumberOfParts();
            }
            return numberOfParts;
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "gatewayBatch");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGatewayBatch();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGatewayBatchSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGatewayBatch(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

