/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.EntrySnapshot;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class GetEntryOp {
    public static Object execute(ExecutablePool pool, LocalRegion region, Object key2) {
        GetEntryOpImpl op = new GetEntryOpImpl(region, key2);
        return pool.execute(op);
    }

    static class GetEntryOpImpl
    extends AbstractOp {
        private LocalRegion region;
        private Object key;

        public GetEntryOpImpl(LocalRegion region, Object key2) {
            super(89, 2);
            this.region = region;
            this.key = key2;
            this.getMessage().addStringPart(region.getFullPath());
            this.getMessage().addStringOrObjPart(key2);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            EntrySnapshot snap = (EntrySnapshot)this.processObjResponse(msg, "getEntry");
            if (snap != null) {
                snap.region = this.region;
            }
            return snap;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return msgType == 3;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetEntry();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetEntrySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetEntry(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

