/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;
import com.gemstone.gemfire.pdx.internal.PdxType;

public class GetPDXTypeByIdOp {
    public static PdxType execute(ExecutablePool pool, int pdxId) {
        GetPDXTypeByIdOpImpl op = new GetPDXTypeByIdOpImpl(pdxId);
        return (PdxType)pool.execute(op);
    }

    private GetPDXTypeByIdOp() {
    }

    private static class GetPDXTypeByIdOpImpl
    extends AbstractOp {
        public GetPDXTypeByIdOpImpl(int pdxId) {
            super(92, 1);
            this.getMessage().addIntPart(pdxId);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            return this.processObjResponse(msg, "getPDXTypeById");
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startGetPDXTypeById();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endGetPDXTypeByIdSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endGetPDXTypeById(start, this.hasTimedOut(), this.hasFailed());
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected boolean participateInTransaction() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }
    }
}

