/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class MakePrimaryOp {
    public static void execute(ExecutablePool pool, Connection conn, boolean sentClientReady) {
        MakePrimaryOpImpl op = new MakePrimaryOpImpl(sentClientReady);
        pool.executeOn(conn, (Op)op);
    }

    private MakePrimaryOp() {
    }

    private static class MakePrimaryOpImpl
    extends AbstractOp {
        public MakePrimaryOpImpl(boolean sentClientReady) {
            super(31, 1);
            this.getMessage().addBytesPart(new byte[]{(byte)(sentClientReady ? 1 : 0)});
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "makePrimary");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startMakePrimary();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endMakePrimarySend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endMakePrimary(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

