/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.CopyException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.SerializationException;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.SynchronizationCommitConflictException;
import com.gemstone.gemfire.cache.TransactionException;
import com.gemstone.gemfire.cache.client.NoAvailableServersException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.ServerRefusedConnectionException;
import com.gemstone.gemfire.cache.client.SubscriptionNotEnabledException;
import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.AuthenticateUserOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.Endpoint;
import com.gemstone.gemfire.cache.client.internal.EndpointManager;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.ExecuteFunctionOp;
import com.gemstone.gemfire.cache.client.internal.ExecuteRegionFunctionOp;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.PingOp;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.QueueManager;
import com.gemstone.gemfire.cache.client.internal.RegisterInterestTracker;
import com.gemstone.gemfire.cache.client.internal.TXFailoverOp;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.client.internal.pooling.ConnectionDestroyedException;
import com.gemstone.gemfire.cache.client.internal.pooling.ConnectionManager;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.FunctionInvocationTargetException;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.PoolManagerImpl;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.tier.BatchException;
import com.gemstone.gemfire.internal.cache.wan.BatchException70;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.security.AuthenticationRequiredException;
import com.gemstone.gemfire.security.GemFireSecurityException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.BufferUnderflowException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class OpExecutorImpl
implements ExecutablePool {
    private static final Logger logger = LogService.getLogger();
    private static final boolean TRY_SERVERS_ONCE = Boolean.getBoolean("gemfire.PoolImpl.TRY_SERVERS_ONCE");
    private static final int TX_RETRY_ATTEMPT = Integer.getInteger("gemfire.txRetryAttempt", 500);
    private final ConnectionManager connectionManager;
    private final int retryAttempts;
    private final long serverTimeout;
    private final boolean threadLocalConnections;
    private final ThreadLocal<Connection> localConnection = new ThreadLocal();
    private final ThreadLocal<Map<ServerLocation, Connection>> localConnectionMap = new ThreadLocal();
    private final EndpointManager endpointManager;
    private final RegisterInterestTracker riTracker;
    private final QueueManager queueManager;
    private final CancelCriterion cancelCriterion;
    private PoolImpl pool;
    private final ThreadLocal<Boolean> serverAffinity = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private boolean serverAffinityFailover = false;
    private final ThreadLocal<ServerLocation> affinityServerLocation = new ThreadLocal();
    private final ThreadLocal<Integer> affinityRetryCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public OpExecutorImpl(ConnectionManager manager, QueueManager queueManager, EndpointManager endpointManager, RegisterInterestTracker riTracker, int retryAttempts, long serverTimeout, boolean threadLocalConnections, CancelCriterion cancelCriterion, PoolImpl pool) {
        this.connectionManager = manager;
        this.queueManager = queueManager;
        this.endpointManager = endpointManager;
        this.riTracker = riTracker;
        this.retryAttempts = retryAttempts;
        this.serverTimeout = serverTimeout;
        this.threadLocalConnections = threadLocalConnections;
        this.cancelCriterion = cancelCriterion;
        this.pool = pool;
    }

    @Override
    public Object execute(Op op) {
        return this.execute(op, this.retryAttempts);
    }

    @Override
    public Object execute(Op op, int retries) {
        Connection conn;
        if (this.serverAffinity.get().booleanValue()) {
            ServerLocation loc = this.affinityServerLocation.get();
            if (loc == null) {
                loc = this.getNextOpServerLocation();
                this.affinityServerLocation.set(loc);
                if (logger.isDebugEnabled()) {
                    logger.debug("setting server affinity to {}", this.affinityServerLocation.get());
                }
            }
            return this.executeWithServerAffinity(loc, op);
        }
        boolean success = false;
        HashSet<ServerLocation> attemptedServers = new HashSet<ServerLocation>();
        Connection connection = conn = this.threadLocalConnections ? this.localConnection.get() : null;
        if (conn == null || conn.isDestroyed()) {
            conn = this.connectionManager.borrowConnection(this.serverTimeout);
        } else if (this.threadLocalConnections) {
            this.localConnection.set(null);
            try {
                this.connectionManager.activate(conn);
            }
            catch (ConnectionDestroyedException ex) {
                conn = this.connectionManager.borrowConnection(this.serverTimeout);
            }
        }
        try {
            int attempt = 0;
            while (true) {
                if (attempt == 1 && op instanceof AbstractOp) {
                    AbstractOp absOp = (AbstractOp)op;
                    absOp.getMessage().setIsRetry();
                }
                try {
                    this.authenticateIfRequired(conn, op);
                    Object result = this.executeWithPossibleReAuthentication(conn, op);
                    success = true;
                    Object object = result;
                    return object;
                }
                catch (Exception e) {
                    block26: {
                        this.handleException(e, conn, attempt, attempt >= retries && retries != -1);
                        attemptedServers.add(conn.getServer());
                        try {
                            conn = this.connectionManager.exchangeConnection(conn, attemptedServers, this.serverTimeout);
                        }
                        catch (NoAvailableServersException nse) {
                            if (retries == -1 || TRY_SERVERS_ONCE) {
                                this.handleException(e, conn, attempt, true);
                                break block26;
                            }
                            attemptedServers.clear();
                            try {
                                conn = this.connectionManager.exchangeConnection(conn, attemptedServers, this.serverTimeout);
                            }
                            catch (NoAvailableServersException nse2) {
                                this.handleException(e, conn, attempt, true);
                            }
                        }
                    }
                    ++attempt;
                    continue;
                }
                break;
            }
        }
        finally {
            if (this.threadLocalConnections) {
                this.connectionManager.passivate(conn, success);
                Connection existingConnection = this.localConnection.get();
                if (existingConnection != null && existingConnection != conn) {
                    this.connectionManager.returnConnection(existingConnection);
                }
                if (!conn.isDestroyed()) {
                    this.localConnection.set(conn);
                } else {
                    this.localConnection.set(null);
                }
            } else {
                this.connectionManager.returnConnection(conn);
            }
        }
    }

    private Object executeWithServerAffinity(ServerLocation loc, Op op) {
        try {
            Object retVal = this.executeOnServer(loc, op, true, false);
            this.affinityRetryCount.set(0);
            return retVal;
        }
        catch (ServerConnectivityException e) {
            int transactionId;
            block12: {
                if (logger.isDebugEnabled()) {
                    logger.debug("caught exception while executing with affinity:{}", e.getMessage(), e);
                }
                if (!this.serverAffinityFailover || e instanceof ServerOperationException) {
                    this.affinityRetryCount.set(0);
                    throw e;
                }
                int retryCount = this.affinityRetryCount.get();
                if (this.retryAttempts != -1 && retryCount >= this.retryAttempts || retryCount > TX_RETRY_ATTEMPT) {
                    this.affinityRetryCount.set(0);
                    throw e;
                }
                this.affinityRetryCount.set(retryCount + 1);
                this.affinityServerLocation.set(null);
                if (logger.isDebugEnabled()) {
                    logger.debug("reset server affinity: attempting txFailover");
                }
                AbstractOp absOp = (AbstractOp)op;
                absOp.getMessage().setIsRetry();
                transactionId = absOp.getMessage().getTransactionId();
                try {
                    TXFailoverOp.execute(this.pool, transactionId);
                }
                catch (TransactionException e2) {
                    TXStateProxy txState = TXManagerImpl.getCurrentTXState();
                    if (txState == null) {
                        throw e2;
                    }
                    if (txState.operationCount() <= 1) break block12;
                    throw e2;
                }
            }
            if (op instanceof ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl) {
                op = new ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl((ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)op, 1, new HashSet<String>());
                ((ExecuteRegionFunctionOp.ExecuteRegionFunctionOpImpl)op).getMessage().setTransactionId(transactionId);
            } else if (op instanceof ExecuteFunctionOp.ExecuteFunctionOpImpl) {
                op = new ExecuteFunctionOp.ExecuteFunctionOpImpl((ExecuteFunctionOp.ExecuteFunctionOpImpl)op, 1);
                ((ExecuteFunctionOp.ExecuteFunctionOpImpl)op).getMessage().setTransactionId(transactionId);
            }
            return this.pool.execute(op);
        }
    }

    @Override
    public void setupServerAffinity(boolean allowFailover) {
        if (logger.isDebugEnabled()) {
            logger.debug("setting up server affinity");
        }
        this.serverAffinityFailover = allowFailover;
        this.serverAffinity.set(Boolean.TRUE);
    }

    @Override
    public void releaseServerAffinity() {
        if (logger.isDebugEnabled()) {
            logger.debug("reset server affinity");
        }
        this.serverAffinity.set(Boolean.FALSE);
        this.affinityServerLocation.set(null);
    }

    @Override
    public ServerLocation getServerAffinityLocation() {
        return this.affinityServerLocation.get();
    }

    @Override
    public void setServerAffinityLocation(ServerLocation serverLocation) {
        assert (this.affinityServerLocation.get() == null);
        this.affinityServerLocation.set(serverLocation);
    }

    public ServerLocation getNextOpServerLocation() {
        Connection conn;
        ServerLocation retVal = null;
        Connection connection = conn = this.threadLocalConnections ? this.localConnection.get() : null;
        if (conn == null || conn.isDestroyed()) {
            conn = this.connectionManager.borrowConnection(this.serverTimeout);
            retVal = conn.getServer();
            this.connectionManager.returnConnection(conn);
        } else {
            retVal = conn.getServer();
        }
        return retVal;
    }

    @Override
    public Object executeOn(ServerLocation server, Op op) {
        return this.executeOn(server, op, true, false);
    }

    @Override
    public Object executeOn(ServerLocation p_server, Op op, boolean accessed, boolean onlyUseExistingCnx) {
        ServerLocation server = p_server;
        if (this.serverAffinity.get().booleanValue()) {
            ServerLocation affinityserver = this.affinityServerLocation.get();
            if (affinityserver != null) {
                server = affinityserver;
            } else {
                this.affinityServerLocation.set(server);
            }
            return this.executeWithServerAffinity(server, op);
        }
        return this.executeOnServer(server, op, accessed, onlyUseExistingCnx);
    }

    private Object executeOnServer(ServerLocation p_server, Op op, boolean accessed, boolean onlyUseExistingCnx) {
        boolean success;
        Object qcs;
        Connection conn;
        boolean pingOp;
        boolean returnCnx;
        ServerLocation server;
        block14: {
            block15: {
                Endpoint ep;
                server = p_server;
                returnCnx = true;
                pingOp = op instanceof PingOp.PingOpImpl;
                conn = null;
                if (pingOp && this.queueManager != null && (ep = this.endpointManager.getEndpointMap().get(server)) != null && (conn = (qcs = this.queueManager.getAllConnectionsNoWait()).getConnection(ep)) != null) {
                    returnCnx = false;
                }
                if (conn == null) {
                    if (this.useThreadLocalConnection(op, pingOp)) {
                        conn = this.getActivatedThreadLocalConnectionForSingleHop(server, onlyUseExistingCnx);
                        returnCnx = false;
                    } else {
                        conn = this.connectionManager.borrowConnection(server, this.serverTimeout, onlyUseExistingCnx);
                    }
                }
                success = true;
                try {
                    qcs = this.executeWithPossibleReAuthentication(conn, op);
                    if (!this.serverAffinity.get().booleanValue() || this.affinityServerLocation.get() != null) break block14;
                    if (!logger.isDebugEnabled()) break block15;
                }
                catch (Exception e) {
                    try {
                        success = false;
                        this.handleException(e, conn, 0, true);
                        throw new ServerConnectivityException("Received error connecting to server", e);
                    }
                    catch (Throwable throwable) {
                        if (this.serverAffinity.get().booleanValue() && this.affinityServerLocation.get() == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("setting server affinity to {} server:{}", conn.getEndpoint().getMemberId(), conn.getServer());
                            }
                            this.affinityServerLocation.set(conn.getServer());
                        }
                        if (this.useThreadLocalConnection(op, pingOp)) {
                            this.connectionManager.passivate(conn, success);
                            this.setThreadLocalConnectionForSingleHop(server, conn);
                        }
                        if (returnCnx) {
                            this.connectionManager.returnConnection(conn, accessed);
                        }
                        throw throwable;
                    }
                }
                logger.debug("setting server affinity to {} server:{}", conn.getEndpoint().getMemberId(), conn.getServer());
            }
            this.affinityServerLocation.set(conn.getServer());
        }
        if (this.useThreadLocalConnection(op, pingOp)) {
            this.connectionManager.passivate(conn, success);
            this.setThreadLocalConnectionForSingleHop(server, conn);
        }
        if (returnCnx) {
            this.connectionManager.returnConnection(conn, accessed);
        }
        return qcs;
    }

    private boolean useThreadLocalConnection(Op op, boolean pingOp) {
        return this.threadLocalConnections && !pingOp && op.useThreadLocalConnection();
    }

    private Connection getActivatedThreadLocalConnectionForSingleHop(ServerLocation server, boolean onlyUseExistingCnx) {
        assert (this.threadLocalConnections);
        Connection conn = null;
        Map<ServerLocation, Connection> connMap = this.localConnectionMap.get();
        if (connMap != null && !connMap.isEmpty()) {
            conn = connMap.get(server);
        }
        boolean borrow = true;
        if (conn != null) {
            try {
                this.connectionManager.activate(conn);
                borrow = false;
                if (!conn.getServer().equals(server)) {
                    borrow = true;
                }
            }
            catch (ConnectionDestroyedException e) {
                // empty catch block
            }
        }
        if (conn == null || borrow) {
            conn = this.connectionManager.borrowConnection(server, this.serverTimeout, onlyUseExistingCnx);
        }
        if (borrow && connMap != null) {
            connMap.remove(server);
        }
        return conn;
    }

    private void setThreadLocalConnectionForSingleHop(ServerLocation server, Connection conn) {
        assert (this.threadLocalConnections);
        Map<ServerLocation, Connection> connMap = this.localConnectionMap.get();
        if (connMap == null) {
            connMap = new HashMap<ServerLocation, Connection>();
            this.localConnectionMap.set(connMap);
        }
        connMap.put(server, conn);
    }

    @Override
    public Object executeOnPrimary(Op op) {
        if (this.queueManager == null) {
            throw new SubscriptionNotEnabledException();
        }
        HashSet<ServerLocation> attemptedPrimaries = new HashSet<ServerLocation>();
        while (true) {
            Connection primary = this.queueManager.getAllConnections().getPrimary();
            try {
                return this.executeWithPossibleReAuthentication(primary, op);
            }
            catch (Exception e) {
                boolean finalAttempt = !attemptedPrimaries.add(primary.getServer());
                this.handleException(e, primary, 0, finalAttempt);
                if (!finalAttempt) continue;
                throw new ServerConnectivityException("Tried the same primary server twice.", e);
            }
            break;
        }
    }

    @Override
    public void executeOnAllQueueServers(Op op) {
        if (this.queueManager == null) {
            throw new SubscriptionNotEnabledException();
        }
        RuntimeException lastException = null;
        QueueManager.QueueConnections connections = this.queueManager.getAllConnectionsNoWait();
        Connection primary = connections.getPrimary();
        if (primary != null) {
            try {
                this.executeWithPossibleReAuthentication(primary, op);
            }
            catch (Exception e) {
                try {
                    this.handleException(e, primary, 0, false);
                }
                catch (RuntimeException e2) {
                    lastException = e2;
                }
            }
        }
        List backups = connections.getBackups();
        for (int i = 0; i < backups.size(); ++i) {
            Connection conn = (Connection)backups.get(i);
            try {
                this.executeWithPossibleReAuthentication(conn, op);
                continue;
            }
            catch (Exception e) {
                try {
                    this.handleException(e, conn, 0, false);
                    continue;
                }
                catch (RuntimeException e2) {
                    lastException = e2;
                }
            }
        }
        if (lastException != null) {
            throw lastException;
        }
    }

    @Override
    public Object executeOnQueuesAndReturnPrimaryResult(Op op) {
        if (this.queueManager == null) {
            throw new SubscriptionNotEnabledException();
        }
        QueueManager.QueueConnections connections = this.queueManager.getAllConnections();
        List backups = connections.getBackups();
        if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
            logger.trace(LogMarker.BRIDGE_SERVER, "sending {} to backups: {}", op, backups);
        }
        for (int i = backups.size() - 1; i >= 0; --i) {
            Connection conn = (Connection)backups.get(i);
            try {
                this.executeWithPossibleReAuthentication(conn, op);
                continue;
            }
            catch (Exception e) {
                this.handleException(e, conn, 0, false);
            }
        }
        Connection primary = connections.getPrimary();
        HashSet<ServerLocation> attemptedPrimaries = new HashSet<ServerLocation>();
        while (true) {
            try {
                if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                    logger.trace(LogMarker.BRIDGE_SERVER, "sending {} to primary: {}", op, primary);
                }
                return this.executeWithPossibleReAuthentication(primary, op);
            }
            catch (Exception e) {
                if (logger.isTraceEnabled(LogMarker.BRIDGE_SERVER)) {
                    logger.trace(LogMarker.BRIDGE_SERVER, "caught exception sending to primary {}", e.getMessage(), e);
                }
                boolean finalAttempt = !attemptedPrimaries.add(primary.getServer());
                this.handleException(e, primary, 0, finalAttempt);
                primary = this.queueManager.getAllConnections().getPrimary();
                if (!finalAttempt) continue;
                throw new ServerConnectivityException("Tried the same primary server twice.", e);
            }
            break;
        }
    }

    @Override
    public void releaseThreadLocalConnection() {
        Connection conn = this.localConnection.get();
        this.localConnection.set(null);
        if (conn != null) {
            this.connectionManager.returnConnection(conn);
        }
        Map<ServerLocation, Connection> connMap = this.localConnectionMap.get();
        this.localConnectionMap.set(null);
        if (connMap != null) {
            for (Connection c : connMap.values()) {
                this.connectionManager.returnConnection(c);
            }
        }
    }

    @Override
    public Object executeOn(Connection conn, Op op, boolean timeoutFatal) {
        try {
            return this.executeWithPossibleReAuthentication(conn, op);
        }
        catch (Exception e) {
            this.handleException(op, e, conn, 0, true, timeoutFatal);
            throw new ServerConnectivityException("Received error connecting to server", e);
        }
    }

    @Override
    public Object executeOn(Connection conn, Op op) {
        return this.executeOn(conn, op, false);
    }

    @Override
    public RegisterInterestTracker getRITracker() {
        return this.riTracker;
    }

    protected void handleException(Throwable e, Connection conn, int retryCount, boolean finalAttempt) {
        this.handleException(e, conn, retryCount, finalAttempt, false);
    }

    protected void handleException(Op op, Throwable e, Connection conn, int retryCount, boolean finalAttempt, boolean timeoutFatal) throws CacheRuntimeException {
        if (op instanceof AuthenticateUserOp.AuthenticateUserOpImpl) {
            if (e instanceof GemFireSecurityException) {
                throw (GemFireSecurityException)e;
            }
            if (e instanceof ServerRefusedConnectionException) {
                throw (ServerRefusedConnectionException)e;
            }
        }
        this.handleException(e, conn, retryCount, finalAttempt, timeoutFatal);
    }

    protected void handleException(Throwable e, Connection conn, int retryCount, boolean finalAttempt, boolean timeoutFatal) throws CacheRuntimeException {
        String title;
        GemFireException exToThrow = null;
        boolean invalidateServer = true;
        boolean warn = true;
        boolean forceThrow = false;
        Throwable cause = e;
        this.cancelCriterion.checkCancelInProgress(e);
        if (logger.isDebugEnabled() && !(e instanceof EOFException)) {
            if (e instanceof EOFException) {
                logger.debug("OpExecutor.handleException on Connection to {} found EOF", conn.getServer());
            } else if (e instanceof SocketTimeoutException) {
                logger.debug("OpExecutor.handleException on Connection to {} read timed out", conn.getServer());
            } else {
                logger.debug("OpExecutor.handleException on Connection to {}", conn.getServer(), e);
            }
        }
        if (e instanceof NotSerializableException) {
            title = null;
            exToThrow = new SerializationException("Pool message failure", e);
        } else if (e instanceof BatchException || e instanceof BatchException70) {
            title = null;
            exToThrow = new ServerOperationException(e);
        } else if (e instanceof RegionDestroyedException) {
            invalidateServer = false;
            title = null;
            exToThrow = (RegionDestroyedException)e;
        } else if (e instanceof GemFireSecurityException) {
            title = null;
            exToThrow = new ServerOperationException(e);
        } else if (e instanceof SerializationException) {
            title = null;
            exToThrow = new ServerOperationException(e);
        } else if (e instanceof CopyException) {
            title = null;
            exToThrow = new ServerOperationException(e);
        } else if (e instanceof ClassNotFoundException) {
            title = null;
            exToThrow = new ServerOperationException(e);
        } else if (e instanceof TransactionException) {
            title = null;
            exToThrow = (TransactionException)e;
            invalidateServer = false;
        } else if (e instanceof SynchronizationCommitConflictException) {
            title = null;
            exToThrow = (SynchronizationCommitConflictException)e;
            invalidateServer = false;
        } else if (e instanceof SocketException) {
            title = "Socket closed".equals(e.getMessage()) || "Connection reset".equals(e.getMessage()) || "Connection refused: connect".equals(e.getMessage()) || "Connection refused".equals(e.getMessage()) ? e.getMessage() : "SocketException";
        } else if (e instanceof SocketTimeoutException) {
            invalidateServer = timeoutFatal;
            title = "socket timed out on client";
            cause = null;
        } else if (e instanceof ConnectionDestroyedException) {
            invalidateServer = false;
            title = "connection was asynchronously destroyed";
            cause = null;
        } else if (e instanceof EOFException) {
            title = "closed socket on server";
        } else if (e instanceof IOException) {
            title = "IOException";
        } else if (e instanceof BufferUnderflowException) {
            title = "buffer underflow reading from server";
        } else if (e instanceof CancelException) {
            title = "Cancelled";
            warn = false;
        } else if (e instanceof InternalFunctionInvocationTargetException) {
            title = null;
            exToThrow = (InternalFunctionInvocationTargetException)e;
        } else if (e instanceof FunctionInvocationTargetException) {
            title = null;
            exToThrow = (GemFireException)e;
        } else if (e instanceof PutAllPartialResultException) {
            title = null;
            exToThrow = (PutAllPartialResultException)e;
            invalidateServer = false;
        } else {
            Throwable t = e.getCause();
            if (t instanceof ConnectException || t instanceof SocketException || t instanceof SocketTimeoutException || t instanceof IOException || t instanceof SerializationException || t instanceof CopyException || t instanceof GemFireSecurityException || t instanceof ServerOperationException || t instanceof TransactionException || t instanceof CancelException) {
                this.handleException(t, conn, retryCount, finalAttempt, timeoutFatal);
                return;
            }
            if (e instanceof ServerOperationException) {
                title = null;
                exToThrow = (ServerOperationException)e;
                invalidateServer = false;
            } else if (e instanceof FunctionException) {
                if (t instanceof InternalFunctionInvocationTargetException) {
                    this.handleException(t, conn, retryCount, finalAttempt, timeoutFatal);
                    return;
                }
                title = null;
                exToThrow = (FunctionException)e;
            } else if (e instanceof ServerConnectivityException && e.getMessage().equals("Connection error while authenticating user")) {
                title = null;
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), e);
                }
            } else {
                title = e.toString();
                forceThrow = true;
            }
        }
        if (title != null) {
            boolean msgNeeded;
            conn.destroy();
            if (invalidateServer) {
                this.endpointManager.serverCrashed(conn.getEndpoint());
            }
            boolean logEnabled = warn ? logger.isWarnEnabled() : logger.isDebugEnabled();
            boolean bl = msgNeeded = logEnabled || finalAttempt;
            if (msgNeeded) {
                StringBuffer sb = this.getExceptionMessage(title, retryCount, finalAttempt, conn, e);
                String msg = sb.toString();
                if (logEnabled) {
                    if (warn) {
                        logger.warn(msg);
                    } else {
                        logger.debug(msg);
                    }
                }
                if (forceThrow || finalAttempt) {
                    exToThrow = new ServerConnectivityException(msg, cause);
                }
            }
        }
        if (exToThrow != null) {
            throw exToThrow;
        }
    }

    private StringBuffer getExceptionMessage(String exceptionName, int retryCount, boolean finalAttempt, Connection connection, Throwable ex) {
        StringBuffer message = new StringBuffer(200);
        message.append("Pool unexpected ").append(exceptionName);
        if (connection != null) {
            message.append(" connection=").append(connection);
        }
        if (retryCount > 0) {
            message.append(" attempt=").append(retryCount + 1);
        }
        message.append(')');
        if (finalAttempt) {
            message.append(". Server unreachable: could not connect after ").append(retryCount + 1).append(" attempts");
        }
        return message;
    }

    public Connection getThreadLocalConnection() {
        return this.localConnection.get();
    }

    public void setThreadLocalConnection(Connection conn) {
        this.localConnection.set(conn);
    }

    private void authenticateIfRequired(Connection conn, Op op) {
        if (!conn.getServer().getRequiresCredentials()) {
            return;
        }
        if (this.pool == null) {
            PoolImpl poolImpl = (PoolImpl)PoolManagerImpl.getPMI().find(this.endpointManager.getPoolName());
            if (poolImpl == null) {
                return;
            }
            this.pool = poolImpl;
        }
        if (this.pool.getMultiuserAuthentication()) {
            UserAttributes ua;
            if (((AbstractOp)op).needsUserId() && (ua = UserAttributes.userAttributes.get()) != null && !ua.getServerToId().containsKey(conn.getServer())) {
                this.authenticateMultiuser(this.pool, conn, ua);
            }
        } else if (((AbstractOp)op).needsUserId() && conn.getServer().getUserId() == -1L) {
            Connection connImpl = this.connectionManager.getConnection(conn);
            conn.getServer().setUserId((Long)AuthenticateUserOp.executeOn(connImpl, this.pool));
            if (logger.isDebugEnabled()) {
                logger.debug("OpExecutorImpl.execute() - single user mode - authenticated this user on {}", conn);
            }
        }
    }

    private void authenticateMultiuser(PoolImpl pool, Connection conn, UserAttributes ua) {
        try {
            Long userId = (Long)AuthenticateUserOp.executeOn(conn.getServer(), pool, ua.getCredentials());
            if (userId != null) {
                ua.setServerToId(conn.getServer(), userId);
                if (logger.isDebugEnabled()) {
                    logger.debug("OpExecutorImpl.execute() - multiuser mode - authenticated this user on {}", conn);
                }
            }
        }
        catch (ServerConnectivityException sce) {
            Throwable cause = sce.getCause();
            if (cause instanceof SocketException || cause instanceof EOFException || cause instanceof IOException || cause instanceof BufferUnderflowException || cause instanceof CancelException || sce.getMessage() != null && (sce.getMessage().indexOf("Could not create a new connection to server") != -1 || sce.getMessage().indexOf("socket timed out on client") != -1 || sce.getMessage().indexOf("connection was asynchronously destroyed") != -1)) {
                throw new ServerConnectivityException("Connection error while authenticating user");
            }
            throw sce;
        }
    }

    private Object executeWithPossibleReAuthentication(Connection conn, Op op) throws Exception {
        try {
            return conn.execute(op);
        }
        catch (ServerConnectivityException sce) {
            Throwable cause = sce.getCause();
            if (cause instanceof AuthenticationRequiredException && "User authorization attributes not found.".equals(cause.getMessage()) || sce.getMessage().contains("Connection error while authenticating user")) {
                PoolImpl pool = (PoolImpl)PoolManagerImpl.getPMI().find(this.endpointManager.getPoolName());
                if (!pool.getMultiuserAuthentication()) {
                    Connection connImpl = this.connectionManager.getConnection(conn);
                    conn.getServer().setUserId((Long)AuthenticateUserOp.executeOn(connImpl, this));
                    return conn.execute(op);
                }
                UserAttributes ua = UserAttributes.userAttributes.get();
                if (ua != null) {
                    this.authenticateMultiuser(pool, conn, ua);
                }
                return conn.execute(op);
            }
            throw sce;
        }
    }
}

