/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionService;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.ProxyCacheCloseOp;
import com.gemstone.gemfire.cache.client.internal.ProxyRegion;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.internal.ProxyQueryService;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.PdxInstanceFactory;
import com.gemstone.gemfire.pdx.internal.PdxInstanceFactoryImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class ProxyCache
implements RegionService {
    private final GemFireCacheImpl cache;
    private UserAttributes userAttributes;
    private ProxyQueryService proxyQueryService;
    private boolean isClosed = false;
    private final Stopper stopper = new Stopper();

    public ProxyCache(Properties properties, GemFireCacheImpl cache, PoolImpl pool) {
        this.userAttributes = new UserAttributes(properties, pool);
        this.cache = cache;
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean keepAlive) {
        if (this.isClosed) {
            return;
        }
        try {
            if (this.proxyQueryService != null) {
                this.proxyQueryService.closeCqs(keepAlive);
            }
            UserAttributes.userAttributes.set(this.getUserAttributes());
            Iterator iter = this.userAttributes.getServerToId().keySet().iterator();
            while (iter.hasNext()) {
                ProxyCacheCloseOp.executeOn((ServerLocation)iter.next(), (PoolImpl)this.userAttributes.getPool(), this.getProperties(), keepAlive);
            }
            ((PoolImpl)this.userAttributes.getPool()).getProxyCacheList().remove(this);
        }
        finally {
            this.proxyQueryService = null;
            this.userAttributes.setCredentials(null);
            this.userAttributes = null;
            this.isClosed = true;
            UserAttributes.userAttributes.set(null);
        }
    }

    public String getName() {
        return this.cache.getName();
    }

    @Override
    public QueryService getQueryService() {
        this.preOp();
        if (this.proxyQueryService == null) {
            this.proxyQueryService = new ProxyQueryService(this, this.userAttributes.getPool().getQueryService());
        }
        return this.proxyQueryService;
    }

    @Override
    public <K, V> Region<K, V> getRegion(String path) {
        this.preOp();
        if (this.cache.getRegion(path) == null) {
            return null;
        }
        if (!this.cache.getRegion(path).getAttributes().getDataPolicy().isEmpty()) {
            throw new IllegalStateException("Region's data-policy must be EMPTY when multiuser-authentication is true");
        }
        return new ProxyRegion(this, this.cache.getRegion(path));
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public void setProperties(Properties properties) {
        this.preOp();
        this.userAttributes.setCredentials(properties);
    }

    public Properties getProperties() {
        this.preOp();
        return this.userAttributes.getCredentials();
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.preOp();
        this.userAttributes = userAttributes;
    }

    public UserAttributes getUserAttributes() {
        this.preOp();
        return this.userAttributes;
    }

    public Object getUserId(Object key2) {
        this.preOp();
        if (!(key2 instanceof ServerLocation)) {
            throw new IllegalArgumentException("Key must be of type ServerLocation, but is " + key2.getClass());
        }
        return this.userAttributes.getServerToId().get(key2);
    }

    private void preOp() {
        this.stopper.checkCancelInProgress(null);
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    @Override
    public Set<Region<?, ?>> rootRegions() {
        this.preOp();
        HashSet<ProxyRegion> rRegions = new HashSet<ProxyRegion>();
        for (LocalRegion lr : this.cache.rootRegions()) {
            if (lr.getAttributes().getDataPolicy().withStorage()) continue;
            rRegions.add(new ProxyRegion(this, lr));
        }
        return Collections.unmodifiableSet(rRegions);
    }

    @Override
    public PdxInstanceFactory createPdxInstanceFactory(String className) {
        return PdxInstanceFactoryImpl.newCreator(className, true);
    }

    public PdxInstanceFactory createPdxInstanceFactory(String className, boolean b) {
        return PdxInstanceFactoryImpl.newCreator(className, b);
    }

    @Override
    public PdxInstance createPdxEnum(String className, String enumName, int enumOrdinal) {
        return PdxInstanceFactoryImpl.createPdxEnum(className, enumName, enumOrdinal, this.cache);
    }

    protected class Stopper
    extends CancelCriterion {
        protected Stopper() {
        }

        @Override
        public String cancelInProgress() {
            String reason = ProxyCache.this.cache.getCancelCriterion().cancelInProgress();
            if (reason != null) {
                return reason;
            }
            if (ProxyCache.this.isClosed()) {
                return "Authenticated cache view is closed for this user.";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            RuntimeException result = ProxyCache.this.cache.getCancelCriterion().generateCancelledException(e);
            if (result != null) {
                return result;
            }
            if (e == null) {
                return new CacheClosedException(reason);
            }
            try {
                return new CacheClosedException(reason, e);
            }
            catch (IllegalStateException e2) {
                return new CacheClosedException(reason);
            }
        }
    }
}

