/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.cache.client.internal.AbstractOp;
import com.gemstone.gemfire.cache.client.internal.Connection;
import com.gemstone.gemfire.cache.client.internal.ConnectionStats;
import com.gemstone.gemfire.cache.client.internal.ExecutablePool;
import com.gemstone.gemfire.cache.client.internal.Op;
import com.gemstone.gemfire.cache.client.internal.QueueConnectionImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.Message;

public class ReadyForEventsOp {
    public static void execute(ExecutablePool pool, QueueConnectionImpl primary) {
        ReadyForEventsOpImpl op = new ReadyForEventsOpImpl();
        pool.executeOn(primary, (Op)op);
    }

    private ReadyForEventsOp() {
    }

    private static class ReadyForEventsOpImpl
    extends AbstractOp {
        public ReadyForEventsOpImpl() {
            super(53, 1);
        }

        @Override
        protected void processSecureBytes(Connection cnx, Message message) throws Exception {
        }

        @Override
        protected boolean needsUserId() {
            return false;
        }

        @Override
        protected void sendMessage(Connection cnx) throws Exception {
            this.getMessage().setEarlyAck((byte)(this.getMessage().getEarlyAckByte() & 2));
            this.getMessage().send(false);
        }

        @Override
        protected Object processResponse(Message msg) throws Exception {
            this.processAck(msg, "readyForEvents");
            return null;
        }

        @Override
        protected boolean isErrorResponse(int msgType) {
            return false;
        }

        @Override
        protected long startAttempt(ConnectionStats stats) {
            return stats.startReadyForEvents();
        }

        @Override
        protected void endSendAttempt(ConnectionStats stats, long start) {
            stats.endReadyForEventsSend(start, this.hasFailed());
        }

        @Override
        protected void endAttempt(ConnectionStats stats, long start) {
            stats.endReadyForEvents(start, this.hasTimedOut(), this.hasFailed());
        }
    }
}

