/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.client.ServerConnectivityException;
import com.gemstone.gemfire.cache.client.ServerOperationException;
import com.gemstone.gemfire.cache.client.internal.ClientMetadataService;
import com.gemstone.gemfire.cache.client.internal.GetAllOp;
import com.gemstone.gemfire.cache.client.internal.SingleHopOperationCallable;
import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PutAllPartialResultException;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.gemstone.gemfire.internal.cache.tier.sockets.VersionedObjectList;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public class SingleHopClientExecutor {
    private static final Logger logger = LogService.getLogger();
    static final ExecutorService execService = Executors.newCachedThreadPool(new ThreadFactory(){
        AtomicInteger threadNum = new AtomicInteger();

        @Override
        public Thread newThread(Runnable r) {
            Thread result = new Thread(r, "Function Execution Thread-" + this.threadNum.incrementAndGet());
            result.setDaemon(true);
            return result;
        }
    });

    static void submitAll(List callableTasks) {
        if (callableTasks != null && !callableTasks.isEmpty()) {
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (RejectedExecutionException rejectedExecutionEx) {
                throw rejectedExecutionEx;
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator itr = futures.iterator();
                while (itr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = itr.next();
                    try {
                        fut.get();
                    }
                    catch (InterruptedException e) {
                        throw new InternalGemFireException(e.getMessage());
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof FunctionException) {
                            throw (FunctionException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerOperationException) {
                            throw (ServerOperationException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            throw (ServerConnectivityException)ee.getCause();
                        }
                        throw SingleHopClientExecutor.executionThrowable(ee.getCause());
                    }
                }
            }
        }
    }

    static boolean submitAllHA(List callableTasks, LocalRegion region, ResultCollector rc, Set<String> failedNodes) {
        ClientMetadataService cms = region.getCache().getClientMetadataService();
        boolean reexecute = false;
        if (callableTasks != null && !callableTasks.isEmpty()) {
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (RejectedExecutionException rejectedExecutionEx) {
                throw rejectedExecutionEx;
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator futureItr = futures.iterator();
                Iterator taskItr = callableTasks.iterator();
                boolean isDebugEnabled = logger.isDebugEnabled();
                while (futureItr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = futureItr.next();
                    SingleHopOperationCallable task = (SingleHopOperationCallable)taskItr.next();
                    ServerLocation server = task.getServer();
                    try {
                        fut.get();
                        if (!isDebugEnabled) continue;
                        logger.debug("ExecuteRegionFunctionSingleHopOp#got result from {}", server);
                    }
                    catch (InterruptedException e) {
                        throw new InternalGemFireException(e.getMessage());
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof InternalFunctionInvocationTargetException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.InternalFunctionInvocationTargetException : Caused by :{}", ee.getCause());
                            }
                            try {
                                cms = region.getCache().getClientMetadataService();
                            }
                            catch (CacheClosedException e) {
                                return false;
                            }
                            cms.scheduleGetPRMetaData(region, false);
                            cms.removeBucketServerLocation(server);
                            reexecute = true;
                            failedNodes.addAll(((InternalFunctionInvocationTargetException)ee.getCause()).getFailedNodeSet());
                            rc.clearResults();
                            continue;
                        }
                        if (ee.getCause() instanceof FunctionException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.FunctionException : Caused by :{}", ee.getCause());
                            }
                            throw (FunctionException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerOperationException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.ServerOperationException : Caused by :{}", ee.getCause());
                            }
                            throw (ServerOperationException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            if (isDebugEnabled) {
                                logger.debug("ExecuteRegionFunctionSingleHopOp#ExecutionException.ServerConnectivityException : Caused by :{} The failed server is: {}", ee.getCause(), server);
                            }
                            try {
                                cms = region.getCache().getClientMetadataService();
                            }
                            catch (CacheClosedException e) {
                                return false;
                            }
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            reexecute = true;
                            rc.clearResults();
                            continue;
                        }
                        throw SingleHopClientExecutor.executionThrowable(ee.getCause());
                    }
                }
            }
        }
        return reexecute;
    }

    static Map<ServerLocation, Object> submitBulkOp(List callableTasks, ClientMetadataService cms, LocalRegion region, Map<ServerLocation, RuntimeException> failedServers) {
        if (callableTasks != null && !callableTasks.isEmpty()) {
            HashMap<ServerLocation, Object> resultMap = new HashMap<ServerLocation, Object>();
            boolean anyPartialResults = false;
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (RejectedExecutionException rejectedExecutionEx) {
                throw rejectedExecutionEx;
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator futureItr = futures.iterator();
                Iterator taskItr = callableTasks.iterator();
                RuntimeException rte = null;
                boolean isDebugEnabled = logger.isDebugEnabled();
                while (futureItr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = futureItr.next();
                    SingleHopOperationCallable task = (SingleHopOperationCallable)taskItr.next();
                    ServerLocation server = task.getServer();
                    try {
                        VersionedObjectList versions = (VersionedObjectList)fut.get();
                        if (logger.isDebugEnabled()) {
                            logger.debug("submitBulkOp#got result from {}:{}", server, versions);
                        }
                        resultMap.put(server, versions);
                    }
                    catch (InterruptedException e) {
                        InternalGemFireException ige = new InternalGemFireException(e);
                        failedServers.put(server, ige);
                        if (rte != null) continue;
                        rte = ige;
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof ServerOperationException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("submitBulkOp#ExecutionException from server {}", server, ee);
                            }
                            ServerOperationException soe = (ServerOperationException)ee.getCause();
                            failedServers.put(server, soe);
                            if (rte != null) continue;
                            rte = soe;
                            continue;
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("submitBulkOp#ExecutionException for server {}", server, ee);
                            }
                            cms = region.getCache().getClientMetadataService();
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            failedServers.put(server, (ServerConnectivityException)ee.getCause());
                            continue;
                        }
                        Throwable t = ee.getCause();
                        if (t instanceof PutAllPartialResultException) {
                            resultMap.put(server, t);
                            anyPartialResults = true;
                            failedServers.put(server, (PutAllPartialResultException)t);
                            continue;
                        }
                        RuntimeException other_rte = SingleHopClientExecutor.executionThrowable(ee.getCause());
                        failedServers.put(server, other_rte);
                        if (rte != null) continue;
                        rte = other_rte;
                    }
                }
                if (rte != null && !anyPartialResults) {
                    throw rte;
                }
            }
            return resultMap;
        }
        return null;
    }

    static Map<ServerLocation, Object> submitGetAll(Map<ServerLocation, HashSet> serverToFilterMap, List callableTasks, ClientMetadataService cms, LocalRegion region) {
        if (callableTasks != null && !callableTasks.isEmpty()) {
            HashMap<ServerLocation, Object> resultMap = new HashMap<ServerLocation, Object>();
            List futures = null;
            try {
                futures = execService.invokeAll(callableTasks);
            }
            catch (RejectedExecutionException rejectedExecutionEx) {
                throw rejectedExecutionEx;
            }
            catch (InterruptedException e) {
                throw new InternalGemFireException(e.getMessage());
            }
            if (futures != null) {
                Iterator futureItr = futures.iterator();
                Iterator taskItr = callableTasks.iterator();
                while (futureItr.hasNext() && !execService.isShutdown() && !execService.isTerminated()) {
                    Future fut = futureItr.next();
                    SingleHopOperationCallable task = (SingleHopOperationCallable)taskItr.next();
                    List keys = ((GetAllOp.GetAllOpImpl)task.getOperation()).getKeyList();
                    ServerLocation server = task.getServer();
                    try {
                        VersionedObjectList valuesFromServer = (VersionedObjectList)fut.get();
                        valuesFromServer.setKeys(keys);
                        VersionedObjectList.Iterator it = valuesFromServer.iterator();
                        while (it.hasNext()) {
                            VersionedObjectList.Entry entry = it.next();
                            Object key2 = entry.getKey();
                            Object value2 = entry.getValue();
                            if (entry.isKeyNotOnServer() || !(value2 instanceof Throwable)) continue;
                            logger.warn(LocalizedMessage.create(LocalizedStrings.GetAll_0_CAUGHT_THE_FOLLOWING_EXCEPTION_ATTEMPTING_TO_GET_VALUE_FOR_KEY_1, new Object[]{value2, key2}), (Throwable)value2);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("GetAllOp#got result from {}: {}", server, valuesFromServer);
                        }
                        resultMap.put(server, valuesFromServer);
                    }
                    catch (InterruptedException e) {
                        throw new InternalGemFireException(e.getMessage());
                    }
                    catch (ExecutionException ee) {
                        if (ee.getCause() instanceof ServerOperationException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("GetAllOp#ExecutionException.ServerOperationException : Caused by :{}", ee.getCause());
                            }
                            throw (ServerOperationException)ee.getCause();
                        }
                        if (ee.getCause() instanceof ServerConnectivityException) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("GetAllOp#ExecutionException.ServerConnectivityException : Caused by :{} The failed server is: {}", ee.getCause(), server);
                            }
                            try {
                                cms = region.getCache().getClientMetadataService();
                            }
                            catch (CacheClosedException e) {
                                return null;
                            }
                            cms.removeBucketServerLocation(server);
                            cms.scheduleGetPRMetaData(region, false);
                            resultMap.put(server, ee.getCause());
                            continue;
                        }
                        throw SingleHopClientExecutor.executionThrowable(ee.getCause());
                    }
                }
                return resultMap;
            }
        }
        return null;
    }

    static void submitTask(Runnable task) {
        execService.submit(task);
    }

    private static RuntimeException executionThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IllegalStateException("Don't know", t);
    }
}

