/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.client.internal.locator;

import com.gemstone.gemfire.cache.client.internal.locator.SerializationHelper;
import com.gemstone.gemfire.cache.client.internal.locator.ServerLocationResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class GetAllServersResponse
extends ServerLocationResponse {
    private ArrayList servers;
    private boolean serversFound = false;

    public GetAllServersResponse() {
    }

    public GetAllServersResponse(ArrayList servers) {
        this.servers = servers;
        if (servers != null && !servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.servers = SerializationHelper.readServerLocationList(in);
        if (this.servers != null && !this.servers.isEmpty()) {
            this.serversFound = true;
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        SerializationHelper.writeServerLocationList(this.servers, out);
    }

    public ArrayList getServers() {
        return this.servers;
    }

    public String toString() {
        return "GetAllServersResponse{servers=" + this.getServers() + "}";
    }

    @Override
    public int getDSFID() {
        return -42;
    }

    @Override
    public boolean hasResult() {
        return this.serversFound;
    }
}

