/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.operations;

import com.gemstone.gemfire.cache.operations.OperationContext;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.Token;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PutAllOperationContext
extends OperationContext {
    private final UpdateOnlyMap map;
    private boolean postOperation = false;
    private Object callbackArg;

    public PutAllOperationContext(Map map) {
        this.map = new UpdateOnlyMap(map);
    }

    @Override
    public OperationContext.OperationCode getOperationCode() {
        return OperationContext.OperationCode.PUTALL;
    }

    @Override
    public boolean isPostOperation() {
        return this.postOperation;
    }

    protected void setPostOperation() {
        this.postOperation = true;
    }

    public <K, V> Map<K, V> getMap() {
        return this.map;
    }

    public void setMap(Map map) {
        if (map == this.map) {
            return;
        }
        if (map == null) {
            throw new IllegalArgumentException("PutAllOperationContext.setMap does not allow a null map.");
        }
        if (map.size() != this.map.size()) {
            throw new IllegalArgumentException("PutAllOperationContext.setMap does not allow the size of the map to be changed.");
        }
        try {
            this.map.putAll(map);
        }
        catch (UnsupportedOperationException ex) {
            throw new IllegalArgumentException("PutAllOperationContext.setMap " + ex.getMessage() + " to the original keys of the putAll");
        }
    }

    public Object getCallbackArg() {
        return this.callbackArg;
    }

    public void setCallbackArg(Object callbackArg) {
        this.callbackArg = callbackArg;
    }

    private static class UpdateOnlyMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set keySet = null;
        private transient Set entrySet = null;
        private transient Collection values = null;

        UpdateOnlyMap(Map m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.m = m;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key2) {
            return this.m.containsKey(key2);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.values().contains(val);
        }

        public Object get(Object key2) {
            return UpdateOnlyMap.exportValue(this.m.get(key2));
        }

        private static Object exportValue(Object v) {
            Object result = v == Token.INVALID ? null : (v instanceof CachedDeserializable ? ((CachedDeserializable)v).getDeserializedForReading() : v);
            return result;
        }

        public Object put(Object key2, Object value2) {
            if (this.containsKey(key2)) {
                return this.m.put(key2, value2);
            }
            throw new UnsupportedOperationException("can not add the key \"" + key2 + "\"");
        }

        public void putAll(Map m) {
            if (m != null) {
                Iterator i$ = m.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry i;
                    Map.Entry me = i = i$.next();
                    this.put(me.getKey(), me.getValue());
                }
            }
        }

        public Object remove(Object key2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.unmodifiableSet(new EntrySet());
            }
            return this.entrySet;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(new Values());
            }
            return this.values;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map m = (Map)o;
            if (m.size() != this.size()) {
                return false;
            }
            try {
                for (Map.Entry e : this.entrySet()) {
                    Object key2 = e.getKey();
                    Object value2 = e.getValue();
                    if (!(value2 == null ? m.get(key2) != null || !m.containsKey(key2) : !value2.equals(m.get(key2)))) continue;
                    return false;
                }
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int h = 0;
            Iterator i = this.entrySet().iterator();
            while (i.hasNext()) {
                h += ((Map.Entry)i.next()).hashCode();
            }
            return h;
        }

        public String toString() {
            Iterator i = this.entrySet().iterator();
            if (!i.hasNext()) {
                return "{}";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            while (true) {
                Map.Entry e = (Map.Entry)i.next();
                Object key2 = e.getKey();
                Object value2 = e.getValue();
                sb.append((Object)(key2 == this ? "(this Map)" : key2));
                sb.append('=');
                sb.append((Object)(value2 == this ? "(this Map)" : value2));
                if (!i.hasNext()) {
                    return sb.append('}').toString();
                }
                sb.append(',').append(' ');
            }
        }

        private class ValueIterator
        implements Iterator {
            private Iterator mIterator;

            private ValueIterator() {
                this.mIterator = UpdateOnlyMap.this.m.values().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mIterator.hasNext();
            }

            public Object next() {
                return UpdateOnlyMap.exportValue(this.mIterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private final class Values
        extends AbstractCollection {
            private Values() {
            }

            @Override
            public Iterator iterator() {
                return new ValueIterator();
            }

            @Override
            public int size() {
                return UpdateOnlyMap.this.m.size();
            }
        }

        private static class ExportableEntry
        implements Map.Entry {
            private final Map.Entry e;

            ExportableEntry(Map.Entry e) {
                this.e = e;
            }

            public Object getKey() {
                return this.e.getKey();
            }

            public Object getValue() {
                return UpdateOnlyMap.exportValue(this.e.getValue());
            }

            public Object setValue(Object value2) {
                return UpdateOnlyMap.exportValue(this.e.setValue(value2));
            }

            @Override
            public int hashCode() {
                return Objects.hashCode(this.getKey()) ^ Objects.hashCode(this.getValue());
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)o;
                return UpdateOnlyMap.eq(this.getKey(), other.getKey()) && UpdateOnlyMap.eq(this.getValue(), other.getValue());
            }

            public String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        }

        private class EntryIterator
        implements Iterator {
            private Iterator mIterator;

            private EntryIterator() {
                this.mIterator = UpdateOnlyMap.this.m.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mIterator.hasNext();
            }

            public Object next() {
                Map.Entry me = (Map.Entry)this.mIterator.next();
                return new ExportableEntry(me);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }

        private final class EntrySet
        extends AbstractSet {
            private EntrySet() {
            }

            @Override
            public Iterator iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return UpdateOnlyMap.this.m.size();
            }
        }
    }
}

