/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.partition;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.control.RebalanceResults;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRebalanceInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.FixedPartitionAttributesImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.control.RebalanceResultsImpl;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.partitioned.InternalPRInfo;
import com.gemstone.gemfire.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.ExplicitMoveDirector;
import com.gemstone.gemfire.internal.cache.partitioned.rebalance.PercentageMoveDirector;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class PartitionRegionHelper {
    private PartitionRegionHelper() {
    }

    public static Map<String, Region<?, ?>> getColocatedRegions(Region<?, ?> r) {
        Map<String, Region> ret;
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr2 = (PartitionedRegion)r;
            ret = ColocationHelper.getAllColocationRegions(pr2);
            if (ret.isEmpty()) {
                ret = Collections.emptyMap();
            }
        } else if (r instanceof LocalDataSet) {
            LocalDataSet lds = (LocalDataSet)r;
            InternalRegionFunctionContext fc = lds.getFunctionContext();
            if (fc != null) {
                ret = ColocationHelper.getAllColocatedLocalDataSets(lds.getProxy(), fc);
                if (ret.isEmpty()) {
                    ret = Collections.emptyMap();
                }
            } else {
                ret = ColocationHelper.getColocatedLocalDataSetsForBuckets(lds.getProxy(), lds.getBucketSet());
            }
        } else {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
        }
        return Collections.unmodifiableMap(ret);
    }

    public static boolean isPartitionedRegion(Region<?, ?> r) {
        if (r == null) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionRegionHelper_ARGUMENT_REGION_IS_NULL.toString());
        }
        return r instanceof PartitionedRegion;
    }

    private static PartitionedRegion isPartitionedCheck(Region<?, ?> r) {
        if (!PartitionRegionHelper.isPartitionedRegion(r)) {
            throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
        }
        return (PartitionedRegion)r;
    }

    public static Set<PartitionRegionInfo> getPartitionRegionInfo(Cache cache) {
        TreeSet<PartitionRegionInfo> prDetailsSet = new TreeSet<PartitionRegionInfo>();
        PartitionRegionHelper.fillInPartitionedRegionInfo((GemFireCacheImpl)cache, prDetailsSet, false);
        return prDetailsSet;
    }

    public static PartitionRegionInfo getPartitionRegionInfo(Region<?, ?> region) {
        try {
            PartitionedRegion pr2 = PartitionRegionHelper.isPartitionedCheck(region);
            GemFireCacheImpl cache = (GemFireCacheImpl)region.getCache();
            return pr2.getRedundancyProvider().buildPartitionedRegionInfo(false, cache.getResourceManager().getLoadProbe());
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    private static void fillInPartitionedRegionInfo(GemFireCacheImpl cache, Set prDetailsSet, boolean internal) {
        Set<PartitionedRegion> prSet = cache.getPartitionedRegions();
        if (prSet.isEmpty()) {
            return;
        }
        for (PartitionedRegion pr2 : prSet) {
            InternalPRInfo prDetails = pr2.getRedundancyProvider().buildPartitionedRegionInfo(internal, cache.getResourceManager().getLoadProbe());
            if (prDetails == null) continue;
            prDetailsSet.add(prDetails);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignBucketsToPartitions(Region<?, ?> region) {
        PartitionedRegion pr2 = PartitionRegionHelper.isPartitionedCheck(region);
        PartitionedRegion.RecoveryLock lock = null;
        try {
            lock = pr2.getRecoveryLock();
            lock.lock();
            for (int i = 0; i < PartitionRegionHelper.getNumberOfBuckets(pr2); ++i) {
                pr2.createBucket(i, 0, null);
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    private static int getNumberOfBuckets(PartitionedRegion pr2) {
        if (pr2.isFixedPartitionedRegion()) {
            int numBuckets = 0;
            HashSet<FixedPartitionAttributesImpl> fpaSet = new HashSet<FixedPartitionAttributesImpl>(pr2.getRegionAdvisor().adviseAllFixedPartitionAttributes());
            if (pr2.getFixedPartitionAttributesImpl() != null) {
                fpaSet.addAll(pr2.getFixedPartitionAttributesImpl());
            }
            for (FixedPartitionAttributesImpl fpa : fpaSet) {
                numBuckets += fpa.getNumBuckets();
            }
            return numBuckets;
        }
        return pr2.getTotalNumberOfBuckets();
    }

    public static <K, V> DistributedMember getPrimaryMemberForKey(Region<K, V> r, K key2) {
        PartitionedRegion pr2 = PartitionRegionHelper.isPartitionedCheck(r);
        int bucketId = PartitionedRegionHelper.getHashKey(pr2, null, key2, null, null);
        return pr2.getBucketPrimary(bucketId);
    }

    public static <K, V> Set<DistributedMember> getRedundantMembersForKey(Region<K, V> r, K key2) {
        DistributedMember primary = PartitionRegionHelper.getPrimaryMemberForKey(r, key2);
        Set<DistributedMember> owners = PartitionRegionHelper.getAllForKey(r, key2);
        if (primary != null) {
            owners.remove(primary);
        }
        return Collections.unmodifiableSet(owners);
    }

    public static <K, V> Set<DistributedMember> getAllMembersForKey(Region<K, V> r, K key2) {
        return Collections.unmodifiableSet(PartitionRegionHelper.getAllForKey(r, key2));
    }

    private static <K, V> Set<? extends DistributedMember> getAllForKey(Region<K, V> r, K key2) {
        PartitionedRegion pr2 = PartitionRegionHelper.isPartitionedCheck(r);
        int bucketId = PartitionedRegionHelper.getHashKey(pr2, null, key2, null, null);
        return pr2.getRegionAdvisor().getBucketOwners(bucketId);
    }

    public static Map<String, Region<?, ?>> getLocalColocatedRegions(RegionFunctionContext c) {
        Region r = c.getDataSet();
        PartitionRegionHelper.isPartitionedCheck(r);
        InternalRegionFunctionContext rfci = (InternalRegionFunctionContext)c;
        Map<String, Region<?, ?>> ret = rfci.getColocatedLocalDataSets();
        return ret;
    }

    public static <K, V> Region<K, V> getLocalDataForContext(RegionFunctionContext c) {
        Region r = c.getDataSet();
        PartitionRegionHelper.isPartitionedCheck(r);
        InternalRegionFunctionContext rfci = (InternalRegionFunctionContext)c;
        return rfci.getLocalDataSet(r);
    }

    public static <K, V> Region<K, V> getLocalData(Region<K, V> r) {
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr2 = (PartitionedRegion)r;
            Set<Integer> buckets = pr2.getDataStore() != null ? pr2.getDataStore().getAllLocalBucketIds() : Collections.emptySet();
            return new LocalDataSet(pr2, buckets);
        }
        if (r instanceof LocalDataSet) {
            return r;
        }
        throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
    }

    public static <K, V> Region<K, V> getLocalPrimaryData(Region<K, V> r) {
        if (PartitionRegionHelper.isPartitionedRegion(r)) {
            PartitionedRegion pr2 = (PartitionedRegion)r;
            Set<Integer> buckets = pr2.getDataStore() != null ? pr2.getDataStore().getAllLocalPrimaryBucketIds() : Collections.emptySet();
            return new LocalDataSet(pr2, buckets);
        }
        if (r instanceof LocalDataSet) {
            return r;
        }
        throw new IllegalArgumentException(LocalizedStrings.PartitionManager_REGION_0_IS_NOT_A_PARTITIONED_REGION.toLocalizedString(r.getFullPath()));
    }

    public static <K> void moveBucketByKey(Region<K, ?> region, DistributedMember source, DistributedMember destination, K key2) {
        PartitionedRegion pr2 = PartitionRegionHelper.isPartitionedCheck(region);
        if (pr2.isFixedPartitionedRegion()) {
            throw new IllegalStateException("Cannot move data in a fixed partitioned region");
        }
        int bucketId = pr2.getKeyInfo(key2).getBucketId();
        ExplicitMoveDirector director = new ExplicitMoveDirector(key2, bucketId, source, destination, region.getCache().getDistributedSystem());
        PartitionedRegionRebalanceOp rebalance2 = new PartitionedRegionRebalanceOp(pr2, false, director, true, true);
        rebalance2.execute();
    }

    public static RebalanceResults moveData(Region<?, ?> region, DistributedMember source, DistributedMember destination, float percentage) {
        PartitionedRegion pr2 = PartitionRegionHelper.isPartitionedCheck(region);
        if (pr2.isFixedPartitionedRegion()) {
            throw new IllegalStateException("Cannot move data in a fixed partitioned region");
        }
        if (percentage <= 0.0f || (double)percentage > 100.0) {
            throw new IllegalArgumentException("Percentage must be between 0 and 100");
        }
        PercentageMoveDirector director = new PercentageMoveDirector(source, destination, percentage);
        PartitionedRegionRebalanceOp rebalance2 = new PartitionedRegionRebalanceOp(pr2, false, director, true, true);
        Set<PartitionRebalanceInfo> results = rebalance2.execute();
        RebalanceResultsImpl rebalanceResults = new RebalanceResultsImpl();
        for (PartitionRebalanceInfo details : results) {
            rebalanceResults.addDetails(details);
        }
        return rebalanceResults;
    }
}

