/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.AbstractCompiledValue;
import com.gemstone.gemfire.cache.query.internal.AbstractGroupOrRangeJunction;
import com.gemstone.gemfire.cache.query.internal.CompiledJunction;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CompositeGroupJunction;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.Filter;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.ResultsBag;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.internal.parse.OQLLexerTokenTypes;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class AllGroupJunction
extends AbstractCompiledValue
implements Filter,
OQLLexerTokenTypes {
    private List abstractGroupOrRangeJunctions = null;
    private int operator = 0;
    private List iterOperands = null;

    AllGroupJunction(List abstractGroupOrRangeJunctions, int operator, List iterOperands) {
        this.operator = operator;
        this.abstractGroupOrRangeJunctions = abstractGroupOrRangeJunctions;
        if (operator != 84) {
            Support.Assert(iterOperands.size() == 0, "For OR Junction all operands need to be filterOperands");
        }
        this.iterOperands = iterOperands;
    }

    @Override
    public List getChildren() {
        ArrayList children = new ArrayList();
        children.addAll(this.abstractGroupOrRangeJunctions);
        children.addAll(this.iterOperands);
        return children;
    }

    @Override
    public Object evaluate(ExecutionContext context) {
        Support.assertionFailed("Should not have come here");
        return null;
    }

    @Override
    public int getType() {
        return -8;
    }

    @Override
    public SelectResults filterEvaluate(ExecutionContext context, SelectResults intermediateResults) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (this.operator == 84) {
            return this.evaluateAndJunction(context);
        }
        return this.evaluateOrJunction(context);
    }

    private SelectResults evaluateAndJunction(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        int len = this.abstractGroupOrRangeJunctions.size();
        Collection[] results = new SelectResults[len];
        List finalList = context.getCurrentIterators();
        LinkedList expansionList = new LinkedList(finalList);
        RuntimeIterator[][] itrsForResultFields = new RuntimeIterator[len][];
        CompiledValue gj = null;
        Iterator junctionItr = this.abstractGroupOrRangeJunctions.iterator();
        List grpItrs = null;
        int j = 0;
        RuntimeIterator tempItr = null;
        while (junctionItr.hasNext()) {
            gj = (CompiledValue)junctionItr.next();
            SelectResults filterResults = ((Filter)((Object)gj)).filterEvaluate(context, null);
            Support.Assert(filterResults != null, "FilterResults cannot be null here");
            if (filterResults.isEmpty()) {
                ObjectType type;
                if (finalList.size() > 1) {
                    type = QueryUtils.createStructTypeForRuntimeIterators(finalList);
                    return new StructBag((StructTypeImpl)type, context.getCachePerfStats());
                }
                type = ((RuntimeIterator)finalList.iterator().next()).getElementType();
                if (type instanceof StructType) {
                    return new StructBag((StructTypeImpl)type, context.getCachePerfStats());
                }
                return new ResultsBag(type, context.getCachePerfStats());
            }
            results[j] = filterResults;
            grpItrs = gj instanceof CompositeGroupJunction ? QueryUtils.getDependentItrChainForIndpndntItrs(((CompositeGroupJunction)gj).getIndependentIteratorsOfCJ(), context) : context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(((AbstractGroupOrRangeJunction)gj).getIndependentIteratorForGroup()[0]);
            itrsForResultFields[j] = new RuntimeIterator[grpItrs.size()];
            Iterator grpItr = grpItrs.iterator();
            int k = 0;
            while (grpItr.hasNext()) {
                tempItr = (RuntimeIterator)grpItr.next();
                itrsForResultFields[j][k++] = tempItr;
                expansionList.remove(tempItr);
            }
            ++j;
        }
        SelectResults resultsSet = null;
        CompiledValue iterOperandsToSend = null;
        if (!this.iterOperands.isEmpty()) {
            int size2 = this.iterOperands.size();
            CompiledValue[] cv = new CompiledValue[size2];
            for (int k = 0; k < size2; ++k) {
                cv[k] = (CompiledValue)this.iterOperands.get(k);
            }
            iterOperandsToSend = cv.length == 1 ? cv[0] : new CompiledJunction(cv, this.operator);
        }
        QueryObserver observer = QueryObserverHolder.getInstance();
        observer.beforeCartesianOfGroupJunctionsInAnAllGroupJunctionOfType_AND(results);
        resultsSet = QueryUtils.cartesian((SelectResults[])results, itrsForResultFields, expansionList, finalList, context, iterOperandsToSend);
        observer.afterCartesianOfGroupJunctionsInAnAllGroupJunctionOfType_AND();
        Support.Assert(resultsSet != null, "ResultsSet obtained was NULL in AllGroupJunction");
        return resultsSet;
    }

    private SelectResults evaluateOrJunction(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        SelectResults[] grpResults = new SelectResults[1];
        List finalList = context.getCurrentIterators();
        RuntimeIterator[][] itrsForResultFields = new RuntimeIterator[1][];
        CompiledValue gj = null;
        Iterator junctionItr = this.abstractGroupOrRangeJunctions.iterator();
        List grpItrs = null;
        RuntimeIterator tempItr = null;
        SelectResults intermediateResults = null;
        while (junctionItr.hasNext()) {
            LinkedList expansionList = new LinkedList(finalList);
            gj = (CompiledValue)junctionItr.next();
            grpResults[0] = ((Filter)((Object)gj)).filterEvaluate(context, null);
            grpItrs = gj instanceof CompositeGroupJunction ? QueryUtils.getDependentItrChainForIndpndntItrs(((CompositeGroupJunction)gj).getIndependentIteratorsOfCJ(), context) : context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(((AbstractGroupOrRangeJunction)gj).getIndependentIteratorForGroup()[0]);
            itrsForResultFields[0] = new RuntimeIterator[grpItrs.size()];
            Iterator grpItr = grpItrs.iterator();
            int k = 0;
            while (grpItr.hasNext()) {
                tempItr = (RuntimeIterator)grpItr.next();
                itrsForResultFields[0][k++] = tempItr;
                expansionList.remove(tempItr);
            }
            SelectResults expandedResult = QueryUtils.cartesian(grpResults, itrsForResultFields, expansionList, finalList, context, null);
            intermediateResults = intermediateResults == null ? expandedResult : QueryUtils.union(expandedResult, intermediateResults, context);
        }
        return intermediateResults;
    }

    List getGroupOperands() {
        return Collections.unmodifiableList(this.abstractGroupOrRangeJunctions);
    }

    List getIterOperands() {
        return Collections.unmodifiableList(this.iterOperands);
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return 1;
    }
}

