/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.CqServiceStatistics;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;

public class CqServiceStatisticsImpl
implements CqServiceStatistics {
    private CqService cqService;

    public CqServiceStatisticsImpl(CqService cqs) {
        this.cqService = cqs;
    }

    @Override
    public long numCqsActive() {
        return this.cqService.getCqServiceVsdStats().getNumCqsActive();
    }

    @Override
    public long numCqsCreated() {
        return this.cqService.getCqServiceVsdStats().getNumCqsCreated();
    }

    @Override
    public long numCqsClosed() {
        return this.cqService.getCqServiceVsdStats().getNumCqsClosed();
    }

    @Override
    public long numCqsStopped() {
        return this.cqService.getCqServiceVsdStats().getNumCqsStopped();
    }

    @Override
    public long numCqsOnClient() {
        return this.cqService.getCqServiceVsdStats().getNumCqsOnClient();
    }

    @Override
    public long numCqsOnRegion(String regionName) {
        DefaultQueryService queryService = (DefaultQueryService)((GemFireCacheImpl)CacheFactory.getAnyInstance()).getLocalQueryService();
        try {
            CqQuery[] cqs = queryService.getCqs(regionName);
            if (cqs != null) {
                return cqs.length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0L;
    }
}

