/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.CqState;

public class CqStateImpl
implements CqState {
    public static final int STOPPED = 0;
    public static final int RUNNING = 1;
    public static final int CLOSED = 2;
    public static final int CLOSING = 3;
    public static final int INIT = 4;
    private volatile int state = 4;

    @Override
    public boolean isRunning() {
        return this.state == 1;
    }

    @Override
    public boolean isStopped() {
        return this.state == 0 || this.state == 4;
    }

    @Override
    public boolean isClosed() {
        return this.state == 2;
    }

    @Override
    public boolean isClosing() {
        return this.state == 3;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getState() {
        return this.state;
    }

    @Override
    public String toString() {
        switch (this.state) {
            case 0: {
                return "STOPPED";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "CLOSED";
            }
        }
        return "UNKNOWN";
    }
}

