/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheRuntimeException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.ProxyCache;
import com.gemstone.gemfire.cache.client.internal.ServerProxy;
import com.gemstone.gemfire.cache.client.internal.UserAttributes;
import com.gemstone.gemfire.cache.execute.RegionFunctionContext;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.QueryStatistics;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.CompiledIteratorDef;
import com.gemstone.gemfire.cache.query.internal.CompiledSelect;
import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.IndexTrackingQueryObserver;
import com.gemstone.gemfire.cache.query.internal.QCompiler;
import com.gemstone.gemfire.cache.query.internal.QueryExecutionCanceledException;
import com.gemstone.gemfire.cache.query.internal.QueryExecutionContext;
import com.gemstone.gemfire.cache.query.internal.QueryExecutor;
import com.gemstone.gemfire.cache.query.internal.QueryMonitor;
import com.gemstone.gemfire.cache.query.internal.QueryObserver;
import com.gemstone.gemfire.cache.query.internal.QueryObserverHolder;
import com.gemstone.gemfire.cache.query.internal.ResultsCollectionCopyOnReadWrapper;
import com.gemstone.gemfire.cache.query.internal.ResultsCollectionPdxDeserializerWrapper;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PRQueryProcessor;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultQuery
implements Query {
    private final CompiledValue compiledQuery;
    private final String queryString;
    private final Cache cache;
    private ServerProxy serverProxy;
    protected AtomicLong numExecutions = new AtomicLong(0L);
    protected AtomicLong totalExecutionTime = new AtomicLong(0L);
    private QueryStatistics stats;
    private boolean isCompiled = false;
    private boolean traceOn = false;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    public static boolean QUERY_VERBOSE = Boolean.getBoolean("gemfire.Query.VERBOSE");
    public static final int COMPILED_QUERY_CLEAR_TIME = Integer.getInteger("gemfire.Query.COMPILED_QUERY_CLEAR_TIME", 600000);
    public static int TEST_COMPILED_QUERY_CLEAR_TIME = -1;
    public static final Object NULL_RESULT = new Object();
    private volatile boolean isCanceled = false;
    private CacheRuntimeException canceledException;
    private final boolean[] queryCompletedForMonitoring = new boolean[]{false};
    private ProxyCache proxyCache;
    private boolean isCqQuery = false;
    private boolean isQueryWithFunctionContext = false;
    private CqQueryImpl cqQuery = null;
    private volatile boolean lastUsed = true;
    public static TestHook testHook;
    private static final ThreadLocal<Boolean> pdxReadSerialized;
    private boolean isRemoteQuery = false;
    private boolean keepSerialized = false;
    private static final ThreadLocal<Map<String, Set<String>>> pdxClassToFieldsMap;
    private static final ThreadLocal<Map<String, Set<String>>> pdxClassToMethodsMap;

    public static void setPdxClasstofieldsmap(Map<String, Set<String>> map) {
        pdxClassToFieldsMap.set(map);
    }

    public static Map<String, Set<String>> getPdxClasstofieldsmap() {
        return pdxClassToFieldsMap.get();
    }

    public static void setPdxClasstoMethodsmap(Map<String, Set<String>> map) {
        pdxClassToMethodsMap.set(map);
    }

    public static Map<String, Set<String>> getPdxClasstoMethodsmap() {
        return pdxClassToMethodsMap.get();
    }

    public DefaultQuery(String queryString, Cache cache) {
        this.queryString = queryString;
        QCompiler compiler = new QCompiler();
        this.compiledQuery = compiler.compileQuery(queryString);
        this.traceOn = compiler.isTraceRequested() || QUERY_VERBOSE;
        this.cache = cache;
        this.stats = new DefaultQueryStatistics();
    }

    public static boolean getPdxReadSerialized() {
        return pdxReadSerialized.get();
    }

    public static void setPdxReadSerialized(boolean readSerialized) {
        pdxReadSerialized.set(readSerialized);
    }

    public static void setPdxReadSerialized(Cache cache, boolean readSerialized) {
        if (cache != null && !cache.getPdxReadSerialized()) {
            DefaultQuery.setPdxReadSerialized(readSerialized);
        }
    }

    @Override
    public QueryStatistics getStatistics() {
        return this.stats;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public Object execute() throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.execute(EMPTY_ARRAY);
    }

    @Override
    public Object execute(Object[] parameters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object object;
        QueryExecutionContext context;
        QueryMonitor queryMonitor;
        QueryObserver indexObserver;
        Object result;
        long startTime;
        block19: {
            if (parameters == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_PARAMETERS_CANNOT_BE_NULL.toLocalizedString());
            }
            if (this.serverProxy != null) {
                return this.executeOnServer(parameters);
            }
            startTime = 0L;
            result = null;
            if (this.traceOn && this.cache != null) {
                startTime = NanoTimer.getTime();
            }
            indexObserver = null;
            queryMonitor = null;
            QueryExecutor qe = this.checkQueryOnPR(parameters);
            DefaultQuery.setPdxReadSerialized(this.cache, true);
            context = new QueryExecutionContext(parameters, this.cache, this);
            indexObserver = this.startTrace();
            if (qe == null) break block19;
            if (testHook != null) {
                testHook.doTestHook(1);
            }
            result = qe.executeQuery(this, parameters, null);
            if (!this.isRemoteQuery() && !this.cache.getPdxReadSerialized() && result instanceof SelectResults) {
                result = new ResultsCollectionPdxDeserializerWrapper((SelectResults)result, false);
            }
            Object object2 = result;
            DefaultQuery.setPdxReadSerialized(this.cache, false);
            if (queryMonitor != null) {
                queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
            }
            this.endTrace(indexObserver, startTime, result);
            return object2;
        }
        try {
            boolean needsCopyOnReadWrapper;
            if (GemFireCacheImpl.getInstance() != null) {
                queryMonitor = GemFireCacheImpl.getInstance().getQueryMonitor();
            }
            if (queryMonitor != null) {
                queryMonitor.monitorQueryThread(Thread.currentThread(), this);
            }
            ((ExecutionContext)context).setCqQueryContext(this.isCqQuery);
            result = this.executeUsingContext(context);
            boolean bl = needsCopyOnReadWrapper = this.cache.getCopyOnRead() && !DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL || context.isIndexUsed() && DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL;
            if (!this.isRemoteQuery() && !this.cache.getPdxReadSerialized() && result instanceof SelectResults) {
                result = new ResultsCollectionPdxDeserializerWrapper((SelectResults)result, needsCopyOnReadWrapper);
            } else if (!this.isRemoteQuery() && this.cache.getCopyOnRead() && result instanceof SelectResults && needsCopyOnReadWrapper) {
                result = new ResultsCollectionCopyOnReadWrapper((SelectResults)result);
            }
            object = result;
        }
        catch (QueryExecutionCanceledException e) {
            try {
                if (this.canceledException != null) {
                    throw this.canceledException;
                }
                throw new QueryExecutionCanceledException("Query was canceled. It may be due to low memory or the query was running longer than the MAX_QUERY_EXECUTION_TIME.");
            }
            catch (Throwable throwable) {
                DefaultQuery.setPdxReadSerialized(this.cache, false);
                if (queryMonitor != null) {
                    queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
                }
                this.endTrace(indexObserver, startTime, result);
                throw throwable;
            }
        }
        DefaultQuery.setPdxReadSerialized(this.cache, false);
        if (queryMonitor != null) {
            queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
        }
        this.endTrace(indexObserver, startTime, result);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeOnServer(Object[] parameters) {
        long startTime = CachePerfStats.getStatTime();
        SelectResults result = null;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw new CacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            result = this.serverProxy.query(this.queryString, parameters);
        }
        finally {
            UserAttributes.userAttributes.set(null);
            long endTime = CachePerfStats.getStatTime();
            this.updateStatistics(endTime - startTime);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object prExecuteOnBucket(Object[] parameters, PartitionedRegion pr2, BucketRegion bukRgn) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        if (parameters == null) {
            parameters = EMPTY_ARRAY;
        }
        long startTime = 0L;
        Object result = null;
        if (this.traceOn && this.cache != null) {
            startTime = NanoTimer.getTime();
        }
        IndexTrackingQueryObserver indexObserver = null;
        String otherObserver = null;
        if (this.traceOn) {
            QueryObserver qo = QueryObserverHolder.getInstance();
            if (qo instanceof IndexTrackingQueryObserver) {
                indexObserver = (IndexTrackingQueryObserver)qo;
            } else if (!QueryObserverHolder.hasObserver()) {
                indexObserver = new IndexTrackingQueryObserver();
                QueryObserverHolder.setInstance(indexObserver);
            } else {
                otherObserver = qo.getClass().getName();
            }
        }
        QueryExecutionContext context = new QueryExecutionContext(parameters, this.cache, this);
        context.setBucketRegion(pr2, bukRgn);
        ((ExecutionContext)context).setCqQueryContext(this.isCqQuery);
        QueryMonitor queryMonitor = null;
        if (GemFireCacheImpl.getInstance() != null) {
            queryMonitor = GemFireCacheImpl.getInstance().getQueryMonitor();
        }
        if (queryMonitor != null && PRQueryProcessor.NUM_THREADS > 1) {
            queryMonitor.monitorQueryThread(Thread.currentThread(), this);
        }
        try {
            result = this.executeUsingContext(context);
        }
        finally {
            if (queryMonitor != null && PRQueryProcessor.NUM_THREADS > 1) {
                queryMonitor.stopMonitoringQueryThread(Thread.currentThread(), this);
            }
            int resultSize = 0;
            if (this.traceOn && result instanceof Collection) {
                resultSize = ((Collection)result).size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, otherObserver, resultSize, this.queryString, bukRgn);
            if (this.traceOn && this.cache != null && this.cache.getLogger().fineEnabled()) {
                this.cache.getLogger().fine(queryVerboseMsg);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeUsingContext(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        long startTime = CachePerfStats.getStatTime();
        TXStateProxy tx = null;
        if (!((GemFireCacheImpl)this.cache).isClient()) {
            tx = ((TXManagerImpl)this.cache.getCacheTransactionManager()).internalSuspend();
        }
        try {
            observer.startQuery(this);
            observer.beforeQueryEvaluation(this.compiledQuery, context);
            Object results = null;
            try {
                this.compiledQuery.computeDependencies(context);
                if (testHook != null) {
                    testHook.doTestHook(1);
                }
                results = this.compiledQuery.evaluate(context);
            }
            catch (QueryExecutionCanceledException e) {
                try {
                    if (this.canceledException != null) {
                        throw this.canceledException;
                    }
                    throw new QueryExecutionCanceledException("Query was canceled. It may be due to low memory or the query was running longer than the MAX_QUERY_EXECUTION_TIME.");
                }
                catch (Throwable throwable) {
                    observer.afterQueryEvaluation(results);
                    throw throwable;
                }
            }
            observer.afterQueryEvaluation(results);
            Object object = results;
            return object;
        }
        finally {
            observer.endQuery();
            long endTime = CachePerfStats.getStatTime();
            this.updateStatistics(endTime - startTime);
            pdxClassToFieldsMap.remove();
            pdxClassToMethodsMap.remove();
            if (tx != null) {
                ((TXManagerImpl)this.cache.getCacheTransactionManager()).resume(tx);
            }
        }
    }

    private QueryExecutor checkQueryOnPR(Object[] parameters) throws RegionNotFoundException {
        ArrayList<QueryExecutor> prs = new ArrayList<QueryExecutor>();
        for (String regionPath : this.getRegionsInQuery(parameters)) {
            Region rgn = this.cache.getRegion(regionPath);
            if (rgn == null) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw new RegionNotFoundException(LocalizedStrings.DefaultQuery_REGION_NOT_FOUND_0.toLocalizedString(regionPath));
            }
            if (!(rgn instanceof QueryExecutor)) continue;
            prs.add((QueryExecutor)((Object)rgn));
        }
        if (prs.size() == 1) {
            return (QueryExecutor)prs.get(0);
        }
        if (prs.size() > 1) {
            if (!this.isQueryWithFunctionContext()) {
                throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_A_QUERY_ON_A_PARTITIONED_REGION_0_MAY_NOT_REFERENCE_ANY_OTHER_REGION_1.toLocalizedString(((QueryExecutor)prs.get(0)).getName(), ((QueryExecutor)prs.get(1)).getName()));
            }
            QueryExecutor root = null;
            for (QueryExecutor eachPR : prs) {
                boolean colocated = false;
                for (QueryExecutor allPRs : prs) {
                    if (eachPR == allPRs || !((PartitionedRegion)eachPR).colocatedByList.contains(allPRs) && !((PartitionedRegion)allPRs).colocatedByList.contains(eachPR)) continue;
                    colocated = true;
                    break;
                }
                if (!colocated && root != null) {
                    throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_A_QUERY_ON_A_PARTITIONED_REGION_0_MAY_NOT_REFERENCE_ANY_OTHER_NON_COLOCATED_PARTITIONED_REGION_1.toLocalizedString(eachPR.getName(), root.getName()));
                }
                root = eachPR;
            }
            CompiledSelect select2 = this.getSimpleSelect();
            if (select2 == null) {
                throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_QUERY_MUST_BE_A_SIMPLE_SELECT_WHEN_REFERENCING_A_PARTITIONED_REGION.toLocalizedString());
            }
            HashSet regions = new HashSet();
            CompiledValue whereClause = select2.getWhereClause();
            if (whereClause != null) {
                whereClause.getRegionsInQuery(regions, parameters);
                if (!regions.isEmpty()) {
                    throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_THE_WHERE_CLAUSE_CANNOT_REFER_TO_A_REGION_WHEN_QUERYING_ON_A_PARTITIONED_REGION.toLocalizedString());
                }
            }
            List fromClause = select2.getIterators();
            Iterator fromClauseIterator = fromClause.iterator();
            CompiledIteratorDef itrDef = (CompiledIteratorDef)fromClauseIterator.next();
            itrDef.visitNodes(new CompiledValue.NodeVisitor(){

                @Override
                public boolean visit(CompiledValue node) {
                    if (node instanceof CompiledSelect) {
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONEDREGION_THE_FIRST_FROM_CLAUSE_ITERATOR_MUST_NOT_CONTAIN_A_SUBQUERY.toLocalizedString());
                    }
                    return true;
                }
            });
            if (!this.isQueryWithFunctionContext()) {
                List orderBys;
                while (fromClauseIterator.hasNext()) {
                    itrDef = (CompiledIteratorDef)fromClauseIterator.next();
                    itrDef.getRegionsInQuery(regions, parameters);
                    if (regions.isEmpty()) continue;
                    throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONED_REGION_THE_FROM_CLAUSE_ITERATORS_OTHER_THAN_THE_FIRST_ONE_MUST_NOT_REFERENCE_ANY_REGIONS.toLocalizedString());
                }
                List projs = select2.getProjectionAttributes();
                if (projs != null) {
                    for (Object[] rawProj : projs) {
                        CompiledValue proj = (CompiledValue)rawProj[1];
                        proj.getRegionsInQuery(regions, parameters);
                        if (regions.isEmpty()) continue;
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONED_REGION_THE_PROJECTIONS_MUST_NOT_REFERENCE_ANY_REGIONS.toLocalizedString());
                    }
                }
                if ((orderBys = select2.getOrderByAttrs()) != null) {
                    for (CompiledValue orderBy : orderBys) {
                        orderBy.getRegionsInQuery(regions, parameters);
                        if (regions.isEmpty()) continue;
                        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_WHEN_QUERYING_A_PARTITIONED_REGION_THE_ORDERBY_ATTRIBUTES_MUST_NOT_REFERENCE_ANY_REGIONS.toLocalizedString());
                    }
                }
            }
            return (QueryExecutor)prs.get(0);
        }
        return null;
    }

    private void updateStatistics(long executionTime) {
        this.numExecutions.incrementAndGet();
        this.totalExecutionTime.addAndGet(executionTime);
        ((GemFireCacheImpl)this.cache).getCachePerfStats().endQueryExecution(executionTime);
    }

    @Override
    public void compile() throws TypeMismatchException, NameResolutionException {
        throw new UnsupportedOperationException(LocalizedStrings.DefaultQuery_NOT_YET_IMPLEMENTED.toLocalizedString());
    }

    @Override
    public boolean isCompiled() {
        return this.isCompiled;
    }

    public boolean isTraced() {
        return this.traceOn;
    }

    public Set getRegionsInQuery(Object[] parameters) {
        HashSet regions = new HashSet();
        this.compiledQuery.getRegionsInQuery(regions, parameters);
        return Collections.unmodifiableSet(regions);
    }

    public CompiledSelect getSimpleSelect() {
        if (this.compiledQuery instanceof CompiledSelect) {
            return (CompiledSelect)this.compiledQuery;
        }
        return null;
    }

    public CompiledSelect getSelect() {
        return (CompiledSelect)this.compiledQuery;
    }

    public int getLimit(Object[] bindArguments) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.compiledQuery instanceof CompiledSelect ? ((CompiledSelect)this.compiledQuery).getLimitValue(bindArguments) : -1;
    }

    public void setServerProxy(ServerProxy serverProxy) {
        this.serverProxy = serverProxy;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public CacheRuntimeException getQueryCanceledException() {
        return this.canceledException;
    }

    public boolean[] getQueryCompletedForMonitoring() {
        return this.queryCompletedForMonitoring;
    }

    public void setQueryCompletedForMonitoring(boolean value2) {
        this.queryCompletedForMonitoring[0] = value2;
    }

    public void setCanceled(boolean isCanceled, CacheRuntimeException canceledException) {
        this.isCanceled = isCanceled;
        this.canceledException = canceledException;
    }

    public void setIsCqQuery(boolean isCqQuery) {
        this.isCqQuery = isCqQuery;
    }

    public boolean isCqQuery() {
        return this.isCqQuery;
    }

    public void setCqQuery(CqQueryImpl cqQuery) {
        this.cqQuery = cqQuery;
    }

    public void setLastUsed(boolean lastUsed) {
        this.lastUsed = lastUsed;
    }

    public boolean getLastUsed() {
        return this.lastUsed;
    }

    public CqQueryImpl getCqQuery() {
        return this.cqQuery;
    }

    public String toString() {
        StringBuffer tempBuff = new StringBuffer("Query String = ");
        tempBuff.append(this.queryString);
        tempBuff.append(';');
        tempBuff.append("isCancelled = ");
        tempBuff.append(this.isCanceled);
        tempBuff.append("; Total Executions = ");
        tempBuff.append(this.numExecutions);
        tempBuff.append("; Total Execution Time = ");
        tempBuff.append(this.totalExecutionTime);
        return tempBuff.toString();
    }

    void setProxyCache(ProxyCache proxyCache) {
        this.proxyCache = proxyCache;
    }

    public static void setTestCompiledQueryClearTime(int val) {
        TEST_COMPILED_QUERY_CLEAR_TIME = val;
    }

    public static String getLogMessage(QueryObserver observer, long startTime, int resultSize, String query) {
        String usedIndexesString = null;
        String rowCountString = null;
        float time = 0.0f;
        time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        if (observer != null && observer instanceof IndexTrackingQueryObserver) {
            IndexTrackingQueryObserver indexObserver = (IndexTrackingQueryObserver)observer;
            Map usedIndexes = indexObserver.getUsedIndexes();
            indexObserver.reset();
            StringBuffer buf = new StringBuffer();
            buf.append(" indexesUsed(");
            buf.append(usedIndexes.size());
            buf.append(")");
            if (usedIndexes.size() > 0) {
                buf.append(":");
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey().toString() + entry.getValue());
                    if (!itr.hasNext()) continue;
                    buf.append(",");
                }
            }
            usedIndexesString = buf.toString();
        } else if (QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + observer.getClass().getName() + ")";
        }
        if (resultSize != -1) {
            rowCountString = " rowCount = " + resultSize + ";";
        }
        return "Query Executed in " + time + " ms;" + (rowCountString != null ? rowCountString : "") + (usedIndexesString != null ? usedIndexesString : "") + " \"" + query + "\"";
    }

    public static String getLogMessage(IndexTrackingQueryObserver indexObserver, long startTime, String otherObserver, int resultSize, String query, BucketRegion bucket) {
        String usedIndexesString = null;
        String rowCountString = null;
        float time = 0.0f;
        if (startTime > 0L) {
            time = (float)(NanoTimer.getTime() - startTime) / 1000000.0f;
        }
        if (indexObserver != null) {
            Map usedIndexes = indexObserver.getUsedIndexes(bucket.getFullPath());
            StringBuffer buf = new StringBuffer();
            buf.append(" indexesUsed(");
            buf.append(usedIndexes.size());
            buf.append(")");
            if (usedIndexes.size() > 0) {
                buf.append(":");
                Iterator itr = usedIndexes.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey().toString() + "(Results: " + entry.getValue() + ", Bucket: " + bucket.getId() + ")");
                    if (!itr.hasNext()) continue;
                    buf.append(",");
                }
            }
            usedIndexesString = buf.toString();
        } else if (QUERY_VERBOSE) {
            usedIndexesString = " indexesUsed(NA due to other observer in the way: " + otherObserver + ")";
        }
        rowCountString = " rowCount = " + resultSize + ";";
        return "Query Executed" + (startTime > 0L ? " in " + time + " ms;" : ";") + (rowCountString != null ? rowCountString : "") + (usedIndexesString != null ? usedIndexesString : "") + " \"" + query + "\"";
    }

    @Override
    public Object execute(RegionFunctionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.execute(context, EMPTY_ARRAY);
    }

    @Override
    public Object execute(RegionFunctionContext context, Object[] parameters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        block6: {
            Object result = null;
            if (context == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_FUNCTIONCONTEXT_CANNOT_BE_NULL.toLocalizedString());
            }
            this.isQueryWithFunctionContext = true;
            if (parameters == null) {
                throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_PARAMETERS_CANNOT_BE_NULL.toLocalizedString());
            }
            long startTime = 0L;
            if (this.traceOn && this.cache != null) {
                startTime = NanoTimer.getTime();
            }
            QueryObserver indexObserver = null;
            QueryExecutor qe = this.checkQueryOnPR(parameters);
            try {
                indexObserver = this.startTrace();
                if (qe == null) break block6;
                Set<Integer> buckets = null;
                LocalDataSet localDataSet = (LocalDataSet)PartitionRegionHelper.getLocalDataForContext(context);
                buckets = localDataSet.getBucketSet();
                Object object = result = qe.executeQuery(this, parameters, buckets);
                this.endTrace(indexObserver, startTime, result);
                return object;
            }
            catch (Throwable throwable) {
                this.endTrace(indexObserver, startTime, result);
                throw throwable;
            }
        }
        throw new IllegalArgumentException(LocalizedStrings.DefaultQuery_API_ONLY_FOR_PR.toLocalizedString());
    }

    public boolean isQueryWithFunctionContext() {
        return this.isQueryWithFunctionContext;
    }

    public QueryObserver startTrace() {
        QueryObserver queryObserver = null;
        if (this.traceOn && this.cache != null) {
            QueryObserver qo = QueryObserverHolder.getInstance();
            if (qo instanceof IndexTrackingQueryObserver) {
                queryObserver = qo;
            } else if (!QueryObserverHolder.hasObserver()) {
                queryObserver = new IndexTrackingQueryObserver();
                QueryObserverHolder.setInstance(queryObserver);
            } else {
                queryObserver = qo;
            }
        }
        return queryObserver;
    }

    public void endTrace(QueryObserver indexObserver, long startTime, Object result) {
        if (this.traceOn && this.cache != null) {
            int resultSize = -1;
            if (result instanceof Collection) {
                resultSize = ((Collection)result).size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, resultSize, this.queryString);
            this.cache.getLogger().info(queryVerboseMsg);
        }
    }

    public void endTrace(QueryObserver indexObserver, long startTime, Collection<Collection> result) {
        if (this.cache != null && this.cache.getLogger().infoEnabled() && this.traceOn) {
            int resultSize = 0;
            Iterator<Collection> iterator = result.iterator();
            while (iterator.hasNext()) {
                resultSize += iterator.next().size();
            }
            String queryVerboseMsg = DefaultQuery.getLogMessage(indexObserver, startTime, resultSize, this.queryString);
            if (this.cache.getLogger().infoEnabled()) {
                this.cache.getLogger().info(queryVerboseMsg);
            }
        }
    }

    public boolean isRemoteQuery() {
        return this.isRemoteQuery;
    }

    public void setRemoteQuery(boolean isRemoteQuery) {
        this.isRemoteQuery = isRemoteQuery;
    }

    public void keepResultsSerialized(CompiledSelect cs, ExecutionContext context) {
        if (this.isRemoteQuery() && cs.getIterators().size() == context.getAllIndependentIteratorsOfCurrentScope().size() && cs.getWhereClause() == null && cs.getProjectionAttributes() == null && !cs.isDistinct()) {
            this.setKeepSerialized(true);
        }
    }

    public boolean isKeepSerialized() {
        return this.keepSerialized;
    }

    public void setKeepSerialized(boolean keepSerialized) {
        this.keepSerialized = keepSerialized;
    }

    static {
        pdxReadSerialized = new ThreadLocal(){

            protected Boolean initialValue() {
                return new Boolean(Boolean.FALSE);
            }
        };
        pdxClassToFieldsMap = new ThreadLocal(){

            protected Map<String, Set<String>> initialValue() {
                return new HashMap<String, Set<String>>();
            }
        };
        pdxClassToMethodsMap = new ThreadLocal(){

            protected Map<String, Set<String>> initialValue() {
                return new HashMap<String, Set<String>>();
            }
        };
    }

    public static interface TestHook {
        public void doTestHook(int var1);

        public void doTestHook(String var1);
    }

    class DefaultQueryStatistics
    implements QueryStatistics {
        DefaultQueryStatistics() {
        }

        @Override
        public long getTotalExecutionTime() {
            return DefaultQuery.this.totalExecutionTime.get();
        }

        @Override
        public long getNumExecutions() {
            return DefaultQuery.this.numExecutions.get();
        }
    }
}

