/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.internal.CompiledValue;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.IndexInfo;
import com.gemstone.gemfire.cache.query.internal.QueryUtils;
import com.gemstone.gemfire.cache.query.internal.RuntimeIterator;
import com.gemstone.gemfire.cache.query.internal.Support;
import com.gemstone.gemfire.cache.query.types.StructType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

class IndexConditioningHelper {
    boolean shufflingNeeded = true;
    RuntimeIterator[] indexFieldToItrsMapping = null;
    List expansionList = Collections.EMPTY_LIST;
    List finalList = null;
    List checkList = null;
    StructType structType = null;
    RuntimeIterator indpndntItr = null;
    IndexInfo indxInfo = null;

    public IndexConditioningHelper(IndexInfo indexInfo, ExecutionContext context, int indexFieldsSize, boolean completeExpansion, CompiledValue iterOperands, RuntimeIterator grpIndpndntItr) {
        this.indxInfo = indexInfo;
        List grpItrs = null;
        int size2 = indexInfo.mapping.length;
        this.indpndntItr = grpIndpndntItr;
        this.indexFieldToItrsMapping = new RuntimeIterator[indexFieldsSize];
        if (this.indpndntItr == null) {
            HashSet set1 = new HashSet();
            context.computeUtlimateDependencies(indexInfo._path, set1);
            Support.Assert(set1.size() == 1, " Since we are in Indexed Evaluate that means there has to be exactly one independent iterator for this compiled comparison");
            this.indpndntItr = (RuntimeIterator)set1.iterator().next();
            Support.Assert(this.indpndntItr.getScopeID() == context.currentScope().getScopeID(), " Since we are in Indexed Evaluate that means the current scope count & indpenedent iterator's scope count should match");
        }
        if (!(indexInfo._matchLevel != 0 || completeExpansion && context.getCurrentIterators().size() != size2)) {
            if (size2 > 1) {
                Support.Assert(indexInfo._index.getResultSetType() instanceof StructType, " If the match level is zero & the size of mapping array is 1 then Index is surely ResultBag else StructBag");
                grpItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(this.indpndntItr);
                boolean isReshufflingNeeded = false;
                int pos = -1;
                for (int i = 0; i < size2; ++i) {
                    pos = indexInfo.mapping[i];
                    isReshufflingNeeded = isReshufflingNeeded || pos != i + 1;
                    this.indexFieldToItrsMapping[pos - 1] = (RuntimeIterator)grpItrs.get(i);
                }
                this.finalList = grpItrs;
                if (isReshufflingNeeded || iterOperands != null) {
                    this.checkList = null;
                } else {
                    this.structType = QueryUtils.createStructTypeForRuntimeIterators(grpItrs);
                    this.shufflingNeeded = false;
                }
            } else {
                this.finalList = new ArrayList();
                this.finalList.add(this.indpndntItr);
                Support.Assert(this.indexFieldToItrsMapping.length == 1, "In this else block , it should be guaranteed that there exists only one iterator in query as well as index from clause & that should be nothing but the independent RuntimeIterator of the group  ");
                this.indexFieldToItrsMapping[0] = this.indpndntItr;
                this.shufflingNeeded = iterOperands != null;
            }
        } else {
            boolean cutDownNeeded;
            grpItrs = context.getCurrScopeDpndntItrsBasedOnSingleIndpndntItr(this.indpndntItr);
            int pos = -1;
            this.finalList = completeExpansion ? context.getCurrentIterators() : grpItrs;
            this.checkList = new ArrayList();
            this.expansionList = new LinkedList(this.finalList);
            RuntimeIterator tempItr = null;
            int unMappedFields = indexFieldsSize;
            for (int i = 0; i < size2; ++i) {
                pos = indexInfo.mapping[i];
                if (pos <= 0) continue;
                this.indexFieldToItrsMapping[pos - 1] = tempItr = (RuntimeIterator)grpItrs.get(i);
                this.expansionList.remove(tempItr);
                this.checkList.add(tempItr);
                --unMappedFields;
            }
            boolean bl = cutDownNeeded = unMappedFields > 0;
            if (!cutDownNeeded) {
                this.checkList = null;
            }
        }
    }
}

