/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.query.internal.HashingStrategy;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectIntHashMap
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7718697444988416372L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    final HashingStrategy hashingStrategy;
    private transient Set<Entry> entrySet = null;
    private transient Set<Object> keySet = null;

    public ObjectIntHashMap(int initialCapacity, float loadFactor, HashingStrategy hs) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.hashingStrategy = hs == null ? new IntHashMapStrategy() : hs;
        this.init();
    }

    public ObjectIntHashMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, null);
    }

    public ObjectIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f, null);
    }

    public ObjectIntHashMap(int initialCapacity, HashingStrategy hs) {
        this(initialCapacity, 0.75f, hs);
    }

    public ObjectIntHashMap() {
        this(null);
    }

    public ObjectIntHashMap(HashingStrategy hs) {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.hashingStrategy = hs == null ? new IntHashMapStrategy() : hs;
        this.init();
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(Object key2) {
        if (key2 == null) {
            return this.getForNullKey();
        }
        int hash = ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key2));
        Entry e = this.table[ObjectIntHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key2 || this.hashingStrategy.equals(k, key2))) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    private int getForNullKey() {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    public boolean containsKey(Object key2) {
        return this.getEntry(key2) != null;
    }

    final Entry getEntry(Object key2) {
        int hash = key2 == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key2));
        Entry e = this.table[ObjectIntHashMap.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key2 || key2 != null && this.hashingStrategy.equals(k, key2))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public int put(Object key2, int value2) {
        if (key2 == null) {
            return this.putForNullKey(value2);
        }
        int hash = ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key2));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key2 || this.hashingStrategy.equals(k, key2))) {
                int oldValue = e.value;
                e.value = value2;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key2, value2, i);
        return 0;
    }

    private int putForNullKey(int value2) {
        Entry e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                int oldValue = e.value;
                e.value = value2;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value2, 0);
        return 0;
    }

    private void putForCreate(Object key2, int value2) {
        int hash = key2 == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key2));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key2 || key2 != null && this.hashingStrategy.equals(k, key2))) {
                e.value = value2;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key2, value2, i);
    }

    private void putAllForCreate(ObjectIntHashMap m) {
        for (Entry e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry[] newTable) {
        Entry[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next2;
            Entry e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next2 = e.next;
                int i = ObjectIntHashMap.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next2) != null);
        }
    }

    public void putAll(ObjectIntHashMap m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (Entry e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public int remove(Object key2) {
        Entry e = this.removeEntryForKey(key2);
        return e == null ? 0 : e.value;
    }

    final Entry removeEntryForKey(Object key2) {
        Entry prev;
        int hash = key2 == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key2));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Object k;
            Entry next2 = e.next;
            if (e.hash == hash && ((k = e.key) == key2 || key2 != null && this.hashingStrategy.equals(k, key2))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next2;
                } else {
                    prev.next = next2;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next2;
        }
        return e;
    }

    final Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Entry)) {
            return null;
        }
        Entry entry = (Entry)o;
        Object key2 = entry.getKey();
        int hash = key2 == null ? 0 : ObjectIntHashMap.hash(this.hashingStrategy.hashCode(key2));
        int i = ObjectIntHashMap.indexFor(hash, this.table.length);
        Entry e = prev = this.table[i];
        while (e != null) {
            Entry next2 = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next2;
                } else {
                    prev.next = next2;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next2;
        }
        return e;
    }

    public void clear() {
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(int value2) {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry e = tab[i];
            while (e != null) {
                if (value2 == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        ObjectIntHashMap result = null;
        try {
            result = (ObjectIntHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectIntHashMap)) {
            return false;
        }
        ObjectIntHashMap m = (ObjectIntHashMap)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Entry e : this.entrySet()) {
                Object key2 = e.getKey();
                int value2 = e.getValue();
                if (!m.containsKey(key2)) {
                    return false;
                }
                if (value2 == m.get(key2)) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        Iterator<Entry> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += i.next().hashCode();
        }
        return h;
    }

    public String toString() {
        Iterator<Entry> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Entry e = i.next();
            Object key2 = e.getKey();
            int value2 = e.getValue();
            sb.append(key2 == this ? "(this Map)" : key2);
            sb.append('=');
            sb.append(value2);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    void addEntry(int hash, Object key2, int value2, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key2, value2, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, Object key2, int value2, int bucketIndex) {
        Entry e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry(hash, key2, value2, e);
        ++this.size;
    }

    Iterator<Object> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Entry> newEntryIterator() {
        return new EntryIterator();
    }

    public Set<Object> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Set<Entry> entrySet() {
        return this.entrySet0();
    }

    private Set<Entry> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<Entry> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                Entry e = i.next();
                s.writeObject(e.getKey());
                s.writeInt(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size2 = s.readInt();
        for (int i = 0; i < size2; ++i) {
            Object key2 = s.readObject();
            int value2 = s.readInt();
            this.putForCreate(key2, value2);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private final class IntHashMapStrategy
    implements HashingStrategy {
        private IntHashMapStrategy() {
        }

        @Override
        public int hashCode(Object o) {
            return o.hashCode();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }
    }

    private final class EntrySet
    extends AbstractSet<Entry> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry> iterator() {
            return ObjectIntHashMap.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Entry candidate = ObjectIntHashMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return ObjectIntHashMap.this.removeMapping(o) != null;
        }

        @Override
        public int size() {
            return ObjectIntHashMap.this.size;
        }

        @Override
        public void clear() {
            ObjectIntHashMap.this.clear();
        }
    }

    private final class KeySet
    extends AbstractSet<Object> {
        private KeySet() {
        }

        @Override
        public Iterator<Object> iterator() {
            return ObjectIntHashMap.this.newKeyIterator();
        }

        @Override
        public int size() {
            return ObjectIntHashMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return ObjectIntHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return ObjectIntHashMap.this.removeEntryForKey(o) != null;
        }

        @Override
        public void clear() {
            ObjectIntHashMap.this.clear();
        }
    }

    private final class EntryIterator
    extends HashIterator<Entry> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            return this.nextEntry();
        }
    }

    private final class KeyIterator
    extends HashIterator<Object> {
        private KeyIterator() {
        }

        @Override
        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry next;
        int expectedModCount;
        int index;
        Entry current;

        HashIterator() {
            this.expectedModCount = ObjectIntHashMap.this.modCount;
            if (ObjectIntHashMap.this.size > 0) {
                Entry[] t = ObjectIntHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry nextEntry() {
            if (ObjectIntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry[] t = ObjectIntHashMap.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (ObjectIntHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            ObjectIntHashMap.this.removeEntryForKey(k);
            this.expectedModCount = ObjectIntHashMap.this.modCount;
        }
    }

    class Entry {
        final Object key;
        int value;
        Entry next;
        final int hash;

        Entry(int h, Object k, int v, Entry n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        public final Object getKey() {
            return this.key;
        }

        public final int getValue() {
            return this.value;
        }

        public final int setValue(int newValue) {
            int oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public final boolean equals(Object o) {
            int v2;
            int v1;
            Object k2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && ObjectIntHashMap.this.hashingStrategy.equals(k1, k2)) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        public final int hashCode() {
            return this.hash ^ this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(ObjectIntHashMap m) {
        }

        void recordRemoval(ObjectIntHashMap m) {
        }
    }
}

