/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheStatistics;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import com.gemstone.gemfire.cache.query.internal.DefaultQueryService;
import com.gemstone.gemfire.cache.query.internal.ExecutionContext;
import com.gemstone.gemfire.cache.query.internal.ResultsCollectionWrapper;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.ObjectTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.TypeUtils;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;

public class QRegion
implements SelectResults {
    private final Region region;
    private final SelectResults values;

    public QRegion(Region region, boolean includeKeys) {
        if (region == null) {
            throw new IllegalArgumentException(LocalizedStrings.QRegion_REGION_CAN_NOT_BE_NULL.toLocalizedString());
        }
        this.region = region;
        Class<Object> constraint = this.region.getAttributes().getValueConstraint();
        if (constraint == null) {
            constraint = Object.class;
        }
        ResultsCollectionWrapper res = null;
        res = includeKeys ? new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), this.region.entrySet()) : new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), this.region.values());
        res.setModifiable(false);
        if (!DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL) {
            res.setIgnoreCopyOnReadForQuery(true);
        }
        this.values = res;
    }

    public QRegion(Region region, boolean includeKeys, ExecutionContext context) {
        if (region == null) {
            throw new IllegalArgumentException(LocalizedStrings.QRegion_REGION_CAN_NOT_BE_NULL.toLocalizedString());
        }
        Class<Object> constraint = region.getAttributes().getValueConstraint();
        if (constraint == null) {
            constraint = Object.class;
        }
        ResultsCollectionWrapper res = null;
        if (context.getBucketList() != null && region instanceof PartitionedRegion) {
            LocalDataSet localData = new LocalDataSet((PartitionedRegion)region, new HashSet<Integer>(context.getBucketList()));
            this.region = localData;
            res = includeKeys ? new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), localData.localEntrySet()) : new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), localData.localValues());
        } else {
            this.region = region;
            res = includeKeys ? new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), region.entrySet()) : new ResultsCollectionWrapper(TypeUtils.getObjectType(constraint), region.values());
        }
        res.setModifiable(false);
        if (!DefaultQueryService.COPY_ON_READ_AT_ENTRY_LEVEL) {
            res.setIgnoreCopyOnReadForQuery(true);
        }
        this.values = res;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setKeepSerialized(boolean keepSerialized) {
        ((ResultsCollectionWrapper)this.values).setKeepSerialized(keepSerialized);
    }

    protected ObjectType getKeyType() {
        Class<Object> constraint = this.region.getAttributes().getKeyConstraint();
        if (constraint == null) {
            constraint = Object.class;
        }
        return TypeUtils.getObjectType(constraint);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        this.values.setElementType(elementType);
    }

    public SelectResults getKeys() {
        ResultsCollectionWrapper res;
        if (this.region instanceof LocalDataSet) {
            LocalDataSet localData = (LocalDataSet)this.region;
            res = new ResultsCollectionWrapper(this.getKeyType(), localData.localKeys());
        } else {
            res = new ResultsCollectionWrapper(this.getKeyType(), this.region.keys());
        }
        res.setModifiable(false);
        return res;
    }

    public Collection values() {
        return this;
    }

    public SelectResults getValues() {
        return this;
    }

    public SelectResults getEntries() {
        ResultsCollectionWrapper res;
        if (this.region instanceof LocalDataSet) {
            LocalDataSet localData = (LocalDataSet)this.region;
            res = new ResultsCollectionWrapper(TypeUtils.getRegionEntryType(this.region), localData.localEntrySet());
        } else {
            res = new ResultsCollectionWrapper(TypeUtils.getRegionEntryType(this.region), this.region.entries(false));
        }
        res.setModifiable(false);
        return res;
    }

    public boolean isOrdered() {
        return false;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    public int occurrences(Object element) {
        int count = 0;
        for (Object v : this.values) {
            if (!(element == null ? v == null : element.equals(v))) continue;
            ++count;
        }
        return count;
    }

    public List asList() {
        return new ArrayList(this.values);
    }

    public Set asSet() {
        return new HashSet(this.values);
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(QRegion.class, this.values.getCollectionType().getElementType());
    }

    @Override
    public boolean add(Object obj) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object obj) {
        return this.values.contains(obj);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.values.containsAll(collection);
    }

    @Override
    public Iterator iterator() {
        return this.values.iterator();
    }

    public void becomeLockGrantor() {
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException(LocalizedStrings.QRegion_REGION_VALUES_IS_NOT_MODIFIABLE.toLocalizedString());
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public Object[] toArray(Object[] obj) {
        return this.values.toArray(obj);
    }

    public boolean containsKey(Object key2) {
        return this.region.containsKey(key2);
    }

    public boolean containsValueForKey(Object key2) {
        return this.region.containsValueForKey(key2);
    }

    public void create(Object key2, Object value2) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.region.create(key2, value2);
    }

    public void create(Object key2, Object value2, Object aCacheWriterParam) throws TimeoutException, EntryExistsException, CacheWriterException {
        this.region.create(key2, value2, aCacheWriterParam);
    }

    public Region createSubregion(String subregionName, RegionAttributes aRegionAttributes) throws RegionExistsException, TimeoutException {
        return this.region.createSubregion(subregionName, aRegionAttributes);
    }

    public void destroy(Object key2) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        this.region.destroy(key2);
    }

    public void destroy(Object key2, Object aCacheWriterParam) throws TimeoutException, EntryNotFoundException, CacheWriterException {
        this.region.destroy(key2, aCacheWriterParam);
    }

    public void destroyRegion() throws CacheWriterException, TimeoutException {
        this.region.destroyRegion();
    }

    public void destroyRegion(Object aCallbackArgument) throws CacheWriterException, TimeoutException {
        this.region.destroyRegion(aCallbackArgument);
    }

    public Set entries(boolean recursive) {
        return this.region.entries(recursive);
    }

    public boolean existsValue(String queryPredicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.region.existsValue(queryPredicate);
    }

    public Object get(Object key2) throws CacheLoaderException, TimeoutException {
        return this.region.get(key2);
    }

    public Object get(Object key2, Object aCallbackArgument) throws TimeoutException, CacheLoaderException {
        return this.region.get(key2, aCallbackArgument);
    }

    public RegionAttributes getAttributes() {
        return this.region.getAttributes();
    }

    public AttributesMutator getAttributesMutator() {
        return this.region.getAttributesMutator();
    }

    public Cache getCache() {
        return this.region.getCache();
    }

    public Lock getDistributedLock(Object key2) throws IllegalStateException {
        return this.region.getDistributedLock(key2);
    }

    public Region.Entry getEntry(Object key2) {
        return this.region.getEntry(key2);
    }

    public String getFullPath() {
        return this.region.getFullPath();
    }

    public String getName() {
        return this.region.getName();
    }

    public Region getParentRegion() {
        return this.region.getParentRegion();
    }

    public Lock getRegionDistributedLock() throws IllegalStateException {
        return this.region.getRegionDistributedLock();
    }

    public CacheStatistics getStatistics() {
        return this.region.getStatistics();
    }

    public Region getSubregion(String path) {
        return this.region.getSubregion(path);
    }

    public Object getUserAttribute() {
        return this.region.getUserAttribute();
    }

    public void invalidate(Object key2) throws TimeoutException, EntryNotFoundException {
        this.region.invalidate(key2);
    }

    public void invalidate(Object key2, Object aCallbackArgument) throws TimeoutException, EntryNotFoundException {
        this.region.invalidate(key2, aCallbackArgument);
    }

    public void invalidateRegion() throws TimeoutException {
        this.region.invalidateRegion();
    }

    public void invalidateRegion(Object aCallbackArgument) throws TimeoutException {
        this.region.invalidateRegion(aCallbackArgument);
    }

    public boolean isDestroyed() {
        return this.region.isDestroyed();
    }

    public Set keys() {
        return this.region.keys();
    }

    public void localDestroy(Object key2) throws EntryNotFoundException {
        this.region.localDestroy(key2);
    }

    public void localDestroy(Object key2, Object aCallbackArgument) throws EntryNotFoundException {
        this.region.localDestroy(key2, aCallbackArgument);
    }

    public void localDestroyRegion() {
        this.region.localDestroyRegion();
    }

    public void localDestroyRegion(Object aCallbackArgument) {
        this.region.localDestroyRegion(aCallbackArgument);
    }

    public void close() {
        this.region.close();
    }

    public void localInvalidate(Object key2) throws EntryNotFoundException {
        this.region.localInvalidate(key2);
    }

    public void localInvalidate(Object key2, Object aCallbackArgument) throws EntryNotFoundException {
        this.region.localInvalidate(key2, aCallbackArgument);
    }

    public void localInvalidateRegion() {
        this.region.localInvalidateRegion();
    }

    public void localInvalidateRegion(Object aCallbackArgument) {
        this.region.localInvalidateRegion(aCallbackArgument);
    }

    public void put(Object key2, Object value2) throws TimeoutException, CacheWriterException {
        this.region.put(key2, value2);
    }

    public void put(Object key2, Object value2, Object aCallbackArgument) throws TimeoutException, CacheWriterException {
        this.region.put(key2, value2, aCallbackArgument);
    }

    public SelectResults query(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.region.query(predicate);
    }

    public Object selectValue(String predicate) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        return this.region.selectValue(predicate);
    }

    public void setUserAttribute(Object value2) {
        this.region.setUserAttribute(value2);
    }

    public Set subregions(boolean recursive) {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void loadSnapshot(InputStream inputStream) throws IOException, ClassNotFoundException, CacheWriterException, TimeoutException {
        this.region.loadSnapshot(inputStream);
    }

    public void saveSnapshot(OutputStream outputStream) throws IOException {
        this.region.saveSnapshot(outputStream);
    }

    public void registerInterest(Object key2) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterest(Object key2, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void registerInterestRegex(String regex, InterestResultPolicy policy) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterest(Object key2) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public void unregisterInterestRegex(String regex) throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestList() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public List getInterestListRegex() throws CacheWriterException {
        throw new UnsupportedOperationException(LocalizedStrings.UNSUPPORTED_AT_THIS_TIME.toLocalizedString());
    }

    public String toString() {
        return this.region.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.values.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean containsValue(Object arg0) {
        return this.region.containsValue(arg0);
    }

    public void putAll(Map arg0) {
        this.region.putAll(arg0);
    }

    public SelectResults entrySet() {
        ResultsCollectionWrapper res = new ResultsCollectionWrapper(new ObjectTypeImpl(Map.Entry.class), this.region.entries(false));
        res.setModifiable(false);
        return res;
    }

    public Set keySet() {
        return this.region.keys();
    }
}

