/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.query.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.internal.StructBag;
import com.gemstone.gemfire.cache.query.internal.StructImpl;
import com.gemstone.gemfire.cache.query.internal.types.CollectionTypeImpl;
import com.gemstone.gemfire.cache.query.internal.types.StructTypeImpl;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gnu.trove.THashSet;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class StructSet
extends THashSet
implements SelectResults,
DataSerializableFixedID {
    private static final long serialVersionUID = -1228835506930611510L;
    protected StructType structType;
    private boolean modifiable = true;

    public StructSet() {
    }

    public StructSet(StructType structType) {
        super(new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    public StructSet(Collection c, StructType structType) {
        super(c, (TObjectHashingStrategy)new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    StructSet(StructBag bag) {
        super(new ObjectArrayHashingStrategy());
        this.structType = (StructType)bag.elementType;
        if (bag.hasLimitIterator) {
            this.ensureCapacity(bag.size());
            Iterator itr = bag.fieldValuesIterator();
            while (itr.hasNext()) {
                this.addFieldValues((Object[])itr.next());
            }
        } else {
            Set<Object> keys = bag.map.keySet();
            this.ensureCapacity(keys.size());
            for (Object key2 : keys) {
                this.addFieldValues((Object[])key2);
            }
        }
    }

    public StructSet(int initialCapacity, StructType structType) {
        super(initialCapacity, (TObjectHashingStrategy)new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    public StructSet(int initialCapacity, float loadFactor, StructType structType) {
        super(initialCapacity, loadFactor, new ObjectArrayHashingStrategy());
        if (structType == null) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_STRUCTTYPE_MUST_NOT_BE_NULL.toLocalizedString());
        }
        this.structType = structType;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof StructSet)) {
            return false;
        }
        if (!this.structType.equals(((StructSet)other).structType)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.structType.hashCode();
    }

    @Override
    public boolean add(Object obj) {
        if (!(obj instanceof StructImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_THIS_SET_ONLY_ACCEPTS_STRUCTIMPL.toLocalizedString());
        }
        StructImpl s = (StructImpl)obj;
        if (!s.getStructType().equals(this.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_OBJ_DOES_NOT_HAVE_THE_SAME_STRUCTTYPE_REQUIRED_0_ACTUAL_1.toLocalizedString(this.structType, s.getStructType()));
        }
        return this.addFieldValues(s.getFieldValues());
    }

    public boolean addFieldValues(Object[] fieldValues) {
        return super.add(fieldValues);
    }

    @Override
    public boolean contains(Object obj) {
        if (!(obj instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)obj;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.containsFieldValues(s.getFieldValues());
    }

    public boolean containsFieldValues(Object[] fieldValues) {
        return super.contains(fieldValues);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Struct)) {
            return false;
        }
        Struct s = (Struct)o;
        if (!this.structType.equals(StructTypeImpl.typeFromStruct(s))) {
            return false;
        }
        return this.removeFieldValues(s.getFieldValues());
    }

    public boolean removeFieldValues(Object[] fieldValues) {
        return super.remove(fieldValues);
    }

    @Override
    public boolean addAll(Collection c) {
        if (c instanceof StructSet) {
            return this.addAll((StructSet)c);
        }
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(Collection c) {
        if (c instanceof StructSet) {
            return this.removeAll((StructSet)c);
        }
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection c) {
        if (c instanceof StructSet) {
            return this.retainAll((StructSet)c);
        }
        return super.retainAll(c);
    }

    public boolean addAll(StructSet ss) {
        boolean modified = false;
        if (!this.structType.equals(ss.structType)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_TYPES_DONT_MATCH.toLocalizedString());
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            Object[] vals = (Object[])itr.next();
            if (!super.add(vals)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(StructSet ss) {
        boolean modified = false;
        if (!this.structType.equals(ss.structType)) {
            return false;
        }
        Iterator itr = ss.fieldValuesIterator();
        while (itr.hasNext()) {
            Object[] vals = (Object[])itr.next();
            if (!super.remove(vals)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(StructSet ss) {
        if (!this.structType.equals(ss.structType)) {
            if (this.isEmpty()) {
                return false;
            }
            this.clear();
            return true;
        }
        boolean changed = false;
        int size2 = this.size();
        Iterator it = this.fieldValuesIterator();
        while (size2-- > 0) {
            Object[] vals = (Object[])it.next();
            if (ss.containsFieldValues(vals)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public Iterator iterator() {
        return new StructIterator(this.fieldValuesIterator());
    }

    public Iterator fieldValuesIterator() {
        return super.iterator();
    }

    @Override
    public CollectionType getCollectionType() {
        return new CollectionTypeImpl(Set.class, (ObjectType)this.structType);
    }

    @Override
    public void setElementType(ObjectType elementType) {
        if (!(elementType instanceof StructTypeImpl)) {
            throw new IllegalArgumentException(LocalizedStrings.StructSet_ELEMENT_TYPE_MUST_BE_STRUCT.toLocalizedString());
        }
        this.structType = (StructType)elementType;
    }

    public List asList() {
        return new ArrayList(this);
    }

    public Set asSet() {
        return this;
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable;
    }

    public int occurrences(Object element) {
        return this.contains(element) ? 1 : 0;
    }

    public void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        Iterator i = this.iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Object o = i.next();
            buf.append(o == this ? "(this Collection)" : String.valueOf(o));
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public int getDSFID() {
        return 33;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        this.structType = (StructTypeImpl)DataSerializer.readObject(in);
        for (int j = size2; j > 0; --j) {
            this.add(DataSerializer.readObject(in));
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.size());
        DataSerializer.writeObject(this.structType, out);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DataSerializer.writeObject(i.next(), out);
        }
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    private class StructIterator
    implements Iterator {
        private final Iterator itr;

        StructIterator(Iterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        public Object next() {
            return new StructImpl((StructTypeImpl)StructSet.this.structType, (Object[])this.itr.next());
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    protected static class ObjectArrayHashingStrategy
    implements TObjectHashingStrategy {
        private static final long serialVersionUID = -6407549977968716071L;

        protected ObjectArrayHashingStrategy() {
        }

        @Override
        public final int computeHashCode(Object o) {
            Object[] oa = (Object[])o;
            int h = 0;
            for (int i = 0; i < oa.length; ++i) {
                Object obj = oa[i];
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public final boolean equals(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            if (!(o1 instanceof Object[]) || !(o2 instanceof Object[])) {
                return o1.equals(o2);
            }
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
    }
}

