/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.cache.util;

import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.cache.client.internal.BridgePoolImpl;
import com.gemstone.gemfire.cache.util.BridgeClient;
import com.gemstone.gemfire.cache.util.BridgeWriterException;
import com.gemstone.gemfire.cache.util.EndpointDoesNotExistException;
import com.gemstone.gemfire.cache.util.EndpointExistsException;
import com.gemstone.gemfire.cache.util.EndpointInUseException;
import com.gemstone.gemfire.internal.cache.tier.ConnectionProxy;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;

@Deprecated
public class BridgeWriter
implements CacheWriter,
Declarable {
    protected ConnectionProxy proxy = null;
    private Properties properties;
    private volatile boolean isClosed = false;
    private final AtomicInteger refCount = new AtomicInteger();

    @Override
    public void init(Properties p) {
        if (this.proxy != null) {
            throw new IllegalStateException(LocalizedStrings.BridgeWriter_ALREADY_INITIALIZED.toLocalizedString());
        }
        this.properties = p;
        if (Boolean.getBoolean("skipConnection")) {
            return;
        }
        this.proxy = BridgePoolImpl.create(this.properties, true);
    }

    public void init(BridgeWriter bridgeWriter) {
        if (this.proxy != null) {
            throw new IllegalStateException(LocalizedStrings.BridgeWriter_ALREADY_INITIALIZED.toLocalizedString());
        }
        ConnectionProxy p = bridgeWriter.proxy;
        p.reuse();
        this.proxy = p;
    }

    public static void loadEmergencyClasses() {
        BridgeClient.loadEmergencyClasses();
        BridgePoolImpl.loadEmergencyClasses();
    }

    @Override
    public void close() {
        if (this.refCount.get() <= 0) {
            this.isClosed = true;
            this.proxy.close();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() {
        String reason = this.proxy.getCancelCriterion().cancelInProgress();
        if (reason != null) {
            throw new BridgeWriterException("The BridgeWriter has been closed: " + reason);
        }
        if (this.isClosed) {
            throw new BridgeWriterException(LocalizedStrings.BridgeWriter_THE_BRIDGEWRITER_HAS_BEEN_CLOSED.toLocalizedString());
        }
        if (this.proxy != null && !this.proxy.isOpen()) {
            throw new BridgeWriterException(LocalizedStrings.BridgeWriter_THE_BRIDGEWRITER_HAS_BEEN_CLOSED.toLocalizedString());
        }
    }

    public void detach(Region r) {
        this.refCount.decrementAndGet();
        if (r != null) {
            this.proxy.detachRegion(r);
        }
    }

    public int getAttachCount() {
        return this.refCount.get();
    }

    public void release() {
        this.proxy.release();
    }

    public void terminate() {
        this.isClosed = true;
        this.proxy.terminate();
    }

    public void beforeUpdate(EntryEvent event) throws CacheWriterException {
        throw new IllegalStateException("this method should not be called");
    }

    public void beforeCreate(EntryEvent event) throws CacheWriterException {
        throw new IllegalStateException("this method should not be called");
    }

    public void beforeDestroy(EntryEvent event) throws CacheWriterException {
        throw new IllegalStateException("this method should not be called");
    }

    public void beforeRegionDestroy(RegionEvent event) throws CacheWriterException {
        throw new IllegalStateException("this method should not be called");
    }

    public void beforeRegionClear(RegionEvent event) throws CacheWriterException {
        throw new IllegalStateException("this method should not be called");
    }

    public boolean hasEstablishCallbackConnection() {
        if (this.isClosed) {
            return false;
        }
        return this.proxy.getEstablishCallbackConnection();
    }

    public int getRetryInterval() {
        return this.proxy.getRetryInterval();
    }

    public int getReadTimeout() {
        return this.proxy.getReadTimeout();
    }

    public int getRetryAttempts() {
        return this.proxy.getRetryAttempts();
    }

    public String getLBPolicy() {
        return this.proxy.getLBPolicy();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void addEndpoint(String name, String host, int port) throws EndpointExistsException {
        this.proxy.addEndpoint(name, host, port);
    }

    public void removeEndpoint(String name, String host, int port) throws EndpointDoesNotExistException, EndpointInUseException {
        this.proxy.removeEndpoint(name, host, port);
    }

    public String toString() {
        return LocalizedStrings.BridgeWriter_BRIDGEWRITER_CONNECTED_TO_0.toLocalizedString(this.proxy);
    }

    public void attach(Region r) {
        this.checkClosed();
        this.refCount.incrementAndGet();
    }

    public Object getConnectionProxy() {
        return this.proxy;
    }
}

