/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.InvalidValueException;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.FlowControlParams;
import com.gemstone.gemfire.internal.AbstractConfig;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import com.gemstone.gemfire.memcached.GemFireMemcachedServer;
import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class AbstractDistributionConfig
extends AbstractConfig
implements DistributionConfig {
    static final String[] dcValidAttributeNames;
    protected static final Map dcAttDescriptions;

    protected void checkName(String value2) {
        this._checkIfModifiable("name");
    }

    @Override
    public boolean isNameModifiable() {
        return this._modifiableDefault();
    }

    public boolean isEnableNetworkPartitionDetectionModifiable() {
        return this._modifiableDefault();
    }

    public boolean isDisableAutoReconnectModifiable() {
        return this._modifiableDefault();
    }

    public boolean isDepartureCorrelationWindowModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLogFile(File value2) {
        this._checkIfModifiable("log-file");
    }

    @Override
    public boolean isLogFileModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLogLevel(int value2) {
        this._checkIfModifiable("log-level");
        if (value2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("log-level", value2, Integer.MIN_VALUE));
        }
        if (value2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("log-level", value2, Integer.MAX_VALUE));
        }
    }

    protected void checkStartLocator(String value2) {
        this._checkIfModifiable("start-locator");
        if (value2 != null && value2.trim().length() > 0) {
            new DistributionLocatorId(value2);
        }
    }

    @Override
    public boolean isStartLocatorModifiable() {
        return this._modifiableDefault();
    }

    @Override
    public boolean isLogLevelModifiable() {
        return this._modifiableDefault();
    }

    protected void checkTcpPort(int value2) {
        this._checkIfModifiable("tcp-port");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("tcp-port", value2, 0));
        }
        if (value2 > 65535) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("tcp-port", value2, 65535));
        }
        if (this.getSSLEnabled() && value2 != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_0_WHEN_2_IS_TRUE.toLocalizedString("tcp-port", value2, "ssl-enabled"));
        }
        if (this.getClusterSSLEnabled() && value2 != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_0_WHEN_2_IS_TRUE.toLocalizedString("tcp-port", value2, "cluster-ssl-enabled"));
        }
    }

    @Override
    public boolean isTcpPortModifiable() {
        return this._modifiableDefault();
    }

    protected void checkMcastPort(int value2) {
        this._checkIfModifiable("mcast-port");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-port", value2, 0));
        }
        if (value2 > 65535) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("mcast-port", value2, 65535));
        }
        if (this.getSSLEnabled() && value2 != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_0_WHEN_2_IS_TRUE.toLocalizedString("mcast-port", value2, "ssl-enabled"));
        }
        if (this.getClusterSSLEnabled() && value2 != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_0_WHEN_2_IS_TRUE.toLocalizedString("mcast-port", value2, "cluster-ssl-enabled"));
        }
    }

    @Override
    public boolean isMcastPortModifiable() {
        return this._modifiableDefault();
    }

    protected void checkMcastAddress(InetAddress value2) {
        this._checkIfModifiable("mcast-address");
        if (!value2.isMulticastAddress()) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_IT_WAS_NOT_A_MULTICAST_ADDRESS.toLocalizedString("mcast-address", value2));
        }
    }

    @Override
    public boolean isMcastAddressModifiable() {
        return this._modifiableDefault();
    }

    protected void checkMcastTtl(int value2) {
        this._checkIfModifiable("mcast-ttl");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-ttl", value2, 0));
        }
        if (value2 > 255) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("mcast-ttl", value2, 255));
        }
    }

    @Override
    public boolean isMcastTtlModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSocketLeaseTime(int value2) {
        this._checkIfModifiable("socket-lease-time");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("socket-lease-time", value2, 0));
        }
        if (value2 > 600000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("socket-lease-time", value2, 600000));
        }
    }

    @Override
    public boolean isSocketLeaseTimeModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSocketBufferSize(int value2) {
        this._checkIfModifiable("socket-buffer-size");
        if (value2 < 1024) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("socket-buffer-size", value2, 1024));
        }
        if (value2 > 0xFFFFFF) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("socket-buffer-size", value2, 0xFFFFFF));
        }
    }

    @Override
    public boolean isSocketBufferSizeModifiable() {
        return this._modifiableDefault();
    }

    protected void checkConserveSockets(boolean value2) {
        this._checkIfModifiable("conserve-sockets");
    }

    @Override
    public boolean isConserveSocketsModifiable() {
        return this._modifiableDefault();
    }

    protected void checkRoles(String value2) {
        this._checkIfModifiable("roles");
    }

    public boolean isRolesModifiable() {
        return this._modifiableDefault();
    }

    protected void checkBindAddress(String value2) {
        this._checkIfModifiable("bind-address");
        if (value2 != null && value2.length() > 0 && !SocketCreator.isLocalHost(value2)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value2, SocketCreator.getMyAddresses()));
        }
    }

    @Override
    public boolean isBindAddressModifiable() {
        return this._modifiableDefault();
    }

    protected void checkServerBindAddress(String value2) {
        this._checkIfModifiable("server-bind-address");
        if (value2 != null && value2.length() > 0 && !SocketCreator.isLocalHost(value2)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value2, SocketCreator.getMyAddresses()));
        }
    }

    @Override
    public boolean isServerBindAddressModifiable() {
        return this._modifiableDefault();
    }

    protected void checkDeployWorkingDir(File value2) {
        this._checkIfModifiable("deploy-working-dir");
    }

    @Override
    public boolean isDeployWorkingDirModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLicenseDataManagement(String value2) {
        this._checkIfModifiable("license-data-management");
    }

    @Override
    public boolean isLicenseDataManagementModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLicenseApplicationCache(String value2) {
        this._checkIfModifiable("license-application-cache");
    }

    @Override
    public boolean isLicenseApplicationCacheModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLicenseWorkingDir(File value2) {
        this._checkIfModifiable("license-working-dir");
    }

    @Override
    public boolean isLicenseWorkingDirModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLicenseServerTimeoutModifiable(int value2) {
        this._checkIfModifiable("license-server-timeout");
    }

    @Override
    public boolean isLicenseServerTimeoutModifiable() {
        return this._modifiableDefault();
    }

    protected void checkStatisticSamplingEnabled(boolean value2) {
        this._checkIfModifiable("statistic-sampling-enabled");
    }

    @Override
    public boolean isStatisticSamplingEnabledModifiable() {
        return this._modifiableDefault();
    }

    protected void checkStatisticArchiveFile(File value2) {
        this._checkIfModifiable("statistic-archive-file");
    }

    @Override
    public boolean isStatisticArchiveFileModifiable() {
        return this._modifiableDefault();
    }

    protected void checkCacheXmlFile(File value2) {
        this._checkIfModifiable("cache-xml-file");
    }

    @Override
    public boolean isCacheXmlFileModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSSLEnabled(Boolean value2) {
        this._checkIfModifiable("ssl-enabled");
        if (value2.booleanValue() && this.getMcastPort() != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_FALSE_WHEN_2_IS_NOT_0.toLocalizedString("ssl-enabled", value2, "mcast-port"));
        }
    }

    protected void checkClusterSSLEnabled(Boolean value2) {
        this._checkIfModifiable("cluster-ssl-enabled");
        if (value2.booleanValue() && this.getMcastPort() != 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_MUST_BE_FALSE_WHEN_2_IS_NOT_0.toLocalizedString("cluster-ssl-enabled", value2, "mcast-port"));
        }
    }

    protected void checkHttpServicePort(int value2) {
        this.minMaxCheck("http-service-port", value2, 0, 65535);
    }

    @Override
    public boolean isHttpServicePortModifiable() {
        return true;
    }

    protected void checkHttpServiceBindAddress(String value2) {
        this._checkIfModifiable("http-service-bind-address");
        if (value2 != null && value2.length() > 0 && !SocketCreator.isLocalHost(value2)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value2, SocketCreator.getMyAddresses()));
        }
    }

    @Override
    public boolean isHttpServiceBindAddressModifiable() {
        return this._modifiableDefault();
    }

    public boolean isHttpServiceSSLEnabledModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSL() {
        this._checkIfModifiable("http-service-ssl-enabled");
    }

    public boolean isHttpServiceSSLRequireAuthenticationModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLRequireAuthentication() {
        this._checkIfModifiable("http-service-ssl-require-authentication");
    }

    public boolean isHttpServiceSSLProtocolsModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLProtocols() {
        this._checkIfModifiable("http-service-ssl-protocols");
    }

    public boolean isHttpServiceSSLCiphersModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLCiphers() {
        this._checkIfModifiable("http-service-ssl-ciphers");
    }

    public void checkHttpServiceSSLKeyStore(String value2) {
        this._checkIfModifiable("http-service-ssl-keystore");
    }

    public boolean isHttpServiceSSLKeyStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLKeyStoreType(String value2) {
        this._checkIfModifiable("http-service-ssl-keystore-type");
    }

    public boolean isHttpServiceSSLKeyStoreTypeModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLKeyStorePassword(String value2) {
        this._checkIfModifiable("http-service-ssl-keystore-password");
    }

    public boolean isHttpServiceSSLKeyStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLTrustStore(String value2) {
        this._checkIfModifiable("http-service-ssl-truststore");
    }

    public boolean isHttpServiceSSLTrustStoreModifiable() {
        return this._modifiableDefault();
    }

    public boolean isHttpServiceSSLTrustStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkHttpServiceSSLTrustStorePassword(String value2) {
        this._checkIfModifiable("http-service-ssl-truststore-password");
    }

    protected void checkStartDevRestApi() {
        this._checkIfModifiable("start-dev-rest-api");
    }

    @Override
    public boolean isStartDevRestApiModifiable() {
        return this._modifiableDefault();
    }

    public boolean isSSLEnabledModifiable() {
        return this._modifiableDefault();
    }

    public boolean isClusterSSLEnabledModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSSLProtocols(String value2) {
        this._checkIfModifiable("ssl-protocols");
    }

    protected void checkClusterSSLProtocols(String value2) {
        this._checkIfModifiable("cluster-ssl-protocols");
    }

    public boolean isSSLProtocolsModifiable() {
        return this._modifiableDefault();
    }

    public boolean isClusterSSLProtocolsModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSSLCiphers(String value2) {
        this._checkIfModifiable("ssl-ciphers");
    }

    protected void checkClusterSSLCiphers(String value2) {
        this._checkIfModifiable("cluster-ssl-ciphers");
    }

    public boolean isSSLCiphersModifiable() {
        return this._modifiableDefault();
    }

    public boolean isClusterSSLCiphersModifiable() {
        return this._modifiableDefault();
    }

    public void checkSSLRequireAuthentication(Boolean value2) {
        this._checkIfModifiable("ssl-require-authentication");
    }

    public void checkClusterSSLRequireAuthentication(Boolean value2) {
        this._checkIfModifiable("cluster-ssl-require-authentication");
    }

    public boolean isSSLRequireAuthenticationModifiable() {
        return this._modifiableDefault();
    }

    public boolean isClusterSSLRequireAuthenticationModifiable() {
        return this._modifiableDefault();
    }

    public void checkClusterSSLKeyStore(String value2) {
        this._checkIfModifiable("cluster-ssl-keystore");
    }

    public boolean isClusterSSLKeyStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkClusterSSLKeyStoreType(String value2) {
        this._checkIfModifiable("cluster-ssl-keystore-type");
    }

    public boolean isClusterSSLKeyStoreTypeModifiable() {
        return this._modifiableDefault();
    }

    public void checkClusterSSLKeyStorePassword(String value2) {
        this._checkIfModifiable("cluster-ssl-keystore-password");
    }

    public boolean isClusterSSLKeyStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkClusterSSLTrustStore(String value2) {
        this._checkIfModifiable("cluster-ssl-truststore");
    }

    public boolean isClusterSSLTrustStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkClusterSSLTrustStorePassword(String value2) {
        this._checkIfModifiable("cluster-ssl-truststore-password");
    }

    public boolean isClusterSSLTrustStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLKeyStore(String value2) {
        this._checkIfModifiable("server-ssl-keystore");
    }

    public boolean isServerSSLKeyStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLKeyStoreType(String value2) {
        this._checkIfModifiable("server-ssl-keystore-type");
    }

    public boolean isServerSSLKeyStoreTypeModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLKeyStorePassword(String value2) {
        this._checkIfModifiable("server-ssl-keystore-password");
    }

    public boolean isServerSSLKeyStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLTrustStore(String value2) {
        this._checkIfModifiable("server-ssl-truststore");
    }

    public boolean isServerSSLTrustStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLTrustStorePassword(String value2) {
        this._checkIfModifiable("server-ssl-truststore-password");
    }

    public boolean isServerSSLTrustStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkJmxManagerSSLKeyStore(String value2) {
        this._checkIfModifiable("jmx-manager-ssl-keystore");
    }

    public boolean isJmxManagerSSLKeyStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkJmxManagerSSLKeyStoreType(String value2) {
        this._checkIfModifiable("jmx-manager-ssl-keystore-type");
    }

    public boolean isJmxManagerSSLKeyStoreTypeModifiable() {
        return this._modifiableDefault();
    }

    public void checkJmxManagerSSLKeyStorePassword(String value2) {
        this._checkIfModifiable("jmx-manager-ssl-keystore-password");
    }

    public boolean isJmxManagerSSLKeyStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkJmxManagerSSLTrustStore(String value2) {
        this._checkIfModifiable("jmx-manager-ssl-truststore");
    }

    public boolean isJmxManagerSSLTrustStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkJmxManagerSSLTrustStorePassword(String value2) {
        this._checkIfModifiable("jmx-manager-ssl-truststore-password");
    }

    public boolean isJmxManagerSSLTrustStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLKeyStore(String value2) {
        this._checkIfModifiable("gateway-ssl-keystore");
    }

    public boolean isGatewaySSLKeyStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLKeyStoreType(String value2) {
        this._checkIfModifiable("gateway-ssl-keystore-type");
    }

    public boolean isGatewaySSLKeyStoreTypeModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLKeyStorePassword(String value2) {
        this._checkIfModifiable("gateway-ssl-keystore-password");
    }

    public boolean isGatewaySSLKeyStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLTrustStore(String value2) {
        this._checkIfModifiable("gateway-ssl-truststore");
    }

    public boolean isGatewaySSLTrustStoreModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLTrustStorePassword(String value2) {
        this._checkIfModifiable("gateway-ssl-truststore-password");
    }

    public boolean isGatewaySSLTrustStorePasswordModifiable() {
        return this._modifiableDefault();
    }

    public void checkMcastSendBufferSizeModifiable() {
        this._checkIfModifiable("mcast-send-buffer-size");
    }

    @Override
    public boolean isMcastSendBufferSizeModifiable() {
        return this._modifiableDefault();
    }

    public void checkMcastRecvBufferSizeModifiable() {
        this._checkIfModifiable("mcast-recv-buffer-size");
    }

    @Override
    public boolean isMcastRecvBufferSizeModifiable() {
        return this._modifiableDefault();
    }

    public void checkMcastFlowControlModifiable() {
        this._checkIfModifiable("mcast-flow-control");
    }

    @Override
    public boolean isMcastFlowControlModifiable() {
        return this._modifiableDefault();
    }

    public void checkUdpSendBufferSizeModifiable() {
        this._checkIfModifiable("udp-send-buffer-size");
    }

    @Override
    public boolean isUdpSendBufferSizeModifiable() {
        return this._modifiableDefault();
    }

    public void checkUdpRecvBufferSizeModifiable() {
        this._checkIfModifiable("udp-recv-buffer-size");
    }

    @Override
    public boolean isUdpRecvBufferSizeModifiable() {
        return this._modifiableDefault();
    }

    public void checkUdpFragmentSizeModifiable() {
        this._checkIfModifiable("udp-fragment-size");
    }

    @Override
    public boolean isUdpFragmentSizeModifiable() {
        return this._modifiableDefault();
    }

    public void checkDisableTcpModifiable() {
        this._checkIfModifiable("disable-tcp");
    }

    @Override
    public boolean isDisableTcpModifiable() {
        return this._modifiableDefault();
    }

    public void checkEnableTimeStatisticsModifiable() {
        this._checkIfModifiable("enable-time-statistics");
    }

    public boolean isEnableTimeStatisticsModifiable() {
        return this._modifiableDefault();
    }

    public void checkMemberTimeoutModifiable() {
        this._checkIfModifiable("member-timeout");
    }

    @Override
    public boolean isMemberTimeoutModifiable() {
        return this._modifiableDefault();
    }

    public boolean isMembershipPortRangeModifiable() {
        return this._modifiableDefault();
    }

    public boolean isMaxNumberOfTiesModifiable() {
        return this._modifiableDefault();
    }

    public boolean isMaxTimeOutModifiable() {
        return this._modifiableDefault();
    }

    protected void checkStatisticSampleRate(int value2) {
        this._checkIfModifiable("statistic-sample-rate");
        if (value2 < 100) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("statistic-sample-rate", value2, 100));
        }
        if (value2 > 60000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("statistic-sample-rate", value2, 60000));
        }
    }

    @Override
    public boolean isStatisticSampleRateModifiable() {
        return this._modifiableDefault();
    }

    @Override
    public boolean isDeltaPropagationModifiable() {
        return this._modifiableDefault();
    }

    protected void checkDeltaPropagationModifiable() {
        this._checkIfModifiable("delta-propagation");
    }

    protected String checkRemoteLocators(String value2) {
        this._checkIfModifiable("remote-locators");
        return value2;
    }

    public boolean isDistributedSystemIdModifiable() {
        return this._modifiableDefault();
    }

    protected void checkDistributedSystemId(int value2) {
        this._checkIfModifiable("distributed-system-id");
        String distributedSystemListener = System.getProperty("gemfire.DistributedSystemListener");
        if (distributedSystemListener == null && value2 < -1) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("distributed-system-id", value2, -1));
        }
        if (value2 > 255) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("distributed-system-id", value2, 255));
        }
    }

    public boolean isEnforceUniqueHostModifiable() {
        return this._modifiableDefault();
    }

    protected void checkEnforceUniqueHostModifiable() {
        this._checkIfModifiable("enforce-unique-host");
    }

    public boolean isRedundancyZoneModifiable() {
        return this._modifiableDefault();
    }

    protected void checkRedundancyZoneModifiable() {
        this._checkIfModifiable("redundancy-zone");
    }

    protected void checkSSLPropertyModifiable() {
        this._checkIfModifiable("javax.net.ssl");
    }

    protected boolean isSSLPropertyModifiable() {
        return this._modifiableDefault();
    }

    protected void checkUserCommandPackages(String value2) {
        this._checkIfModifiable("user-command-packages");
    }

    @Override
    public boolean isUserCommandPackagesModifiable() {
        return this._modifiableDefault();
    }

    protected String checkLocators(String value2) {
        this._checkIfModifiable("locators");
        StringBuffer sb = new StringBuffer();
        HashSet<InetSocketAddress> locs = new HashSet<InetSocketAddress>();
        StringTokenizer st = new StringTokenizer(value2, ",");
        boolean firstUniqueLocator = true;
        while (st.hasMoreTokens()) {
            int lastIndex;
            String host;
            String locator = st.nextToken();
            StringBuffer locatorsb = new StringBuffer();
            int portIndex = locator.indexOf(91);
            if (portIndex < 1) {
                portIndex = locator.lastIndexOf(58);
            }
            if (portIndex < 1) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0_HOST_NAME_WAS_EMPTY.toLocalizedString(value2));
            }
            int bindAddrIdx = locator.lastIndexOf(64, portIndex - 1);
            if (bindAddrIdx < 0) {
                bindAddrIdx = locator.lastIndexOf(58, portIndex - 1);
            }
            if ((host = locator.substring(0, bindAddrIdx > -1 ? bindAddrIdx : portIndex)).indexOf(58) >= 0) {
                bindAddrIdx = locator.lastIndexOf(64);
                host = locator.substring(0, bindAddrIdx > -1 ? bindAddrIdx : portIndex);
            }
            InetAddress hostAddress = null;
            try {
                hostAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_UNKNOWN_LOCATOR_HOST_0.toLocalizedString(host));
            }
            locatorsb.append(host);
            if (bindAddrIdx > -1) {
                String bindAddr = locator.substring(bindAddrIdx + 1, portIndex);
                try {
                    hostAddress = InetAddress.getByName(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_UNKNOWN_LOCATOR_BIND_ADDRESS_0.toLocalizedString(bindAddr));
                }
                if (bindAddr.indexOf(58) >= 0) {
                    locatorsb.append('@');
                } else {
                    locatorsb.append(':');
                }
                locatorsb.append(bindAddr);
            }
            if ((lastIndex = locator.lastIndexOf(93)) == -1) {
                if (locator.indexOf(91) >= 0) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0.toLocalizedString(value2));
                }
                lastIndex = locator.length();
            }
            String port = locator.substring(portIndex + 1, lastIndex);
            int portVal = 0;
            try {
                portVal = Integer.parseInt(port);
                if (portVal < 1 || portVal > 65535) {
                    throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0_THE_PORT_1_WAS_NOT_GREATER_THAN_ZERO_AND_LESS_THAN_65536.toLocalizedString(value2, portVal));
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_INVALID_LOCATOR_0.toLocalizedString(value2));
            }
            locatorsb.append('[');
            locatorsb.append(port);
            locatorsb.append(']');
            InetSocketAddress sockAddr = new InetSocketAddress(hostAddress, portVal);
            if (locs.contains(sockAddr)) continue;
            if (!firstUniqueLocator) {
                sb.append(',');
            } else {
                firstUniqueLocator = false;
            }
            locs.add(new InetSocketAddress(hostAddress, portVal));
            sb.append(locatorsb);
        }
        return sb.toString();
    }

    @Override
    public boolean isLocatorsModifiable() {
        return this._modifiableDefault();
    }

    @Override
    public boolean isLocatorWaitTimeModifiable() {
        return this._modifiableDefault();
    }

    public boolean isRemoteLocatorsModifiable() {
        return this._modifiableDefault();
    }

    protected void checkAckWaitThreshold(int value2) {
        this._checkIfModifiable("ack-wait-threshold");
        if (value2 < 1) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("ack-wait-threshold", value2, 1));
        }
        if (value2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("ack-wait-threshold", value2, Integer.MAX_VALUE));
        }
    }

    @Override
    public boolean isAckWaitThresholdModifiable() {
        return this._modifiableDefault();
    }

    protected void checkAckSevereAlertThreshold(int value2) {
        this._checkIfModifiable("ack-severe-alert-threshold");
        if (value2 < 0) {
            throw new IllegalArgumentException("Could not set \"ack-severe-alert-threshold\" to \"" + value2 + "\" because its value can not be less than \"" + 0 + "\".");
        }
        if (value2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Could not set \"ack-severe-alert-threshold\" to \"" + value2 + "\" because its value can not be greater than \"" + Integer.MAX_VALUE + "\".");
        }
    }

    @Override
    public boolean isAckSevereAlertThresholdModifiable() {
        return this._modifiableDefault();
    }

    @Override
    public boolean isArchiveFileSizeLimitModifiable() {
        return this._modifiableDefault();
    }

    protected void checkArchiveFileSizeLimit(int value2) {
        this._checkIfModifiable("archive-file-size-limit");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("archive-file-size-limit", value2, 0));
        }
        if (value2 > 1000000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("archive-file-size-limit", value2, 1000000));
        }
    }

    @Override
    public boolean isArchiveDiskSpaceLimitModifiable() {
        return this._modifiableDefault();
    }

    protected void checkArchiveDiskSpaceLimit(int value2) {
        this._checkIfModifiable("archive-disk-space-limit");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("archive-disk-space-limit", value2, 0));
        }
        if (value2 > 1000000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("archive-disk-space-limit", value2, 1000000));
        }
    }

    @Override
    public boolean isLogFileSizeLimitModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLogFileSizeLimit(int value2) {
        this._checkIfModifiable("log-file-size-limit");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("log-file-size-limit", value2, 0));
        }
        if (value2 > 1000000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("log-file-size-limit", value2, 1000000));
        }
    }

    @Override
    public boolean isLogDiskSpaceLimitModifiable() {
        return this._modifiableDefault();
    }

    protected void checkLogDiskSpaceLimit(int value2) {
        this._checkIfModifiable("log-disk-space-limit");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("log-disk-space-limit", value2, 0));
        }
        if (value2 > 1000000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("log-disk-space-limit", value2, 1000000));
        }
    }

    protected void minMaxCheck(String propName, int value2, int minValue, int maxValue) {
        this._checkIfModifiable(propName);
        if (value2 < minValue) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString(propName, value2, minValue));
        }
        if (value2 > maxValue) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString(propName, value2, maxValue));
        }
    }

    protected void checkMcastSendBufferSize(int newSize) {
        this.minMaxCheck("mcast-send-buffer-size", newSize, 2048, Integer.MAX_VALUE);
    }

    protected void checkMcastRecvBufferSize(int newSize) {
        this.minMaxCheck("mcast-recv-buffer-size", newSize, 2048, Integer.MAX_VALUE);
    }

    protected void checkMcastFlowControl(FlowControlParams params) {
        this._checkIfModifiable("mcast-flow-control");
        int value2 = params.getByteAllowance();
        if (value2 < 10000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_BYTEALLOWANCE_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-flow-control", value2, 10000));
        }
        float fvalue = params.getRechargeThreshold();
        if (fvalue < 0.1f) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGETHRESHOLD_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-flow-control", new Float(fvalue), new Float(0.1f)));
        }
        if (fvalue > 0.5f) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGETHRESHOLD_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("mcast-flow-control", new Float(fvalue), new Float(0.5f)));
        }
        value2 = params.getRechargeBlockMs();
        if (value2 < 500) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGEBLOCKMS_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("mcast-flow-control", value2, 500));
        }
        if (value2 > 60000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_RECHARGEBLOCKMS_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("mcast-flow-control", value2, 60000));
        }
    }

    protected void checkUdpFragmentSize(int value2) {
        this.minMaxCheck("udp-fragment-size", value2, 1000, 60000);
    }

    protected void checkUdpSendBufferSize(int newSize) {
        this.minMaxCheck("udp-send-buffer-size", newSize, 2048, Integer.MAX_VALUE);
    }

    protected void checkUdpRecvBufferSize(int newSize) {
        this.minMaxCheck("udp-recv-buffer-size", newSize, 2048, Integer.MAX_VALUE);
    }

    protected void checkMemberTimeout(int value2) {
        this.minMaxCheck("member-timeout", value2, 10, 600000);
    }

    protected void checkMembershipPortRange(int[] value2) {
        this.minMaxCheck("membership-port-range", value2[0], DEFAULT_MEMBERSHIP_PORT_RANGE[0], value2[1]);
        this.minMaxCheck("membership-port-range", value2[1], value2[0], DEFAULT_MEMBERSHIP_PORT_RANGE[1]);
        if (value2[1] - value2[0] < 2) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("membership-port-range", value2[0] + "-" + value2[1], 3));
        }
    }

    @Override
    public boolean isAsyncDistributionTimeoutModifiable() {
        return this._modifiableDefault();
    }

    protected void checkAsyncDistributionTimeout(int value2) {
        this._checkIfModifiable("async-distribution-timeout");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("async-distribution-timeout", value2, 0));
        }
        if (value2 > 60000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("async-distribution-timeout", value2, 60000));
        }
    }

    @Override
    public boolean isAsyncQueueTimeoutModifiable() {
        return this._modifiableDefault();
    }

    protected void checkAsyncQueueTimeout(int value2) {
        this._checkIfModifiable("async-queue-timeout");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("async-queue-timeout", value2, 0));
        }
        if (value2 > 86400000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("async-queue-timeout", value2, 86400000));
        }
    }

    @Override
    public boolean isAsyncMaxQueueSizeModifiable() {
        return this._modifiableDefault();
    }

    protected void checkAsyncMaxQueueSize(int value2) {
        this._checkIfModifiable("async-max-queue-size");
        if (value2 < 0) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("async-max-queue-size", value2, 0));
        }
        if (value2 > 1024) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("async-max-queue-size", value2, 1024));
        }
    }

    protected void checkClientConflation(String value2) {
        if (!(value2.equals("server") || value2.equals("true") || value2.equals("false"))) {
            throw new IllegalArgumentException("Could not set \"conflate-events\" to \"" + value2 + "\" because its value is not recognized");
        }
    }

    @Override
    public boolean isClientConflationModifiable() {
        return this._modifiableDefault();
    }

    protected void checkDurableClientId(String value2) {
        this._checkIfModifiable("durable-client-id");
    }

    @Override
    public boolean isDurableClientIdModifiable() {
        return this._modifiableDefault();
    }

    protected void checkDurableClientTimeout(int value2) {
        this._checkIfModifiable("durable-client-timeout");
    }

    @Override
    public boolean isDurableClientTimeoutModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityClientAuthInit(String value2) {
        this._checkIfModifiable("security-client-auth-init");
    }

    @Override
    public boolean isSecurityClientAuthInitModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityClientAuthenticator(String value2) {
        this._checkIfModifiable("security-client-authenticator");
    }

    @Override
    public boolean isSecurityClientAuthenticatorModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityClientDHAlgo(String value2) {
        this._checkIfModifiable("security-client-dhalgo");
    }

    @Override
    public boolean isSecurityClientDHAlgoModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityPeerAuthInit(String value2) {
        this._checkIfModifiable("security-peer-auth-init");
        if (value2 != null && value2.length() > 0 && this.getMcastPort() != 0) {
            String mcastInfo = "mcast-port[" + this.getMcastPort() + "]";
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_2_MUST_BE_0_WHEN_SECURITY_IS_ENABLED.toLocalizedString("security-peer-auth-init", value2, mcastInfo));
        }
    }

    @Override
    public boolean isSecurityPeerAuthInitModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityPeerAuthenticator(String value2) {
        this._checkIfModifiable("security-peer-authenticator");
        if (value2 != null && value2.length() > 0 && this.getMcastPort() != 0) {
            String mcastInfo = "mcast-port[" + this.getMcastPort() + "]";
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_2_MUST_BE_0_WHEN_SECURITY_IS_ENABLED.toLocalizedString("security-peer-authenticator", value2, mcastInfo));
        }
    }

    @Override
    public boolean isSecurityPeerAuthenticatorModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityClientAccessor(String value2) {
        this._checkIfModifiable("security-client-accessor");
    }

    public boolean isSecurityClientAccessorModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityClientAccessorPP(String value2) {
        this._checkIfModifiable("security-client-accessor-pp");
    }

    public boolean isSecurityClientAccessorPPModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityLogLevel(int value2) {
        this._checkIfModifiable("security-log-level");
        if (value2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("security-log-level", LogWriterImpl.levelToString(value2), LogWriterImpl.levelToString(Integer.MIN_VALUE)));
        }
        if (value2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("security-log-level", LogWriterImpl.levelToString(value2), LogWriterImpl.levelToString(Integer.MAX_VALUE)));
        }
    }

    @Override
    public boolean isSecurityLogLevelModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityLogFile(File value2) {
        this._checkIfModifiable("security-log-file");
    }

    @Override
    public boolean isSecurityLogFileModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurityPeerMembershipTimeout(int value2) {
        this._checkIfModifiable("security-peer-verifymember-timeout");
        this.minMaxCheck("security-peer-verifymember-timeout", value2, 0, 60000);
    }

    @Override
    public boolean isSecurityPeerMembershipTimeoutModifiable() {
        return this._modifiableDefault();
    }

    protected void checkSecurity(String key2, String value2) {
        this._checkIfModifiable(key2);
    }

    @Override
    public boolean isSecurityModifiable() {
        return this._modifiableDefault();
    }

    protected void checkRemoveUnresponsiveClientModifiable() {
        this._checkIfModifiable("remove-unresponsive-client");
    }

    @Override
    public boolean isRemoveUnresponsiveClientModifiable() {
        return this._modifiableDefault();
    }

    protected void checkGroups(String value2) {
        this._checkIfModifiable("groups");
    }

    @Override
    public boolean isGroupsModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManager() {
        this._checkIfModifiable("jmx-manager");
    }

    @Override
    public boolean isJmxManagerModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerStart() {
        this._checkIfModifiable("jmx-manager-start");
    }

    @Override
    public boolean isJmxManagerStartModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxSSLManagerEnabled() {
        this._checkIfModifiable("jmx-manager-ssl");
    }

    protected void checkJmxManagerSSLEnabled() {
        this._checkIfModifiable("jmx-manager-ssl-enabled");
    }

    public boolean isJmxManagerSSLEnabledModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerSSLCiphers() {
        this._checkIfModifiable("jmx-manager-ssl-ciphers");
    }

    public boolean isJmxManagerSSLCiphersModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerSSLProtocols() {
        this._checkIfModifiable("jmx-manager-ssl-protocols");
    }

    public boolean isJmxManagerSSLProtocolsModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerSSLRequireAuthentication() {
        this._checkIfModifiable("jmx-manager-ssl-require-authentication");
    }

    public boolean isJmxManagerSSLRequireAuthenticationModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerPort(int value2) {
        this.minMaxCheck("jmx-manager-port", value2, 0, 65535);
    }

    @Override
    public boolean isJmxManagerPortModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerBindAddress(String value2) {
        this._checkIfModifiable("jmx-manager-bind-address");
    }

    @Override
    public boolean isJmxManagerBindAddressModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerHostnameForClients(String value2) {
        this._checkIfModifiable("jmx-manager-hostname-for-clients");
    }

    @Override
    public boolean isJmxManagerHostnameForClientsModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerPasswordFile(String value2) {
        this._checkIfModifiable("jmx-manager-password-file");
    }

    @Override
    public boolean isJmxManagerPasswordFileModifiable() {
        return this._modifiableDefault();
    }

    protected void checkJmxManagerAccessFile(String value2) {
        this._checkIfModifiable("jmx-manager-access-file");
    }

    @Override
    public boolean isJmxManagerAccessFileModifiable() {
        return this._modifiableDefault();
    }

    @Override
    public boolean isJmxManagerHttpPortModifiable() {
        return this.isHttpServicePortModifiable();
    }

    protected void checkJmxManagerHttpPort(int value2) {
        this.minMaxCheck("jmx-manager-http-port", value2, 0, 65535);
    }

    protected void checkJmxManagerUpdateRate(int value2) {
        this._checkIfModifiable("jmx-manager-update-rate");
        if (value2 < 1000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_LESS_THAN_2.toLocalizedString("jmx-manager-update-rate", value2, 1000));
        }
        if (value2 > 300000) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_COULD_NOT_SET_0_TO_1_BECAUSE_ITS_VALUE_CAN_NOT_BE_GREATER_THAN_2.toLocalizedString("jmx-manager-update-rate", value2, 300000));
        }
    }

    @Override
    public boolean isJmxManagerUpdateRateModifiable() {
        return this._modifiableDefault();
    }

    protected void checkMemcachedPort(int value2) {
        this.minMaxCheck("memcached-port", value2, 0, 65535);
    }

    @Override
    public boolean isMemcachedPortModifiable() {
        return this._modifiableDefault();
    }

    protected void checkMemcachedProtocol(String protocol) {
        if (protocol == null || !protocol.equalsIgnoreCase(GemFireMemcachedServer.Protocol.ASCII.name()) && !protocol.equalsIgnoreCase(GemFireMemcachedServer.Protocol.BINARY.name())) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_MEMCACHED_PROTOCOL_MUST_BE_ASCII_OR_BINARY.toLocalizedString());
        }
    }

    @Override
    public boolean isMemcachedProtocolModifiable() {
        return false;
    }

    protected void checkMemcachedBindAddress(String value2) {
        this._checkIfModifiable("memcached-bind-address");
        if (value2 != null && value2.length() > 0 && !SocketCreator.isLocalHost(value2)) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractDistributionConfig_MEMCACHED_BIND_ADDRESS_0_INVALID_MUST_BE_IN_1.toLocalizedString(value2, SocketCreator.getMyAddresses()));
        }
    }

    @Override
    public boolean isMemcachedBindAddressModifiable() {
        return this._modifiableDefault();
    }

    protected void checkEnableSharedConfiguration() {
        this._checkIfModifiable("enable-cluster-configuration");
    }

    protected void checkUseSharedConfiguration() {
        this._checkIfModifiable("use-cluster-configuration");
    }

    protected void checkLoadSharedConfigFromDir() {
        this._checkIfModifiable("load-cluster-configuration-from-dir");
    }

    protected void checkClusterConfigDir() {
        this._checkIfModifiable("cluster-configuration-dir");
    }

    public boolean isEnableSharedConfigurationModifiable() {
        return this._modifiableDefault();
    }

    public boolean isLoadSharedConfigFromDirModifiable() {
        return this._modifiableDefault();
    }

    public boolean isUseSharedConfigurationModifiable() {
        return this._modifiableDefault();
    }

    @Override
    protected void checkAttributeName(String attName) {
        if (!(attName.startsWith("security-") || attName.startsWith("custom-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-"))) {
            super.checkAttributeName(attName);
        }
    }

    public static boolean isWellKnownAttribute(String attName) {
        return Arrays.binarySearch(dcValidAttributeNames, attName) >= 0;
    }

    @Override
    public void setAttributeObject(String attName, Object attValue, ConfigSource source) {
        Class validValueClass = this.getAttributeType(attName);
        if (attValue != null && !validValueClass.isInstance(attValue)) {
            throw new InvalidValueException(LocalizedStrings.AbstractDistributionConfig_0_VALUE_1_MUST_BE_OF_TYPE_2.toLocalizedString(attName, attValue, validValueClass.getName()));
        }
        if (attName.equalsIgnoreCase("ack-wait-threshold")) {
            this.setAckWaitThreshold((Integer)attValue);
        } else if (attName.equalsIgnoreCase("ack-severe-alert-threshold")) {
            this.setAckSevereAlertThreshold((Integer)attValue);
        } else if (attName.equalsIgnoreCase("archive-disk-space-limit")) {
            this.setArchiveDiskSpaceLimit((Integer)attValue);
        } else if (attName.equalsIgnoreCase("archive-file-size-limit")) {
            this.setArchiveFileSizeLimit((Integer)attValue);
        } else if (attName.equalsIgnoreCase("cache-xml-file")) {
            this.setCacheXmlFile((File)attValue);
        } else if (attName.equalsIgnoreCase("deploy-working-dir")) {
            this.setDeployWorkingDir((File)attValue);
        } else if (attName.equalsIgnoreCase("license-data-management")) {
            this.setLicenseDataManagement((String)attValue);
        } else if (attName.equalsIgnoreCase("license-application-cache")) {
            this.setLicenseApplicationCache((String)attValue);
        } else if (attName.equalsIgnoreCase("license-working-dir")) {
            this.setLicenseWorkingDir((File)attValue);
        } else if (attName.equalsIgnoreCase("writable-working-dir")) {
            this.setWritableWorkingDir((File)attValue);
        } else if (attName.equalsIgnoreCase("license-server-timeout")) {
            this.setLicenseServerTimeout((Integer)attValue);
        } else if (attName.equalsIgnoreCase("log-disk-space-limit")) {
            this.setLogDiskSpaceLimit((Integer)attValue);
        } else if (attName.equalsIgnoreCase("log-file")) {
            this.setLogFile((File)attValue);
        } else if (attName.equalsIgnoreCase("log-file-size-limit")) {
            this.setLogFileSizeLimit((Integer)attValue);
        } else if (attName.equalsIgnoreCase("log-level")) {
            this.setLogLevel(LogWriterImpl.levelNameToCode((String)attValue));
        } else if (attName.equalsIgnoreCase("locators")) {
            this.setLocators((String)attValue);
        } else if (attName.equalsIgnoreCase("locator-wait-time")) {
            this.setLocatorWaitTime((Integer)attValue);
        } else if (attName.equalsIgnoreCase("remote-locators")) {
            this.setRemoteLocators((String)attValue);
        } else if (attName.equalsIgnoreCase("mcast-address")) {
            this.setMcastAddress((InetAddress)attValue);
        } else if (attName.equalsIgnoreCase("bind-address")) {
            this.setBindAddress((String)attValue);
        } else if (attName.equalsIgnoreCase("server-bind-address")) {
            this.setServerBindAddress((String)attValue);
        } else if (attName.equalsIgnoreCase("tcp-port")) {
            this.setTcpPort((Integer)attValue);
        } else if (attName.equalsIgnoreCase("mcast-port")) {
            this.setMcastPort((Integer)attValue);
        } else if (attName.equalsIgnoreCase("mcast-ttl")) {
            this.setMcastTtl((Integer)attValue);
        } else if (attName.equalsIgnoreCase("socket-lease-time")) {
            this.setSocketLeaseTime((Integer)attValue);
        } else if (attName.equalsIgnoreCase("socket-buffer-size")) {
            this.setSocketBufferSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("conserve-sockets")) {
            this.setConserveSockets((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("roles")) {
            this.setRoles((String)attValue);
        } else if (attName.equalsIgnoreCase("name")) {
            this.setName((String)attValue);
        } else if (attName.equalsIgnoreCase("statistic-archive-file")) {
            this.setStatisticArchiveFile((File)attValue);
        } else if (attName.equalsIgnoreCase("statistic-sample-rate")) {
            this.setStatisticSampleRate((Integer)attValue);
        } else if (attName.equalsIgnoreCase("statistic-sampling-enabled")) {
            this.setStatisticSamplingEnabled((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("ssl-enabled")) {
            this.setSSLEnabled((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("ssl-protocols")) {
            this.setSSLProtocols((String)attValue);
        } else if (attName.equalsIgnoreCase("ssl-ciphers")) {
            this.setSSLCiphers((String)attValue);
        } else if (attName.equalsIgnoreCase("ssl-require-authentication")) {
            this.setSSLRequireAuthentication((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-enabled")) {
            this.setClusterSSLEnabled((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-protocols")) {
            this.setClusterSSLProtocols((String)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-ciphers")) {
            this.setClusterSSLCiphers((String)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-require-authentication")) {
            this.setClusterSSLRequireAuthentication((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-keystore")) {
            this.setClusterSSLKeyStore((String)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-keystore-type")) {
            this.setClusterSSLKeyStoreType((String)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-keystore-password")) {
            this.setClusterSSLKeyStorePassword((String)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-truststore")) {
            this.setClusterSSLTrustStore((String)attValue);
        } else if (attName.equalsIgnoreCase("cluster-ssl-truststore-password")) {
            this.setClusterSSLTrustStorePassword((String)attValue);
        } else if (attName.equalsIgnoreCase("mcast-send-buffer-size")) {
            this.setMcastSendBufferSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("mcast-recv-buffer-size")) {
            this.setMcastRecvBufferSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("udp-send-buffer-size")) {
            this.setUdpSendBufferSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("udp-recv-buffer-size")) {
            this.setUdpRecvBufferSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("mcast-flow-control")) {
            this.setMcastFlowControl((FlowControlParams)attValue);
        } else if (attName.equalsIgnoreCase("udp-fragment-size")) {
            this.setUdpFragmentSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("disable-tcp")) {
            this.setDisableTcp((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("enable-time-statistics")) {
            this.setEnableTimeStatistics((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("member-timeout")) {
            this.setMemberTimeout((Integer)attValue);
        } else if (attName.equalsIgnoreCase("membership-port-range")) {
            this.setMembershipPortRange((int[])attValue);
        } else if (attName.equalsIgnoreCase("max-wait-time-reconnect")) {
            this.setMaxWaitTimeForReconnect((Integer)attValue);
        } else if (attName.equalsIgnoreCase("max-num-reconnect-tries")) {
            this.setMaxNumReconnectTries((Integer)attValue);
        } else if (attName.equalsIgnoreCase("async-distribution-timeout")) {
            this.setAsyncDistributionTimeout((Integer)attValue);
        } else if (attName.equalsIgnoreCase("async-queue-timeout")) {
            this.setAsyncQueueTimeout((Integer)attValue);
        } else if (attName.equalsIgnoreCase("async-max-queue-size")) {
            this.setAsyncMaxQueueSize((Integer)attValue);
        } else if (attName.equalsIgnoreCase("start-locator")) {
            this.setStartLocator((String)attValue);
        } else if (attName.equalsIgnoreCase("conflate-events")) {
            this.setClientConflation((String)attValue);
        } else if (attName.equalsIgnoreCase("durable-client-id")) {
            this.setDurableClientId((String)attValue);
        } else if (attName.equalsIgnoreCase("durable-client-timeout")) {
            this.setDurableClientTimeout((Integer)attValue);
        } else if (attName.equalsIgnoreCase("security-client-auth-init")) {
            this.setSecurityClientAuthInit((String)attValue);
        } else if (attName.equalsIgnoreCase("security-client-authenticator")) {
            this.setSecurityClientAuthenticator((String)attValue);
        } else if (attName.equalsIgnoreCase("security-client-dhalgo")) {
            this.setSecurityClientDHAlgo((String)attValue);
        } else if (attName.equalsIgnoreCase("security-peer-auth-init")) {
            this.setSecurityPeerAuthInit((String)attValue);
        } else if (attName.equalsIgnoreCase("security-peer-authenticator")) {
            this.setSecurityPeerAuthenticator((String)attValue);
        } else if (attName.equalsIgnoreCase("security-client-accessor")) {
            this.setSecurityClientAccessor((String)attValue);
        } else if (attName.equalsIgnoreCase("security-client-accessor-pp")) {
            this.setSecurityClientAccessorPP((String)attValue);
        } else if (attName.equalsIgnoreCase("security-log-level")) {
            this.setSecurityLogLevel(LogWriterImpl.levelNameToCode((String)attValue));
        } else if (attName.equalsIgnoreCase("security-log-file")) {
            this.setSecurityLogFile((File)attValue);
        } else if (attName.equalsIgnoreCase("security-peer-verifymember-timeout")) {
            this.setSecurityPeerMembershipTimeout((Integer)attValue);
        } else if (attName.startsWith("security-")) {
            this.setSecurity(attName, (String)attValue);
        } else if (attName.equalsIgnoreCase("enable-network-partition-detection")) {
            this.setEnableNetworkPartitionDetection((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("disable-auto-reconnect")) {
            this.setDisableAutoReconnect((Boolean)attValue);
        } else if (attName.equalsIgnoreCase("remove-unresponsive-client")) {
            this.setRemoveUnresponsiveClient((Boolean)attValue);
        } else if (attName.startsWith("delta-propagation")) {
            this.setDeltaPropagation((Boolean)attValue);
        } else if (attName.startsWith("distributed-system-id")) {
            this.setDistributedSystemId((Integer)attValue);
        } else if (attName.startsWith("redundancy-zone")) {
            this.setRedundancyZone((String)attValue);
        } else if (attName.startsWith("enforce-unique-host")) {
            this.setEnforceUniqueHost((Boolean)attValue);
        } else if (!attName.startsWith("custom-")) {
            if (attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
                this.setSSLProperty(attName, (String)attValue);
            } else if (attName.equalsIgnoreCase("groups")) {
                this.setGroups((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager")) {
                this.setJmxManager((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-start")) {
                this.setJmxManagerStart((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl")) {
                this.setJmxManagerSSL((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-enabled")) {
                this.setJmxManagerSSLEnabled((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-require-authentication")) {
                this.setJmxManagerSSLRequireAuthentication((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-protocols")) {
                this.setJmxManagerSSLProtocols((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-ciphers")) {
                this.setJmxManagerSSLCiphers((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore")) {
                this.setJmxManagerSSLKeyStore((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-type")) {
                this.setJmxManagerSSLKeyStoreType((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-password")) {
                this.setJmxManagerSSLKeyStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore")) {
                this.setJmxManagerSSLTrustStore((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore-password")) {
                this.setJmxManagerSSLTrustStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-port")) {
                this.setJmxManagerPort((Integer)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-bind-address")) {
                this.setJmxManagerBindAddress((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-hostname-for-clients")) {
                this.setJmxManagerHostnameForClients((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-password-file")) {
                this.setJmxManagerPasswordFile((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-access-file")) {
                this.setJmxManagerAccessFile((String)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-http-port")) {
                this.setJmxManagerHttpPort((Integer)attValue);
            } else if (attName.equalsIgnoreCase("jmx-manager-update-rate")) {
                this.setJmxManagerUpdateRate((Integer)attValue);
            } else if (attName.equalsIgnoreCase("memcached-port")) {
                this.setMemcachedPort((Integer)attValue);
            } else if (attName.equalsIgnoreCase("memcached-protocol")) {
                this.setMemcachedProtocol((String)attValue);
            } else if (attName.equalsIgnoreCase("memcached-bind-address")) {
                this.setMemcachedBindAddress((String)attValue);
            } else if (attName.equalsIgnoreCase("user-command-packages")) {
                this.setUserCommandPackages((String)attValue);
            } else if (attName.equalsIgnoreCase("enable-cluster-configuration")) {
                this.setEnableClusterConfiguration((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("load-cluster-configuration-from-dir")) {
                this.setLoadClusterConfigFromDir((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("use-cluster-configuration")) {
                this.setUseSharedConfiguration((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("cluster-configuration-dir")) {
                this.setClusterConfigDir((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-enabled")) {
                this.setServerSSLEnabled((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-require-authentication")) {
                this.setServerSSLRequireAuthentication((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-protocols")) {
                this.setServerSSLProtocols((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-ciphers")) {
                this.setServerSSLCiphers((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-keystore")) {
                this.setServerSSLKeyStore((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-keystore-type")) {
                this.setServerSSLKeyStoreType((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-keystore-password")) {
                this.setServerSSLKeyStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-truststore")) {
                this.setServerSSLTrustStore((String)attValue);
            } else if (attName.equalsIgnoreCase("server-ssl-truststore-password")) {
                this.setServerSSLTrustStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-enabled")) {
                this.setGatewaySSLEnabled((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-require-authentication")) {
                this.setGatewaySSLRequireAuthentication((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-protocols")) {
                this.setGatewaySSLProtocols((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-ciphers")) {
                this.setGatewaySSLCiphers((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-keystore")) {
                this.setGatewaySSLKeyStore((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-keystore-type")) {
                this.setGatewaySSLKeyStoreType((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-keystore-password")) {
                this.setGatewaySSLKeyStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-truststore")) {
                this.setGatewaySSLTrustStore((String)attValue);
            } else if (attName.equalsIgnoreCase("gateway-ssl-truststore-password")) {
                this.setGatewaySSLTrustStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-port")) {
                this.setHttpServicePort((Integer)attValue);
            } else if (attName.equalsIgnoreCase("http-service-bind-address")) {
                this.setHttpServiceBindAddress((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-enabled")) {
                this.setHttpServiceSSLEnabled((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-require-authentication")) {
                this.setHttpServiceSSLRequireAuthentication((Boolean)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-protocols")) {
                this.setHttpServiceSSLProtocols((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-ciphers")) {
                this.setHttpServiceSSLCiphers((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-keystore")) {
                this.setHttpServiceSSLKeyStore((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-keystore-type")) {
                this.setHttpServiceSSLKeyStoreType((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-keystore-password")) {
                this.setHttpServiceSSLKeyStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-truststore")) {
                this.setHttpServiceSSLTrustStore((String)attValue);
            } else if (attName.equalsIgnoreCase("http-service-ssl-truststore-password")) {
                this.setHttpServiceSSLTrustStorePassword((String)attValue);
            } else if (attName.equalsIgnoreCase("start-dev-rest-api")) {
                this.setStartDevRestApi((Boolean)attValue);
            } else {
                throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
            }
        }
        this.getAttSourceMap().put(attName, source);
    }

    @Override
    public Object getAttributeObject(String attName) {
        this.checkAttributeName(attName);
        if (attName.equalsIgnoreCase("ack-wait-threshold")) {
            return this.getAckWaitThreshold();
        }
        if (attName.equalsIgnoreCase("ack-severe-alert-threshold")) {
            return this.getAckSevereAlertThreshold();
        }
        if (attName.equalsIgnoreCase("archive-disk-space-limit")) {
            return this.getArchiveDiskSpaceLimit();
        }
        if (attName.equalsIgnoreCase("archive-file-size-limit")) {
            return this.getArchiveFileSizeLimit();
        }
        if (attName.equalsIgnoreCase("cache-xml-file")) {
            return this.getCacheXmlFile();
        }
        if (attName.equalsIgnoreCase("deploy-working-dir")) {
            return this.getDeployWorkingDir();
        }
        if (attName.equalsIgnoreCase("license-data-management")) {
            return this.getLicenseDataManagement();
        }
        if (attName.equalsIgnoreCase("license-application-cache")) {
            return this.getLicenseApplicationCache();
        }
        if (attName.equalsIgnoreCase("license-working-dir")) {
            return this.getLicenseWorkingDir();
        }
        if (attName.equalsIgnoreCase("writable-working-dir")) {
            return this.getLicenseWorkingDir();
        }
        if (attName.equalsIgnoreCase("license-server-timeout")) {
            return this.getLicenseServerTimeout();
        }
        if (attName.equalsIgnoreCase("log-disk-space-limit")) {
            return this.getLogDiskSpaceLimit();
        }
        if (attName.equalsIgnoreCase("log-file")) {
            return this.getLogFile();
        }
        if (attName.equalsIgnoreCase("log-file-size-limit")) {
            return this.getLogFileSizeLimit();
        }
        if (attName.equalsIgnoreCase("log-level")) {
            return LogWriterImpl.levelToString(this.getLogLevel());
        }
        if (attName.equalsIgnoreCase("locators")) {
            return this.getLocators();
        }
        if (attName.equalsIgnoreCase("locator-wait-time")) {
            return this.getLocatorWaitTime();
        }
        if (attName.equalsIgnoreCase("remote-locators")) {
            return this.getRemoteLocators();
        }
        if (attName.equalsIgnoreCase("mcast-address")) {
            return this.getMcastAddress();
        }
        if (attName.equalsIgnoreCase("bind-address")) {
            return this.getBindAddress();
        }
        if (attName.equalsIgnoreCase("server-bind-address")) {
            return this.getServerBindAddress();
        }
        if (attName.equalsIgnoreCase("tcp-port")) {
            return this.getTcpPort();
        }
        if (attName.equalsIgnoreCase("mcast-port")) {
            return this.getMcastPort();
        }
        if (attName.equalsIgnoreCase("mcast-ttl")) {
            return this.getMcastTtl();
        }
        if (attName.equalsIgnoreCase("socket-lease-time")) {
            return this.getSocketLeaseTime();
        }
        if (attName.equalsIgnoreCase("socket-buffer-size")) {
            return this.getSocketBufferSize();
        }
        if (attName.equalsIgnoreCase("conserve-sockets")) {
            return this.getConserveSockets();
        }
        if (attName.equalsIgnoreCase("roles")) {
            return this.getRoles();
        }
        if (attName.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (attName.equalsIgnoreCase("statistic-archive-file")) {
            return this.getStatisticArchiveFile();
        }
        if (attName.equalsIgnoreCase("statistic-sample-rate")) {
            return this.getStatisticSampleRate();
        }
        if (attName.equalsIgnoreCase("statistic-sampling-enabled")) {
            return this.getStatisticSamplingEnabled();
        }
        if (attName.equalsIgnoreCase("ssl-enabled")) {
            return this.getSSLEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (attName.equalsIgnoreCase("ssl-protocols")) {
            return this.getSSLProtocols();
        }
        if (attName.equalsIgnoreCase("ssl-ciphers")) {
            return this.getSSLCiphers();
        }
        if (attName.equalsIgnoreCase("ssl-require-authentication")) {
            return this.getSSLRequireAuthentication() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-enabled")) {
            return this.getClusterSSLEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-protocols")) {
            return this.getClusterSSLProtocols();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-ciphers")) {
            return this.getClusterSSLCiphers();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-require-authentication")) {
            return this.getClusterSSLRequireAuthentication() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore")) {
            return this.getClusterSSLKeyStore();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore-type")) {
            return this.getClusterSSLKeyStoreType();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore-password")) {
            return this.getClusterSSLKeyStorePassword();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-truststore")) {
            return this.getClusterSSLTrustStore();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-truststore-password")) {
            return this.getClusterSSLTrustStorePassword();
        }
        if (attName.equalsIgnoreCase("mcast-send-buffer-size")) {
            return this.getMcastSendBufferSize();
        }
        if (attName.equalsIgnoreCase("mcast-recv-buffer-size")) {
            return this.getMcastRecvBufferSize();
        }
        if (attName.equalsIgnoreCase("udp-send-buffer-size")) {
            return this.getUdpSendBufferSize();
        }
        if (attName.equalsIgnoreCase("udp-recv-buffer-size")) {
            return this.getUdpRecvBufferSize();
        }
        if (attName.equalsIgnoreCase("mcast-flow-control")) {
            return this.getMcastFlowControl();
        }
        if (attName.equalsIgnoreCase("udp-fragment-size")) {
            return this.getUdpFragmentSize();
        }
        if (attName.equalsIgnoreCase("disable-tcp")) {
            return this.getDisableTcp();
        }
        if (attName.equalsIgnoreCase("enable-time-statistics")) {
            return this.getEnableTimeStatistics();
        }
        if (attName.equalsIgnoreCase("member-timeout")) {
            return this.getMemberTimeout();
        }
        if (attName.equalsIgnoreCase("membership-port-range")) {
            return this.getMembershipPortRange();
        }
        if (attName.equalsIgnoreCase("max-wait-time-reconnect")) {
            return this.getMaxWaitTimeForReconnect();
        }
        if (attName.equalsIgnoreCase("max-num-reconnect-tries")) {
            return this.getMaxNumReconnectTries();
        }
        if (attName.equalsIgnoreCase("async-distribution-timeout")) {
            return this.getAsyncDistributionTimeout();
        }
        if (attName.equalsIgnoreCase("async-queue-timeout")) {
            return this.getAsyncQueueTimeout();
        }
        if (attName.equalsIgnoreCase("async-max-queue-size")) {
            return this.getAsyncMaxQueueSize();
        }
        if (attName.equalsIgnoreCase("start-locator")) {
            return this.getStartLocator();
        }
        if (attName.equalsIgnoreCase("conflate-events")) {
            return this.getClientConflation();
        }
        if (attName.equalsIgnoreCase("durable-client-id")) {
            return this.getDurableClientId();
        }
        if (attName.equalsIgnoreCase("durable-client-timeout")) {
            return this.getDurableClientTimeout();
        }
        if (attName.equalsIgnoreCase("security-client-auth-init")) {
            return this.getSecurityClientAuthInit();
        }
        if (attName.equalsIgnoreCase("security-client-authenticator")) {
            return this.getSecurityClientAuthenticator();
        }
        if (attName.equalsIgnoreCase("security-client-dhalgo")) {
            return this.getSecurityClientDHAlgo();
        }
        if (attName.equalsIgnoreCase("security-peer-auth-init")) {
            return this.getSecurityPeerAuthInit();
        }
        if (attName.equalsIgnoreCase("security-peer-authenticator")) {
            return this.getSecurityPeerAuthenticator();
        }
        if (attName.equalsIgnoreCase("security-client-accessor")) {
            return this.getSecurityClientAccessor();
        }
        if (attName.equalsIgnoreCase("security-client-accessor-pp")) {
            return this.getSecurityClientAccessorPP();
        }
        if (attName.equalsIgnoreCase("security-log-level")) {
            return LogWriterImpl.levelToString(this.getSecurityLogLevel());
        }
        if (attName.equalsIgnoreCase("security-log-file")) {
            return this.getSecurityLogFile();
        }
        if (attName.equalsIgnoreCase("security-peer-verifymember-timeout")) {
            return this.getSecurityPeerMembershipTimeout();
        }
        if (attName.startsWith("security-")) {
            return this.getSecurity(attName);
        }
        if (attName.equalsIgnoreCase("enable-network-partition-detection")) {
            return this.getEnableNetworkPartitionDetection();
        }
        if (attName.equalsIgnoreCase("disable-auto-reconnect")) {
            return this.getDisableAutoReconnect();
        }
        if (attName.equalsIgnoreCase("remove-unresponsive-client")) {
            return this.getRemoveUnresponsiveClient();
        }
        if (attName.equalsIgnoreCase("delta-propagation")) {
            return this.getDeltaPropagation();
        }
        if (attName.equalsIgnoreCase("distributed-system-id")) {
            return this.getDistributedSystemId();
        }
        if (attName.equalsIgnoreCase("enforce-unique-host")) {
            return this.getEnforceUniqueHost();
        }
        if (attName.equalsIgnoreCase("redundancy-zone")) {
            return this.getRedundancyZone() == null ? "" : this.getRedundancyZone();
        }
        if (attName.equalsIgnoreCase("groups")) {
            return this.getGroups();
        }
        if (attName.equalsIgnoreCase("jmx-manager")) {
            return this.getJmxManager();
        }
        if (attName.equalsIgnoreCase("jmx-manager-start")) {
            return this.getJmxManagerStart();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl")) {
            return this.getJmxManagerSSL();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-enabled")) {
            return this.getJmxManagerSSLEnabled();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-ciphers")) {
            return this.getJmxManagerSSLCiphers();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-protocols")) {
            return this.getJmxManagerSSLProtocols();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-require-authentication")) {
            return this.getJmxManagerSSLRequireAuthentication();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore")) {
            return this.getJmxManagerSSLKeyStore();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-type")) {
            return this.getJmxManagerSSLKeyStoreType();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-password")) {
            return this.getJmxManagerSSLKeyStorePassword();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore")) {
            return this.getJmxManagerSSLTrustStore();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore-password")) {
            return this.getJmxManagerSSLTrustStorePassword();
        }
        if (attName.equalsIgnoreCase("jmx-manager-port")) {
            return this.getJmxManagerPort();
        }
        if (attName.equalsIgnoreCase("jmx-manager-bind-address")) {
            return this.getJmxManagerBindAddress();
        }
        if (attName.equalsIgnoreCase("jmx-manager-hostname-for-clients")) {
            return this.getJmxManagerHostnameForClients();
        }
        if (attName.equalsIgnoreCase("jmx-manager-password-file")) {
            return this.getJmxManagerPasswordFile();
        }
        if (attName.equalsIgnoreCase("jmx-manager-access-file")) {
            return this.getJmxManagerAccessFile();
        }
        if (attName.equalsIgnoreCase("jmx-manager-http-port")) {
            return this.getJmxManagerHttpPort();
        }
        if (attName.equalsIgnoreCase("jmx-manager-update-rate")) {
            return this.getJmxManagerUpdateRate();
        }
        if (attName.equalsIgnoreCase("memcached-port")) {
            return this.getMemcachedPort();
        }
        if (attName.equalsIgnoreCase("memcached-protocol")) {
            return this.getMemcachedProtocol();
        }
        if (attName.equalsIgnoreCase("memcached-bind-address")) {
            return this.getMemcachedBindAddress();
        }
        if (attName.equalsIgnoreCase("user-command-packages")) {
            return this.getUserCommandPackages();
        }
        if (attName.equalsIgnoreCase("enable-cluster-configuration")) {
            return this.getEnableClusterConfiguration();
        }
        if (attName.equalsIgnoreCase("use-cluster-configuration")) {
            return this.getUseSharedConfiguration();
        }
        if (attName.equalsIgnoreCase("load-cluster-configuration-from-dir")) {
            return this.getLoadClusterConfigFromDir();
        }
        if (attName.equalsIgnoreCase("cluster-configuration-dir")) {
            return this.getClusterConfigDir();
        }
        if (attName.equalsIgnoreCase("server-ssl-enabled")) {
            return this.getServerSSLEnabled();
        }
        if (attName.equalsIgnoreCase("server-ssl-ciphers")) {
            return this.getServerSSLCiphers();
        }
        if (attName.equalsIgnoreCase("server-ssl-protocols")) {
            return this.getServerSSLProtocols();
        }
        if (attName.equalsIgnoreCase("server-ssl-require-authentication")) {
            return this.getServerSSLRequireAuthentication();
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore")) {
            return this.getServerSSLKeyStore();
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore-type")) {
            return this.getServerSSLKeyStoreType();
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore-password")) {
            return this.getServerSSLKeyStorePassword();
        }
        if (attName.equalsIgnoreCase("server-ssl-truststore")) {
            return this.getServerSSLTrustStore();
        }
        if (attName.equalsIgnoreCase("server-ssl-truststore-password")) {
            return this.getServerSSLTrustStorePassword();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-enabled")) {
            return this.getGatewaySSLEnabled();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-ciphers")) {
            return this.getGatewaySSLCiphers();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-protocols")) {
            return this.getGatewaySSLProtocols();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-require-authentication")) {
            return this.getGatewaySSLRequireAuthentication();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore")) {
            return this.getGatewaySSLKeyStore();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore-type")) {
            return this.getGatewaySSLKeyStoreType();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore-password")) {
            return this.getGatewaySSLKeyStorePassword();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-truststore")) {
            return this.getGatewaySSLTrustStore();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-truststore-password")) {
            return this.getGatewaySSLTrustStorePassword();
        }
        if (attName.equalsIgnoreCase("http-service-port")) {
            return this.getHttpServicePort();
        }
        if (attName.equalsIgnoreCase("http-service-bind-address")) {
            return this.getHttpServiceBindAddress();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-enabled")) {
            return this.getHttpServiceSSLEnabled();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-ciphers")) {
            return this.getHttpServiceSSLCiphers();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-protocols")) {
            return this.getHttpServiceSSLProtocols();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-require-authentication")) {
            return this.getHttpServiceSSLRequireAuthentication();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore")) {
            return this.getHttpServiceSSLKeyStore();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore-type")) {
            return this.getHttpServiceSSLKeyStoreType();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore-password")) {
            return this.getHttpServiceSSLKeyStorePassword();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-truststore")) {
            return this.getHttpServiceSSLTrustStore();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-truststore-password")) {
            return this.getHttpServiceSSLTrustStorePassword();
        }
        if (attName.equalsIgnoreCase("start-dev-rest-api")) {
            return this.getStartDevRestApi();
        }
        throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
    }

    @Override
    public boolean isAttributeModifiable(String attName) {
        this.checkAttributeName(attName);
        if (attName.equalsIgnoreCase("ack-wait-threshold")) {
            return this.isAckWaitThresholdModifiable();
        }
        if (attName.equalsIgnoreCase("ack-severe-alert-threshold")) {
            return this.isAckSevereAlertThresholdModifiable();
        }
        if (attName.equalsIgnoreCase("archive-disk-space-limit")) {
            return this.isArchiveDiskSpaceLimitModifiable();
        }
        if (attName.equalsIgnoreCase("archive-file-size-limit")) {
            return this.isArchiveFileSizeLimitModifiable();
        }
        if (attName.equalsIgnoreCase("cache-xml-file")) {
            return this.isCacheXmlFileModifiable();
        }
        if (attName.equalsIgnoreCase("deploy-working-dir")) {
            return this.isDeployWorkingDirModifiable();
        }
        if (attName.equalsIgnoreCase("license-data-management")) {
            return this.isLicenseDataManagementModifiable();
        }
        if (attName.equalsIgnoreCase("license-application-cache")) {
            return this.isLicenseApplicationCacheModifiable();
        }
        if (attName.equalsIgnoreCase("license-working-dir")) {
            return this.isLicenseWorkingDirModifiable();
        }
        if (attName.equalsIgnoreCase("writable-working-dir")) {
            return this.isLicenseWorkingDirModifiable();
        }
        if (attName.equalsIgnoreCase("license-server-timeout")) {
            return this.isLicenseServerTimeoutModifiable();
        }
        if (attName.equalsIgnoreCase("log-disk-space-limit")) {
            return this.isLogDiskSpaceLimitModifiable();
        }
        if (attName.equalsIgnoreCase("log-file")) {
            return this.isLogFileModifiable();
        }
        if (attName.equalsIgnoreCase("log-file-size-limit")) {
            return this.isLogFileSizeLimitModifiable();
        }
        if (attName.equalsIgnoreCase("log-level")) {
            return this.isLogLevelModifiable();
        }
        if (attName.equalsIgnoreCase("locators")) {
            return this.isLocatorsModifiable();
        }
        if (attName.equalsIgnoreCase("locator-wait-time")) {
            return this.isLocatorWaitTimeModifiable();
        }
        if (attName.equalsIgnoreCase("remote-locators")) {
            return this.isRemoteLocatorsModifiable();
        }
        if (attName.equalsIgnoreCase("mcast-address")) {
            return this.isMcastAddressModifiable();
        }
        if (attName.equalsIgnoreCase("bind-address")) {
            return this.isBindAddressModifiable();
        }
        if (attName.equalsIgnoreCase("server-bind-address")) {
            return this.isServerBindAddressModifiable();
        }
        if (attName.equalsIgnoreCase("tcp-port")) {
            return this.isTcpPortModifiable();
        }
        if (attName.equalsIgnoreCase("mcast-port")) {
            return this.isMcastPortModifiable();
        }
        if (attName.equalsIgnoreCase("mcast-ttl")) {
            return this.isMcastTtlModifiable();
        }
        if (attName.equalsIgnoreCase("socket-lease-time")) {
            return this.isSocketLeaseTimeModifiable();
        }
        if (attName.equalsIgnoreCase("socket-buffer-size")) {
            return this.isSocketBufferSizeModifiable();
        }
        if (attName.equalsIgnoreCase("conserve-sockets")) {
            return this.isConserveSocketsModifiable();
        }
        if (attName.equalsIgnoreCase("roles")) {
            return this.isRolesModifiable();
        }
        if (attName.equalsIgnoreCase("name")) {
            return this.isNameModifiable();
        }
        if (attName.equalsIgnoreCase("statistic-archive-file")) {
            return this.isStatisticArchiveFileModifiable();
        }
        if (attName.equalsIgnoreCase("statistic-sample-rate")) {
            return this.isStatisticSampleRateModifiable();
        }
        if (attName.equalsIgnoreCase("statistic-sampling-enabled")) {
            return this.isStatisticSamplingEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("ssl-enabled")) {
            return this.isSSLEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("ssl-protocols")) {
            return this.isSSLProtocolsModifiable();
        }
        if (attName.equalsIgnoreCase("ssl-ciphers")) {
            return this.isSSLCiphersModifiable();
        }
        if (attName.equalsIgnoreCase("ssl-require-authentication")) {
            return this.isSSLRequireAuthenticationModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-enabled")) {
            return this.isClusterSSLEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-protocols")) {
            return this.isClusterSSLProtocolsModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-ciphers")) {
            return this.isClusterSSLCiphersModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-require-authentication")) {
            return this.isClusterSSLRequireAuthenticationModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore")) {
            return this.isClusterSSLKeyStoreModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore-type")) {
            return this.isClusterSSLKeyStoreTypeModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore-password")) {
            return this.isClusterSSLKeyStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-truststore")) {
            return this.isClusterSSLTrustStoreModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-ssl-truststore-password")) {
            return this.isClusterSSLTrustStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("mcast-send-buffer-size")) {
            return this.isMcastSendBufferSizeModifiable();
        }
        if (attName.equalsIgnoreCase("mcast-recv-buffer-size")) {
            return this.isMcastRecvBufferSizeModifiable();
        }
        if (attName.equalsIgnoreCase("udp-send-buffer-size")) {
            return this.isUdpSendBufferSizeModifiable();
        }
        if (attName.equalsIgnoreCase("udp-recv-buffer-size")) {
            return this.isUdpRecvBufferSizeModifiable();
        }
        if (attName.equalsIgnoreCase("mcast-flow-control")) {
            return this.isMcastFlowControlModifiable();
        }
        if (attName.equalsIgnoreCase("udp-fragment-size")) {
            return this.isUdpFragmentSizeModifiable();
        }
        if (attName.equalsIgnoreCase("disable-tcp")) {
            return this.isDisableTcpModifiable();
        }
        if (attName.equalsIgnoreCase("enable-time-statistics")) {
            return this.isEnableTimeStatisticsModifiable();
        }
        if (attName.equalsIgnoreCase("member-timeout")) {
            return this.isMemberTimeoutModifiable();
        }
        if (attName.equalsIgnoreCase("membership-port-range")) {
            return this.isMembershipPortRangeModifiable();
        }
        if (attName.equalsIgnoreCase("max-num-reconnect-tries")) {
            return this.isMaxNumberOfTiesModifiable();
        }
        if (attName.equalsIgnoreCase("max-wait-time-reconnect")) {
            return this.isMaxTimeOutModifiable();
        }
        if (attName.equalsIgnoreCase("async-distribution-timeout")) {
            return this.isAsyncDistributionTimeoutModifiable();
        }
        if (attName.equalsIgnoreCase("async-queue-timeout")) {
            return this.isAsyncQueueTimeoutModifiable();
        }
        if (attName.equalsIgnoreCase("async-max-queue-size")) {
            return this.isAsyncMaxQueueSizeModifiable();
        }
        if (attName.equalsIgnoreCase("start-locator")) {
            return this.isStartLocatorModifiable();
        }
        if (attName.equalsIgnoreCase("conflate-events")) {
            return this.isClientConflationModifiable();
        }
        if (attName.equalsIgnoreCase("durable-client-id")) {
            return this.isDurableClientIdModifiable();
        }
        if (attName.equalsIgnoreCase("durable-client-timeout")) {
            return this.isDurableClientTimeoutModifiable();
        }
        if (attName.equalsIgnoreCase("security-client-auth-init")) {
            return this.isSecurityClientAuthInitModifiable();
        }
        if (attName.equalsIgnoreCase("security-client-authenticator")) {
            return this.isSecurityClientAuthenticatorModifiable();
        }
        if (attName.equalsIgnoreCase("security-client-dhalgo")) {
            return this.isSecurityClientDHAlgoModifiable();
        }
        if (attName.equalsIgnoreCase("security-peer-auth-init")) {
            return this.isSecurityPeerAuthInitModifiable();
        }
        if (attName.equalsIgnoreCase("security-peer-authenticator")) {
            return this.isSecurityPeerAuthenticatorModifiable();
        }
        if (attName.equalsIgnoreCase("security-client-accessor")) {
            return this.isSecurityClientAccessorModifiable();
        }
        if (attName.equalsIgnoreCase("security-client-accessor-pp")) {
            return this.isSecurityClientAccessorPPModifiable();
        }
        if (attName.equalsIgnoreCase("security-log-level")) {
            return this.isSecurityLogLevelModifiable();
        }
        if (attName.equalsIgnoreCase("security-log-file")) {
            return this.isSecurityLogFileModifiable();
        }
        if (attName.equalsIgnoreCase("security-peer-verifymember-timeout")) {
            return this.isSecurityPeerMembershipTimeoutModifiable();
        }
        if (attName.startsWith("security-")) {
            return this.isSecurityModifiable();
        }
        if (attName.equalsIgnoreCase("enable-network-partition-detection")) {
            return this.isEnableNetworkPartitionDetectionModifiable();
        }
        if (attName.equalsIgnoreCase("disable-auto-reconnect")) {
            return this.isDisableAutoReconnectModifiable();
        }
        if (attName.equalsIgnoreCase("remove-unresponsive-client")) {
            return this.isRemoveUnresponsiveClientModifiable();
        }
        if (attName.equalsIgnoreCase("delta-propagation")) {
            return this.isDeltaPropagationModifiable();
        }
        if (attName.equalsIgnoreCase("distributed-system-id")) {
            return this.isDistributedSystemIdModifiable();
        }
        if (attName.equalsIgnoreCase("enforce-unique-host")) {
            return this.isEnforceUniqueHostModifiable();
        }
        if (attName.equalsIgnoreCase("redundancy-zone")) {
            return this.isRedundancyZoneModifiable();
        }
        if (attName.startsWith("javax.net.ssl")) {
            return this.isSSLPropertyModifiable();
        }
        if (attName.equalsIgnoreCase("groups")) {
            return this.isGroupsModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager")) {
            return this.isJmxManagerModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-start")) {
            return this.isJmxManagerStartModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl")) {
            return this.isJmxManagerSSLModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-enabled")) {
            return this.isJmxManagerSSLEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-ciphers")) {
            return this.isJmxManagerSSLCiphersModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-protocols")) {
            return this.isJmxManagerSSLProtocolsModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-require-authentication")) {
            return this.isJmxManagerSSLRequireAuthenticationModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore")) {
            return this.isJmxManagerSSLKeyStoreModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-type")) {
            return this.isJmxManagerSSLKeyStoreTypeModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-password")) {
            return this.isJmxManagerSSLKeyStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore")) {
            return this.isJmxManagerSSLTrustStoreModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore-password")) {
            return this.isJmxManagerSSLTrustStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-port")) {
            return this.isJmxManagerPortModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-bind-address")) {
            return this.isJmxManagerBindAddressModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-hostname-for-clients")) {
            return this.isJmxManagerHostnameForClientsModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-password-file")) {
            return this.isJmxManagerPasswordFileModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-access-file")) {
            return this.isJmxManagerAccessFileModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-http-port")) {
            return this.isJmxManagerHttpPortModifiable();
        }
        if (attName.equalsIgnoreCase("jmx-manager-update-rate")) {
            return this.isJmxManagerUpdateRateModifiable();
        }
        if (attName.equalsIgnoreCase("memcached-port")) {
            return this.isMemcachedPortModifiable();
        }
        if (attName.equalsIgnoreCase("memcached-protocol")) {
            return this.isMemcachedProtocolModifiable();
        }
        if (attName.equalsIgnoreCase("memcached-bind-address")) {
            return this.isMemcachedBindAddressModifiable();
        }
        if (attName.equalsIgnoreCase("user-command-packages")) {
            return this.isUserCommandPackagesModifiable();
        }
        if (attName.equalsIgnoreCase("enable-cluster-configuration")) {
            return this.isEnableSharedConfigurationModifiable();
        }
        if (attName.equalsIgnoreCase("load-cluster-configuration-from-dir")) {
            return this.isLoadSharedConfigFromDirModifiable();
        }
        if (attName.equalsIgnoreCase("use-cluster-configuration")) {
            return this.isUseSharedConfigurationModifiable();
        }
        if (attName.equalsIgnoreCase("cluster-configuration-dir")) {
            return this._modifiableDefault();
        }
        if (attName.equalsIgnoreCase("server-ssl-enabled")) {
            return this.isServerSSLEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-ciphers")) {
            return this.isServerSSLCiphersModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-protocols")) {
            return this.isServerSSLProtocolsModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-require-authentication")) {
            return this.isServerSSLRequireAuthenticationModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore")) {
            return this.isServerSSLKeyStoreModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore-type")) {
            return this.isServerSSLKeyStoreTypeModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore-password")) {
            return this.isServerSSLKeyStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-truststore")) {
            return this.isServerSSLTrustStoreModifiable();
        }
        if (attName.equalsIgnoreCase("server-ssl-truststore-password")) {
            return this.isServerSSLTrustStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-enabled")) {
            return this.isGatewaySSLEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-ciphers")) {
            return this.isGatewaySSLCiphersModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-protocols")) {
            return this.isGatewaySSLProtocolsModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-require-authentication")) {
            return this.isGatewaySSLRequireAuthenticationModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore")) {
            return this.isGatewaySSLKeyStoreModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore-type")) {
            return this.isGatewaySSLKeyStoreTypeModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore-password")) {
            return this.isGatewaySSLKeyStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-truststore")) {
            return this.isGatewaySSLTrustStoreModifiable();
        }
        if (attName.equalsIgnoreCase("gateway-ssl-truststore-password")) {
            return this.isGatewaySSLTrustStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-port")) {
            return this.isHttpServicePortModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-bind-address")) {
            return this.isHttpServiceBindAddressModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-enabled")) {
            return this.isHttpServiceSSLEnabledModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-ciphers")) {
            return this.isHttpServiceSSLCiphersModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-protocols")) {
            return this.isHttpServiceSSLProtocolsModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-require-authentication")) {
            return this.isHttpServiceSSLRequireAuthenticationModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore")) {
            return this.isHttpServiceSSLKeyStoreModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore-type")) {
            return this.isHttpServiceSSLKeyStoreTypeModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore-password")) {
            return this.isHttpServiceSSLKeyStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-truststore")) {
            return this.isHttpServiceSSLTrustStoreModifiable();
        }
        if (attName.equalsIgnoreCase("http-service-ssl-truststore-password")) {
            return this.isHttpServiceSSLTrustStorePasswordModifiable();
        }
        if (attName.equalsIgnoreCase("start-dev-rest-api")) {
            return this.isStartDevRestApiModifiable();
        }
        throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
    }

    @Override
    public Class getAttributeType(String attName) {
        this.checkAttributeName(attName);
        if (attName.equalsIgnoreCase("ack-wait-threshold")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("ack-severe-alert-threshold")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("archive-disk-space-limit")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("archive-file-size-limit")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("cache-xml-file")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("deploy-working-dir")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("license-data-management")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("license-application-cache")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("license-working-dir")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("writable-working-dir")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("license-server-timeout")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("log-disk-space-limit")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("log-file")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("log-file-size-limit")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("log-level")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("locators")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("locator-wait-time")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("remote-locators")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("mcast-address")) {
            return InetAddress.class;
        }
        if (attName.equalsIgnoreCase("bind-address")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-bind-address")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("tcp-port")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("mcast-port")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("mcast-ttl")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("socket-lease-time")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("socket-buffer-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("conserve-sockets")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("roles")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("name")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("statistic-archive-file")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("statistic-sample-rate")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("statistic-sampling-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("ssl-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("ssl-protocols")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("ssl-ciphers")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("ssl-require-authentication")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-protocols")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-ciphers")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-require-authentication")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore-type")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-keystore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-truststore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("cluster-ssl-truststore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("mcast-send-buffer-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("mcast-recv-buffer-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("udp-send-buffer-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("udp-recv-buffer-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("mcast-flow-control")) {
            return FlowControlParams.class;
        }
        if (attName.equalsIgnoreCase("udp-fragment-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("disable-tcp")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("enable-time-statistics")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("member-timeout")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("membership-port-range")) {
            return int[].class;
        }
        if (attName.equalsIgnoreCase("max-wait-time-reconnect")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("max-num-reconnect-tries")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("async-distribution-timeout")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("async-queue-timeout")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("async-max-queue-size")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("start-locator")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("conflate-events")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("durable-client-id")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("durable-client-timeout")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("security-client-auth-init")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-client-authenticator")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-client-dhalgo")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-peer-auth-init")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-peer-authenticator")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-client-accessor")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-client-accessor-pp")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-log-level")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("security-log-file")) {
            return File.class;
        }
        if (attName.equalsIgnoreCase("security-peer-verifymember-timeout")) {
            return Integer.class;
        }
        if (attName.startsWith("security-")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("enable-network-partition-detection")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("disable-auto-reconnect")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("remove-unresponsive-client")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("delta-propagation")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("distributed-system-id")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("enforce-unique-host")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("redundancy-zone")) {
            return String.class;
        }
        if (attName.startsWith("custom-")) {
            return String.class;
        }
        if (attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("groups")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-start")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-ciphers")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-protocols")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-require-authentication")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-type")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-keystore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-ssl-truststore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-port")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-bind-address")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-hostname-for-clients")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-password-file")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-access-file")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-http-port")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("jmx-manager-update-rate")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("memcached-port")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("memcached-protocol")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("memcached-bind-address")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("user-command-packages")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("enable-cluster-configuration")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("use-cluster-configuration")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("load-cluster-configuration-from-dir")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("cluster-configuration-dir")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-ciphers")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-protocols")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-require-authentication")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore-type")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-keystore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-truststore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("server-ssl-truststore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-ciphers")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-protocols")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-require-authentication")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore-type")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-keystore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-truststore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("gateway-ssl-truststore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-port")) {
            return Integer.class;
        }
        if (attName.equalsIgnoreCase("http-service-bind-address")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-enabled")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-ciphers")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-protocols")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-require-authentication")) {
            return Boolean.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore-type")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-keystore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-truststore")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("http-service-ssl-truststore-password")) {
            return String.class;
        }
        if (attName.equalsIgnoreCase("start-dev-rest-api")) {
            return Boolean.class;
        }
        throw new InternalGemFireException(LocalizedStrings.AbstractDistributionConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
    }

    public static String[] _getAttNames() {
        return dcValidAttributeNames;
    }

    @Override
    public String[] getAttributeNames() {
        return dcValidAttributeNames;
    }

    @Override
    public String[] getSpecificAttributeNames() {
        return dcValidAttributeNames;
    }

    @Override
    protected Map getAttDescMap() {
        return dcAttDescriptions;
    }

    static final InetAddress _getDefaultMcastAddress() {
        String ipLiteral = SocketCreator.preferIPv6Addresses() ? "FF38::1234" : "239.192.81.1";
        try {
            return InetAddress.getByName(ipLiteral);
        }
        catch (UnknownHostException ex) {
            throw new Error(LocalizedStrings.AbstractDistributionConfig_UNEXPECTED_PROBLEM_GETTING_INETADDRESS_0.toLocalizedString(ex), ex);
        }
    }

    public boolean isServerSSLEnabledModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLEnabled() {
        this._checkIfModifiable("server-ssl-enabled");
    }

    public boolean isServerSSLRequireAuthenticationModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLRequireAuthentication() {
        this._checkIfModifiable("server-ssl-require-authentication");
    }

    public boolean isServerSSLProtocolsModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLProtocols() {
        this._checkIfModifiable("server-ssl-protocols");
    }

    public boolean isServerSSLCiphersModifiable() {
        return this._modifiableDefault();
    }

    public void checkServerSSLCiphers() {
        this._checkIfModifiable("server-ssl-ciphers");
    }

    public boolean isGatewaySSLEnabledModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSL() {
        this._checkIfModifiable("gateway-ssl-enabled");
    }

    public boolean isGatewaySSLRequireAuthenticationModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLRequireAuthentication() {
        this._checkIfModifiable("gateway-ssl-require-authentication");
    }

    public boolean isGatewaySSLProtocolsModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLProtocols() {
        this._checkIfModifiable("gateway-ssl-protocols");
    }

    public boolean isGatewaySSLCiphersModifiable() {
        return this._modifiableDefault();
    }

    public void checkGatewaySSLCiphers() {
        this._checkIfModifiable("gateway-ssl-ciphers");
    }

    static {
        String[] myAtts = new String[]{"ack-wait-threshold", "ack-severe-alert-threshold", "archive-disk-space-limit", "archive-file-size-limit", "bind-address", "server-bind-address", "cache-xml-file", "deploy-working-dir", "license-data-management", "license-application-cache", "writable-working-dir", "license-working-dir", "license-server-timeout", "log-disk-space-limit", "log-file", "log-file-size-limit", "log-level", "locators", "locator-wait-time", "remote-locators", "mcast-address", "mcast-port", "mcast-ttl", "mcast-send-buffer-size", "mcast-recv-buffer-size", "mcast-flow-control", "tcp-port", "socket-lease-time", "socket-buffer-size", "conserve-sockets", "name", "roles", "statistic-archive-file", "statistic-sample-rate", "statistic-sampling-enabled", "ssl-enabled", "ssl-protocols", "ssl-ciphers", "ssl-require-authentication", "cluster-ssl-enabled", "cluster-ssl-protocols", "cluster-ssl-ciphers", "cluster-ssl-require-authentication", "cluster-ssl-keystore", "cluster-ssl-keystore-type", "cluster-ssl-keystore-password", "cluster-ssl-truststore", "cluster-ssl-truststore-password", "udp-send-buffer-size", "udp-recv-buffer-size", "udp-fragment-size", "disable-tcp", "enable-time-statistics", "member-timeout", "membership-port-range", "max-wait-time-reconnect", "max-num-reconnect-tries", "async-distribution-timeout", "async-queue-timeout", "async-max-queue-size", "start-locator", "conflate-events", "durable-client-id", "durable-client-timeout", "enable-network-partition-detection", "disable-auto-reconnect", "security-client-auth-init", "security-client-authenticator", "security-client-dhalgo", "security-peer-auth-init", "security-peer-authenticator", "security-client-accessor", "security-client-accessor-pp", "security-log-level", "security-log-file", "security-peer-verifymember-timeout", "security-", "remove-unresponsive-client", "delta-propagation", "distributed-system-id", "enforce-unique-host", "redundancy-zone", "groups", "jmx-manager", "jmx-manager-start", "jmx-manager-port", "jmx-manager-ssl", "jmx-manager-ssl-enabled", "jmx-manager-ssl-protocols", "jmx-manager-ssl-ciphers", "jmx-manager-ssl-require-authentication", "jmx-manager-ssl-keystore", "jmx-manager-ssl-keystore-type", "jmx-manager-ssl-keystore-password", "jmx-manager-ssl-truststore", "jmx-manager-ssl-truststore-password", "jmx-manager-bind-address", "jmx-manager-hostname-for-clients", "jmx-manager-password-file", "jmx-manager-access-file", "jmx-manager-http-port", "jmx-manager-update-rate", "memcached-port", "memcached-protocol", "memcached-bind-address", "user-command-packages", "enable-cluster-configuration", "use-cluster-configuration", "load-cluster-configuration-from-dir", "cluster-configuration-dir", "http-service-port", "http-service-bind-address", "start-dev-rest-api", "server-ssl-enabled", "server-ssl-require-authentication", "server-ssl-protocols", "server-ssl-ciphers", "server-ssl-keystore", "server-ssl-keystore-type", "server-ssl-keystore-password", "server-ssl-truststore", "server-ssl-truststore-password", "gateway-ssl-enabled", "gateway-ssl-require-authentication", "gateway-ssl-protocols", "gateway-ssl-ciphers", "gateway-ssl-keystore", "gateway-ssl-keystore-type", "gateway-ssl-keystore-password", "gateway-ssl-truststore", "gateway-ssl-truststore-password", "http-service-ssl-enabled", "http-service-ssl-require-authentication", "http-service-ssl-protocols", "http-service-ssl-ciphers", "http-service-ssl-keystore", "http-service-ssl-keystore-type", "http-service-ssl-keystore-password", "http-service-ssl-truststore", "http-service-ssl-truststore-password"};
        List<String> atts = Arrays.asList(myAtts);
        Collections.sort(atts);
        dcValidAttributeNames = atts.toArray(new String[atts.size()]);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ack-wait-threshold", LocalizedStrings.AbstractDistributionConfig_DEFAULT_ACK_WAIT_THRESHOLD_0_1_2.toLocalizedString(15, 1, 1));
        m.put("archive-file-size-limit", LocalizedStrings.AbstractDistributionConfig_ARCHIVE_FILE_SIZE_LIMIT_NAME.toLocalizedString());
        m.put("ack-severe-alert-threshold", LocalizedStrings.AbstractDistributionConfig_ACK_SEVERE_ALERT_THRESHOLD_NAME.toLocalizedString("ack-wait-threshold", 0, 0, Integer.MAX_VALUE));
        m.put("archive-disk-space-limit", LocalizedStrings.AbstractDistributionConfig_ARCHIVE_DISK_SPACE_LIMIT_NAME.toLocalizedString());
        m.put("cache-xml-file", LocalizedStrings.AbstractDistributionConfig_CACHE_XML_FILE_NAME_0.toLocalizedString(DEFAULT_CACHE_XML_FILE));
        m.put("disable-tcp", LocalizedStrings.AbstractDistributionConfig_DISABLE_TCP_NAME_0.toLocalizedString(false));
        m.put("enable-time-statistics", LocalizedStrings.AbstractDistributionConfig_ENABLE_TIME_STATISTICS_NAME.toLocalizedString());
        m.put("deploy-working-dir", LocalizedStrings.AbstractDistributionConfig_DEPLOY_WORKING_DIR_0.toLocalizedString(DEFAULT_DEPLOY_WORKING_DIR));
        m.put("license-data-management", LocalizedStrings.AbstractDistributionConfig_LICENSE_DATA_MANAGEMENT_0.toLocalizedString(""));
        m.put("license-application-cache", LocalizedStrings.AbstractDistributionConfig_LICENSE_APPLICATION_CACHE_0.toLocalizedString(""));
        m.put("license-working-dir", LocalizedStrings.AbstractDistributionConfig_LICENSE_WORKING_DIR_0.toLocalizedString(DEFAULT_LICENSE_WORKING_DIR));
        m.put("writable-working-dir", LocalizedStrings.AbstractDistributionConfig_LICENSE_WORKING_DIR_0.toLocalizedString(DEFAULT_LICENSE_WORKING_DIR));
        m.put("license-server-timeout", LocalizedStrings.AbstractDistributionConfig_LICENSE_SERVER_TIMEOUT_0.toLocalizedString(10000));
        m.put("log-file", LocalizedStrings.AbstractDistributionConfig_LOG_FILE_NAME_0.toLocalizedString(DEFAULT_LOG_FILE));
        m.put("log-level", LocalizedStrings.AbstractDistributionConfig_LOG_LEVEL_NAME_0_1.toLocalizedString(LogWriterImpl.levelToString(700), LogWriterImpl.allowedLogLevels()));
        m.put("log-file-size-limit", LocalizedStrings.AbstractDistributionConfig_LOG_FILE_SIZE_LIMIT_NAME.toLocalizedString());
        m.put("log-disk-space-limit", LocalizedStrings.AbstractDistributionConfig_LOG_DISK_SPACE_LIMIT_NAME.toLocalizedString());
        m.put("locators", LocalizedStrings.AbstractDistributionConfig_LOCATORS_NAME_0.toLocalizedString(""));
        m.put("locator-wait-time", LocalizedStrings.AbstractDistributionConfig_LOCATOR_WAIT_TIME_NAME_0.toLocalizedString(0));
        m.put("tcp-port", LocalizedStrings.AbstractDistributionConfig_TCP_PORT_NAME_0_1_2.toLocalizedString(0, 0, 65535));
        m.put("mcast-port", LocalizedStrings.AbstractDistributionConfig_MCAST_PORT_NAME_0_1_2.toLocalizedString(10334, 0, 65535));
        m.put("mcast-address", LocalizedStrings.AbstractDistributionConfig_MCAST_ADDRESS_NAME_0_1.toLocalizedString(10334, DEFAULT_MCAST_ADDRESS));
        m.put("mcast-ttl", LocalizedStrings.AbstractDistributionConfig_MCAST_TTL_NAME_0_1_2.toLocalizedString(32, 0, 255));
        m.put("mcast-send-buffer-size", LocalizedStrings.AbstractDistributionConfig_MCAST_SEND_BUFFER_SIZE_NAME_0.toLocalizedString(65535));
        m.put("mcast-recv-buffer-size", LocalizedStrings.AbstractDistributionConfig_MCAST_RECV_BUFFER_SIZE_NAME_0.toLocalizedString(0x100000));
        m.put("mcast-flow-control", LocalizedStrings.AbstractDistributionConfig_MCAST_FLOW_CONTROL_NAME_0.toLocalizedString(DEFAULT_MCAST_FLOW_CONTROL));
        m.put("member-timeout", LocalizedStrings.AbstractDistributionConfig_MEMBER_TIMEOUT_NAME_0.toLocalizedString(5000));
        int[] range = DEFAULT_MEMBERSHIP_PORT_RANGE;
        String srange = range == null ? "not available" : "" + range[0] + "-" + range[1];
        String msg = LocalizedStrings.AbstractDistributionConfig_MEMBERSHIP_PORT_RANGE_NAME_0.toLocalizedString(srange);
        m.put("membership-port-range", msg);
        m.put("udp-send-buffer-size", LocalizedStrings.AbstractDistributionConfig_UDP_SEND_BUFFER_SIZE_NAME_0.toLocalizedString(65535));
        m.put("udp-recv-buffer-size", LocalizedStrings.AbstractDistributionConfig_UDP_RECV_BUFFER_SIZE_NAME_0.toLocalizedString(0x100000));
        m.put("udp-fragment-size", LocalizedStrings.AbstractDistributionConfig_UDP_FRAGMENT_SIZE_NAME_0.toLocalizedString(60000));
        m.put("socket-lease-time", LocalizedStrings.AbstractDistributionConfig_SOCKET_LEASE_TIME_NAME_0_1_2.toLocalizedString(60000, 0, 600000));
        m.put("socket-buffer-size", LocalizedStrings.AbstractDistributionConfig_SOCKET_BUFFER_SIZE_NAME_0_1_2.toLocalizedString(32768, 1024, 0xFFFFFF));
        m.put("conserve-sockets", LocalizedStrings.AbstractDistributionConfig_CONSERVE_SOCKETS_NAME_0.toLocalizedString(true));
        m.put("roles", LocalizedStrings.AbstractDistributionConfig_ROLES_NAME_0.toLocalizedString(""));
        m.put("bind-address", LocalizedStrings.AbstractDistributionConfig_BIND_ADDRESS_NAME_0.toLocalizedString(""));
        m.put("server-bind-address", LocalizedStrings.AbstractDistributionConfig_SERVER_BIND_ADDRESS_NAME_0.toLocalizedString(""));
        m.put("name", "A name that uniquely identifies a member in its distributed system. Multiple members in the same distributed system can not have the same name. Defaults to \"\".");
        m.put("statistic-archive-file", LocalizedStrings.AbstractDistributionConfig_STATISTIC_ARCHIVE_FILE_NAME_0.toLocalizedString(DEFAULT_STATISTIC_ARCHIVE_FILE));
        m.put("statistic-sample-rate", LocalizedStrings.AbstractDistributionConfig_STATISTIC_SAMPLE_RATE_NAME_0_1_2.toLocalizedString(1000, 100, 60000));
        m.put("statistic-sampling-enabled", LocalizedStrings.AbstractDistributionConfig_STATISTIC_SAMPLING_ENABLED_NAME_0.toLocalizedString(true));
        m.put("ssl-enabled", LocalizedStrings.AbstractDistributionConfig_SSL_ENABLED_NAME_0.toLocalizedString(false));
        m.put("ssl-protocols", LocalizedStrings.AbstractDistributionConfig_SSL_PROTOCOLS_NAME_0.toLocalizedString("any"));
        m.put("ssl-ciphers", LocalizedStrings.AbstractDistributionConfig_SSL_CIPHERS_NAME_0.toLocalizedString("any"));
        m.put("ssl-require-authentication", LocalizedStrings.AbstractDistributionConfig_SSL_REQUIRE_AUTHENTICATION_NAME.toLocalizedString(true));
        m.put("cluster-ssl-enabled", LocalizedStrings.AbstractDistributionConfig_SSL_ENABLED_NAME_0.toLocalizedString(false));
        m.put("cluster-ssl-protocols", LocalizedStrings.AbstractDistributionConfig_SSL_PROTOCOLS_NAME_0.toLocalizedString("any"));
        m.put("cluster-ssl-ciphers", LocalizedStrings.AbstractDistributionConfig_SSL_CIPHERS_NAME_0.toLocalizedString("any"));
        m.put("cluster-ssl-require-authentication", LocalizedStrings.AbstractDistributionConfig_SSL_REQUIRE_AUTHENTICATION_NAME.toLocalizedString(true));
        m.put("cluster-ssl-keystore", "Location of the Java keystore file containing an distributed member's own certificate and private key.");
        m.put("cluster-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("cluster-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("cluster-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by distributed member (trust store).");
        m.put("cluster-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("max-wait-time-reconnect", LocalizedStrings.AbstractDistributionConfig_MAX_WAIT_TIME_FOR_RECONNECT.toLocalizedString());
        m.put("max-num-reconnect-tries", LocalizedStrings.AbstractDistributionConfig_MAX_NUM_RECONNECT_TRIES.toLocalizedString());
        m.put("async-distribution-timeout", LocalizedStrings.AbstractDistributionConfig_ASYNC_DISTRIBUTION_TIMEOUT_NAME_0_1_2.toLocalizedString(0, 0, 60000));
        m.put("async-queue-timeout", LocalizedStrings.AbstractDistributionConfig_ASYNC_QUEUE_TIMEOUT_NAME_0_1_2.toLocalizedString(60000, 0, 86400000));
        m.put("async-max-queue-size", LocalizedStrings.AbstractDistributionConfig_ASYNC_MAX_QUEUE_SIZE_NAME_0_1_2.toLocalizedString(8, 0, 1024));
        m.put("start-locator", LocalizedStrings.AbstractDistributionConfig_START_LOCATOR_NAME.toLocalizedString());
        m.put("durable-client-id", LocalizedStrings.AbstractDistributionConfig_DURABLE_CLIENT_ID_NAME_0.toLocalizedString(""));
        m.put("conflate-events", LocalizedStrings.AbstractDistributionConfig_CLIENT_CONFLATION_PROP_NAME.toLocalizedString());
        m.put("durable-client-timeout", LocalizedStrings.AbstractDistributionConfig_DURABLE_CLIENT_TIMEOUT_NAME_0.toLocalizedString(300));
        m.put("security-client-auth-init", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_AUTH_INIT_NAME_0.toLocalizedString(""));
        m.put("enable-network-partition-detection", "Whether network partitioning detection is enabled");
        m.put("disable-auto-reconnect", "Whether auto reconnect is attempted after a network partition");
        m.put("security-client-authenticator", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_AUTHENTICATOR_NAME_0.toLocalizedString(""));
        m.put("security-client-dhalgo", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_DHALGO_NAME_0.toLocalizedString(""));
        m.put("security-peer-auth-init", LocalizedStrings.AbstractDistributionConfig_SECURITY_PEER_AUTH_INIT_NAME_0.toLocalizedString(""));
        m.put("security-peer-authenticator", LocalizedStrings.AbstractDistributionConfig_SECURITY_PEER_AUTHENTICATOR_NAME_0.toLocalizedString(""));
        m.put("security-client-accessor", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_ACCESSOR_NAME_0.toLocalizedString(""));
        m.put("security-client-accessor-pp", LocalizedStrings.AbstractDistributionConfig_SECURITY_CLIENT_ACCESSOR_PP_NAME_0.toLocalizedString(""));
        m.put("security-log-level", LocalizedStrings.AbstractDistributionConfig_SECURITY_LOG_LEVEL_NAME_0_1.toLocalizedString(LogWriterImpl.levelToString(700), LogWriterImpl.allowedLogLevels()));
        m.put("security-log-file", LocalizedStrings.AbstractDistributionConfig_SECURITY_LOG_FILE_NAME_0.toLocalizedString(DEFAULT_SECURITY_LOG_FILE));
        m.put("security-peer-verifymember-timeout", LocalizedStrings.AbstractDistributionConfig_SECURITY_PEER_VERIFYMEMBER_TIMEOUT_NAME_0.toLocalizedString(1000));
        m.put("security-", LocalizedStrings.AbstractDistributionConfig_SECURITY_PREFIX_NAME.toLocalizedString());
        m.put("custom-", LocalizedStrings.AbstractDistributionConfig_USERDEFINED_PREFIX_NAME.toLocalizedString());
        m.put("remove-unresponsive-client", LocalizedStrings.AbstractDistributionConfig_REMOVE_UNRESPONSIVE_CLIENT_PROP_NAME_0.toLocalizedString(false));
        m.put("delta-propagation", "Whether delta propagation is enabled");
        m.put("remote-locators", LocalizedStrings.AbstractDistributionConfig_REMOTE_DISTRIBUTED_SYSTEMS_NAME_0.toLocalizedString(""));
        m.put("distributed-system-id", "An id that uniquely idenitifies this distributed system. Required when using portable data exchange objects and the WAN.Must be the same on each member in this distributed system if set.");
        m.put("enforce-unique-host", "Whether to require partitioned regions to put redundant copies of data on different physical machines");
        m.put("redundancy-zone", "The zone that this member is in. When this is set, partitioned regions will not put two copies of the same data in the same zone.");
        m.put("groups", "A comma separated list of all the groups this member belongs to. Defaults to \"\".");
        m.put("user-command-packages", "A comma separated list of the names of the packages containing classes that implement user commands.");
        m.put("jmx-manager", "If true then this member is willing to be a jmx manager. Defaults to false except on a locator.");
        m.put("jmx-manager-start", "If true then the jmx manager will be started when the cache is created. Defaults to false.");
        m.put("jmx-manager-ssl", "If true then the jmx manager will only allow SSL clients to connect. Defaults to false. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-ssl-enabled", "If true then the jmx manager will only allow SSL clients to connect. Defaults to false. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for JMX Manager. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("jmx-manager-ssl-protocols", "List of available SSL protocols that are to be enabled for JMX Manager. Defaults to \"any\" meaning defaults of your provider.");
        m.put("jmx-manager-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous JMX Clients are allowed. Defaults to \"true\".");
        m.put("jmx-manager-ssl-keystore", "Location of the Java keystore file containing jmx manager's own certificate and private key.");
        m.put("jmx-manager-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("jmx-manager-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore. ");
        m.put("jmx-manager-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by jmx manager.");
        m.put("jmx-manager-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("jmx-manager-port", "The port the jmx manager will listen on. Default is \"1099\". Set to zero to disable GemFire's creation of a jmx listening port.");
        m.put("jmx-manager-bind-address", "The address the jmx manager will listen on for remote connections. Default is \"\" which causes the jmx manager to listen on the host's default address. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-hostname-for-clients", "The hostname that will be given to clients when they ask a locator for the location of this jmx manager. Default is \"\" which causes the locator to report the jmx manager's actual ip address as its location. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-password-file", "The name of the file the jmx manager will use to only allow authenticated clients to connect. Default is \"\" which causes the jmx manager to allow all clients to connect. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-access-file", "The name of the file the jmx manager will use to define the access level of authenticated clients. Default is \"\" which causes the jmx manager to allow all clients all access. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-http-port", "By default when a jmx-manager is started it will also start an http server on this port. This server is used by the GemFire Pulse application. Setting this property to zero disables the http server. It defaults to 8080. Ignored if jmx-manager is false.");
        m.put("jmx-manager-update-rate", "The rate in milliseconds at which this member will send updates to each jmx manager. Default is 2000. Values must be in the range 1000..300000.");
        m.put("memcached-port", "The port GemFireMemcachedServer will listen on. Default is 0. Set to zero to disable GemFireMemcachedServer.");
        m.put("memcached-protocol", "The protocol that GemFireMemcachedServer understands. Default is ASCII. Values may be ASCII or BINARY");
        m.put("memcached-bind-address", "The address the GemFireMemcachedServer will listen on for remote connections. Default is \"\" which causes the GemFireMemcachedServer to listen on the host's default address. This property is ignored if memcached-port is \"0\".");
        m.put("enable-cluster-configuration", LocalizedStrings.AbstractDistributionConfig_ENABLE_SHARED_CONFIGURATION.toLocalizedString());
        m.put("use-cluster-configuration", LocalizedStrings.AbstractDistributionConfig_USE_SHARED_CONFIGURATION.toLocalizedString());
        m.put("load-cluster-configuration-from-dir", LocalizedStrings.AbstractDistributionConfig_LOAD_SHARED_CONFIGURATION_FROM_DIR.toLocalizedString("cluster_config"));
        m.put("cluster-configuration-dir", LocalizedStrings.AbstractDistributionConfig_CLUSTER_CONFIGURATION_DIR.toLocalizedString());
        m.put("server-ssl-enabled", "If true then the cache server will only allow SSL clients to connect. Defaults to false.");
        m.put("server-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for CacheServer. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("server-ssl-protocols", "List of available SSL protocols that are to be enabled for CacheServer. Defaults to \"any\" meaning defaults of your provider.");
        m.put("server-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous Clients are allowed. Defaults to \"true\".");
        m.put("server-ssl-keystore", "Location of the Java keystore file containing server's or client's own certificate and private key.");
        m.put("server-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("server-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore. ");
        m.put("server-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by server or client(trust store).");
        m.put("server-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("gateway-ssl-enabled", "If true then the gateway receiver will only allow SSL gateway sender to connect. Defaults to false.");
        m.put("gateway-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for Gateway Receiver. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("gateway-ssl-protocols", "List of available SSL protocols that are to be enabled for Gateway Receiver. Defaults to \"any\" meaning defaults of your provider.");
        m.put("gateway-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous gateway senders are allowed. Defaults to \"true\".");
        m.put("gateway-ssl-keystore", "Location of the Java keystore file containing gateway's own certificate and private key.");
        m.put("gateway-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("gateway-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("gateway-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by gateway.");
        m.put("gateway-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("http-service-port", "If non zero, then the gemfire developer REST service will be deployed and started when the cache is created. Default value is 0.");
        m.put("http-service-bind-address", "The address where gemfire developer REST service will listen for remote REST connections. Default is \"\" which causes the Rest service to listen on the host's default address.");
        m.put("http-service-ssl-enabled", "If true then the http service like REST dev api and Pulse will only allow SSL enabled clients to connect. Defaults to false.");
        m.put("http-service-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for Http Service. Defaults to \"any\" meaning your provider''s defaults.");
        m.put("http-service-ssl-protocols", "List of available SSL protocols that are to be enabled for Http Service. Defaults to \"any\" meaning defaults of your provider.");
        m.put("http-service-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous http clients are allowed. Defaults to \"false\".");
        m.put("http-service-ssl-keystore", "Location of the Java keystore file containing Http Service's own certificate and private key.");
        m.put("http-service-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("http-service-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("http-service-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by Http Service.");
        m.put("http-service-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("start-dev-rest-api", "If true then the developer(API) REST service will be started when the cache is created. Defaults to false.");
        dcAttDescriptions = Collections.unmodifiableMap(m);
    }
}

