/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.IncompatibleSystemException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.ToDataException;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.AdminMessageType;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionChannel;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionMessageObserver;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.FunctionExecutionPooledExecutor;
import com.gemstone.gemfire.distributed.internal.HealthMonitor;
import com.gemstone.gemfire.distributed.internal.HealthMonitorImpl;
import com.gemstone.gemfire.distributed.internal.HighPriorityAckedMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.OverflowQueueWithDMStats;
import com.gemstone.gemfire.distributed.internal.PooledExecutorWithDMStats;
import com.gemstone.gemfire.distributed.internal.SerialQueuedExecutorWithDMStats;
import com.gemstone.gemfire.distributed.internal.ShutdownMessage;
import com.gemstone.gemfire.distributed.internal.StartupMessage;
import com.gemstone.gemfire.distributed.internal.StartupOperation;
import com.gemstone.gemfire.distributed.internal.StartupResponseMessage;
import com.gemstone.gemfire.distributed.internal.ThrottlingMemLinkedQueueWithDMStats;
import com.gemstone.gemfire.distributed.internal.locks.ElderState;
import com.gemstone.gemfire.distributed.internal.membership.DistributedMembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.distributed.internal.membership.MemberFactory;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.NetMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.SetUtils;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.admin.remote.AdminConsoleDisconnectMessage;
import com.gemstone.gemfire.internal.admin.remote.RemoteGfManagerAgent;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.sequencelog.MembershipLogger;
import com.gemstone.gemfire.internal.tcp.Connection;
import com.gemstone.gemfire.internal.tcp.ConnectionTable;
import com.gemstone.gemfire.internal.tcp.ReenteredConnectException;
import com.gemstone.gemfire.internal.tcp.Stub;
import com.gemstone.gemfire.internal.util.concurrent.StoppableReentrantLock;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;

public class DistributionManager
implements Externalizable,
DM {
    private static final Logger logger = LogService.getLogger();
    private static final boolean SYNC_EVENTS = Boolean.getBoolean("DistributionManager.syncEvents");
    public static final boolean INLINE_PROCESS = !Boolean.getBoolean("DistributionManager.enqueueOrderedMessages");
    public static final boolean MULTI_SERIAL_EXECUTORS = !Boolean.getBoolean("DistributionManager.singleSerialExecutor");
    public static final String NAME = "GemFire";
    public static final long TIMEOUT = Long.getLong("DistributionManager.TIMEOUT", -1L);
    public static final int PUSHER_THREADS = Integer.getInteger("DistributionManager.PUSHER_THREADS", 50);
    public static final int PUSHER_QUEUE_SIZE = Integer.getInteger("DistributionManager.PUSHER_QUEUE_SIZE", 4096);
    public static final int MAX_WAITING_THREADS = Integer.getInteger("DistributionManager.MAX_WAITING_THREADS", Integer.MAX_VALUE);
    public static final int MAX_PR_META_DATA_CLEANUP_THREADS = Integer.getInteger("DistributionManager.MAX_PR_META_DATA_CLEANUP_THREADS", 1);
    public static final int MAX_THREADS = Integer.getInteger("DistributionManager.MAX_THREADS", 100);
    public static final int MAX_PR_THREADS = Integer.getInteger("DistributionManager.MAX_PR_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));
    public static final int MAX_FE_THREADS = Integer.getInteger("DistributionManager.MAX_FE_THREADS", Math.max(Runtime.getRuntime().availableProcessors() * 4, 16));
    public static final int INCOMING_QUEUE_LIMIT = Integer.getInteger("DistributionManager.INCOMING_QUEUE_LIMIT", 80000);
    public static final int INCOMING_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.INCOMING_QUEUE_THROTTLE", (int)((double)INCOMING_QUEUE_LIMIT * 0.75));
    public static final double THROTTLE_PERCENT = (double)Integer.getInteger("DistributionManager.SERIAL_QUEUE_THROTTLE_PERCENT", 75).intValue() / 100.0;
    public static final int SERIAL_QUEUE_BYTE_LIMIT = Integer.getInteger("DistributionManager.SERIAL_QUEUE_BYTE_LIMIT", 0x2800000);
    public static final int SERIAL_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.SERIAL_QUEUE_THROTTLE", (int)((double)SERIAL_QUEUE_BYTE_LIMIT * THROTTLE_PERCENT));
    public static final int TOTAL_SERIAL_QUEUE_BYTE_LIMIT = Integer.getInteger("DistributionManager.TOTAL_SERIAL_QUEUE_BYTE_LIMIT", 0x5000000);
    public static final int TOTAL_SERIAL_QUEUE_THROTTLE = Integer.getInteger("DistributionManager.TOTAL_SERIAL_QUEUE_THROTTLE", (int)((double)SERIAL_QUEUE_BYTE_LIMIT * THROTTLE_PERCENT));
    public static final int SERIAL_QUEUE_SIZE_LIMIT = Integer.getInteger("DistributionManager.SERIAL_QUEUE_SIZE_LIMIT", 20000);
    public static final int SERIAL_QUEUE_SIZE_THROTTLE = Integer.getInteger("DistributionManager.SERIAL_QUEUE_SIZE_THROTTLE", (int)((double)SERIAL_QUEUE_SIZE_LIMIT * THROTTLE_PERCENT));
    public static final int MAX_SERIAL_QUEUE_THREAD = Integer.getInteger("DistributionManager.MAX_SERIAL_QUEUE_THREAD", 20);
    public static volatile boolean INCLUDE_LINK_LOCAL_ADDRESSES = Boolean.getBoolean("gemfire.IncludeLinkLocalAddresses");
    public static final int NORMAL_DM_TYPE = 10;
    public static final int LOCATOR_DM_TYPE = 11;
    public static final int ADMIN_ONLY_DM_TYPE = 12;
    public static final int LONER_DM_TYPE = 13;
    public static final int STANDARD_EXECUTOR = 73;
    public static final int SERIAL_EXECUTOR = 74;
    public static final int HIGH_PRIORITY_EXECUTOR = 75;
    public static final int WAITING_POOL_EXECUTOR = 77;
    public static final int PARTITIONED_REGION_EXECUTOR = 78;
    public static final int VIEW_EXECUTOR = 79;
    public static final int REGION_FUNCTION_EXECUTION_EXECUTOR = 80;
    private static int openDMs = 0;
    public static volatile boolean isDedicatedAdminVM = false;
    public static volatile boolean isCommandLineAdminVM = false;
    protected final InternalDistributedMember myid;
    private final int dmType;
    private final ConcurrentMap membershipListeners;
    protected final Object membershipListenersLock = new MembershipListenersLock();
    protected volatile Set allMembershipListeners = Collections.EMPTY_SET;
    protected final Object allMembershipListenersLock = new MembershipListenersLock();
    protected final BlockingQueue membershipEventQueue = new LinkedBlockingQueue();
    private Thread memberEventThread;
    protected final String description;
    protected DistributionStats stats;
    protected boolean exceptionInThreads;
    static ThreadLocal isStartupThread = new ThreadLocal();
    private static InheritableThreadLocal distributionManagerType = new InheritableThreadLocal();
    protected volatile boolean shutdownMsgSent = false;
    protected volatile boolean closeInProgress = false;
    private volatile boolean receivedStartupResponse = false;
    private volatile String rejectionMessage = null;
    protected MembershipManager membershipManager;
    protected DistributionChannel channel;
    private Map<InternalDistributedMember, InternalDistributedMember> members = Collections.emptyMap();
    private Set membersAndAdmin = Collections.emptySet();
    private Map<InternalDistributedMember, Collection<String>> hostedLocatorsAll = Collections.emptyMap();
    private Map<InternalDistributedMember, Collection<String>> hostedLocatorsWithSharedConfiguration = Collections.emptyMap();
    public static final String DEFAULT_VERSION_PRE_6_6_2 = "6.6.0.0";
    private final Object membersLock = new MembersLock();
    private final Object adminConsolesLock = new Object();
    private volatile Set<InternalDistributedMember> adminConsoles = Collections.emptySet();
    protected LoggingThreadGroup threadGroup;
    private ThreadPoolExecutor threadPool;
    private ThreadPoolExecutor highPriorityPool;
    private ThreadPoolExecutor waitingPool;
    private ThreadPoolExecutor prMetaDataCleanupThreadPool;
    private ThreadPoolExecutor partitionedRegionThread;
    private ThreadPoolExecutor partitionedRegionPool;
    private ThreadPoolExecutor functionExecutionThread;
    private ThreadPoolExecutor functionExecutionPool;
    private ThreadPoolExecutor serialThread;
    private ThreadPoolExecutor viewThread;
    private ThrottlingMemLinkedQueueWithDMStats serialQueue;
    protected volatile boolean readyForMessages = false;
    private volatile boolean readyToSendMsgs = false;
    private final Object readyToSendMsgsLock = new Object();
    protected volatile boolean closed = false;
    private InternalDistributedSystem system;
    private RemoteTransportConfig transport;
    private volatile RemoteGfManagerAgent agent;
    private SerialQueuedExecutorPool serialQueuedExecutorPool;
    private final Semaphore parallelGIIs = new Semaphore(InitialImageOperation.MAX_PARALLEL_GIIS);
    private final HashMap<InetAddress, Set<InetAddress>> equivalentHosts = new HashMap();
    private int distributedSystemId = -1;
    private final Map<InternalDistributedMember, String> redundancyZones = Collections.synchronizedMap(new HashMap());
    private boolean enforceUniqueZone = false;
    private volatile boolean isSharedConfigEnabledForDS = false;
    public static final InheritableThreadLocal<Boolean> isFunctionExecutionThread = new InheritableThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    volatile Throwable rootCause = null;
    private final Stopper stopper = new Stopper(this);
    private final Object shutdownMutex = new Object();
    private static final int MAX_STOP_TIME = 20000;
    private static final int STOP_PAUSE_TIME = 1000;
    private static final int MAX_STOP_ATTEMPTS = 10;
    private volatile boolean shutdownInProgress = false;
    private final Object membershipViewIdGuard = new Object();
    private long membershipViewIdAcknowledged;
    private static final int STARTUP_TIMEOUT = Integer.getInteger("DistributionManager.STARTUP_TIMEOUT", 15000);
    public static final boolean DEBUG_NO_ACKNOWLEDGEMENTS = Boolean.getBoolean("DistributionManager.DEBUG_NO_ACKNOWLEDGEMENTS");
    private Set unfinishedStartups = null;
    private final Object unfinishedStartupsLock = new Object();
    protected final Object elderMonitor = new Object();
    private boolean waitingForElderChange = false;
    private boolean adam = false;
    protected volatile InternalDistributedMember elder = null;
    private final StoppableReentrantLock elderLock;
    private ElderState elderState;
    private volatile boolean elderStateInitialized;
    private final ConcurrentMap hmMap = new ConcurrentHashMap();

    @Override
    public boolean isSharedConfigurationServiceEnabledForDS() {
        return this.isSharedConfigEnabledForDS;
    }

    protected static void setDistributionManagerType(int vmType) {
        switch (vmType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                distributionManagerType.set(vmType);
                break;
            }
            default: {
                throw new IllegalArgumentException(LocalizedStrings.DistributionManager_UNKNOWN_DISTRIBUTIONMANAGERTYPE_0.toLocalizedString(vmType));
            }
        }
    }

    public static int getDistributionManagerType() {
        Integer vmType = (Integer)distributionManagerType.get();
        if (vmType == null) {
            return 0;
        }
        return vmType;
    }

    public static boolean isSameHost(InternalDistributedMember id1, InternalDistributedMember id2) {
        return id1.getIpAddress().equals(id2.getIpAddress());
    }

    public static DistributionManager create(InternalDistributedSystem system) {
        DistributionManager dm = null;
        try {
            if (Boolean.getBoolean("Locator.forceLocatorDMType")) {
                DistributionManager.setDistributionManagerType(11);
            } else if (isDedicatedAdminVM) {
                DistributionManager.setDistributionManagerType(12);
            } else {
                DistributionManager.setDistributionManagerType(10);
            }
            RemoteTransportConfig transport = new RemoteTransportConfig(system.getConfig());
            transport.setIsReconnectingDS(system.isReconnectingDS());
            transport.setOldDSMembershipInfo(system.oldDSMembershipInfo());
            long start = System.currentTimeMillis();
            dm = new DistributionManager(system, transport);
            dm.assertDistributionManagerType();
            InternalDistributedMember id = dm.getDistributionManagerId();
            if (!"".equals(id.getName())) {
                InternalDistributedMember m;
                Iterator i$ = dm.getViewMembers().iterator();
                while (i$.hasNext() && !(m = (InternalDistributedMember)i$.next()).equals(id)) {
                    if (!id.getName().equals(m.getName()) || !dm.getMembershipManager().verifyMember(m, "member is using the name of " + id)) continue;
                    throw new IncompatibleSystemException("Member " + id + " could not join this distributed system because the existing member " + m + " used the same name. Set the \"name\" gemfire property to a unique value.");
                }
            }
            dm.addNewMember(id, null);
            dm.selectElder();
            StartupOperation op = new StartupOperation(dm, transport);
            try {
                if (!dm.sendStartupMessage(op, true)) {
                    if (dm.getOtherDistributionManagerIds().size() == 0) {
                        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_DIDNT_HEAR_BACK_FROM_ANY_OTHER_SYSTEM_I_AM_THE_FIRST_ONE));
                    } else if (transport.isMcastEnabled() && !dm.testMulticast()) {
                        logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_RECEIVED_NO_STARTUP_RESPONSES_BUT_OTHER_MEMBERS_EXIST_MULTICAST_IS_NOT_RESPONSIVE));
                    }
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new InternalGemFireException(LocalizedStrings.DistributionManager_INTERRUPTED_WHILE_WAITING_FOR_FIRST_STARTUPRESPONSEMESSAGE.toLocalizedString(), ex);
            }
            catch (IncompatibleSystemException ex) {
                logger.fatal(ex.getMessage(), (Throwable)ex);
                throw ex;
            }
            finally {
                dm.readyToSendMsgs();
            }
            if (logger.isInfoEnabled()) {
                long delta = System.currentTimeMillis() - start;
                Object[] objectArray = new Object[6];
                objectArray[0] = dm.getDistributionManagerId();
                objectArray[1] = transport;
                objectArray[2] = dm.getOtherDistributionManagerIds().size();
                objectArray[3] = dm.getOtherDistributionManagerIds();
                Object object = objectArray[4] = logger.isInfoEnabled(LogMarker.DM) ? " (VERBOSE, took " + delta + " ms)" : "";
                objectArray[5] = dm.getDMType() == 12 ? " (admin only)" : (dm.getDMType() == 11 ? " (locator)" : "");
                Object[] logArgs = objectArray;
                logger.info(LogMarker.DM, LocalizedMessage.create(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGER_0_STARTED_ON_1_THERE_WERE_2_OTHER_DMS_3_4_5, logArgs));
                MembershipLogger.logStartup(dm.getDistributionManagerId());
            }
            return dm;
        }
        catch (RuntimeException r) {
            if (dm != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("cleaning up incompletely started DistributionManager due to exception", (Throwable)r);
                }
                super.uncleanShutdown(true);
            }
            throw r;
        }
    }

    void runUntilShutdown(Runnable r) {
        try {
            r.run();
        }
        catch (CancelException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Caught shutdown exception", (Throwable)e);
            }
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            if (this.closeInProgress) {
                logger.debug("Caught unusual exception during shutdown: {}", t.getMessage(), t);
            }
            logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_TASK_FAILED_WITH_EXCEPTION), t);
        }
    }

    @Override
    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    public DistributionManager() {
        this.elderLock = null;
        this.membershipListeners = null;
        this.myid = null;
        this.description = null;
        this.dmType = 0;
        throw new IllegalAccessError("this constructor should never be invoked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributionManager(RemoteTransportConfig transport, InternalDistributedSystem system) {
        LoggingThreadGroup group;
        this.dmType = DistributionManager.getDistributionManagerType();
        this.system = system;
        this.elderLock = new StoppableReentrantLock(this.stopper);
        this.transport = transport;
        this.membershipListeners = new ConcurrentHashMap();
        this.distributedSystemId = system.getConfig().getDistributedSystemId();
        long statId = OSProcess.getId();
        this.stats = new DistributionStats(system, statId);
        DistributionStats.enableClockStats = system.getConfig().getEnableTimeStatistics();
        this.exceptionInThreads = false;
        this.threadGroup = group = LoggingThreadGroup.createThreadGroup("DistributionManager Threads", logger);
        boolean finishedConstructor = false;
        try {
            OverflowQueueWithDMStats poolQueue;
            if (MULTI_SERIAL_EXECUTORS) {
                if (logger.isInfoEnabled(LogMarker.DM)) {
                    logger.info(LogMarker.DM, "Serial Queue info : THROTTLE_PERCENT: " + THROTTLE_PERCENT + " SERIAL_QUEUE_BYTE_LIMIT :" + SERIAL_QUEUE_BYTE_LIMIT + " SERIAL_QUEUE_THROTTLE :" + SERIAL_QUEUE_THROTTLE + " TOTAL_SERIAL_QUEUE_BYTE_LIMIT :" + TOTAL_SERIAL_QUEUE_BYTE_LIMIT + " TOTAL_SERIAL_QUEUE_THROTTLE :" + TOTAL_SERIAL_QUEUE_THROTTLE + " SERIAL_QUEUE_SIZE_LIMIT :" + SERIAL_QUEUE_SIZE_LIMIT + " SERIAL_QUEUE_SIZE_THROTTLE :" + SERIAL_QUEUE_SIZE_THROTTLE);
                }
                this.serialQueuedExecutorPool = new SerialQueuedExecutorPool(this.threadGroup, this.stats);
            }
            if (SERIAL_QUEUE_BYTE_LIMIT == 0) {
                poolQueue = new OverflowQueueWithDMStats(this.stats.getSerialQueueHelper());
            } else {
                this.serialQueue = new ThrottlingMemLinkedQueueWithDMStats(TOTAL_SERIAL_QUEUE_BYTE_LIMIT, TOTAL_SERIAL_QUEUE_THROTTLE, SERIAL_QUEUE_SIZE_LIMIT, SERIAL_QUEUE_SIZE_THROTTLE, this.stats.getSerialQueueHelper());
                poolQueue = this.serialQueue;
            }
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incSerialThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incNumSerialThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incNumSerialThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_SERIAL_MESSAGE_PROCESSOR.toLocalizedString());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            SerialQueuedExecutorWithDMStats executor = new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getSerialProcessorHelper(), tf);
            this.serialThread = executor;
            LinkedBlockingQueue q = new LinkedBlockingQueue();
            tf = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incViewThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incNumViewThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incNumViewThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_VIEW_MESSAGE_PROCESSOR.toLocalizedString());
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.viewThread = new SerialQueuedExecutorWithDMStats(q, this.stats.getViewProcessorHelper(), tf);
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getOverflowQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getOverflowQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incProcessingThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incNumProcessingThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incNumProcessingThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_POOLED_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            PooledExecutorWithDMStats pool = new PooledExecutorWithDMStats(poolQueue, MAX_THREADS, this.stats.getNormalPoolHelper(), tf);
            this.threadPool = pool;
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getHighPriorityQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getHighPriorityQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incHighPriorityThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incHighPriorityThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incHighPriorityThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_POOLED_HIGH_PRIORITY_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            this.highPriorityPool = new PooledExecutorWithDMStats(poolQueue, MAX_THREADS, this.stats.getHighPriorityPoolHelper(), tf);
            ThreadFactory tf2 = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incWaitingThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incWaitingThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incWaitingThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_POOLED_WAITING_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            AbstractQueue poolQueue2 = MAX_WAITING_THREADS == Integer.MAX_VALUE ? new SynchronousQueue() : new OverflowQueueWithDMStats(this.stats.getWaitingQueueHelper());
            this.waitingPool = new PooledExecutorWithDMStats((BlockingQueue<Runnable>)((Object)poolQueue2), MAX_WAITING_THREADS, this.stats.getWaitingPoolHelper(), tf2);
            tf2 = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incWaitingThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incWaitingThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incWaitingThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, LocalizedStrings.DistributionManager_PR_META_DATA_CLEANUP_MESSAGE_PROCESSOR.toLocalizedString() + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            poolQueue2 = new OverflowQueueWithDMStats(this.stats.getWaitingQueueHelper());
            this.prMetaDataCleanupThreadPool = new PooledExecutorWithDMStats((BlockingQueue<Runnable>)((Object)poolQueue2), MAX_PR_META_DATA_CLEANUP_THREADS, this.stats.getWaitingPoolHelper(), tf2);
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getPartitionedRegionQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getPartitionedRegionQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incPartitionedRegionThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incPartitionedRegionThreads(1);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incPartitionedRegionThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, "PartitionedRegion Message Processor" + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            if (MAX_PR_THREADS > 1) {
                this.partitionedRegionPool = new PooledExecutorWithDMStats(poolQueue, MAX_PR_THREADS, this.stats.getPartitionedRegionPoolHelper(), tf);
            } else {
                executor = new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getPartitionedRegionPoolHelper(), tf);
                this.partitionedRegionThread = executor;
            }
            poolQueue = INCOMING_QUEUE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getFunctionExecutionQueueHelper()) : new OverflowQueueWithDMStats(INCOMING_QUEUE_LIMIT, this.stats.getFunctionExecutionQueueHelper());
            tf = new ThreadFactory(){
                private int next = 0;

                @Override
                public Thread newThread(final Runnable command) {
                    DistributionManager.this.stats.incFunctionExecutionThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DistributionManager.this.stats.incFunctionExecutionThreads(1);
                            isFunctionExecutionThread.set(Boolean.TRUE);
                            try {
                                ConnectionTable.threadWantsSharedResources();
                                Connection.makeReaderThread();
                                DistributionManager.this.runUntilShutdown(command);
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                                DistributionManager.this.stats.incFunctionExecutionThreads(-1);
                            }
                        }
                    };
                    Thread thread = new Thread(group, r, "Function Execution Processor" + this.next++);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            if (MAX_FE_THREADS > 1) {
                this.functionExecutionPool = new FunctionExecutionPooledExecutor(poolQueue, MAX_FE_THREADS, this.stats.getFunctionExecutionPoolHelper(), tf, true);
            } else {
                executor = new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getFunctionExecutionPoolHelper(), tf);
                this.functionExecutionThread = executor;
            }
            if (!SYNC_EVENTS) {
                this.memberEventThread = new Thread(group, new MemberEventInvoker(), "DM-MemberEventInvoker");
                this.memberEventThread.setDaemon(true);
            }
            StringBuffer sb = new StringBuffer(" (took ");
            long start = System.currentTimeMillis();
            DistributionConfig config = system.getConfig();
            String bindAddress = config.getBindAddress();
            if (bindAddress != null && !bindAddress.equals("")) {
                System.setProperty("gemfire.jg-bind-address", bindAddress);
            } else {
                System.getProperties().remove("gemfire.jg-bind-address");
            }
            start = System.currentTimeMillis();
            config = system.getConfig();
            DurableClientAttributes dac = null;
            if (config.getDurableClientId() != null) {
                dac = new DurableClientAttributes(config.getDurableClientId(), config.getDurableClientTimeout());
            }
            MemberAttributes.setDefaults(-1, OSProcess.getId(), DistributionManager.getDistributionManagerType(), -1, config.getName(), MemberAttributes.parseGroups(config.getRoles(), config.getGroups()), dac);
            MyListener l = new MyListener(this);
            this.membershipManager = MemberFactory.newMembershipManager(l, system.getConfig(), transport, this.stats);
            sb.append(System.currentTimeMillis() - start);
            sb.append("/");
            this.myid = this.membershipManager.getLocalMember();
            this.channel = new DistributionChannel(this.membershipManager);
            this.membershipManager.postConnect();
            sb.append(" ms)");
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_STARTING_DISTRIBUTIONMANAGER_0_1, new Object[]{this.myid, logger.isInfoEnabled(LogMarker.DM) ? sb.toString() : ""}));
            this.description = "GemFire on " + this.myid + " started at " + new Date(System.currentTimeMillis()).toString();
            finishedConstructor = true;
        }
        finally {
            if (!finishedConstructor) {
                this.askThreadsToStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributionManager(InternalDistributedSystem system, RemoteTransportConfig transport) {
        this(transport, system);
        boolean finishedConstructor = false;
        try {
            isStartupThread.set(Boolean.TRUE);
            this.startThreads();
            this.membershipManager.startEventProcessing();
            while (true) {
                this.getCancelCriterion().checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.membershipManager.waitForEventProcessing();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            Class<DistributionManager> clazz = DistributionManager.class;
            synchronized (DistributionManager.class) {
                ++openDMs;
                // ** MonitorExit[var4_5] (shouldn't be in output)
                finishedConstructor = true;
            }
        }
        finally {
            if (!finishedConstructor) {
                this.askThreadsToStop();
            }
        }
        {
            return;
        }
    }

    @Override
    public boolean areOnEquivalentHost(InternalDistributedMember member1, InternalDistributedMember member2) {
        Set<InetAddress> equivalents1 = this.getEquivalents(member1.getIpAddress());
        return equivalents1.contains(member2.getIpAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEquivalentHosts(Set<InetAddress> equivs) {
        Iterator<InetAddress> it = equivs.iterator();
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            while (it.hasNext()) {
                this.equivalentHosts.put(it.next(), Collections.unmodifiableSet(equivs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<InetAddress, Set<InetAddress>> getEquivalentHostsSnapshot() {
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            return new HashMap<InetAddress, Set<InetAddress>>(this.equivalentHosts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InetAddress> getEquivalents(InetAddress in) {
        Set<InetAddress> result;
        HashMap<InetAddress, Set<InetAddress>> hashMap = this.equivalentHosts;
        synchronized (hashMap) {
            result = this.equivalentHosts.get(in);
        }
        if (result == null) {
            result = Collections.singleton(in);
        }
        return result;
    }

    public void setRedundancyZone(InternalDistributedMember member, String redundancyZone) {
        if (redundancyZone != null && !redundancyZone.equals("")) {
            this.redundancyZones.put(member, redundancyZone);
        }
        if (member != this.getDistributionManagerId()) {
            String relationship = this.areInSameZone(this.getDistributionManagerId(), member) ? "" : "not ";
            Object[] logArgs = new Object[]{member, relationship};
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGER_MEMBER_0_IS_1_EQUIVALENT, logArgs));
        }
    }

    public void setEnforceUniqueZone(boolean enforceUniqueZone) {
        this.enforceUniqueZone |= enforceUniqueZone;
    }

    @Override
    public boolean enforceUniqueZone() {
        return this.enforceUniqueZone;
    }

    public String getRedundancyZone(InternalDistributedMember member) {
        return this.redundancyZones.get(member);
    }

    private void assertDistributionManagerType() {
        int theDmType = this.getDMType();
        switch (theDmType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            default: {
                Assert.assertTrue(false, "unknown distribution manager type");
            }
        }
        InternalDistributedMember theId = this.getDistributionManagerId();
        int vmKind = theId.getVmKind();
        if (theDmType != vmKind) {
            Assert.assertTrue(false, "InternalDistributedMember has a vmKind of " + vmKind + " instead of " + theDmType);
        }
    }

    public int getDMType() {
        return this.dmType;
    }

    @Override
    public Vector getViewMembers() {
        MembershipManager mgr;
        NetView result = null;
        DistributionChannel ch = this.channel;
        if (ch != null && (mgr = ch.getMembershipManager()) != null) {
            result = mgr.getView();
        }
        if (result == null) {
            result = new Vector();
        }
        return result;
    }

    @Override
    public DistributedMember getOldestMember(Collection c) throws NoSuchElementException {
        Vector view = this.getViewMembers();
        for (int i = 0; i < view.size(); ++i) {
            Object viewMbr = view.get(i);
            for (Object nextMbr : c) {
                if (!viewMbr.equals(nextMbr)) continue;
                return (DistributedMember)nextMbr;
            }
        }
        throw new NoSuchElementException(LocalizedStrings.DistributionManager_NONE_OF_THE_GIVEN_MANAGERS_IS_IN_THE_CURRENT_MEMBERSHIP_VIEW.toLocalizedString());
    }

    private boolean testMulticast() {
        return this.membershipManager.testMulticast();
    }

    public static String printView(NetView v) {
        if (v == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        NetMember leadObj = v.getLeadMember();
        InternalDistributedMember lead = leadObj == null ? null : new InternalDistributedMember(v.getLeadMember());
        sb.append("[");
        Iterator it = v.iterator();
        while (it.hasNext()) {
            InternalDistributedMember m = (InternalDistributedMember)it.next();
            sb.append(m.toString());
            if (lead != null && lead.equals(m)) {
                sb.append("{lead}");
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected void startThreads() {
        this.system.setDM(this);
        if (this.memberEventThread != null) {
            this.memberEventThread.start();
        }
        try {
            NetView v = this.membershipManager.getView();
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_INITIAL_MEMBERSHIPMANAGER_VIEW___0, DistributionManager.printView(v)));
            Iterator it = v.iterator();
            while (it.hasNext()) {
                this.addNewMember((InternalDistributedMember)it.next(), null);
            }
            this.selectElder();
        }
        catch (Exception ex) {
            throw new InternalGemFireException(LocalizedStrings.DistributionManager_COULD_NOT_PROCESS_INITIAL_VIEW.toLocalizedString(), ex);
        }
        try {
            this.getWaitingThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    isStartupThread.set(Boolean.TRUE);
                    DistributionManager.this.readyForMessages();
                }
            });
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNCAUGHT_EXCEPTION_CALLING_READYFORMESSAGES), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readyForMessages() {
        DistributionManager distributionManager = this;
        synchronized (distributionManager) {
            this.readyForMessages = true;
            this.notifyAll();
        }
        this.membershipManager.startEventProcessing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitUntilReadyForMessages() {
        if (this.readyForMessages) {
            return;
        }
        DistributionManager distributionManager = this;
        synchronized (distributionManager) {
            while (!this.readyForMessages) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readyToSendMsgs() {
        Object object = this.readyToSendMsgsLock;
        synchronized (object) {
            this.readyToSendMsgs = true;
            this.readyToSendMsgsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitUntilReadyToSendMsgs(DistributionMessage msg) {
        if (this.readyToSendMsgs) {
            return;
        }
        if (msg instanceof StartupMessage) return;
        if (msg instanceof StartupResponseMessage) return;
        if (msg instanceof AdminMessageType) {
            return;
        }
        if (isStartupThread.get() != null) {
            return;
        }
        Object object = this.readyToSendMsgsLock;
        synchronized (object) {
            while (!this.readyToSendMsgs) {
                this.stopper.checkCancelInProgress(null);
                boolean interrupted = Thread.interrupted();
                try {
                    this.readyToSendMsgsLock.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.stopper.checkCancelInProgress(e);
                    continue;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            return;
        }
    }

    @Override
    public void restartCommunications() {
        this.membershipManager.reset();
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
        this.membershipManager.forceUDPMessagingForCurrentThread();
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
        this.membershipManager.releaseUDPMessagingForCurrentThread();
    }

    public boolean exceptionInThreads() {
        return this.exceptionInThreads || this.threadGroup.getUncaughtExceptionsCount() > 0L;
    }

    void clearExceptionInThreads() {
        this.exceptionInThreads = false;
        this.threadGroup.clearUncaughtExceptionsCount();
    }

    @Override
    public long cacheTimeMillis() {
        return this.system.getClock().cacheTimeMillis();
    }

    @Override
    public InternalDistributedMember getDistributionManagerId() {
        return this.myid;
    }

    protected Stub getDirectChannel() {
        return this.membershipManager.getDirectChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDistributionManagerIds() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.members.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHostedLocators(InternalDistributedMember member, Collection<String> locators, boolean isSharedConfigurationEnabled) {
        Object object = this.membersLock;
        synchronized (object) {
            if (locators == null || locators.isEmpty()) {
                throw new IllegalArgumentException("Cannot use empty collection of locators");
            }
            if (this.hostedLocatorsAll.isEmpty()) {
                this.hostedLocatorsAll = new HashMap<InternalDistributedMember, Collection<String>>();
            }
            if (!this.isSharedConfigEnabledForDS) {
                this.isSharedConfigEnabledForDS = isSharedConfigurationEnabled;
            }
            Map<InternalDistributedMember, Collection<String>> tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsAll);
            tmp.remove(member);
            tmp.put(member, locators);
            tmp = Collections.unmodifiableMap(tmp);
            this.hostedLocatorsAll = tmp;
            if (isSharedConfigurationEnabled) {
                if (locators == null || locators.isEmpty()) {
                    throw new IllegalArgumentException("Cannot use empty collection of locators");
                }
                if (this.hostedLocatorsWithSharedConfiguration.isEmpty()) {
                    this.hostedLocatorsWithSharedConfiguration = new HashMap<InternalDistributedMember, Collection<String>>();
                }
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsWithSharedConfiguration);
                tmp.remove(member);
                tmp.put(member, locators);
                tmp = Collections.unmodifiableMap(tmp);
                this.hostedLocatorsWithSharedConfiguration = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHostedLocators(InternalDistributedMember member) {
        Object object = this.membersLock;
        synchronized (object) {
            Map<InternalDistributedMember, Collection<String>> tmp;
            if (this.hostedLocatorsAll.containsKey(member)) {
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsAll);
                tmp.remove(member);
                tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                this.hostedLocatorsAll = tmp;
            }
            if (this.hostedLocatorsWithSharedConfiguration.containsKey(member)) {
                tmp = new HashMap<InternalDistributedMember, Collection<String>>(this.hostedLocatorsWithSharedConfiguration);
                tmp.remove(member);
                tmp = tmp.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(tmp);
                this.hostedLocatorsWithSharedConfiguration = tmp;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getHostedLocators(InternalDistributedMember member) {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsAll.get(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocators() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsAll;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InternalDistributedMember, Collection<String>> getAllHostedLocatorsWithSharedConfiguration() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.hostedLocatorsWithSharedConfiguration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getDistributionManagerIdsIncludingAdmin() {
        Object object = this.membersLock;
        synchronized (object) {
            return this.membersAndAdmin;
        }
    }

    public DistributionChannel getDistributionChannel() {
        return this.channel;
    }

    @Override
    public Set getOtherDistributionManagerIds() {
        HashSet result = new HashSet(this.getDistributionManagerIds());
        InternalDistributedMember me = this.getDistributionManagerId();
        result.remove(me);
        return result;
    }

    @Override
    public Set getOtherNormalDistributionManagerIds() {
        HashSet result = new HashSet(this.getNormalDistributionManagerIds());
        InternalDistributedMember me = this.getDistributionManagerId();
        result.remove(me);
        return result;
    }

    @Override
    public InternalDistributedMember getCanonicalId(DistributedMember id) {
        InternalDistributedMember result = this.members.get(id);
        if (result == null) {
            return (InternalDistributedMember)id;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set addMembershipListenerAndGetDistributionManagerIds(MembershipListener l) {
        Object object = this.membersLock;
        synchronized (object) {
            this.addMembershipListener(l);
            return this.members.keySet();
        }
    }

    public void addNewMember(InternalDistributedMember member, Stub stub) {
        int vmType = member.getVmKind();
        switch (vmType) {
            case 12: {
                this.handleConsoleStartup(member, stub);
                break;
            }
            case 10: 
            case 11: {
                this.handleManagerStartup(member, stub);
                break;
            }
            default: {
                throw new InternalGemFireError(LocalizedStrings.DistributionManager_UNKNOWN_MEMBER_TYPE_0.toLocalizedString(vmType));
            }
        }
    }

    @Override
    public InternalDistributedMember getId() {
        return this.myid;
    }

    @Override
    public long getChannelId() {
        return this.channel.getId();
    }

    @Override
    public Set putOutgoingUserData(DistributionMessage message) throws NotSerializableException {
        return this.sendMessage(message);
    }

    @Override
    public Set putOutgoing(DistributionMessage msg) {
        try {
            DistributionMessageObserver observer = DistributionMessageObserver.getInstance();
            if (observer != null) {
                observer.beforeSendMessage(this, msg);
            }
            return this.sendMessage(msg);
        }
        catch (NotSerializableException e) {
            throw new InternalGemFireException(e);
        }
        catch (ToDataException e) {
            throw e;
        }
    }

    public String toString() {
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        block21: {
            Object object = this.shutdownMutex;
            synchronized (object) {
                if (this.closeInProgress) {
                    return;
                }
                this.closeInProgress = true;
            }
            String exceptionStatus = this.exceptionInThreads() ? LocalizedStrings.DistributionManager_AT_LEAST_ONE_EXCEPTION_OCCURRED.toLocalizedString() : "";
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_SHUTTING_DOWN_DISTRIBUTIONMANAGER_0_1, new Object[]{this.myid, exceptionStatus}));
            long start = System.currentTimeMillis();
            try {
                if (this.rootCause instanceof ForcedDisconnectException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("inhibiting sending of shutdown message to other members due to forced-disconnect");
                    }
                    break block21;
                }
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConnectionTable.threadWantsSharedResources();
                            DistributionManager.this.sendShutdownMessage();
                        }
                        catch (CancelException e) {
                            logger.debug("Cancelled during shutdown message", (Throwable)e);
                        }
                    }
                };
                Thread t = new Thread(this.threadGroup, r, LocalizedStrings.DistributionManager_SHUTDOWN_MESSAGE_THREAD_FOR_0.toLocalizedString(this.myid));
                t.start();
                boolean interrupted = Thread.interrupted();
                try {
                    t.join(20000L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    t.interrupt();
                    logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_INTERRUPTED_SENDING_SHUTDOWN_MESSAGE_TO_PEERS), (Throwable)e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t.isAlive()) {
                    t.interrupt();
                    logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_FAILED_SENDING_SHUTDOWN_MESSAGE_TO_PEERS_TIMEOUT));
                }
            }
            finally {
                this.shutdownMsgSent = true;
                try {
                    this.uncleanShutdown(false);
                }
                finally {
                    Long delta = System.currentTimeMillis() - start;
                    logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGER_STOPPED_IN_0_MS, delta));
                }
            }
        }
    }

    private void askThreadsToStop() {
        Thread th;
        ThreadPoolExecutor es = this.serialThread;
        if (es != null) {
            es.shutdown();
        }
        if ((es = this.viewThread) != null) {
            es.shutdown();
        }
        if (this.serialQueuedExecutorPool != null) {
            this.serialQueuedExecutorPool.shutdown();
        }
        if ((es = this.functionExecutionThread) != null) {
            es.shutdown();
        }
        if ((es = this.functionExecutionPool) != null) {
            es.shutdown();
        }
        if ((es = this.partitionedRegionThread) != null) {
            es.shutdown();
        }
        if ((es = this.partitionedRegionPool) != null) {
            es.shutdown();
        }
        if ((es = this.highPriorityPool) != null) {
            es.shutdown();
        }
        if ((es = this.waitingPool) != null) {
            es.shutdown();
        }
        if ((es = this.prMetaDataCleanupThreadPool) != null) {
            es.shutdown();
        }
        if ((es = this.threadPool) != null) {
            es.shutdown();
        }
        if ((th = this.memberEventThread) != null) {
            th.interrupt();
        }
    }

    private void waitForThreadsToStop(long timeInMillis) throws InterruptedException {
        ExecutorService[] allExecutors;
        long start = System.currentTimeMillis();
        long remaining = timeInMillis;
        for (ExecutorService es : allExecutors = new ExecutorService[]{this.serialThread, this.viewThread, this.functionExecutionThread, this.functionExecutionPool, this.partitionedRegionThread, this.partitionedRegionPool, this.highPriorityPool, this.waitingPool, this.prMetaDataCleanupThreadPool, this.threadPool}) {
            if (es != null) {
                es.awaitTermination(remaining, TimeUnit.MILLISECONDS);
            }
            if ((remaining = timeInMillis - (System.currentTimeMillis() - start)) > 0L) continue;
            return;
        }
        this.serialQueuedExecutorPool.awaitTermination(remaining, TimeUnit.MILLISECONDS);
        remaining = timeInMillis - (System.currentTimeMillis() - start);
        if (remaining <= 0L) {
            return;
        }
        Thread th = this.memberEventThread;
        if (th != null) {
            th.interrupt();
            th.join(remaining);
        }
    }

    private void clobberThread(Thread t) {
        if (t == null) {
            return;
        }
        if (t.isAlive()) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_FORCING_THREAD_STOP_ON__0_, t));
            t.interrupt();
            try {
                for (int i = 0; i < 10 && t.isAlive(); ++i) {
                    t.join(1000L);
                    t.interrupt();
                }
            }
            catch (InterruptedException ex) {
                logger.debug("Interrupted while attempting to terminate threads.");
                Thread.currentThread().interrupt();
            }
            if (t.isAlive()) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_CLOBBERTHREAD_THREAD_REFUSED_TO_DIE__0, t));
            }
        }
    }

    private boolean executorAlive(ThreadPoolExecutor tpe, String name) {
        if (tpe == null) {
            return false;
        }
        int ac = tpe.getActiveCount();
        if (ac > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Still waiting for {} threads in '{}' pool to exit", ac, name);
            }
            return true;
        }
        return false;
    }

    private void forceThreadsToStop() {
        Thread th;
        long endTime = System.currentTimeMillis() + 20000L;
        String culprits = "";
        while (true) {
            boolean stillAlive = false;
            culprits = "";
            if (this.executorAlive(this.serialThread, "serial thread")) {
                stillAlive = true;
                culprits = culprits + " serial thread;";
            }
            if (this.executorAlive(this.viewThread, "view thread")) {
                stillAlive = true;
                culprits = culprits + " view thread;";
            }
            if (this.executorAlive(this.partitionedRegionThread, "partitioned region thread")) {
                stillAlive = true;
                culprits = culprits + " partitioned region thread;";
            }
            if (this.executorAlive(this.partitionedRegionPool, "partitioned region pool")) {
                stillAlive = true;
                culprits = culprits + " partitioned region pool;";
            }
            if (this.executorAlive(this.highPriorityPool, "high priority pool")) {
                stillAlive = true;
                culprits = culprits + " high priority pool;";
            }
            if (this.executorAlive(this.waitingPool, "waiting pool")) {
                stillAlive = true;
                culprits = culprits + " waiting pool;";
            }
            if (this.executorAlive(this.prMetaDataCleanupThreadPool, "prMetaDataCleanupThreadPool")) {
                stillAlive = true;
                culprits = culprits + " special waiting pool;";
            }
            if (this.executorAlive(this.threadPool, "thread pool")) {
                stillAlive = true;
                culprits = culprits + " thread pool;";
            }
            if (!stillAlive) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now >= endTime) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_INTERRUPTED_DURING_SHUTDOWN), (Throwable)e);
                break;
            }
        }
        logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_DAEMON_THREADS_ARE_SLOW_TO_STOP_CULPRITS_INCLUDE_0, culprits));
        if (this.serialThread != null) {
            this.serialThread.shutdownNow();
        }
        if (this.viewThread != null) {
            this.viewThread.shutdownNow();
        }
        if (this.functionExecutionThread != null) {
            this.functionExecutionThread.shutdownNow();
        }
        if (this.functionExecutionPool != null) {
            this.functionExecutionPool.shutdownNow();
        }
        if (this.partitionedRegionThread != null) {
            this.partitionedRegionThread.shutdownNow();
        }
        if (this.partitionedRegionPool != null) {
            this.partitionedRegionPool.shutdownNow();
        }
        if (this.highPriorityPool != null) {
            this.highPriorityPool.shutdownNow();
        }
        if (this.waitingPool != null) {
            this.waitingPool.shutdownNow();
        }
        if (this.prMetaDataCleanupThreadPool != null) {
            this.prMetaDataCleanupThreadPool.shutdownNow();
        }
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
        if ((th = this.memberEventThread) != null) {
            this.clobberThread(th);
        }
    }

    @Override
    public boolean shutdownInProgress() {
        return this.shutdownInProgress;
    }

    /*
     * Exception decompiling
     */
    private void uncleanShutdown(boolean duringStartup) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryCatchLeaveGoto(ClassifyGotos.java:144)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyTryLeaveGoto(ClassifyGotos.java:76)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ClassifyGotos.classifyGotos(ClassifyGotos.java:66)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.classifyGotos(Op03Rewriters.java:105)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:752)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public InternalDistributedSystem getSystem() {
        return this.system;
    }

    public RemoteTransportConfig getTransport() {
        return this.transport;
    }

    @Override
    public void addMembershipListener(MembershipListener l) {
        this.membershipListeners.putIfAbsent(l, Boolean.TRUE);
    }

    @Override
    public void removeMembershipListener(MembershipListener l) {
        this.membershipListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllMembershipListener(MembershipListener l) {
        Object object = this.allMembershipListenersLock;
        synchronized (object) {
            HashSet<MembershipListener> newAllMembershipListeners = new HashSet<MembershipListener>(this.allMembershipListeners);
            newAllMembershipListeners.add(l);
            this.allMembershipListeners = newAllMembershipListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllMembershipListener(MembershipListener l) {
        Object object = this.allMembershipListenersLock;
        synchronized (object) {
            HashSet newAllMembershipListeners = new HashSet(this.allMembershipListeners);
            if (!newAllMembershipListeners.remove(l)) {
                // empty if block
            }
            this.allMembershipListeners = newAllMembershipListeners;
        }
    }

    private void handleJoinEvent(MemberJoinedEvent ev) {
        InternalDistributedMember id = ev.getId();
        for (MembershipListener listener : this.membershipListeners.keySet()) {
            try {
                listener.memberJoined(id);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            try {
                listener.memberJoined(id);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
    }

    private void handleCrashEvent(MemberCrashedEvent ev) {
        InternalDistributedMember id = ev.getId();
        for (MembershipListener listener : this.membershipListeners.keySet()) {
            try {
                listener.memberDeparted(id, true);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            try {
                listener.memberDeparted(id, true);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
        MembershipLogger.logCrash(id);
    }

    private void handleDepartEvent(MemberDepartedEvent ev) {
        InternalDistributedMember id = ev.getId();
        for (MembershipListener listener : this.membershipListeners.keySet()) {
            try {
                listener.memberDeparted(id, false);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            try {
                listener.memberDeparted(id, false);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
    }

    private void handleSuspectEvent(MemberSuspectEvent ev) {
        InternalDistributedMember id = ev.getId();
        InternalDistributedMember whoSuspected = ev.whoSuspected();
        for (MembershipListener listener : this.membershipListeners.keySet()) {
            try {
                listener.memberSuspect(id, whoSuspected);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            try {
                listener.memberSuspect(id, whoSuspected);
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleViewInstalledEvent(ViewInstalledEvent ev) {
        Object object = this.membershipViewIdGuard;
        synchronized (object) {
            this.membershipViewIdAcknowledged = ev.getViewId();
            this.membershipViewIdGuard.notifyAll();
        }
    }

    private void handleQuorumLostEvent(QuorumLostEvent ev) {
        for (MembershipListener listener : this.membershipListeners.keySet()) {
            try {
                listener.quorumLost(ev.getFailures(), ev.getRemaining());
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            try {
                listener.quorumLost(ev.getFailures(), ev.getRemaining());
            }
            catch (CancelException e) {
                if (this.closeInProgress) {
                    if (!logger.isTraceEnabled()) break;
                    logger.trace("MemberEventInvoker: cancelled");
                    break;
                }
                logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForViewInstallation(long id) throws InterruptedException {
        if (id <= this.membershipViewIdAcknowledged) {
            return;
        }
        Object object = this.membershipViewIdGuard;
        synchronized (object) {
            while (this.membershipViewIdAcknowledged < id && this.stopper.cancelInProgress() == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("waiting for view {}.  Current DM view processed by all listeners is {}", id, this.membershipViewIdAcknowledged);
                }
                this.membershipViewIdGuard.wait();
            }
        }
    }

    protected void handleMemberEvent(MemberEvent ev) {
        try {
            switch (ev.eventType()) {
                case 0: {
                    this.handleJoinEvent((MemberJoinedEvent)ev);
                    break;
                }
                case 1: {
                    this.handleDepartEvent((MemberDepartedEvent)ev);
                    break;
                }
                case 2: {
                    this.handleCrashEvent((MemberCrashedEvent)ev);
                    break;
                }
                case 3: {
                    this.handleSuspectEvent((MemberSuspectEvent)ev);
                    break;
                }
                case 4: {
                    this.handleViewInstalledEvent((ViewInstalledEvent)ev);
                    break;
                }
                case 5: {
                    this.handleQuorumLostEvent((QuorumLostEvent)ev);
                    break;
                }
                default: {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNKNOWN_TYPE_OF_MEMBERSHIP_EVENT_RECEIVED_0, ev));
                    break;
                }
            }
        }
        catch (CancelException ex) {
            logger.debug("Cancellation while calling membership listener for event <{}>: {}", ev, ex.getMessage(), ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_EXCEPTION_WHILE_CALLING_MEMBERSHIP_LISTENER_FOR_EVENT__0, ev), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMemberEvent(MemberEvent ev) {
        if (SYNC_EVENTS) {
            this.handleMemberEvent(ev);
        } else {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.membershipEventQueue.put(ev);
            }
            catch (InterruptedException ex) {
                interrupted = true;
                this.stopper.checkCancelInProgress(ex);
                this.handleMemberEvent(ev);
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (this.closed) return;
        this.shutdown();
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_MARKING_DISTRIBUTIONMANAGER_0_AS_CLOSED, this.myid));
        MembershipLogger.logShutdown(this.myid);
        this.closed = true;
        Class<DistributionManager> clazz = DistributionManager.class;
        synchronized (DistributionManager.class) {
            --openDMs;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void throwIfDistributionStopped() {
        if (this.shutdownMsgSent) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DistributionManager_MESSAGE_DISTRIBUTION_HAS_TERMINATED.toLocalizedString(), this.getRootCause());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAdminConsole(InternalDistributedMember theId) {
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_NEW_ADMINISTRATION_MEMBER_DETECTED_AT_0, theId));
        Object object = this.adminConsolesLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> tmp = new HashSet<InternalDistributedMember>(this.adminConsoles);
            tmp.add(theId);
            this.adminConsoles = Collections.unmodifiableSet(tmp);
        }
    }

    @Override
    public DMStats getStats() {
        return this.stats;
    }

    @Override
    public DistributionConfig getConfig() {
        DistributionConfig result = null;
        InternalDistributedSystem sys = this.getSystem();
        if (sys != null) {
            result = this.system.getConfig();
        }
        return result;
    }

    @Override
    public Set getAllOtherMembers() {
        HashSet result = new HashSet(this.getDistributionManagerIdsIncludingAdmin());
        result.remove(this.getDistributionManagerId());
        return result;
    }

    @Override
    public void retainMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        Iterator<InternalDistributedMember> it = members.iterator();
        while (it.hasNext()) {
            InternalDistributedMember id = it.next();
            if (id.getVersionObject().compareTo(version) >= 0) continue;
            it.remove();
        }
    }

    @Override
    public void removeMembersWithSameOrNewerVersion(Collection<InternalDistributedMember> members, Version version) {
        Iterator<InternalDistributedMember> it = members.iterator();
        while (it.hasNext()) {
            InternalDistributedMember id = it.next();
            if (id.getVersionObject().compareTo(version) < 0) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set addAllMembershipListenerAndGetAllIds(MembershipListener l) {
        MembershipManager mgr;
        DistributionChannel ch = this.channel;
        if (ch != null && (mgr = ch.getMembershipManager()) != null) {
            Object object = mgr.getViewLock();
            synchronized (object) {
                Object object2 = this.membersLock;
                synchronized (object2) {
                    this.addAllMembershipListener(l);
                    return this.getDistributionManagerIdsIncludingAdmin();
                }
            }
        }
        Object object = this.membersLock;
        synchronized (object) {
            this.addAllMembershipListener(l);
            return Collections.EMPTY_SET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean sendStartupMessage(StartupOperation op, boolean cancelOnTimeout) throws InterruptedException {
        boolean isAdminDM;
        HashSet<InetAddress> equivs;
        boolean ok;
        block28: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            this.receivedStartupResponse = false;
            ok = false;
            equivs = StartupMessage.getMyAddresses(this);
            if (equivs == null || equivs.size() == 0) {
                equivs = new HashSet<InetAddress>();
                try {
                    equivs.add(SocketCreator.getLocalHost());
                }
                catch (UnknownHostException e) {
                    if (this.getViewMembers().size() <= 1) break block28;
                    throw new SystemConnectException("Unable to examine network cards and other members exist");
                }
            }
        }
        this.setEquivalentHosts(equivs);
        this.setEnforceUniqueZone(this.getConfig().getEnforceUniqueHost());
        String redundancyZone = this.getConfig().getRedundancyZone();
        if (redundancyZone != null && !redundancyZone.equals("")) {
            this.setEnforceUniqueZone(true);
        } else if (this.getSystem().getLicenseChecker() != null && (redundancyZone = this.getSystem().getLicenseChecker().getHostToken()) != null && !redundancyZone.equals("")) {
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_RUNNING_IN_VMWARE_VM, redundancyZone));
        }
        this.setRedundancyZone(this.getDistributionManagerId(), redundancyZone);
        if (logger.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Equivalent IPs for this host: ");
            Iterator it = equivs.iterator();
            while (it.hasNext()) {
                InetAddress in = (InetAddress)it.next();
                sb.append(in.toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            logger.debug(sb);
        }
        HashSet allOthers = new HashSet(this.getViewMembers());
        allOthers.remove(this.getDistributionManagerId());
        if (allOthers.isEmpty()) {
            return false;
        }
        for (InternalDistributedMember member : allOthers) {
            this.membershipManager.getStubForMember(member);
        }
        try {
            ok = op.sendStartupMessage(allOthers, STARTUP_TIMEOUT, equivs, redundancyZone, this.enforceUniqueZone());
        }
        catch (Exception re) {
            throw new SystemConnectException(LocalizedStrings.DistributionManager_ONE_OR_MORE_PEERS_GENERATED_EXCEPTIONS_DURING_CONNECTION_ATTEMPT.toLocalizedString(), re);
        }
        if (this.rejectionMessage != null) {
            throw new IncompatibleSystemException(this.rejectionMessage);
        }
        boolean bl = isAdminDM = this.getId().getVmKind() == 12 || this.getId().getVmKind() == 11 || isDedicatedAdminVM || Boolean.getBoolean("Locator.forceLocatorDMType");
        if (!isAdminDM && this.getSystem().getLicenseChecker() != null) {
            this.getSystem().getLicenseChecker().checkPeerLimit(this.getId());
        }
        boolean receivedAny = this.receivedStartupResponse;
        if (!ok) {
            Object object = this.unfinishedStartupsLock;
            synchronized (object) {
                int unresponsiveCount = this.unfinishedStartups == null ? 0 : this.unfinishedStartups.size();
                if (unresponsiveCount != 0 && Boolean.getBoolean("DistributionManager.requireAllStartupResponses")) {
                    throw new SystemConnectException(LocalizedStrings.DistributionManager_NO_STARTUP_REPLIES_FROM_0.toLocalizedString(this.unfinishedStartups));
                }
            }
            if (allOthers.size() != 0 && !receivedAny) {
                StringBuffer sb = new StringBuffer();
                Iterator itt = allOthers.iterator();
                while (itt.hasNext()) {
                    Object m = itt.next();
                    sb.append(m.toString());
                    if (!itt.hasNext()) continue;
                    sb.append(", ");
                }
                if (DEBUG_NO_ACKNOWLEDGEMENTS) {
                    this.printStacks(allOthers, false);
                }
                throw new SystemConnectException(LocalizedStrings.DistributionManager_RECEIVED_NO_CONNECTION_ACKNOWLEDGMENTS_FROM_ANY_OF_THE_0_SENIOR_CACHE_MEMBERS_1.toLocalizedString(Integer.toString(allOthers.size()), sb.toString()));
            }
            InternalDistributedMember e = this.getElderId();
            if (e != null) {
                boolean unresponsiveElder;
                Object object2 = this.unfinishedStartupsLock;
                synchronized (object2) {
                    unresponsiveElder = this.unfinishedStartups == null ? false : this.unfinishedStartups.contains(e);
                }
                if (unresponsiveElder) {
                    logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_FORCING_AN_ELDER_JOIN_EVENT_SINCE_A_STARTUP_RESPONSE_WAS_NOT_RECEIVED_FROM_ELDER__0_, e));
                    this.handleManagerStartup(e, null);
                }
            }
        }
        return receivedAny;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnfinishedStartups(Collection s) {
        Object object = this.unfinishedStartupsLock;
        synchronized (object) {
            Assert.assertTrue(this.unfinishedStartups == null, "Set unfinished startups twice");
            this.unfinishedStartups = new HashSet(s);
            Iterator it = this.unfinishedStartups.iterator();
            Object object2 = this.membersLock;
            synchronized (object2) {
                while (it.hasNext()) {
                    InternalDistributedMember m = (InternalDistributedMember)it.next();
                    if (this.isCurrentMember(m)) continue;
                    it.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUnfinishedStartup(InternalDistributedMember m, boolean departed) {
        Object object = this.unfinishedStartupsLock;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("removeUnfinishedStartup for {} wtih {}", m, this.unfinishedStartups);
            }
            if (this.unfinishedStartups == null) {
                return;
            }
            if (!this.unfinishedStartups.remove(m)) {
                return;
            }
            StringId msg = null;
            msg = departed ? LocalizedStrings.DistributionManager_STOPPED_WAITING_FOR_STARTUP_REPLY_FROM_0_BECAUSE_THE_PEER_DEPARTED_THE_VIEW : LocalizedStrings.DistributionManager_STOPPED_WAITING_FOR_STARTUP_REPLY_FROM_0_BECAUSE_THE_REPLY_WAS_FINALLY_RECEIVED;
            logger.info(LocalizedMessage.create(msg, m));
            int numLeft = this.unfinishedStartups.size();
            if (numLeft != 0) {
                logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_STILL_AWAITING_0_RESPONSES_FROM_1, new Object[]{numLeft, this.unfinishedStartups}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStartupResponse(InternalDistributedMember sender, long otherCacheTime, String theRejectionMessage) {
        this.removeUnfinishedStartup(sender, false);
        DistributionManager distributionManager = this;
        synchronized (distributionManager) {
            if (!this.receivedStartupResponse) {
                this.receivedStartupResponse = true;
            }
            if (theRejectionMessage != null && this.rejectionMessage == null) {
                this.rejectionMessage = theRejectionMessage;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStartupResponse(InternalDistributedMember sender, String theRejectionMessage) {
        this.removeUnfinishedStartup(sender, false);
        DistributionManager distributionManager = this;
        synchronized (distributionManager) {
            if (!this.receivedStartupResponse) {
                this.receivedStartupResponse = true;
            }
            if (theRejectionMessage != null && this.rejectionMessage == null) {
                this.rejectionMessage = theRejectionMessage;
            }
        }
    }

    private InternalDistributedMember getElderCandidate() {
        int managerType;
        InternalDistributedMember member2;
        Vector theMembers = this.getViewMembers();
        int elderCandidates = 0;
        Iterator it = theMembers.iterator();
        boolean anyPre80Members = false;
        while (it.hasNext()) {
            member2 = (InternalDistributedMember)it.next();
            if (member2.getVersionObject().compareTo(Version.GFE_80) >= 0) continue;
            anyPre80Members = true;
        }
        if (!this.adam) {
            it = theMembers.iterator();
            while (it.hasNext() && ((managerType = (member2 = (InternalDistributedMember)it.next()).getVmKind()) == 12 || managerType == 11 && anyPre80Members || this.getMembershipManager().isSurpriseMember(member2) || ++elderCandidates <= 1)) {
            }
        }
        for (InternalDistributedMember member2 : theMembers) {
            managerType = member2.getVmKind();
            if (managerType == 12 || managerType == 11 && anyPre80Members || this.getMembershipManager().isSurpriseMember(member2)) continue;
            if (member2.equals(this.myid)) {
                if (!this.adam && elderCandidates == 1) {
                    this.adam = true;
                    logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_0_IS_THE_ELDER_AND_THE_ONLY_MEMBER, this.myid));
                } else {
                    logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_I_0_AM_THE_ELDER, this.myid));
                }
            }
            return member2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectElder() {
        this.getSystem().getCancelCriterion().checkCancelInProgress(null);
        if (this.myid.equals(this.elder)) {
            return;
        }
        InternalDistributedMember candidate = this.getElderCandidate();
        if (candidate == null) {
            this.changeElder(null);
            return;
        }
        Object object = this.elderMonitor;
        synchronized (object) {
            if (!candidate.equals(this.elder)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The elder is: {} (was {})", candidate, this.elder);
                }
                this.changeElder(candidate);
            }
        }
    }

    private String prettifyReason(String r) {
        String str = "java.io.IOException:";
        if (r.startsWith("java.io.IOException:")) {
            return r.substring("java.io.IOException:".length());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeManager(InternalDistributedMember theId, boolean crashed, String p_reason) {
        String reason = p_reason;
        boolean result = false;
        if (this.isCurrentMember(theId)) {
            reason = this.prettifyReason(reason);
            Object object = this.membersLock;
            synchronized (object) {
                Map<InternalDistributedMember, InternalDistributedMember> tmp;
                if (logger.isDebugEnabled()) {
                    logger.debug("DistributionManager: removing member <{}>; crashed {}; reason = {}", theId, crashed, reason);
                }
                if ((tmp = new HashMap<InternalDistributedMember, InternalDistributedMember>(this.members)).remove(theId) != null) {
                    tmp = tmp.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(tmp);
                    this.members = tmp;
                    result = true;
                } else {
                    result = false;
                }
                Set tmp2 = new HashSet(this.membersAndAdmin);
                if (tmp2.remove(theId)) {
                    tmp2 = tmp2.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(tmp2);
                    this.membersAndAdmin = tmp2;
                }
                this.removeHostedLocators(theId);
            }
        }
        if (!theId.equals(this.myid) && theId.equals(this.elder)) {
            try {
                this.selectElder();
            }
            catch (DistributedSystemDisconnectedException e) {
                // empty catch block
            }
        }
        this.redundancyZones.remove(theId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleManagerStartup(InternalDistributedMember theId, Stub directChannel) {
        HashMap<InternalDistributedMember, InternalDistributedMember> tmp = null;
        Object object = this.membersLock;
        synchronized (object) {
            if (this.members.containsKey(theId)) {
                return;
            }
            tmp = new HashMap<InternalDistributedMember, InternalDistributedMember>(this.members);
            tmp.put(theId, theId);
            this.members = Collections.unmodifiableMap(tmp);
            HashSet<InternalDistributedMember> stmp = new HashSet<InternalDistributedMember>(this.membersAndAdmin);
            stmp.add(theId);
            this.membersAndAdmin = Collections.unmodifiableSet(stmp);
        }
        if (theId.getVmKind() != 11) {
            this.stats.incNodes(1);
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_ADMITTING_MEMBER_0_NOW_THERE_ARE_1_NONADMIN_MEMBERS, new Object[]{theId, tmp.size()}));
        this.addMemberEvent(new MemberJoinedEvent(theId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrentMember(InternalDistributedMember id) {
        Set m;
        Object object = this.membersLock;
        synchronized (object) {
            m = this.membersAndAdmin;
        }
        return m.contains(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConsoleStartup(InternalDistributedMember theId, Serializable directChannel) {
        HashSet<InternalDistributedMember> tmp = null;
        Object object = this.membersLock;
        synchronized (object) {
            if (this.membersAndAdmin.contains(theId)) {
                return;
            }
            tmp = new HashSet<InternalDistributedMember>(this.membersAndAdmin);
            tmp.add(theId);
            this.membersAndAdmin = Collections.unmodifiableSet(tmp);
        }
        for (MembershipListener listener : this.allMembershipListeners) {
            listener.memberJoined(theId);
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_DMMEMBERSHIP_ADMITTING_NEW_ADMINISTRATION_MEMBER__0_, theId));
    }

    public void handleIncomingDMsg(DistributionMessage message) {
        this.stats.incReceivedMessages(1L);
        this.stats.incReceivedBytes(message.getBytesRead());
        this.stats.incMessageChannelTime(message.resetTimestamp());
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "Received message '{}' from <{}>", message, message.getSender());
        }
        this.scheduleIncomingMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConsoleShutdown(InternalDistributedMember theId, boolean crashed, String reason) {
        Set<Object> tmp;
        boolean removedConsole = false;
        boolean removedMember = false;
        Object object = this.membersLock;
        synchronized (object) {
            if (!this.members.containsKey(theId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistributionManager: removing admin member <{}>; crashed = {}; reason = {}", theId, crashed, reason);
                }
                if ((tmp = new HashSet(this.membersAndAdmin)).remove(theId)) {
                    tmp = tmp.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(tmp);
                    this.membersAndAdmin = tmp;
                    removedMember = true;
                }
            }
            this.removeHostedLocators(theId);
        }
        object = this.adminConsolesLock;
        synchronized (object) {
            if (this.adminConsoles.contains(theId)) {
                removedConsole = true;
                tmp = new HashSet<InternalDistributedMember>(this.adminConsoles);
                tmp.remove(theId);
                tmp = tmp.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(tmp);
                this.adminConsoles = tmp;
            }
        }
        if (removedMember) {
            for (MembershipListener listener : this.allMembershipListeners) {
                listener.memberDeparted(theId, crashed);
            }
        }
        if (removedConsole) {
            StringId msg = null;
            msg = crashed ? LocalizedStrings.DistributionManager_ADMINISTRATION_MEMBER_AT_0_CRASHED_1 : LocalizedStrings.DistributionManager_ADMINISTRATION_MEMBER_AT_0_CLOSED_1;
            logger.info(LocalizedMessage.create(msg, new Object[]{theId, reason}));
        }
        this.redundancyZones.remove(theId);
    }

    public void shutdownMessageReceived(InternalDistributedMember theId, String reason) {
        this.membershipManager.shutdownMessageReceived(theId, reason);
        this.handleManagerDeparture(theId, false, LocalizedStrings.ShutdownMessage_SHUTDOWN_MESSAGE_RECEIVED.toLocalizedString());
    }

    @Override
    public void handleManagerDeparture(InternalDistributedMember theId, boolean p_crashed, String p_reason) {
        boolean crashed = p_crashed;
        String reason = p_reason;
        AlertAppender.getInstance().removeAlertListener(theId);
        try {
            this.selectElder();
        }
        catch (DistributedSystemDisconnectedException e) {
            // empty catch block
        }
        int vmType = theId.getVmKind();
        if (vmType == 12) {
            this.removeUnfinishedStartup(theId, true);
            this.handleConsoleShutdown(theId, crashed, reason);
            return;
        }
        if (!this.isCurrentMember(theId)) {
            return;
        }
        this.removeUnfinishedStartup(theId, true);
        if (this.removeManager(theId, crashed, reason)) {
            StringId msg;
            if (theId.getVmKind() != 11) {
                this.stats.incNodes(-1);
            }
            if (crashed && !this.closeInProgress) {
                msg = LocalizedStrings.DistributionManager_MEMBER_AT_0_UNEXPECTEDLY_LEFT_THE_DISTRIBUTED_CACHE_1;
                this.addMemberEvent(new MemberCrashedEvent(theId, reason));
            } else {
                msg = LocalizedStrings.DistributionManager_MEMBER_AT_0_GRACEFULLY_LEFT_THE_DISTRIBUTED_CACHE_1;
                this.addMemberEvent(new MemberDepartedEvent(theId, reason));
            }
            logger.info(LocalizedMessage.create(msg, new Object[]{theId, this.prettifyReason(reason)}));
            if (this.serialQueuedExecutorPool != null) {
                this.serialQueuedExecutorPool.handleMemberDeparture(theId);
            }
        }
    }

    public void handleManagerSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected) {
        if (!this.isCurrentMember(suspect)) {
            return;
        }
        int vmType = suspect.getVmKind();
        if (vmType == 12) {
            return;
        }
        this.addMemberEvent(new MemberSuspectEvent(suspect, whoSuspected));
    }

    public void handleViewInstalled(NetView view) {
        this.addMemberEvent(new ViewInstalledEvent(view));
    }

    public void handleQuorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        this.addMemberEvent(new QuorumLostEvent(failures, remaining));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendShutdownMessage() {
        if (this.getDMType() == 12 && Locator.getLocators().size() == 0) {
            return;
        }
        ShutdownMessage m = new ShutdownMessage();
        InternalDistributedMember theId = this.getDistributionManagerId();
        m.setDistributionManagerId(theId);
        HashSet allOthers = new HashSet(this.getViewMembers());
        allOthers.remove(this.getDistributionManagerId());
        m.setMulticast(this.system.getConfig().getMcastPort() != 0);
        m.setRecipients(allOthers);
        if (logger.isTraceEnabled(LogMarker.DM)) {
            logger.trace(LogMarker.DM, "{} Sending {} to {}", this.getDistributionManagerId(), m, m.getRecipientsDescription());
        }
        try {
            long startTime = DistributionStats.getStatTime();
            this.channel.send(m.getRecipients(), m, this, this.stats);
            this.stats.incSentMessages(1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incSentMessagesTime(DistributionStats.getStatTime() - startTime);
            }
        }
        catch (CancelException e) {
            logger.debug("CancelException caught sending shutdown: {}", e.getMessage(), e);
        }
        catch (Exception ex2) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributionManager_WHILE_SENDING_SHUTDOWN_MESSAGE), (Throwable)ex2);
        }
        finally {
            this.shutdownMsgSent = true;
        }
    }

    public final Executor getExecutor(int processorType, InternalDistributedMember sender) {
        switch (processorType) {
            case 73: {
                return this.getThreadPool();
            }
            case 74: {
                return this.getSerialExecutor(sender);
            }
            case 79: {
                return this.viewThread;
            }
            case 75: {
                return this.getHighPriorityThreadPool();
            }
            case 77: {
                return this.getWaitingThreadPool();
            }
            case 78: {
                return this.getPartitionedRegionExcecutor();
            }
            case 80: {
                return this.getFunctionExcecutor();
            }
        }
        throw new InternalGemFireError(LocalizedStrings.DistributionManager_UNKNOWN_PROCESSOR_TYPE.toLocalizedString(processorType));
    }

    protected Set sendOutgoingSerialized(DistributionMessage msg) {
        try {
            return this.sendOutgoing(msg);
        }
        catch (NotSerializableException e) {
            throw new InternalGemFireException(e);
        }
        catch (ToDataException e) {
            throw e;
        }
    }

    protected Set sendOutgoing(DistributionMessage message) throws NotSerializableException {
        boolean sentToAll;
        long startTime = DistributionStats.getStatTime();
        Set result = this.channel.send(message.getRecipients(), message, this, this.stats);
        long endTime = 0L;
        if (DistributionStats.enableClockStats) {
            endTime = NanoTimer.getTime();
        }
        if (sentToAll = message.forAll()) {
            this.stats.incBroadcastMessages(1L);
            if (DistributionStats.enableClockStats) {
                this.stats.incBroadcastMessagesTime(endTime - startTime);
            }
        }
        this.stats.incSentMessages(1L);
        if (DistributionStats.enableClockStats) {
            this.stats.incSentMessagesTime(endTime - startTime);
            this.stats.incDistributeMessageTime(endTime - message.getTimestamp());
        }
        return result;
    }

    Set sendMessage(DistributionMessage message) throws NotSerializableException {
        HashSet<InternalDistributedMember> result = null;
        try {
            this.stopper.checkCancelInProgress(null);
            this.waitUntilReadyToSendMsgs(message);
            result = this.sendOutgoing(message);
        }
        catch (NotSerializableException ex) {
            throw ex;
        }
        catch (ToDataException ex) {
            throw ex;
        }
        catch (ReenteredConnectException ex) {
            throw ex;
        }
        catch (CancelException ex) {
            throw ex;
        }
        catch (InvalidDeltaException ide) {
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_CAUGHT_EXCEPTION_WHILE_SENDING_DELTA), ide.getCause());
            throw (RuntimeException)ide.getCause();
        }
        catch (Exception ex) {
            this.exceptionInThreads = true;
            String receiver = "NULL";
            if (message != null) {
                receiver = message.getRecipientsDescription();
            }
            logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributionManager_WHILE_PUSHING_MESSAGE_0_TO_1, new Object[]{message, receiver}), (Throwable)ex);
            if (message == null || message.forAll()) {
                return null;
            }
            result = new HashSet<InternalDistributedMember>();
            for (int i = 0; i < message.getRecipients().length; ++i) {
                result.add(message.getRecipients()[i]);
            }
            return result;
        }
        return result;
    }

    protected void scheduleIncomingMessage(DistributionMessage message) {
        this.waitUntilReadyForMessages();
        message.schedule(this);
    }

    @Override
    public boolean isAdam() {
        return this.adam;
    }

    @Override
    public InternalDistributedMember getElderId() throws DistributedSystemDisconnectedException {
        if (this.closeInProgress) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.DistributionManager_NO_VALID_ELDER_WHEN_SYSTEM_IS_SHUTTING_DOWN.toLocalizedString(), this.getRootCause());
        }
        this.getSystem().getCancelCriterion().checkCancelInProgress(null);
        InternalDistributedMember result = this.elder;
        if (result != null && this.membershipManager.memberExists(result)) {
            return result;
        }
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_ELDER__0__IS_NOT_CURRENTLY_AN_ACTIVE_MEMBER_SELECTING_NEW_ELDER, this.elder));
        this.selectElder();
        logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_NEWLY_SELECTED_ELDER_IS_NOW__0_, this.elder));
        return this.elder;
    }

    @Override
    public boolean isElder() {
        return this.getId().equals(this.elder);
    }

    @Override
    public boolean isLoner() {
        return false;
    }

    @Override
    public ElderState getElderState(boolean force, boolean useTryLock) {
        if (force) {
            if (logger.isDebugEnabled() && !this.myid.equals(this.elder)) {
                logger.debug("Forcing myself, {}, to be the elder.", this.myid);
            }
            this.changeElder(this.myid);
        }
        if (force || this.myid.equals(this.elder)) {
            if (this.elderStateInitialized) {
                return this.elderState;
            }
            return this.getElderStateWithTryLock(useTryLock);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ElderState getElderStateWithTryLock(boolean useTryLock) {
        boolean locked = false;
        if (useTryLock) {
            boolean interrupted = Thread.interrupted();
            try {
                locked = this.elderLock.tryLock(2000L);
            }
            catch (InterruptedException e) {
                interrupted = true;
                this.getCancelCriterion().checkCancelInProgress(e);
                locked = this.elderLock.tryLock();
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            locked = true;
            this.elderLock.lock();
        }
        if (!locked) {
            throw new IllegalStateException(LocalizedStrings.DistributionManager_POSSIBLE_DEADLOCK_DETECTED.toLocalizedString());
        }
        try {
            if (this.elderState == null) {
                this.elderState = new ElderState(this);
            }
        }
        finally {
            this.elderLock.unlock();
        }
        this.elderStateInitialized = true;
        return this.elderState;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean waitForElder(final InternalDistributedMember desiredElder) {
        boolean bl;
        InternalDistributedMember currentElder;
        MembershipListener l = null;
        try {
            Object object = this.elderMonitor;
            // MONITORENTER : object
            while (true) {
                if (this.closeInProgress) {
                    boolean bl2 = false;
                    // MONITOREXIT : object
                    if (l == null) return bl2;
                    this.removeMembershipListener(l);
                    return bl2;
                }
                currentElder = this.elder;
                if (!desiredElder.equals(currentElder)) break block14;
                bl = true;
                break;
            }
        }
        catch (Throwable throwable) {
            if (l == null) throw throwable;
            this.removeMembershipListener(l);
            throw throwable;
        }
        {
            block14: {
                // MONITOREXIT : object
                if (l == null) return bl;
                this.removeMembershipListener(l);
                return bl;
            }
            if (!this.isCurrentMember(desiredElder)) {
                boolean bl3 = false;
                // MONITOREXIT : object
                if (l == null) return bl3;
                this.removeMembershipListener(l);
                return bl3;
            }
            if (this.myid.equals(currentElder)) {
                boolean bl4 = false;
                // MONITOREXIT : object
                if (l == null) return bl4;
                this.removeMembershipListener(l);
                return bl4;
            }
            if (l == null) {
                l = new MembershipListener(){

                    @Override
                    public void memberJoined(InternalDistributedMember theId) {
                    }

                    @Override
                    public void memberDeparted(InternalDistributedMember theId, boolean crashed) {
                        if (desiredElder.equals(theId)) {
                            DistributionManager.this.notifyElderChangeWaiters();
                        }
                    }

                    @Override
                    public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected) {
                    }

                    public void viewInstalled(NetView view) {
                    }

                    @Override
                    public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
                    }
                };
                this.addMembershipListener(l);
            }
            logger.info(LocalizedMessage.create(LocalizedStrings.DistributionManager_CHANGING_ELDER_FROM_0_TO_1, new Object[]{currentElder, desiredElder}));
            this.elderChangeWait();
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeElder(InternalDistributedMember newElder) {
        Object object = this.elderMonitor;
        synchronized (object) {
            if (newElder != null && this.myid != null && !this.myid.equals(newElder) && this.myid.equals(this.elder)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("changeElder found this VM to be the elder and is taking an early out");
                }
                return;
            }
            this.elder = newElder;
            if (this.waitingForElderChange) {
                this.waitingForElderChange = false;
                this.elderMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyElderChangeWaiters() {
        Object object = this.elderMonitor;
        synchronized (object) {
            if (this.waitingForElderChange) {
                this.waitingForElderChange = false;
                this.elderMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void elderChangeWait() {
        this.waitingForElderChange = true;
        while (this.waitingForElderChange) {
            this.stopper.checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.elderMonitor.wait();
                break;
            }
            catch (InterruptedException ignore) {
                interrupted = true;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    @Override
    public ExecutorService getHighPriorityThreadPool() {
        return this.highPriorityPool;
    }

    @Override
    public ExecutorService getWaitingThreadPool() {
        return this.waitingPool;
    }

    @Override
    public ExecutorService getPrMetaDataCleanupThreadPool() {
        return this.prMetaDataCleanupThreadPool;
    }

    public Executor getPartitionedRegionExcecutor() {
        if (this.partitionedRegionThread != null) {
            return this.partitionedRegionThread;
        }
        return this.partitionedRegionPool;
    }

    public Executor getFunctionExcecutor() {
        if (this.functionExecutionThread != null) {
            return this.functionExecutionThread;
        }
        return this.functionExecutionPool;
    }

    private Executor getSerialExecutor(InternalDistributedMember sender) {
        if (MULTI_SERIAL_EXECUTORS) {
            return this.serialQueuedExecutorPool.getThrottledSerialExecutor(sender);
        }
        return this.serialThread;
    }

    public ThrottlingMemLinkedQueueWithDMStats getSerialQueue(InternalDistributedMember sender) {
        if (MULTI_SERIAL_EXECUTORS) {
            return this.serialQueuedExecutorPool.getSerialQueue(sender);
        }
        return this.serialQueue;
    }

    public void setAgent(RemoteGfManagerAgent agent) {
        if (agent != null) {
            if (this.agent != null) {
                throw new IllegalStateException(LocalizedStrings.DistributionManager_THERE_IS_ALREADY_AN_ADMIN_AGENT_ASSOCIATED_WITH_THIS_DISTRIBUTION_MANAGER.toLocalizedString());
            }
        } else if (this.agent == null) {
            throw new IllegalStateException(LocalizedStrings.DistributionManager_THERE_WAS_NEVER_AN_ADMIN_AGENT_ASSOCIATED_WITH_THIS_DISTRIBUTION_MANAGER.toLocalizedString());
        }
        this.agent = agent;
    }

    public RemoteGfManagerAgent getAgent() {
        return this.agent;
    }

    public String getDistributionConfigDescription() {
        if (this.agent == null) {
            return null;
        }
        return this.agent.getTransport().toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGERS_SHOULD_NOT_BE_COPY_SHARED.toLocalizedString());
    }

    @Override
    public void readExternal(ObjectInput out) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException(LocalizedStrings.DistributionManager_DISTRIBUTIONMANAGERS_SHOULD_NOT_BE_COPY_SHARED.toLocalizedString());
    }

    public HealthMonitor getHealthMonitor(InternalDistributedMember owner) {
        return (HealthMonitor)this.hmMap.get(owner);
    }

    public void createHealthMonitor(InternalDistributedMember owner, GemFireHealthConfig cfg) {
        if (this.closeInProgress) {
            return;
        }
        HealthMonitor hm = this.getHealthMonitor(owner);
        if (hm != null) {
            hm.stop();
            this.hmMap.remove(owner);
        }
        HealthMonitorImpl newHm = new HealthMonitorImpl(owner, cfg, this);
        newHm.start();
        this.hmMap.put(owner, newHm);
    }

    public void removeHealthMonitor(InternalDistributedMember owner, int theId) {
        HealthMonitor hm = this.getHealthMonitor(owner);
        if (hm != null && hm.getId() == theId) {
            hm.stop();
            this.hmMap.remove(owner);
        }
    }

    public void removeAllHealthMonitors() {
        Iterator it = this.hmMap.values().iterator();
        while (it.hasNext()) {
            HealthMonitor hm = (HealthMonitor)it.next();
            hm.stop();
            it.remove();
        }
    }

    @Override
    public Set getAdminMemberSet() {
        return this.adminConsoles;
    }

    @Override
    public int getRoleCount(Role role) {
        int count = 0;
        Set mbrs = this.getDistributionManagerIds();
        Iterator mbrIter = mbrs.iterator();
        block0: while (mbrIter.hasNext()) {
            Set<Role> roles = ((InternalDistributedMember)mbrIter.next()).getRoles();
            for (Role mbrRole : roles) {
                if (!mbrRole.equals(role)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    @Override
    public boolean isRolePresent(Role role) {
        Set mbrs = this.getDistributionManagerIds();
        Iterator mbrIter = mbrs.iterator();
        while (mbrIter.hasNext()) {
            Set<Role> roles = ((InternalDistributedMember)mbrIter.next()).getRoles();
            for (Role mbrRole : roles) {
                if (!mbrRole.equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set getAllRoles() {
        HashSet<Role> allRoles = new HashSet<Role>();
        Set mbrs = this.getDistributionManagerIds();
        Iterator mbrIter = mbrs.iterator();
        while (mbrIter.hasNext()) {
            Set<Role> roles = ((InternalDistributedMember)mbrIter.next()).getRoles();
            for (Role mbrRole : roles) {
                allRoles.add(mbrRole);
            }
        }
        return allRoles;
    }

    @Override
    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    @Override
    public Throwable getRootCause() {
        return this.rootCause;
    }

    @Override
    public void setRootCause(Throwable t) {
        this.rootCause = t;
    }

    @Override
    public Set<InternalDistributedMember> getMembersInThisZone() {
        return this.getMembersInSameZone(this.getDistributionManagerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InternalDistributedMember> getMembersInSameZone(InternalDistributedMember targetMember) {
        HashSet<InternalDistributedMember> buddyMembers = new HashSet<InternalDistributedMember>();
        if (!this.redundancyZones.isEmpty()) {
            Map<InternalDistributedMember, String> map = this.redundancyZones;
            synchronized (map) {
                String targetZone = this.redundancyZones.get(targetMember);
                for (Map.Entry<InternalDistributedMember, String> entry : this.redundancyZones.entrySet()) {
                    if (!entry.getValue().equals(targetZone)) continue;
                    buddyMembers.add(entry.getKey());
                }
            }
        } else {
            buddyMembers.add(targetMember);
            Set<InetAddress> targetAddrs = this.getEquivalents(targetMember.getIpAddress());
            for (InternalDistributedMember o : this.getDistributionManagerIds()) {
                if (!SetUtils.intersectsWith(targetAddrs, this.getEquivalents(o.getIpAddress()))) continue;
                buddyMembers.add(o);
            }
        }
        return buddyMembers;
    }

    @Override
    public boolean areInSameZone(InternalDistributedMember member1, InternalDistributedMember member2) {
        if (!this.redundancyZones.isEmpty()) {
            String zone1 = this.redundancyZones.get(member1);
            String zone2 = this.redundancyZones.get(member2);
            return zone1 != null && zone1.equals(zone2);
        }
        return this.areOnEquivalentHost(member1, member2);
    }

    @Override
    public void acquireGIIPermitUninterruptibly() {
        this.parallelGIIs.acquireUninterruptibly();
        this.stats.incInitialImageRequestsInProgress(1);
    }

    @Override
    public void releaseGIIPermit() {
        this.stats.incInitialImageRequestsInProgress(-1);
        this.parallelGIIs.release();
    }

    public void setDistributedSystemId(int distributedSystemId) {
        if (distributedSystemId != -1) {
            this.distributedSystemId = distributedSystemId;
        }
    }

    @Override
    public int getDistributedSystemId() {
        return this.distributedSystemId;
    }

    public void printDistributedSystemStacks(boolean useNative) {
        this.printStacks(new HashSet(this.getDistributionManagerIds()), useNative);
    }

    public void printStacks(Collection ids, boolean useNative) {
        HashSet<InternalDistributedMember> requiresMessage = new HashSet<InternalDistributedMember>();
        if (ids.contains(this.myid)) {
            OSProcess.printStacks(0, useNative);
        }
        if (useNative) {
            requiresMessage.addAll(ids);
            ids.remove(this.myid);
        } else {
            for (InternalDistributedMember mbr : ids) {
                if (mbr.getProcessId() > 0 && mbr.getIpAddress().equals(this.myid.getIpAddress())) {
                    if (mbr.equals(this.myid) || OSProcess.printStacks(mbr.getProcessId(), false)) continue;
                    requiresMessage.add(mbr);
                    continue;
                }
                requiresMessage.add(mbr);
            }
        }
        if (requiresMessage.size() > 0) {
            HighPriorityAckedMessage msg = new HighPriorityAckedMessage();
            msg.dumpStacks(requiresMessage, useNative, false);
        }
    }

    @Override
    public Set<DistributedMember> getGroupMembers(String group) {
        HashSet<DistributedMember> result = null;
        for (DistributedMember m : this.getDistributionManagerIdsIncludingAdmin()) {
            if (!m.getGroups().contains(group)) continue;
            if (result == null) {
                result = new HashSet<DistributedMember>();
            }
            result.add(m);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set getNormalDistributionManagerIds() {
        Object object = this.membersLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
            for (InternalDistributedMember m : this.members.keySet()) {
                if (m.getVmKind() == 11) continue;
                result.add(m);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<InternalDistributedMember> getLocatorDistributionManagerIds() {
        Object object = this.membersLock;
        synchronized (object) {
            HashSet<InternalDistributedMember> result = new HashSet<InternalDistributedMember>();
            for (InternalDistributedMember m : this.members.keySet()) {
                if (m.getVmKind() != 11) continue;
                result.add(m);
            }
            return result;
        }
    }

    private static final class QuorumLostEvent
    extends MemberEvent {
        Set<InternalDistributedMember> failures;
        List<InternalDistributedMember> remaining;

        QuorumLostEvent(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            super(null);
            this.failures = failures;
            this.remaining = remaining;
        }

        public Set<InternalDistributedMember> getFailures() {
            return this.failures;
        }

        public List<InternalDistributedMember> getRemaining() {
            return this.remaining;
        }

        @Override
        public int eventType() {
            return 5;
        }

        public String toString() {
            return "quorum lost.  failures=" + this.failures + "; remaining=" + this.remaining;
        }
    }

    private static final class ViewInstalledEvent
    extends MemberEvent {
        NetView view;

        ViewInstalledEvent(NetView view) {
            super(null);
            this.view = view;
        }

        public long getViewId() {
            return this.view.getViewNumber();
        }

        @Override
        public int eventType() {
            return 4;
        }

        public String toString() {
            return "view installed: " + this.view;
        }
    }

    private static final class MemberSuspectEvent
    extends MemberEvent {
        InternalDistributedMember whoSuspected;

        MemberSuspectEvent(InternalDistributedMember suspect, InternalDistributedMember whoSuspected) {
            super(suspect);
            this.whoSuspected = whoSuspected;
        }

        public InternalDistributedMember whoSuspected() {
            return this.whoSuspected;
        }

        @Override
        public int eventType() {
            return 3;
        }

        public String toString() {
            return "member " + this.getId() + " suspected by: " + this.whoSuspected;
        }
    }

    private static final class MemberCrashedEvent
    extends MemberEvent {
        String reason;

        MemberCrashedEvent(InternalDistributedMember id, String r) {
            super(id);
            this.reason = r;
        }

        @Override
        public int eventType() {
            return 2;
        }

        public String toString() {
            return "member " + this.getId() + " crashed: " + this.reason;
        }
    }

    private static final class MemberDepartedEvent
    extends MemberEvent {
        String reason;

        MemberDepartedEvent(InternalDistributedMember id, String r) {
            super(id);
            this.reason = r;
        }

        @Override
        public int eventType() {
            return 1;
        }

        public String toString() {
            return "member " + this.getId() + " departed (" + this.reason + ")";
        }
    }

    private static final class MemberJoinedEvent
    extends MemberEvent {
        MemberJoinedEvent(InternalDistributedMember id) {
            super(id);
        }

        public String toString() {
            return "member " + this.getId() + " joined";
        }

        @Override
        public int eventType() {
            return 0;
        }
    }

    private static abstract class MemberEvent {
        static final int MEMBER_JOINED = 0;
        static final int MEMBER_DEPARTED = 1;
        static final int MEMBER_CRASHED = 2;
        static final int MEMBER_SUSPECT = 3;
        static final int VIEW_INSTALLED = 4;
        static final int QUORUM_LOST = 5;
        private InternalDistributedMember id;

        MemberEvent(InternalDistributedMember id) {
            this.id = id;
        }

        public InternalDistributedMember getId() {
            return this.id;
        }

        public abstract int eventType();
    }

    private final class MyListener
    implements DistributedMembershipListener {
        DistributionManager dm;

        public MyListener(DistributionManager dm) {
            this.dm = dm;
        }

        @Override
        public boolean isShutdownMsgSent() {
            return DistributionManager.this.shutdownMsgSent;
        }

        @Override
        public void membershipFailure(String reason, Throwable t) {
            DistributionManager.this.exceptionInThreads = true;
            DistributionManager.this.rootCause = t;
            DistributionManager.this.getSystem().disconnect(reason, t, true);
        }

        @Override
        public void messageReceived(DistributionMessage message) {
            DistributionManager.this.handleIncomingDMsg(message);
        }

        @Override
        public void newMemberConnected(InternalDistributedMember member, Stub stub) {
            this.dm.addNewMember(member, stub);
        }

        @Override
        public void memberDeparted(InternalDistributedMember theId, boolean crashed, String reason) {
            boolean wasAdmin = DistributionManager.this.getAdminMemberSet().contains(theId);
            if (wasAdmin) {
                AdminConsoleDisconnectMessage message = new AdminConsoleDisconnectMessage();
                message.setSender(theId);
                message.setCrashed(crashed);
                message.setAlertListenerExpected(true);
                message.setIgnoreAlertListenerRemovalFailure(true);
                message.setRecipient(DistributionManager.this.myid);
                message.setReason(reason);
                DistributionManager.this.handleIncomingDMsg(message);
            }
            this.dm.handleManagerDeparture(theId, crashed, reason);
        }

        @Override
        public void memberSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected) {
            this.dm.handleManagerSuspect(suspect, whoSuspected);
        }

        @Override
        public void viewInstalled(NetView view) {
            this.processElderSelection();
            this.dm.handleViewInstalled(view);
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            this.dm.handleQuorumLost(failures, remaining);
        }

        @Override
        public DistributionManager getDM() {
            return this.dm;
        }

        private void processElderSelection() {
            try {
                this.dm.selectElder();
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }
    }

    private static final class MembershipListenersLock {
        protected MembershipListenersLock() {
        }
    }

    private static final class MembersLock {
        protected MembersLock() {
        }
    }

    private static class SerialQueuedExecutorPool {
        ConcurrentMap serialQueuedExecutorMap = new ConcurrentHashMap(MAX_SERIAL_QUEUE_THREAD);
        Map serialQueuedMap = new HashMap(MAX_SERIAL_QUEUE_THREAD);
        Map senderToSerialQueueIdMap = new HashMap();
        ArrayList threadMarkedForUse = new ArrayList();
        DistributionStats stats;
        ThreadGroup threadGroup;

        SerialQueuedExecutorPool(ThreadGroup group, DistributionStats stats) {
            this.threadGroup = group;
            this.stats = stats;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer getQueueId(InternalDistributedMember sender, boolean createNew) {
            Integer queueId;
            Map map = this.senderToSerialQueueIdMap;
            synchronized (map) {
                queueId = (Integer)this.senderToSerialQueueIdMap.get(sender);
                if (!createNew || queueId != null) {
                    return queueId;
                }
                if (!this.threadMarkedForUse.isEmpty()) {
                    queueId = (Integer)this.threadMarkedForUse.remove(0);
                }
                if (queueId == null) {
                    queueId = (this.serialQueuedExecutorMap.size() + 1) % MAX_SERIAL_QUEUE_THREAD;
                }
                this.senderToSerialQueueIdMap.put(sender, queueId);
            }
            return queueId;
        }

        public ThrottlingMemLinkedQueueWithDMStats getSerialQueue(InternalDistributedMember sender) {
            Integer queueId = this.getQueueId(sender, false);
            if (queueId == null) {
                return null;
            }
            return (ThrottlingMemLinkedQueueWithDMStats)this.serialQueuedMap.get(queueId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SerialQueuedExecutorWithDMStats getThrottledSerialExecutor(InternalDistributedMember sender) {
            SerialQueuedExecutorWithDMStats executor = this.getSerialExecutor(sender);
            int totalSerialQueueMemSize = this.stats.getSerialQueueBytes();
            if (this.stats.getSerialQueueBytes() > TOTAL_SERIAL_QUEUE_THROTTLE && !DistributionMessage.isPreciousThread()) {
                do {
                    boolean interrupted = Thread.interrupted();
                    try {
                        float throttlePercent = (float)(totalSerialQueueMemSize - TOTAL_SERIAL_QUEUE_THROTTLE) / (float)(TOTAL_SERIAL_QUEUE_BYTE_LIMIT - TOTAL_SERIAL_QUEUE_THROTTLE);
                        int sleep = (int)(100.0 * (double)throttlePercent);
                        sleep = Math.max(sleep, 1);
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                    }
                    finally {
                        if (interrupted) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.stats.getSerialQueueHelper().incThrottleCount();
                } while (this.stats.getSerialQueueBytes() >= TOTAL_SERIAL_QUEUE_BYTE_LIMIT);
            }
            return executor;
        }

        public SerialQueuedExecutorWithDMStats getSerialExecutor(InternalDistributedMember sender) {
            SerialQueuedExecutorWithDMStats executor = null;
            Integer queueId = this.getQueueId(sender, true);
            executor = (SerialQueuedExecutorWithDMStats)this.serialQueuedExecutorMap.get(queueId);
            if (executor != null) {
                return executor;
            }
            executor = this.createSerialExecutor(queueId);
            this.serialQueuedExecutorMap.put(queueId, executor);
            if (logger.isDebugEnabled()) {
                logger.debug("Created Serial Queued Executor With queueId {}. Total number of live Serial Threads :{}", queueId, this.serialQueuedExecutorMap.size());
            }
            this.stats.incSerialPooledThread();
            return executor;
        }

        private SerialQueuedExecutorWithDMStats createSerialExecutor(final Integer id) {
            OverflowQueueWithDMStats poolQueue = SERIAL_QUEUE_BYTE_LIMIT == 0 ? new OverflowQueueWithDMStats(this.stats.getSerialQueueHelper()) : new ThrottlingMemLinkedQueueWithDMStats(SERIAL_QUEUE_BYTE_LIMIT, SERIAL_QUEUE_THROTTLE, SERIAL_QUEUE_SIZE_LIMIT, SERIAL_QUEUE_SIZE_THROTTLE, this.stats.getSerialQueueHelper());
            this.serialQueuedMap.put(id, poolQueue);
            ThreadFactory tf = new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable command) {
                    SerialQueuedExecutorPool.this.stats.incSerialPooledThreadStarts();
                    Runnable r = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ConnectionTable.threadWantsSharedResources();
                            Connection.makeReaderThread();
                            try {
                                command.run();
                            }
                            finally {
                                ConnectionTable.releaseThreadsSockets();
                            }
                        }
                    };
                    Thread thread = new Thread(SerialQueuedExecutorPool.this.threadGroup, r, "Pooled Serial Message Processor " + id);
                    thread.setDaemon(true);
                    return thread;
                }
            };
            return new SerialQueuedExecutorWithDMStats(poolQueue, this.stats.getSerialPooledProcessorHelper(), tf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMemberDeparture(InternalDistributedMember member) {
            Integer queueId = this.getQueueId(member, false);
            if (queueId == null) {
                return;
            }
            boolean isUsed = false;
            Map map = this.senderToSerialQueueIdMap;
            synchronized (map) {
                this.senderToSerialQueueIdMap.remove(member);
                for (Integer value2 : this.senderToSerialQueueIdMap.values()) {
                    if (!value2.equals(queueId)) continue;
                    isUsed = true;
                    break;
                }
                if (!isUsed) {
                    if (logger.isInfoEnabled(LogMarker.DM)) {
                        logger.info(LogMarker.DM, LocalizedMessage.create(LocalizedStrings.DistributionManager_MARKING_THE_SERIALQUEUEDEXECUTOR_WITH_ID__0__USED_BY_THE_MEMBER__1__TO_BE_UNUSED, new Object[]{queueId, member}));
                    }
                    this.threadMarkedForUse.add(queueId);
                }
            }
        }

        public void awaitTermination(long time, TimeUnit unit) throws InterruptedException {
            long timeNanos;
            long remainingNanos = timeNanos = unit.toNanos(time);
            long start = System.nanoTime();
            for (ExecutorService executor : this.serialQueuedExecutorMap.values()) {
                executor.awaitTermination(remainingNanos, TimeUnit.NANOSECONDS);
                timeNanos = System.nanoTime() - start;
                remainingNanos = timeNanos;
                if (remainingNanos > 0L) continue;
                return;
            }
        }

        protected void shutdown() {
            for (ExecutorService executor : this.serialQueuedExecutorMap.values()) {
                executor.shutdown();
            }
        }
    }

    protected class MemberEventInvoker
    implements Runnable {
        protected MemberEventInvoker() {
        }

        @Override
        public void run() {
            while (true) {
                SystemFailure.checkFailure();
                if (!((DistributionManager)DistributionManager.this).system.isConnected && DistributionManager.this.isClosed()) break;
                try {
                    MemberEvent ev = (MemberEvent)DistributionManager.this.membershipEventQueue.take();
                    DistributionManager.this.handleMemberEvent(ev);
                    continue;
                }
                catch (InterruptedException e) {
                    if (DistributionManager.this.closeInProgress) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: InterruptedException during shutdown");
                        break;
                    }
                    logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_INTERRUPTEDEXCEPTION), (Throwable)e);
                }
                catch (DistributedSystemDisconnectedException e) {
                }
                catch (CancelException e) {
                    if (DistributionManager.this.closeInProgress) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace("MemberEventInvoker: cancelled");
                        break;
                    }
                    logger.warn(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNEXPECTED_CANCELLATION), (Throwable)e);
                }
                catch (Exception e) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.DistributionManager_UNCAUGHT_EXCEPTION_PROCESSING_MEMBER_EVENT), (Throwable)e);
                    continue;
                }
                break;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("MemberEventInvoker on {} stopped", DistributionManager.this);
            }
        }
    }

    private static class Stopper
    extends CancelCriterion {
        private DistributionManager dm;

        Stopper(DistributionManager dm) {
            this.dm = dm;
        }

        @Override
        public String cancelInProgress() {
            this.checkFailure();
            if (this.dm.shutdownMsgSent) {
                return LocalizedStrings.DistributionManager__0_MESSAGE_DISTRIBUTION_HAS_TERMINATED.toLocalizedString(this.dm.toString());
            }
            if (this.dm.rootCause != null) {
                return this.dm.toString() + ": " + this.dm.rootCause.getMessage();
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            String reason = this.cancelInProgress();
            if (reason == null) {
                return null;
            }
            Throwable rc = this.dm.rootCause;
            if (rc == null) {
                return new DistributedSystemDisconnectedException(reason, e);
            }
            if (e == null) {
                return new DistributedSystemDisconnectedException(reason, rc);
            }
            Throwable nt = e;
            while (nt.getCause() != null) {
                nt = nt.getCause();
            }
            if (nt == rc) {
                return new DistributedSystemDisconnectedException(reason, e);
            }
            try {
                nt.initCause(rc);
                return new DistributedSystemDisconnectedException(reason, e);
            }
            catch (IllegalStateException e2) {
                return new DistributedSystemDisconnectedException(reason, rc);
            }
        }
    }
}

