/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.org.jgroups.conf.XmlConfigurator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class DistributionManagerConfig {
    public static final String FILE_NAME = "javagroups.xml";
    private String string;

    static DistributionManagerConfig getConfig(File dir) {
        if (!dir.exists()) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionManagerConfig_CANNOT_READ_DISTRIBUTION_MANAGER_CONFIG_DIRECTORY_0_DOES_NOT_EXIST.toLocalizedString(dir));
        }
        File file = new File(dir, FILE_NAME);
        if (!file.exists()) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionManagerConfig_CANNOT_READ_DISTRIBUTION_MANAGER_CONFIG_CONFIGURATION_FILE_0_DOES_NOT_EXIST.toLocalizedString(file));
        }
        try {
            return DistributionManagerConfig.parse(file);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(LocalizedStrings.DistributionManagerConfig_WHILE_PARSING_0_1.toLocalizedString(file, ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DistributionManagerConfig parse(File file) throws IOException {
        DistributionManagerConfig config = new DistributionManagerConfig();
        try (FileInputStream fis = new FileInputStream(file);){
            XmlConfigurator conf = XmlConfigurator.getInstance(fis);
            config.string = conf.getProtocolStackString();
        }
        return config;
    }

    String asString() {
        return this.string;
    }
}

