/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.PoolStatHelper;
import com.gemstone.gemfire.distributed.internal.QueueStatHelper;
import com.gemstone.gemfire.distributed.internal.ThrottledMemQueueStatHelper;
import com.gemstone.gemfire.distributed.internal.ThrottledQueueStatHelper;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.tcp.Buffers;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import org.apache.logging.log4j.Logger;

public class DistributionStats
implements DMStats {
    private static final Logger logger = LogService.getLogger();
    public static boolean enableClockStats = false;
    private static final StatisticsType type;
    private static final int sentMessagesId;
    private static final int sentCommitMessagesId;
    private static final int commitWaitsId;
    private static final int sentMessagesTimeId;
    private static final int sentMessagesMaxTimeId;
    private static final int broadcastMessagesId;
    private static final int broadcastMessagesTimeId;
    private static final int receivedMessagesId;
    private static final int receivedBytesId;
    private static final int sentBytesId;
    private static final int processedMessagesId;
    private static final int processedMessagesTimeId;
    private static final int messageProcessingScheduleTimeId;
    private static final int messageChannelTimeId;
    private static final int replyMessageTimeId;
    private static final int distributeMessageTimeId;
    private static final int nodesId;
    private static final int overflowQueueSizeId;
    private static final int processingThreadsId;
    private static final int serialThreadsId;
    private static final int waitingThreadsId;
    private static final int highPriorityThreadsId;
    private static final int partitionedRegionThreadsId;
    private static final int functionExecutionThreadsId;
    private static final int partitionedRegionThreadJobsId;
    private static final int functionExecutionThreadJobsId;
    private static final int waitingQueueSizeId;
    private static final int overflowQueueThrottleTimeId;
    private static final int overflowQueueThrottleCountId;
    private static final int highPriorityQueueSizeId;
    private static final int highPriorityQueueThrottleTimeId;
    private static final int highPriorityQueueThrottleCountId;
    private static final int partitionedRegionQueueSizeId;
    private static final int partitionedRegionQueueThrottleTimeId;
    private static final int partitionedRegionQueueThrottleCountId;
    private static final int functionExecutionQueueSizeId;
    private static final int functionExecutionQueueThrottleCountId;
    private static final int functionExecutionQueueThrottleTimeId;
    private static final int serialQueueSizeId;
    private static final int serialQueueBytesId;
    private static final int serialPooledThreadId;
    private static final int serialQueueThrottleTimeId;
    private static final int serialQueueThrottleCountId;
    private static final int replyWaitsInProgressId;
    private static final int replyWaitsCompletedId;
    private static final int replyWaitTimeId;
    private static final int replyTimeoutsId;
    private static final int replyWaitMaxTimeId;
    private static final int receiverConnectionsId;
    private static final int failedAcceptsId;
    private static final int failedConnectsId;
    private static final int reconnectAttemptsId;
    private static final int lostConnectionLeaseId;
    private static final int sharedOrderedSenderConnectionsId;
    private static final int sharedUnorderedSenderConnectionsId;
    private static final int threadOrderedSenderConnectionsId;
    private static final int threadUnorderedSenderConnectionsId;
    private static final int syncSocketWritesInProgressId;
    private static final int syncSocketWriteTimeId;
    private static final int syncSocketWritesId;
    private static final int syncSocketWriteBytesId;
    private static final int ucastReadsId;
    private static final int ucastReadBytesId;
    private static final int ucastWriteTimeId;
    private static final int ucastWritesId;
    private static final int ucastWriteBytesId;
    private static final int ucastRetransmitsId;
    private static final int mcastReadsId;
    private static final int mcastReadBytesId;
    private static final int mcastWriteTimeId;
    private static final int mcastWritesId;
    private static final int mcastWriteBytesId;
    private static final int mcastRetransmitsId;
    private static final int mcastRetransmitRequestsId;
    private static final int serializationTimeId;
    private static final int serializationsId;
    private static final int serializedBytesId;
    private static final int pdxSerializationsId;
    private static final int pdxSerializedBytesId;
    private static final int deserializationTimeId;
    private static final int deserializationsId;
    private static final int deserializedBytesId;
    private static final int pdxDeserializationsId;
    private static final int pdxDeserializedBytesId;
    private static final int pdxInstanceDeserializationsId;
    private static final int pdxInstanceDeserializationTimeId;
    private static final int pdxInstanceCreationsId;
    private static final int msgSerializationTimeId;
    private static final int msgDeserializationTimeId;
    private static final int batchSendTimeId;
    private static final int batchCopyTimeId;
    private static final int batchWaitTimeId;
    private static final int batchFlushTimeId;
    private static final int ucastFlushesId;
    private static final int ucastFlushTimeId;
    private static final int flowControlWaitsInProgressId;
    private static final int flowControlThrottleWaitsInProgressId;
    private static final int flowControlRequestsId;
    private static final int flowControlResponsesId;
    private static final int jgUNICASTdataReceivedTimeId;
    private static final int jgReceivedMessagesSizeId;
    private static final int jgQueuedMessagesSizeId;
    private static final int jgSentMessagesPoolSizeId;
    private static final int jgUcastReceivedMessagesSizeId;
    private static final int jgUcastSentMessagesSizeId;
    private static final int jgUcastSentHighPriorityMessagesSizeId;
    private static final int jgSTABLEsuspendTimeId;
    private static final int jgSTABLEmessagesId;
    private static final int jgSTABLEmessagesSentId;
    private static final int jgSTABILITYmessagesId;
    private static final int jgDownTimeId;
    private static final int jgUpTimeId;
    private static final int jChannelUpTimeId;
    private static final int jgFCsendBlocksId;
    private static final int jgFCautoRequestsId;
    private static final int jgFCreplenishId;
    private static final int jgFCresumesId;
    private static final int jgFCsentCreditsId;
    private static final int jgFCsentThrottleRequestsId;
    private static final int jgNAKACKwaitsId;
    private static final int threadOwnedReceiversId;
    private static final int threadOwnedReceiversId2;
    private static final int jgFragmentationsPerformedId;
    private static final int jgFragmentsCreatedId;
    private static final int asyncSocketWritesInProgressId;
    private static final int asyncSocketWritesId;
    private static final int asyncSocketWriteRetriesId;
    private static final int asyncSocketWriteTimeId;
    private static final int asyncSocketWriteBytesId;
    private static final int socketLocksInProgressId;
    private static final int socketLocksId;
    private static final int socketLockTimeId;
    private static final int bufferAcquiresInProgressId;
    private static final int bufferAcquiresId;
    private static final int bufferAcquireTimeId;
    private static final int asyncQueueAddTimeId;
    private static final int asyncQueueRemoveTimeId;
    private static final int asyncQueuesId;
    private static final int asyncQueueFlushesInProgressId;
    private static final int asyncQueueFlushesCompletedId;
    private static final int asyncQueueFlushTimeId;
    private static final int asyncQueueTimeoutExceededId;
    private static final int asyncQueueSizeExceededId;
    private static final int asyncDistributionTimeoutExceededId;
    private static final int asyncQueueSizeId;
    private static final int asyncQueuedMsgsId;
    private static final int asyncDequeuedMsgsId;
    private static final int asyncConflatedMsgsId;
    private static final int asyncThreadsId;
    private static final int asyncThreadInProgressId;
    private static final int asyncThreadCompletedId;
    private static final int asyncThreadTimeId;
    private static final int receiverDirectBufferSizeId;
    private static final int receiverHeapBufferSizeId;
    private static final int senderDirectBufferSizeId;
    private static final int senderHeapBufferSizeId;
    private static final int messagesBeingReceivedId;
    private static final int messageBytesBeingReceivedId;
    private static final int serialThreadStartsId;
    private static final int viewThreadStartsId;
    private static final int processingThreadStartsId;
    private static final int highPriorityThreadStartsId;
    private static final int waitingThreadStartsId;
    private static final int partitionedRegionThreadStartsId;
    private static final int functionExecutionThreadStartsId;
    private static final int serialPooledThreadStartsId;
    private static final int TOSentMsgId;
    private static final int replyHandoffTimeId;
    private static final int viewThreadsId;
    private static final int serialThreadJobsId;
    private static final int viewProcessorThreadJobsId;
    private static final int serialPooledThreadJobsId;
    private static final int pooledMessageThreadJobsId;
    private static final int highPriorityThreadJobsId;
    private static final int waitingPoolThreadJobsId;
    private static final int eldersId;
    private static final int initialImageMessagesInFlightId;
    private static final int initialImageRequestsInProgressId;
    private final Statistics stats;

    public DistributionStats(StatisticsFactory f, long statId) {
        this.stats = f.createAtomicStatistics(type, "distributionStats", statId);
        Buffers.initBufferStats(this);
    }

    public DistributionStats(Statistics stats) {
        this.stats = stats;
    }

    public static long getStatTime() {
        return enableClockStats ? NanoTimer.getTime() : 0L;
    }

    public void close() {
        this.stats.close();
    }

    @Override
    public long getSentMessages() {
        return this.stats.getLong(sentMessagesId);
    }

    @Override
    public void incTOSentMsg() {
        this.stats.incLong(TOSentMsgId, 1L);
    }

    @Override
    public long getSentCommitMessages() {
        return this.stats.getLong(sentCommitMessagesId);
    }

    @Override
    public long getCommitWaits() {
        return this.stats.getLong(commitWaitsId);
    }

    @Override
    public void incSentMessages(long messages) {
        this.stats.incLong(sentMessagesId, messages);
    }

    @Override
    public void incSentCommitMessages(long messages) {
        this.stats.incLong(sentCommitMessagesId, messages);
    }

    @Override
    public void incCommitWaits() {
        this.stats.incLong(commitWaitsId, 1L);
    }

    @Override
    public long getSentMessagesTime() {
        return this.stats.getLong(sentMessagesTimeId);
    }

    @Override
    public void incSentMessagesTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(sentMessagesTimeId, nanos);
            long millis = nanos / 1000000L;
            if (this.getSentMessagesMaxTime() < millis) {
                this.stats.setLong(sentMessagesMaxTimeId, millis);
            }
        }
    }

    public long getSentMessagesMaxTime() {
        return this.stats.getLong(sentMessagesMaxTimeId);
    }

    @Override
    public long getBroadcastMessages() {
        return this.stats.getLong(broadcastMessagesId);
    }

    @Override
    public void incBroadcastMessages(long messages) {
        this.stats.incLong(broadcastMessagesId, messages);
    }

    @Override
    public long getBroadcastMessagesTime() {
        return this.stats.getLong(broadcastMessagesTimeId);
    }

    @Override
    public void incBroadcastMessagesTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(broadcastMessagesTimeId, nanos);
        }
    }

    @Override
    public long getReceivedMessages() {
        return this.stats.getLong(receivedMessagesId);
    }

    @Override
    public void incReceivedMessages(long messages) {
        this.stats.incLong(receivedMessagesId, messages);
    }

    @Override
    public long getReceivedBytes() {
        return this.stats.getLong(receivedBytesId);
    }

    @Override
    public void incReceivedBytes(long bytes) {
        this.stats.incLong(receivedBytesId, bytes);
    }

    @Override
    public void incSentBytes(long bytes) {
        this.stats.incLong(sentBytesId, bytes);
    }

    @Override
    public long getProcessedMessages() {
        return this.stats.getLong(processedMessagesId);
    }

    @Override
    public void incProcessedMessages(long messages) {
        this.stats.incLong(processedMessagesId, messages);
    }

    @Override
    public long getProcessedMessagesTime() {
        return this.stats.getLong(processedMessagesTimeId);
    }

    @Override
    public void incProcessedMessagesTime(long start) {
        if (enableClockStats) {
            this.stats.incLong(processedMessagesTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public long getMessageProcessingScheduleTime() {
        return this.stats.getLong(messageProcessingScheduleTimeId);
    }

    @Override
    public void incMessageProcessingScheduleTime(long elapsed) {
        if (enableClockStats) {
            this.stats.incLong(messageProcessingScheduleTimeId, elapsed);
        }
    }

    @Override
    public int getOverflowQueueSize() {
        return this.stats.getInt(overflowQueueSizeId);
    }

    @Override
    public void incOverflowQueueSize(int messages) {
        this.stats.incInt(overflowQueueSizeId, messages);
    }

    protected void incWaitingQueueSize(int messages) {
        this.stats.incInt(waitingQueueSizeId, messages);
    }

    protected void incOverflowQueueThrottleCount(int delays) {
        this.stats.incInt(overflowQueueThrottleCountId, delays);
    }

    protected void incOverflowQueueThrottleTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(overflowQueueThrottleTimeId, nanos);
        }
    }

    protected void incHighPriorityQueueSize(int messages) {
        this.stats.incInt(highPriorityQueueSizeId, messages);
    }

    protected void incHighPriorityQueueThrottleCount(int delays) {
        this.stats.incInt(highPriorityQueueThrottleCountId, delays);
    }

    protected void incHighPriorityQueueThrottleTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(highPriorityQueueThrottleTimeId, nanos);
        }
    }

    protected void incPartitionedRegionQueueSize(int messages) {
        this.stats.incInt(partitionedRegionQueueSizeId, messages);
    }

    protected void incPartitionedRegionQueueThrottleCount(int delays) {
        this.stats.incInt(partitionedRegionQueueThrottleCountId, delays);
    }

    protected void incPartitionedRegionQueueThrottleTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(partitionedRegionQueueThrottleTimeId, nanos);
        }
    }

    protected void incFunctionExecutionQueueSize(int messages) {
        this.stats.incInt(functionExecutionQueueSizeId, messages);
    }

    protected void incFunctionExecutionQueueThrottleCount(int delays) {
        this.stats.incInt(functionExecutionQueueThrottleCountId, delays);
    }

    protected void incFunctionExecutionQueueThrottleTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(functionExecutionQueueThrottleTimeId, nanos);
        }
    }

    protected void incSerialQueueSize(int messages) {
        this.stats.incInt(serialQueueSizeId, messages);
    }

    protected void incSerialQueueBytes(int amount) {
        this.stats.incInt(serialQueueBytesId, amount);
    }

    public int getSerialQueueBytes() {
        return this.stats.getInt(serialQueueBytesId);
    }

    protected void incSerialPooledThread() {
        this.stats.incInt(serialPooledThreadId, 1);
    }

    protected void incSerialQueueThrottleCount(int delays) {
        this.stats.incInt(serialQueueThrottleCountId, delays);
    }

    protected void incSerialQueueThrottleTime(long nanos) {
        if (enableClockStats) {
            this.stats.incLong(serialQueueThrottleTimeId, nanos);
        }
    }

    @Override
    public int getNumProcessingThreads() {
        return this.stats.getInt(processingThreadsId);
    }

    @Override
    public void incNumProcessingThreads(int threads) {
        this.stats.incInt(processingThreadsId, threads);
    }

    @Override
    public int getNumSerialThreads() {
        return this.stats.getInt(serialThreadsId);
    }

    @Override
    public void incNumSerialThreads(int threads) {
        this.stats.incInt(serialThreadsId, threads);
    }

    protected void incWaitingThreads(int threads) {
        this.stats.incInt(waitingThreadsId, threads);
    }

    protected void incHighPriorityThreads(int threads) {
        this.stats.incInt(highPriorityThreadsId, threads);
    }

    protected void incPartitionedRegionThreads(int threads) {
        this.stats.incInt(partitionedRegionThreadsId, threads);
    }

    protected void incFunctionExecutionThreads(int threads) {
        this.stats.incInt(functionExecutionThreadsId, threads);
    }

    @Override
    public void incMessageChannelTime(long delta) {
        if (enableClockStats) {
            this.stats.incLong(messageChannelTimeId, delta);
        }
    }

    @Override
    public long getReplyMessageTime() {
        return this.stats.getLong(replyMessageTimeId);
    }

    @Override
    public void incReplyMessageTime(long val) {
        if (enableClockStats) {
            this.stats.incLong(replyMessageTimeId, val);
        }
    }

    @Override
    public long getDistributeMessageTime() {
        return this.stats.getLong(distributeMessageTimeId);
    }

    @Override
    public void incDistributeMessageTime(long val) {
        if (enableClockStats) {
            this.stats.incLong(distributeMessageTimeId, val);
        }
    }

    @Override
    public int getNodes() {
        return this.stats.getInt(nodesId);
    }

    @Override
    public void setNodes(int val) {
        this.stats.setInt(nodesId, val);
    }

    @Override
    public void incNodes(int val) {
        this.stats.incInt(nodesId, val);
    }

    @Override
    public int getReplyWaitsInProgress() {
        return this.stats.getInt(replyWaitsInProgressId);
    }

    @Override
    public int getReplyWaitsCompleted() {
        return this.stats.getInt(replyWaitsCompletedId);
    }

    @Override
    public long getReplyWaitTime() {
        return this.stats.getLong(replyWaitTimeId);
    }

    public long getReplyWaitMaxTime() {
        return this.stats.getLong(replyWaitMaxTimeId);
    }

    @Override
    public long startSocketWrite(boolean sync) {
        if (sync) {
            this.stats.incInt(syncSocketWritesInProgressId, 1);
        } else {
            this.stats.incInt(asyncSocketWritesInProgressId, 1);
        }
        return DistributionStats.getStatTime();
    }

    @Override
    public void endSocketWrite(boolean sync, long start, int bytesWritten, int retries) {
        long now = DistributionStats.getStatTime();
        if (sync) {
            this.stats.incInt(syncSocketWritesInProgressId, -1);
            this.stats.incInt(syncSocketWritesId, 1);
            this.stats.incLong(syncSocketWriteBytesId, (long)bytesWritten);
            if (enableClockStats) {
                this.stats.incLong(syncSocketWriteTimeId, now - start);
            }
        } else {
            this.stats.incInt(asyncSocketWritesInProgressId, -1);
            this.stats.incInt(asyncSocketWritesId, 1);
            if (retries != 0) {
                this.stats.incInt(asyncSocketWriteRetriesId, retries);
            }
            this.stats.incLong(asyncSocketWriteBytesId, (long)bytesWritten);
            if (enableClockStats) {
                this.stats.incLong(asyncSocketWriteTimeId, now - start);
            }
        }
    }

    @Override
    public long startSocketLock() {
        this.stats.incInt(socketLocksInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endSocketLock(long start) {
        long ts = DistributionStats.getStatTime();
        this.stats.incInt(socketLocksInProgressId, -1);
        this.stats.incInt(socketLocksId, 1);
        this.stats.incLong(socketLockTimeId, ts - start);
    }

    @Override
    public long startBufferAcquire() {
        this.stats.incInt(bufferAcquiresInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endBufferAcquire(long start) {
        long ts = DistributionStats.getStatTime();
        this.stats.incInt(bufferAcquiresInProgressId, -1);
        this.stats.incInt(bufferAcquiresId, 1);
        this.stats.incLong(bufferAcquireTimeId, ts - start);
    }

    @Override
    public long startUcastWrite() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endUcastWrite(long start, int bytesWritten) {
        if (enableClockStats) {
            this.stats.incLong(ucastWriteTimeId, DistributionStats.getStatTime() - start);
        }
        this.stats.incInt(ucastWritesId, 1);
        this.stats.incLong(ucastWriteBytesId, (long)bytesWritten);
    }

    @Override
    public long startMcastWrite() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endMcastWrite(long start, int bytesWritten) {
        this.stats.incInt(mcastWritesId, 1);
        if (enableClockStats) {
            this.stats.incLong(mcastWriteTimeId, DistributionStats.getStatTime() - start);
        }
        this.stats.incLong(mcastWriteBytesId, (long)bytesWritten);
    }

    @Override
    public int getMcastWrites() {
        return this.stats.getInt(mcastWritesId);
    }

    @Override
    public void incMcastReadBytes(long amount) {
        this.stats.incInt(mcastReadsId, 1);
        this.stats.incLong(mcastReadBytesId, amount);
    }

    @Override
    public void incUcastReadBytes(long amount) {
        this.stats.incInt(ucastReadsId, 1);
        this.stats.incLong(ucastReadBytesId, amount);
    }

    @Override
    public long startSerialization() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endSerialization(long start, int bytes) {
        if (enableClockStats) {
            this.stats.incLong(serializationTimeId, DistributionStats.getStatTime() - start);
        }
        this.stats.incInt(serializationsId, 1);
        this.stats.incLong(serializedBytesId, (long)bytes);
    }

    @Override
    public long startPdxInstanceDeserialization() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endPdxInstanceDeserialization(long start) {
        if (enableClockStats) {
            this.stats.incLong(pdxInstanceDeserializationTimeId, DistributionStats.getStatTime() - start);
        }
        this.stats.incInt(pdxInstanceDeserializationsId, 1);
    }

    @Override
    public void incPdxSerialization(int bytes) {
        this.stats.incInt(pdxSerializationsId, 1);
        this.stats.incLong(pdxSerializedBytesId, (long)bytes);
    }

    @Override
    public void incPdxDeserialization(int bytes) {
        this.stats.incInt(pdxDeserializationsId, 1);
        this.stats.incLong(pdxDeserializedBytesId, (long)bytes);
    }

    @Override
    public void incPdxInstanceCreations() {
        this.stats.incInt(pdxInstanceCreationsId, 1);
    }

    @Override
    public long startDeserialization() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endDeserialization(long start, int bytes) {
        if (enableClockStats) {
            this.stats.incLong(deserializationTimeId, DistributionStats.getStatTime() - start);
        }
        this.stats.incInt(deserializationsId, 1);
        this.stats.incLong(deserializedBytesId, (long)bytes);
    }

    @Override
    public long startMsgSerialization() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endMsgSerialization(long start) {
        if (enableClockStats) {
            this.stats.incLong(msgSerializationTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public long startMsgDeserialization() {
        return DistributionStats.getStatTime();
    }

    @Override
    public void endMsgDeserialization(long start) {
        if (enableClockStats) {
            this.stats.incLong(msgDeserializationTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public long startReplyWait() {
        this.stats.incInt(replyWaitsInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endReplyWait(long startNanos, long initTime) {
        long mswait;
        if (enableClockStats) {
            this.stats.incLong(replyWaitTimeId, DistributionStats.getStatTime() - startNanos);
        }
        if (initTime != 0L && (mswait = System.currentTimeMillis() - initTime) > this.getReplyWaitMaxTime()) {
            this.stats.setLong(replyWaitMaxTimeId, mswait);
        }
        this.stats.incInt(replyWaitsInProgressId, -1);
        this.stats.incInt(replyWaitsCompletedId, 1);
        Breadcrumbs.setSendSide(null);
        Breadcrumbs.setProblem(null);
    }

    @Override
    public void incReplyTimeouts() {
        this.stats.incLong(replyTimeoutsId, 1L);
    }

    @Override
    public long getReplyTimeouts() {
        return this.stats.getLong(replyTimeoutsId);
    }

    @Override
    public void incReceivers() {
        this.stats.incInt(receiverConnectionsId, 1);
    }

    @Override
    public void decReceivers() {
        this.stats.incInt(receiverConnectionsId, -1);
    }

    @Override
    public void incFailedAccept() {
        this.stats.incInt(failedAcceptsId, 1);
    }

    @Override
    public void incFailedConnect() {
        this.stats.incInt(failedConnectsId, 1);
    }

    @Override
    public void incReconnectAttempts() {
        this.stats.incInt(reconnectAttemptsId, 1);
    }

    @Override
    public void incLostLease() {
        this.stats.incInt(lostConnectionLeaseId, 1);
    }

    @Override
    public void incSenders(boolean shared, boolean preserveOrder) {
        if (shared) {
            if (preserveOrder) {
                this.stats.incInt(sharedOrderedSenderConnectionsId, 1);
            } else {
                this.stats.incInt(sharedUnorderedSenderConnectionsId, 1);
            }
        } else if (preserveOrder) {
            this.stats.incInt(threadOrderedSenderConnectionsId, 1);
        } else {
            this.stats.incInt(threadUnorderedSenderConnectionsId, 1);
        }
    }

    @Override
    public int getSendersSU() {
        return this.stats.getInt(sharedUnorderedSenderConnectionsId);
    }

    @Override
    public void decSenders(boolean shared, boolean preserveOrder) {
        if (shared) {
            if (preserveOrder) {
                this.stats.incInt(sharedOrderedSenderConnectionsId, -1);
            } else {
                this.stats.incInt(sharedUnorderedSenderConnectionsId, -1);
            }
        } else if (preserveOrder) {
            this.stats.incInt(threadOrderedSenderConnectionsId, -1);
        } else {
            this.stats.incInt(threadUnorderedSenderConnectionsId, -1);
        }
    }

    @Override
    public int getAsyncSocketWritesInProgress() {
        return this.stats.getInt(asyncSocketWritesInProgressId);
    }

    @Override
    public int getAsyncSocketWrites() {
        return this.stats.getInt(asyncSocketWritesId);
    }

    @Override
    public int getAsyncSocketWriteRetries() {
        return this.stats.getInt(asyncSocketWriteRetriesId);
    }

    @Override
    public long getAsyncSocketWriteBytes() {
        return this.stats.getLong(asyncSocketWriteBytesId);
    }

    @Override
    public long getAsyncSocketWriteTime() {
        return this.stats.getLong(asyncSocketWriteTimeId);
    }

    @Override
    public long getAsyncQueueAddTime() {
        return this.stats.getLong(asyncQueueAddTimeId);
    }

    @Override
    public void incAsyncQueueAddTime(long inc) {
        if (enableClockStats) {
            this.stats.incLong(asyncQueueAddTimeId, inc);
        }
    }

    @Override
    public long getAsyncQueueRemoveTime() {
        return this.stats.getLong(asyncQueueRemoveTimeId);
    }

    @Override
    public void incAsyncQueueRemoveTime(long inc) {
        if (enableClockStats) {
            this.stats.incLong(asyncQueueRemoveTimeId, inc);
        }
    }

    @Override
    public int getAsyncQueues() {
        return this.stats.getInt(asyncQueuesId);
    }

    @Override
    public void incAsyncQueues(int inc) {
        this.stats.incInt(asyncQueuesId, inc);
    }

    @Override
    public int getAsyncQueueFlushesInProgress() {
        return this.stats.getInt(asyncQueueFlushesInProgressId);
    }

    @Override
    public int getAsyncQueueFlushesCompleted() {
        return this.stats.getInt(asyncQueueFlushesCompletedId);
    }

    @Override
    public long getAsyncQueueFlushTime() {
        return this.stats.getLong(asyncQueueFlushTimeId);
    }

    @Override
    public long startAsyncQueueFlush() {
        this.stats.incInt(asyncQueueFlushesInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endAsyncQueueFlush(long start) {
        this.stats.incInt(asyncQueueFlushesInProgressId, -1);
        this.stats.incInt(asyncQueueFlushesCompletedId, 1);
        if (enableClockStats) {
            this.stats.incLong(asyncQueueFlushTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public int getAsyncQueueTimeouts() {
        return this.stats.getInt(asyncQueueTimeoutExceededId);
    }

    @Override
    public void incAsyncQueueTimeouts(int inc) {
        this.stats.incInt(asyncQueueTimeoutExceededId, inc);
    }

    @Override
    public int getAsyncQueueSizeExceeded() {
        return this.stats.getInt(asyncQueueSizeExceededId);
    }

    @Override
    public void incAsyncQueueSizeExceeded(int inc) {
        this.stats.incInt(asyncQueueSizeExceededId, inc);
    }

    @Override
    public int getAsyncDistributionTimeoutExceeded() {
        return this.stats.getInt(asyncDistributionTimeoutExceededId);
    }

    @Override
    public void incAsyncDistributionTimeoutExceeded() {
        this.stats.incInt(asyncDistributionTimeoutExceededId, 1);
    }

    @Override
    public long getAsyncQueueSize() {
        return this.stats.getLong(asyncQueueSizeId);
    }

    @Override
    public void incAsyncQueueSize(long inc) {
        this.stats.incLong(asyncQueueSizeId, inc);
    }

    @Override
    public long getAsyncQueuedMsgs() {
        return this.stats.getLong(asyncQueuedMsgsId);
    }

    @Override
    public void incAsyncQueuedMsgs() {
        this.stats.incLong(asyncQueuedMsgsId, 1L);
    }

    @Override
    public long getAsyncDequeuedMsgs() {
        return this.stats.getLong(asyncDequeuedMsgsId);
    }

    @Override
    public void incAsyncDequeuedMsgs() {
        this.stats.incLong(asyncDequeuedMsgsId, 1L);
    }

    @Override
    public long getAsyncConflatedMsgs() {
        return this.stats.getLong(asyncConflatedMsgsId);
    }

    @Override
    public void incAsyncConflatedMsgs() {
        this.stats.incLong(asyncConflatedMsgsId, 1L);
    }

    @Override
    public int getAsyncThreads() {
        return this.stats.getInt(asyncThreadsId);
    }

    @Override
    public void incAsyncThreads(int inc) {
        this.stats.incInt(asyncThreadsId, inc);
    }

    @Override
    public int getAsyncThreadInProgress() {
        return this.stats.getInt(asyncThreadInProgressId);
    }

    @Override
    public int getAsyncThreadCompleted() {
        return this.stats.getInt(asyncThreadCompletedId);
    }

    @Override
    public long getAsyncThreadTime() {
        return this.stats.getLong(asyncThreadTimeId);
    }

    @Override
    public long startAsyncThread() {
        this.stats.incInt(asyncThreadInProgressId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endAsyncThread(long start) {
        this.stats.incInt(asyncThreadInProgressId, -1);
        this.stats.incInt(asyncThreadCompletedId, 1);
        if (enableClockStats) {
            this.stats.incLong(asyncThreadTimeId, DistributionStats.getStatTime() - start);
        }
    }

    public ThrottledQueueStatHelper getOverflowQueueHelper() {
        return new ThrottledQueueStatHelper(){

            @Override
            public void incThrottleCount() {
                DistributionStats.this.incOverflowQueueThrottleCount(1);
            }

            @Override
            public void throttleTime(long nanos) {
                DistributionStats.this.incOverflowQueueThrottleTime(nanos);
            }

            @Override
            public void add() {
                DistributionStats.this.incOverflowQueueSize(1);
            }

            @Override
            public void remove() {
                DistributionStats.this.incOverflowQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                DistributionStats.this.incOverflowQueueSize(-count);
            }
        };
    }

    public QueueStatHelper getWaitingQueueHelper() {
        return new QueueStatHelper(){

            @Override
            public void add() {
                DistributionStats.this.incWaitingQueueSize(1);
            }

            @Override
            public void remove() {
                DistributionStats.this.incWaitingQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                DistributionStats.this.incWaitingQueueSize(-count);
            }
        };
    }

    public ThrottledQueueStatHelper getHighPriorityQueueHelper() {
        return new ThrottledQueueStatHelper(){

            @Override
            public void incThrottleCount() {
                DistributionStats.this.incHighPriorityQueueThrottleCount(1);
            }

            @Override
            public void throttleTime(long nanos) {
                DistributionStats.this.incHighPriorityQueueThrottleTime(nanos);
            }

            @Override
            public void add() {
                DistributionStats.this.incHighPriorityQueueSize(1);
            }

            @Override
            public void remove() {
                DistributionStats.this.incHighPriorityQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                DistributionStats.this.incHighPriorityQueueSize(-count);
            }
        };
    }

    public ThrottledQueueStatHelper getPartitionedRegionQueueHelper() {
        return new ThrottledQueueStatHelper(){

            @Override
            public void incThrottleCount() {
                DistributionStats.this.incPartitionedRegionQueueThrottleCount(1);
            }

            @Override
            public void throttleTime(long nanos) {
                DistributionStats.this.incPartitionedRegionQueueThrottleTime(nanos);
            }

            @Override
            public void add() {
                DistributionStats.this.incPartitionedRegionQueueSize(1);
            }

            @Override
            public void remove() {
                DistributionStats.this.incPartitionedRegionQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                DistributionStats.this.incPartitionedRegionQueueSize(-count);
            }
        };
    }

    public PoolStatHelper getPartitionedRegionPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incPartitionedRegionThreadJobs(1);
            }

            @Override
            public void endJob() {
                DistributionStats.this.incPartitionedRegionThreadJobs(-1);
            }
        };
    }

    public ThrottledQueueStatHelper getFunctionExecutionQueueHelper() {
        return new ThrottledQueueStatHelper(){

            @Override
            public void incThrottleCount() {
                DistributionStats.this.incFunctionExecutionQueueThrottleCount(1);
            }

            @Override
            public void throttleTime(long nanos) {
                DistributionStats.this.incFunctionExecutionQueueThrottleTime(nanos);
            }

            @Override
            public void add() {
                DistributionStats.this.incFunctionExecutionQueueSize(1);
            }

            @Override
            public void remove() {
                DistributionStats.this.incFunctionExecutionQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                DistributionStats.this.incFunctionExecutionQueueSize(-count);
            }
        };
    }

    public PoolStatHelper getFunctionExecutionPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incFunctionExecutionThreadJobs(1);
            }

            @Override
            public void endJob() {
                DistributionStats.this.incFunctionExecutionThreadJobs(-1);
            }
        };
    }

    public ThrottledMemQueueStatHelper getSerialQueueHelper() {
        return new ThrottledMemQueueStatHelper(){

            @Override
            public void incThrottleCount() {
                DistributionStats.this.incSerialQueueThrottleCount(1);
            }

            @Override
            public void throttleTime(long nanos) {
                DistributionStats.this.incSerialQueueThrottleTime(nanos);
            }

            @Override
            public void add() {
                DistributionStats.this.incSerialQueueSize(1);
            }

            @Override
            public void remove() {
                DistributionStats.this.incSerialQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                DistributionStats.this.incSerialQueueSize(-count);
            }

            @Override
            public void addMem(int amount) {
                DistributionStats.this.incSerialQueueBytes(amount);
            }

            @Override
            public void removeMem(int amount) {
                DistributionStats.this.incSerialQueueBytes(amount * -1);
            }
        };
    }

    public PoolStatHelper getNormalPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incNormalPoolThreadJobs(1);
            }

            @Override
            public void endJob() {
                DistributionStats.this.incNormalPoolThreadJobs(-1);
            }
        };
    }

    public PoolStatHelper getWaitingPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incWaitingPoolThreadJobs(1);
            }

            @Override
            public void endJob() {
                DistributionStats.this.incWaitingPoolThreadJobs(-1);
            }
        };
    }

    public PoolStatHelper getHighPriorityPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incHighPriorityThreadJobs(1);
            }

            @Override
            public void endJob() {
                DistributionStats.this.incHighPriorityThreadJobs(-1);
            }
        };
    }

    @Override
    public void incBatchSendTime(long start) {
        if (enableClockStats) {
            this.stats.incLong(batchSendTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public void incBatchCopyTime(long start) {
        if (enableClockStats) {
            this.stats.incLong(batchCopyTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public void incBatchWaitTime(long start) {
        if (enableClockStats) {
            this.stats.incLong(batchWaitTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public void incBatchFlushTime(long start) {
        if (enableClockStats) {
            this.stats.incLong(batchFlushTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public void incUcastRetransmits() {
        this.stats.incInt(ucastRetransmitsId, 1);
    }

    @Override
    public void incMcastRetransmits() {
        this.stats.incInt(mcastRetransmitsId, 1);
    }

    @Override
    public void incMcastRetransmitRequests() {
        this.stats.incInt(mcastRetransmitRequestsId, 1);
    }

    @Override
    public int getMcastRetransmits() {
        return this.stats.getInt(mcastRetransmitsId);
    }

    @Override
    public long startUcastFlush() {
        this.stats.incInt(ucastFlushesId, 1);
        return DistributionStats.getStatTime();
    }

    @Override
    public void endUcastFlush(long start) {
        if (enableClockStats) {
            this.stats.incLong(ucastFlushTimeId, DistributionStats.getStatTime() - start);
        }
    }

    @Override
    public void incFlowControlRequests() {
        this.stats.incInt(flowControlRequestsId, 1);
    }

    @Override
    public void incFlowControlResponses() {
        this.stats.incInt(flowControlResponsesId, 1);
    }

    @Override
    public long startFlowControlWait() {
        this.stats.incInt(flowControlWaitsInProgressId, 1);
        return 1L;
    }

    @Override
    public void endFlowControlWait(long start) {
        this.stats.incInt(flowControlWaitsInProgressId, -1);
    }

    @Override
    public long startFlowControlThrottleWait() {
        this.stats.incInt(flowControlThrottleWaitsInProgressId, 1);
        return 1L;
    }

    @Override
    public void endFlowControlThrottleWait(long start) {
        this.stats.incInt(flowControlThrottleWaitsInProgressId, -1);
    }

    @Override
    public void incJgUNICASTdataReceived(long amount) {
        this.stats.incLong(jgUNICASTdataReceivedTimeId, amount);
    }

    @Override
    public void setJgQueuedMessagesSize(long amount) {
        this.stats.setLong(jgQueuedMessagesSizeId, amount);
    }

    @Override
    public void setJgSTABLEreceivedMessagesSize(long amount) {
        this.stats.setLong(jgReceivedMessagesSizeId, amount);
    }

    @Override
    public void setJgSTABLEsentMessagesSize(long amount) {
        this.stats.setLong(jgSentMessagesPoolSizeId, amount);
    }

    @Override
    public void incJgSTABLEsuspendTime(long value2) {
        this.stats.incLong(jgSTABLEsuspendTimeId, value2);
    }

    @Override
    public void incJgSTABLEmessages(long value2) {
        this.stats.incLong(jgSTABLEmessagesId, value2);
    }

    @Override
    public void incJgSTABLEmessagesSent(long value2) {
        this.stats.incLong(jgSTABLEmessagesSentId, value2);
    }

    @Override
    public void incJgSTABILITYmessages(long value2) {
        this.stats.incLong(jgSTABILITYmessagesId, value2);
    }

    @Override
    public void incJgFragmentationsPerformed() {
        this.stats.incLong(jgFragmentationsPerformedId, 1L);
    }

    @Override
    public void incJgFragmentsCreated(long numFrags) {
        this.stats.incLong(jgFragmentsCreatedId, numFrags);
    }

    @Override
    public void setJgUNICASTreceivedMessagesSize(long amount) {
        this.stats.setLong(jgUcastReceivedMessagesSizeId, amount);
    }

    @Override
    public void setJgUNICASTsentMessagesSize(long amount) {
        this.stats.setLong(jgUcastSentMessagesSizeId, amount);
    }

    @Override
    public void setJgUNICASTsentHighPriorityMessagesSize(long amount) {
        this.stats.setLong(jgUcastSentHighPriorityMessagesSizeId, amount);
    }

    @Override
    public void incjgDownTime(long value2) {
        this.stats.incLong(jgDownTimeId, value2);
    }

    @Override
    public void incjgUpTime(long value2) {
        this.stats.incLong(jgUpTimeId, value2);
    }

    @Override
    public void incjChannelUpTime(long value2) {
        this.stats.incLong(jChannelUpTimeId, value2);
    }

    @Override
    public void incJgFCsendBlocks(long value2) {
        this.stats.incLong(jgFCsendBlocksId, value2);
    }

    @Override
    public void incJgFCautoRequests(long value2) {
        this.stats.incLong(jgFCautoRequestsId, value2);
    }

    @Override
    public void incJgFCreplenish(long value2) {
        this.stats.incLong(jgFCreplenishId, value2);
    }

    @Override
    public void incJgFCresumes(long value2) {
        this.stats.incLong(jgFCresumesId, value2);
    }

    @Override
    public void incJgFCsentCredits(long value2) {
        this.stats.incLong(jgFCsentCreditsId, value2);
    }

    @Override
    public void incJgFCsentThrottleRequests(long value2) {
        this.stats.incLong(jgFCsentThrottleRequestsId, value2);
    }

    @Override
    public void incJgNAKACKwaits(long value2) {
        this.stats.incLong(jgNAKACKwaitsId, value2);
    }

    @Override
    public void incThreadOwnedReceivers(long value2, int dominoCount) {
        if (dominoCount < 2) {
            this.stats.incLong(threadOwnedReceiversId, value2);
        } else {
            this.stats.incLong(threadOwnedReceiversId2, value2);
        }
    }

    @Override
    public void incReceiverBufferSize(int inc, boolean direct) {
        if (direct) {
            this.stats.incLong(receiverDirectBufferSizeId, (long)inc);
        } else {
            this.stats.incLong(receiverHeapBufferSizeId, (long)inc);
        }
    }

    @Override
    public void incSenderBufferSize(int inc, boolean direct) {
        if (direct) {
            this.stats.incLong(senderDirectBufferSizeId, (long)inc);
        } else {
            this.stats.incLong(senderHeapBufferSizeId, (long)inc);
        }
    }

    @Override
    public void incMessagesBeingReceived(boolean newMsg, int bytes) {
        if (newMsg) {
            this.stats.incInt(messagesBeingReceivedId, 1);
        }
        this.stats.incLong(messageBytesBeingReceivedId, (long)bytes);
    }

    @Override
    public void decMessagesBeingReceived(int bytes) {
        this.stats.incInt(messagesBeingReceivedId, -1);
        this.stats.incLong(messageBytesBeingReceivedId, (long)(-bytes));
    }

    public void incSerialThreadStarts() {
        this.stats.incLong(serialThreadStartsId, 1L);
    }

    public void incViewThreadStarts() {
        this.stats.incLong(viewThreadStartsId, 1L);
    }

    public void incProcessingThreadStarts() {
        this.stats.incLong(processingThreadStartsId, 1L);
    }

    public void incHighPriorityThreadStarts() {
        this.stats.incLong(highPriorityThreadStartsId, 1L);
    }

    public void incWaitingThreadStarts() {
        this.stats.incLong(waitingThreadStartsId, 1L);
    }

    public void incPartitionedRegionThreadStarts() {
        this.stats.incLong(partitionedRegionThreadStartsId, 1L);
    }

    public void incFunctionExecutionThreadStarts() {
        this.stats.incLong(functionExecutionThreadStartsId, 1L);
    }

    public void incSerialPooledThreadStarts() {
        this.stats.incLong(serialPooledThreadStartsId, 1L);
    }

    @Override
    public void incReplyHandOffTime(long start) {
        if (enableClockStats) {
            long delta = DistributionStats.getStatTime() - start;
            this.stats.incLong(replyHandoffTimeId, delta);
        }
    }

    protected void incPartitionedRegionThreadJobs(int i) {
        this.stats.incInt(partitionedRegionThreadJobsId, i);
    }

    protected void incFunctionExecutionThreadJobs(int i) {
        this.stats.incInt(functionExecutionThreadJobsId, i);
    }

    public void incNumViewThreads(int threads) {
        this.stats.incInt(viewThreadsId, threads);
    }

    public PoolStatHelper getSerialProcessorHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incNumSerialThreadJobs(1);
                if (logger.isTraceEnabled()) {
                    logger.trace("[DM.SerialQueuedExecutor.execute] numSerialThreads={}", DistributionStats.this.getNumSerialThreads());
                }
            }

            @Override
            public void endJob() {
                DistributionStats.this.incNumSerialThreadJobs(-1);
            }
        };
    }

    protected void incNumSerialThreadJobs(int jobs) {
        this.stats.incInt(serialThreadJobsId, jobs);
    }

    public PoolStatHelper getViewProcessorHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incViewProcessorThreadJobs(1);
                if (logger.isTraceEnabled()) {
                    logger.trace("[DM.SerialQueuedExecutor.execute] numViewThreads={}", DistributionStats.this.getNumViewThreads());
                }
            }

            @Override
            public void endJob() {
                DistributionStats.this.incViewProcessorThreadJobs(-1);
            }
        };
    }

    public int getNumViewThreads() {
        return this.stats.getInt(viewThreadsId);
    }

    protected void incViewProcessorThreadJobs(int jobs) {
        this.stats.incInt(viewProcessorThreadJobsId, jobs);
    }

    public PoolStatHelper getSerialPooledProcessorHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                DistributionStats.this.incSerialPooledProcessorThreadJobs(1);
            }

            @Override
            public void endJob() {
                DistributionStats.this.incSerialPooledProcessorThreadJobs(-1);
            }
        };
    }

    protected void incSerialPooledProcessorThreadJobs(int jobs) {
        this.stats.incInt(serialPooledThreadJobsId, jobs);
    }

    protected void incNormalPoolThreadJobs(int jobs) {
        this.stats.incInt(pooledMessageThreadJobsId, jobs);
    }

    protected void incHighPriorityThreadJobs(int jobs) {
        this.stats.incInt(highPriorityThreadJobsId, jobs);
    }

    protected void incWaitingPoolThreadJobs(int jobs) {
        this.stats.incInt(waitingPoolThreadJobsId, jobs);
    }

    @Override
    public int getElders() {
        return this.stats.getInt(eldersId);
    }

    @Override
    public void incElders(int val) {
        this.stats.incInt(eldersId, val);
    }

    @Override
    public int getInitialImageMessagesInFlight() {
        return this.stats.getInt(initialImageMessagesInFlightId);
    }

    @Override
    public void incInitialImageMessagesInFlight(int val) {
        this.stats.incInt(initialImageMessagesInFlightId, val);
    }

    @Override
    public int getInitialImageRequestsInProgress() {
        return this.stats.getInt(initialImageRequestsInProgressId);
    }

    @Override
    public void incInitialImageRequestsInProgress(int val) {
        this.stats.incInt(initialImageRequestsInProgressId, val);
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        String statName = "DistributionStats";
        String statDescription = "Statistics on the gemfire distribution layer.";
        String sentMessagesDesc = "The number of distribution messages that this GemFire system has sent. This includes broadcastMessages.";
        String sentCommitMessagesDesc = "The number of transaction commit messages that this GemFire system has created to be sent. Note that it is possible for a commit to only create one message even though it will end up being sent to multiple recipients.";
        String commitWaitsDesc = "The number of transaction commits that had to wait for a response before they could complete.";
        String sentMessagesTimeDesc = "The total amount of time this distribution manager has spent sending messages. This includes broadcastMessagesTime.";
        String sentMessagesMaxTimeDesc = "The highest amount of time this distribution manager has spent distributing a single message to the network.";
        String broadcastMessagesDesc = "The number of distribution messages that this GemFire system has broadcast. A broadcast message is one sent to every other manager in the group.";
        String broadcastMessagesTimeDesc = "The total amount of time this distribution manager has spent broadcasting messages. A broadcast message is one sent to every other manager in the group.";
        String receivedMessagesDesc = "The number of distribution messages that this GemFire system has received.";
        String receivedBytesDesc = "The number of distribution message bytes that this GemFire system has received.";
        String sentBytesDesc = "The number of distribution message bytes that this GemFire system has sent.";
        String processedMessagesDesc = "The number of distribution messages that this GemFire system has processed.";
        String processedMessagesTimeDesc = "The amount of time this distribution manager has spent in message.process().";
        String messageProcessingScheduleTimeDesc = "The amount of time this distribution manager has spent dispatching message to processor threads.";
        String overflowQueueSizeDesc = "The number of normal distribution messages currently waiting to be processed.";
        String waitingQueueSizeDesc = "The number of distribution messages currently waiting for some other resource before they can be processed.";
        String overflowQueueThrottleTimeDesc = "The total amount of time, in nanoseconds, spent delayed by the overflow queue throttle.";
        String overflowQueueThrottleCountDesc = "The total number of times a thread was delayed in adding a normal message to the overflow queue.";
        String highPriorityQueueSizeDesc = "The number of high priority distribution messages currently waiting to be processed.";
        String highPriorityQueueThrottleTimeDesc = "The total amount of time, in nanoseconds, spent delayed by the high priority queue throttle.";
        String highPriorityQueueThrottleCountDesc = "The total number of times a thread was delayed in adding a normal message to the high priority queue.";
        String serialQueueSizeDesc = "The number of serial distribution messages currently waiting to be processed.";
        String serialQueueBytesDesc = "The approximate number of bytes consumed by serial distribution messages currently waiting to be processed.";
        String serialPooledThreadDesc = "The number of threads created in the SerialQueuedExecutorPool.";
        String serialQueueThrottleTimeDesc = "The total amount of time, in nanoseconds, spent delayed by the serial queue throttle.";
        String serialQueueThrottleCountDesc = "The total number of times a thread was delayed in adding a ordered message to the serial queue.";
        String serialThreadsDesc = "The number of threads currently processing serial/ordered messages.";
        String processingThreadsDesc = "The number of threads currently processing normal messages.";
        String highPriorityThreadsDesc = "The number of threads currently processing high priority messages.";
        String partitionedRegionThreadsDesc = "The number of threads currently processing partitioned region messages.";
        String functionExecutionThreadsDesc = "The number of threads currently processing function execution messages.";
        String waitingThreadsDesc = "The number of threads currently processing messages that had to wait for a resource.";
        String messageChannelTimeDesc = "The total amount of time received messages spent in the distribution channel";
        String replyMessageTimeDesc = "The amount of time spent processing reply messages. This includes both processedMessagesTime and messageProcessingScheduleTime.";
        String distributeMessageTimeDesc = "The amount of time it takes to prepare a message and send it on the network.  This includes sentMessagesTime.";
        String nodesDesc = "The current number of nodes in this distributed system.";
        String replyWaitsInProgressDesc = "Current number of threads waiting for a reply.";
        String replyWaitsCompletedDesc = "Total number of times waits for a reply have completed.";
        String replyWaitTimeDesc = "Total time spent waiting for a reply to a message.";
        String replyWaitMaxTimeDesc = "Maximum time spent transmitting and then waiting for a reply to a message. See sentMessagesMaxTime for related information";
        String replyTimeoutsDesc = "Total number of message replies that have timed out.";
        String receiverConnectionsDesc = "Current number of sockets dedicated to receiving messages.";
        String failedAcceptsDesc = "Total number of times an accept (receiver creation) of a connect from some other member has failed";
        String failedConnectsDesc = "Total number of times a connect (sender creation) to some other member has failed.";
        String reconnectAttemptsDesc = "Total number of times an established connection was lost and a reconnect was attempted.";
        String lostConnectionLeaseDesc = "Total number of times an unshared sender socket has remained idle long enough that its lease expired.";
        String sharedOrderedSenderConnectionsDesc = "Current number of shared sockets dedicated to sending ordered messages.";
        String sharedUnorderedSenderConnectionsDesc = "Current number of shared sockets dedicated to sending unordered messages.";
        String threadOrderedSenderConnectionsDesc = "Current number of thread sockets dedicated to sending ordered messages.";
        String threadUnorderedSenderConnectionsDesc = "Current number of thread sockets dedicated to sending unordered messages.";
        String asyncQueuesDesc = "The current number of queues for asynchronous messaging.";
        String asyncQueueFlushesInProgressDesc = "Current number of asynchronous queues being flushed.";
        String asyncQueueFlushesCompletedDesc = "Total number of asynchronous queue flushes completed.";
        String asyncQueueFlushTimeDesc = "Total time spent flushing asynchronous queues.";
        String asyncQueueTimeoutExceededDesc = "Total number of asynchronous queues that have timed out by being blocked for more than async-queue-timeout milliseconds.";
        String asyncQueueSizeExceededDesc = "Total number of asynchronous queues that have exceeded max size.";
        String asyncDistributionTimeoutExceededDesc = "Total number of times the async-distribution-timeout has been exceeded during a socket write.";
        String asyncQueueSizeDesc = "The current size in bytes used for asynchronous queues.";
        String asyncQueuedMsgsDesc = "The total number of queued messages used for asynchronous queues.";
        String asyncDequeuedMsgsDesc = "The total number of queued messages that have been removed from the queue and successfully sent.";
        String asyncConflatedMsgsDesc = "The total number of queued conflated messages used for asynchronous queues.";
        String asyncThreadsDesc = "Total number of asynchronous message queue threads.";
        String asyncThreadInProgressDesc = "Current iterations of work performed by asynchronous message queue threads.";
        String asyncThreadCompletedDesc = "Total number of iterations of work performed by asynchronous message queue threads.";
        String asyncThreadTimeDesc = "Total time spent by asynchronous message queue threads performing iterations.";
        String receiverDirectBufferSizeDesc = "Current number of bytes allocated from direct memory as buffers for incoming messages.";
        String receiverHeapBufferSizeDesc = "Current number of bytes allocated from Java heap memory as buffers for incoming messages.";
        String senderDirectBufferSizeDesc = "Current number of bytes allocated from direct memory as buffers for outgoing messages.";
        String senderHeapBufferSizeDesc = "Current number of bytes allocated from Java heap memory as buffers for outoing messages.";
        String replyHandoffTimeDesc = "Total number of seconds to switch thread contexts from processing thread to application thread.";
        String partitionedRegionThreadJobsDesc = "The number of messages currently being processed by partitioned region threads";
        String functionExecutionThreadJobsDesc = "The number of messages currently being processed by function execution threads";
        String viewThreadsDesc = "The number of threads currently processing view messages.";
        String serialThreadJobsDesc = "The number of messages currently being processed by serial threads.";
        String viewThreadJobsDesc = "The number of messages currently being processed by view threads.";
        String serialPooledThreadJobsDesc = "The number of messages currently being processed by pooled serial processor threads.";
        String processingThreadJobsDesc = "The number of messages currently being processed by pooled message processor threads.";
        String highPriorityThreadJobsDesc = "The number of messages currently being processed by high priority processor threads.";
        String waitingThreadJobsDesc = "The number of messages currently being processed by waiting pooly processor threads.";
        String eldersDesc = "Current number of system elders hosted in this member.";
        String initialImageMessagesInFlightDesc = "The number of messages with initial image data sent from this member that have not yet been acknowledged.";
        String initialImageRequestsInProgressDesc = "The number of initial images this member is currently receiving.";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createLongCounter("sentMessages", "The number of distribution messages that this GemFire system has sent. This includes broadcastMessages.", "messages"), f.createLongCounter("commitMessages", "The number of transaction commit messages that this GemFire system has created to be sent. Note that it is possible for a commit to only create one message even though it will end up being sent to multiple recipients.", "messages"), f.createLongCounter("commitWaits", "The number of transaction commits that had to wait for a response before they could complete.", "messages"), f.createLongCounter("sentMessagesTime", "The total amount of time this distribution manager has spent sending messages. This includes broadcastMessagesTime.", "nanoseconds", false), f.createLongGauge("sentMessagesMaxTime", "The highest amount of time this distribution manager has spent distributing a single message to the network.", "milliseconds", false), f.createLongCounter("broadcastMessages", "The number of distribution messages that this GemFire system has broadcast. A broadcast message is one sent to every other manager in the group.", "messages"), f.createLongCounter("broadcastMessagesTime", "The total amount of time this distribution manager has spent broadcasting messages. A broadcast message is one sent to every other manager in the group.", "nanoseconds", false), f.createLongCounter("receivedMessages", "The number of distribution messages that this GemFire system has received.", "messages"), f.createLongCounter("receivedBytes", "The number of distribution message bytes that this GemFire system has received.", "bytes"), f.createLongCounter("sentBytes", "The number of distribution message bytes that this GemFire system has sent.", "bytes"), f.createLongCounter("processedMessages", "The number of distribution messages that this GemFire system has processed.", "messages"), f.createLongCounter("processedMessagesTime", "The amount of time this distribution manager has spent in message.process().", "nanoseconds", false), f.createLongCounter("messageProcessingScheduleTime", "The amount of time this distribution manager has spent dispatching message to processor threads.", "nanoseconds", false), f.createIntGauge("overflowQueueSize", "The number of normal distribution messages currently waiting to be processed.", "messages"), f.createIntGauge("waitingQueueSize", "The number of distribution messages currently waiting for some other resource before they can be processed.", "messages"), f.createIntGauge("overflowQueueThrottleCount", "The total number of times a thread was delayed in adding a normal message to the overflow queue.", "delays"), f.createLongCounter("overflowQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the overflow queue throttle.", "nanoseconds", false), f.createIntGauge("highPriorityQueueSize", "The number of high priority distribution messages currently waiting to be processed.", "messages"), f.createIntGauge("highPriorityQueueThrottleCount", "The total number of times a thread was delayed in adding a normal message to the high priority queue.", "delays"), f.createLongCounter("highPriorityQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the high priority queue throttle.", "nanoseconds", false), f.createIntGauge("partitionedRegionQueueSize", "The number of high priority distribution messages currently waiting to be processed.", "messages"), f.createIntGauge("partitionedRegionQueueThrottleCount", "The total number of times a thread was delayed in adding a normal message to the high priority queue.", "delays"), f.createLongCounter("partitionedRegionQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the high priority queue throttle.", "nanoseconds", false), f.createIntGauge("functionExecutionQueueSize", "The number of high priority distribution messages currently waiting to be processed.", "messages"), f.createIntGauge("functionExecutionQueueThrottleCount", "The total number of times a thread was delayed in adding a normal message to the high priority queue.", "delays"), f.createLongCounter("functionExecutionQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the high priority queue throttle.", "nanoseconds", false), f.createIntGauge("serialQueueSize", "The number of serial distribution messages currently waiting to be processed.", "messages"), f.createIntGauge("serialQueueBytes", "The approximate number of bytes consumed by serial distribution messages currently waiting to be processed.", "bytes"), f.createIntCounter("serialPooledThread", "The number of threads created in the SerialQueuedExecutorPool.", "threads"), f.createIntGauge("serialQueueThrottleCount", "The total number of times a thread was delayed in adding a ordered message to the serial queue.", "delays"), f.createLongCounter("serialQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the serial queue throttle.", "nanoseconds", false), f.createIntGauge("serialThreads", "The number of threads currently processing serial/ordered messages.", "threads"), f.createIntGauge("processingThreads", "The number of threads currently processing normal messages.", "threads"), f.createIntGauge("highPriorityThreads", "The number of threads currently processing high priority messages.", "threads"), f.createIntGauge("partitionedRegionThreads", "The number of threads currently processing partitioned region messages.", "threads"), f.createIntGauge("functionExecutionThreads", "The number of threads currently processing function execution messages.", "threads"), f.createIntGauge("waitingThreads", "The number of threads currently processing messages that had to wait for a resource.", "threads"), f.createLongCounter("messageChannelTime", "The total amount of time received messages spent in the distribution channel", "nanoseconds", false), f.createLongCounter("replyMessageTime", "The amount of time spent processing reply messages. This includes both processedMessagesTime and messageProcessingScheduleTime.", "nanoseconds", false), f.createLongCounter("distributeMessageTime", "The amount of time it takes to prepare a message and send it on the network.  This includes sentMessagesTime.", "nanoseconds", false), f.createIntGauge("nodes", "The current number of nodes in this distributed system.", "nodes"), f.createIntGauge("replyWaitsInProgress", "Current number of threads waiting for a reply.", "operations"), f.createIntCounter("replyWaitsCompleted", "Total number of times waits for a reply have completed.", "operations"), f.createLongCounter("replyWaitTime", "Total time spent waiting for a reply to a message.", "nanoseconds", false), f.createLongGauge("replyWaitMaxTime", "Maximum time spent transmitting and then waiting for a reply to a message. See sentMessagesMaxTime for related information", "milliseconds", false), f.createLongCounter("replyTimeouts", "Total number of message replies that have timed out.", "timeouts", false), f.createIntGauge("receivers", "Current number of sockets dedicated to receiving messages.", "sockets"), f.createIntGauge("sendersSO", "Current number of shared sockets dedicated to sending ordered messages.", "sockets"), f.createIntGauge("sendersSU", "Current number of shared sockets dedicated to sending unordered messages.", "sockets"), f.createIntGauge("sendersTO", "Current number of thread sockets dedicated to sending ordered messages.", "sockets"), f.createIntGauge("sendersTU", "Current number of thread sockets dedicated to sending unordered messages.", "sockets"), f.createIntCounter("failedAccepts", "Total number of times an accept (receiver creation) of a connect from some other member has failed", "accepts"), f.createIntCounter("failedConnects", "Total number of times a connect (sender creation) to some other member has failed.", "connects"), f.createIntCounter("reconnectAttempts", "Total number of times an established connection was lost and a reconnect was attempted.", "connects"), f.createIntCounter("senderTimeouts", "Total number of times an unshared sender socket has remained idle long enough that its lease expired.", "expirations"), f.createIntGauge("syncSocketWritesInProgress", "Current number of synchronous/blocking socket write calls in progress.", "writes"), f.createLongCounter("syncSocketWriteTime", "Total amount of time, in nanoseconds, spent in synchronous/blocking socket write calls.", "nanoseconds"), f.createIntCounter("syncSocketWrites", "Total number of completed synchronous/blocking socket write calls.", "writes"), f.createLongCounter("syncSocketWriteBytes", "Total number of bytes sent out in synchronous/blocking mode on sockets.", "bytes"), f.createIntCounter("ucastReads", "Total number of unicast datagrams received", "datagrams"), f.createLongCounter("ucastReadBytes", "Total number of bytes received in unicast datagrams", "bytes"), f.createLongCounter("ucastWriteTime", "Total amount of time, in nanoseconds, spent in unicast datagram socket write calls.", "nanoseconds"), f.createIntCounter("ucastWrites", "Total number of unicast datagram socket write calls.", "writes"), f.createLongCounter("ucastWriteBytes", "Total number of bytes sent out on unicast datagram sockets.", "bytes"), f.createIntCounter("ucastRetransmits", "Total number of unicast datagram socket retransmissions", "writes"), f.createIntCounter("mcastReads", "Total number of multicast datagrams received", "datagrams"), f.createLongCounter("mcastReadBytes", "Total number of bytes received in multicast datagrams", "bytes"), f.createLongCounter("mcastWriteTime", "Total amount of time, in nanoseconds, spent in multicast datagram socket write calls.", "nanoseconds"), f.createIntCounter("mcastWrites", "Total number of multicast datagram socket write calls.", "writes"), f.createLongCounter("mcastWriteBytes", "Total number of bytes sent out on multicast datagram sockets.", "bytes"), f.createIntCounter("mcastRetransmits", "Total number of multicast datagram socket retransmissions", "writes"), f.createIntCounter("mcastRetransmitRequests", "Total number of multicast datagram socket retransmission requests sent to other processes", "requests"), f.createLongCounter("serializationTime", "Total amount of time, in nanoseconds, spent serializing objects. This includes pdx serializations.", "nanoseconds"), f.createIntCounter("serializations", "Total number of object serialization calls. This includes pdx serializations.", "ops"), f.createLongCounter("serializedBytes", "Total number of bytes produced by object serialization. This includes pdx serializations.", "bytes"), f.createIntCounter("pdxSerializations", "Total number of pdx serializations.", "ops"), f.createLongCounter("pdxSerializedBytes", "Total number of bytes produced by pdx serialization.", "bytes"), f.createLongCounter("deserializationTime", "Total amount of time, in nanoseconds, spent deserializing objects. This includes deserialization that results in a PdxInstance.", "nanoseconds"), f.createIntCounter("deserializations", "Total number of object deserialization calls. This includes deserialization that results in a PdxInstance.", "ops"), f.createLongCounter("deserializedBytes", "Total number of bytes read by object deserialization. This includes deserialization that results in a PdxInstance.", "bytes"), f.createIntCounter("pdxDeserializations", "Total number of pdx deserializations.", "ops"), f.createLongCounter("pdxDeserializedBytes", "Total number of bytes read by pdx deserialization.", "bytes"), f.createLongCounter("msgSerializationTime", "Total amount of time, in nanoseconds, spent serializing messages.", "nanoseconds"), f.createLongCounter("msgDeserializationTime", "Total amount of time, in nanoseconds, spent deserializing messages.", "nanoseconds"), f.createIntCounter("pdxInstanceDeserializations", "Total number of times getObject has been called on a PdxInstance.", "ops"), f.createLongCounter("pdxInstanceDeserializationTime", "Total amount of time, in nanoseconds, spent deserializing PdxInstances by calling getObject.", "nanoseconds"), f.createIntCounter("pdxInstanceCreations", "Total number of times a deserialization created a PdxInstance.", "ops"), f.createLongCounter("batchSendTime", "Total amount of time, in nanoseconds, spent queueing and flushing message batches", "nanoseconds"), f.createLongCounter("batchWaitTime", "Reserved for future use", "nanoseconds"), f.createLongCounter("batchCopyTime", "Total amount of time, in nanoseconds, spent copying messages for batched transmission", "nanoseconds"), f.createLongCounter("batchFlushTime", "Total amount of time, in nanoseconds, spent flushing batched messages to the network", "nanoseconds"), f.createIntCounter("ucastFlushes", "Total number of flushes of the unicast datagram protocol, prior to sending a multicast message", "flushes"), f.createLongCounter("ucastFlushTime", "Total amount of time, in nanoseconds, spent waiting for acknowledgements for outstanding unicast datagram messages", "nanoseconds"), f.createIntCounter("flowControlRequests", "Total number of flow control credit requests sent to other processes", "messages"), f.createIntCounter("flowControlResponses", "Total number of flow control credit responses sent to a requestor", "messages"), f.createIntGauge("flowControlWaitsInProgress", "Number of threads blocked waiting for flow-control recharges from other processes", "threads"), f.createLongCounter("flowControlWaitTime", "Total amount of time, in nanoseconds, spent waiting for other processes to recharge the flow of control meter", "nanoseconds"), f.createIntGauge("flowControlThrottleWaitsInProgress", "Number of threads blocked waiting due to flow-control throttle requests from other members", "threads"), f.createLongGauge("jgNAKACKreceivedMessages", "Number of received messages awaiting stability in NAKACK", "messages"), f.createLongGauge("jgNAKACKsentMessages", "Number of sent messages awaiting stability in NAKACK", "messages"), f.createLongGauge("jgQueuedMessages", "Number of messages queued by transport and awaiting processing", "messages"), f.createLongGauge("jgUNICASTreceivedMessages", "Number of received messages awaiting receipt of prior messages", "messages"), f.createLongGauge("jgUNICASTsentMessages", "Number of un-acked normal priority messages", "messages"), f.createLongGauge("jgUNICASTsentHighPriorityMessages", "Number of un-acked high priority messages", "messages"), f.createLongCounter("jgUNICASTdataReceivedTime", "Amount of time spent in JGroups UNICAST send", "nanoseconds"), f.createLongCounter("jgSTABLEsuspendTime", "Amount of time JGroups STABLE is suspended", "nanoseconds"), f.createLongCounter("jgSTABLEmessages", "Number of STABLE messages received by JGroups", "messages"), f.createLongCounter("jgSTABLEmessagesSent", "Number of STABLE messages sent by JGroups", "messages"), f.createLongCounter("jgSTABILITYmessages", "Number of STABILITY messages received by JGroups", "messages"), f.createLongCounter("jgDownTime", "Down Time spent in JGroups stacks", "nanoseconds"), f.createLongCounter("jgUpTime", "Up Time spent in JGroups stacks", "nanoseconds"), f.createLongCounter("jChannelUpTime", "Up Time spent in JChannel including jgroup stack", "nanoseconds"), f.createLongCounter("jgFCsendBlocks", "Number of times JGroups FC halted sends due to backpressure", "events"), f.createLongCounter("jgFCautoRequests", "Number of times JGroups FC automatically sent replenishment requests", "events"), f.createLongCounter("jgFCreplenish", "Number of times JGroups FC received replenishments from receivers", "messages"), f.createLongCounter("jgFCresumes", "Number of times JGroups FC resumed sends due to backpressure", "events"), f.createLongCounter("jgFCsentCredits", "Number of times JGroups FC sent credits to a sender", "events"), f.createLongCounter("jgFCsentThrottleRequests", "Number of times JGroups FC sent throttle requests to a sender", "events"), f.createIntGauge("asyncSocketWritesInProgress", "Current number of non-blocking socket write calls in progress.", "writes"), f.createIntCounter("asyncSocketWrites", "Total number of non-blocking socket write calls completed.", "writes"), f.createIntCounter("asyncSocketWriteRetries", "Total number of retries needed to write a single block of data using non-blocking socket write calls.", "writes"), f.createLongCounter("asyncSocketWriteTime", "Total amount of time, in nanoseconds, spent in non-blocking socket write calls.", "nanoseconds"), f.createLongCounter("asyncSocketWriteBytes", "Total number of bytes sent out on non-blocking sockets.", "bytes"), f.createLongCounter("asyncQueueAddTime", "Total amount of time, in nanoseconds, spent in adding messages to async queue.", "nanoseconds"), f.createLongCounter("asyncQueueRemoveTime", "Total amount of time, in nanoseconds, spent in removing messages from async queue.", "nanoseconds"), f.createIntGauge("asyncQueues", "The current number of queues for asynchronous messaging.", "queues"), f.createIntGauge("asyncQueueFlushesInProgress", "Current number of asynchronous queues being flushed.", "operations"), f.createIntCounter("asyncQueueFlushesCompleted", "Total number of asynchronous queue flushes completed.", "operations"), f.createLongCounter("asyncQueueFlushTime", "Total time spent flushing asynchronous queues.", "nanoseconds", false), f.createIntCounter("asyncQueueTimeoutExceeded", "Total number of asynchronous queues that have timed out by being blocked for more than async-queue-timeout milliseconds.", "timeouts"), f.createIntCounter("asyncQueueSizeExceeded", "Total number of asynchronous queues that have exceeded max size.", "operations"), f.createIntCounter("asyncDistributionTimeoutExceeded", "Total number of times the async-distribution-timeout has been exceeded during a socket write.", "operations"), f.createLongGauge("asyncQueueSize", "The current size in bytes used for asynchronous queues.", "bytes"), f.createLongCounter("asyncQueuedMsgs", "The total number of queued messages used for asynchronous queues.", "msgs"), f.createLongCounter("asyncDequeuedMsgs", "The total number of queued messages that have been removed from the queue and successfully sent.", "msgs"), f.createLongCounter("asyncConflatedMsgs", "The total number of queued conflated messages used for asynchronous queues.", "msgs"), f.createIntGauge("asyncThreads", "Total number of asynchronous message queue threads.", "threads"), f.createIntGauge("asyncThreadInProgress", "Current iterations of work performed by asynchronous message queue threads.", "operations"), f.createIntCounter("asyncThreadCompleted", "Total number of iterations of work performed by asynchronous message queue threads.", "operations"), f.createLongCounter("asyncThreadTime", "Total time spent by asynchronous message queue threads performing iterations.", "nanoseconds", false), f.createLongCounter("jgNAKACKwaits", "Number of delays created by NAKACK sent_msgs overflow", "events"), f.createLongGauge("receiversTO", "Number of receiver threads owned by non-receiver threads in other members.", "threads"), f.createLongGauge("receiversTO2", "Number of receiver threads owned in turn by receiver threads in other members", "threads"), f.createLongCounter("jgFragmentationsPerformed", "Number of message fragmentation operations performed", "operations"), f.createLongCounter("jgFragmentsCreated", "Number of message fragments created", "fragments"), f.createLongGauge("receiverDirectBufferSize", "Current number of bytes allocated from direct memory as buffers for incoming messages.", "bytes"), f.createLongGauge("receiverHeapBufferSize", "Current number of bytes allocated from Java heap memory as buffers for incoming messages.", "bytes"), f.createLongGauge("senderDirectBufferSize", "Current number of bytes allocated from direct memory as buffers for outgoing messages.", "bytes"), f.createLongGauge("senderHeapBufferSize", "Current number of bytes allocated from Java heap memory as buffers for outoing messages.", "bytes"), f.createIntGauge("socketLocksInProgress", "Current number of threads waiting to lock a socket", "threads", false), f.createIntCounter("socketLocks", "Total number of times a socket has been locked.", "locks"), f.createLongCounter("socketLockTime", "Total amount of time, in nanoseconds, spent locking a socket", "nanoseconds", false), f.createIntGauge("bufferAcquiresInProgress", "Current number of threads waiting to acquire a buffer", "threads", false), f.createIntCounter("bufferAcquires", "Total number of times a buffer has been acquired.", "operations"), f.createLongCounter("bufferAcquireTime", "Total amount of time, in nanoseconds, spent acquiring a socket", "nanoseconds", false), f.createIntGauge("messagesBeingReceived", "Current number of message being received off the network or being processed after reception.", "messages"), f.createLongGauge("messageBytesBeingReceived", "Current number of bytes consumed by messages being received or processed.", "bytes"), f.createLongCounter("serialThreadStarts", "Total number of times a thread has been created for the serial message executor.", "starts", false), f.createLongCounter("viewThreadStarts", "Total number of times a thread has been created for the view message executor.", "starts", false), f.createLongCounter("processingThreadStarts", "Total number of times a thread has been created for the pool processing normal messages.", "starts", false), f.createLongCounter("highPriorityThreadStarts", "Total number of times a thread has been created for the pool handling high priority messages.", "starts", false), f.createLongCounter("waitingThreadStarts", "Total number of times a thread has been created for the waiting pool.", "starts", false), f.createLongCounter("partitionedRegionThreadStarts", "Total number of times a thread has been created for the pool handling partitioned region messages.", "starts", false), f.createLongCounter("functionExecutionThreadStarts", "Total number of times a thread has been created for the pool handling function execution messages.", "starts", false), f.createLongCounter("serialPooledThreadStarts", "Total number of times a thread has been created for the serial pool(s).", "starts", false), f.createLongCounter("TOSentMsgs", "Total number of messages sent on thread owned senders", "messages", false), f.createLongCounter("replyHandoffTime", "Total number of seconds to switch thread contexts from processing thread to application thread.", "nanoseconds"), f.createIntGauge("partitionedRegionThreadJobs", "The number of messages currently being processed by partitioned region threads", "messages"), f.createIntGauge("functionExecutionThreadJobs", "The number of messages currently being processed by function execution threads", "messages"), f.createIntGauge("viewThreads", "The number of threads currently processing view messages.", "threads"), f.createIntGauge("serialThreadJobs", "The number of messages currently being processed by serial threads.", "messages"), f.createIntGauge("viewThreadJobs", "The number of messages currently being processed by view threads.", "messages"), f.createIntGauge("serialPooledThreadJobs", "The number of messages currently being processed by pooled serial processor threads.", "messages"), f.createIntGauge("processingThreadJobs", "The number of messages currently being processed by pooled message processor threads.", "messages"), f.createIntGauge("highPriorityThreadJobs", "The number of messages currently being processed by high priority processor threads.", "messages"), f.createIntGauge("waitingThreadJobs", "The number of messages currently being processed by waiting pooly processor threads.", "messages"), f.createIntGauge("elders", "Current number of system elders hosted in this member.", "elders"), f.createIntGauge("initialImageMessagesInFlight", "The number of messages with initial image data sent from this member that have not yet been acknowledged.", "messages"), f.createIntGauge("initialImageRequestsInProgress", "The number of initial images this member is currently receiving.", "requests")});
        sentMessagesId = type.nameToId("sentMessages");
        sentCommitMessagesId = type.nameToId("commitMessages");
        commitWaitsId = type.nameToId("commitWaits");
        sentMessagesTimeId = type.nameToId("sentMessagesTime");
        sentMessagesMaxTimeId = type.nameToId("sentMessagesMaxTime");
        broadcastMessagesId = type.nameToId("broadcastMessages");
        broadcastMessagesTimeId = type.nameToId("broadcastMessagesTime");
        receivedMessagesId = type.nameToId("receivedMessages");
        receivedBytesId = type.nameToId("receivedBytes");
        sentBytesId = type.nameToId("sentBytes");
        processedMessagesId = type.nameToId("processedMessages");
        processedMessagesTimeId = type.nameToId("processedMessagesTime");
        messageProcessingScheduleTimeId = type.nameToId("messageProcessingScheduleTime");
        messageChannelTimeId = type.nameToId("messageChannelTime");
        replyMessageTimeId = type.nameToId("replyMessageTime");
        distributeMessageTimeId = type.nameToId("distributeMessageTime");
        nodesId = type.nameToId("nodes");
        overflowQueueSizeId = type.nameToId("overflowQueueSize");
        waitingQueueSizeId = type.nameToId("waitingQueueSize");
        overflowQueueThrottleTimeId = type.nameToId("overflowQueueThrottleTime");
        overflowQueueThrottleCountId = type.nameToId("overflowQueueThrottleCount");
        highPriorityQueueSizeId = type.nameToId("highPriorityQueueSize");
        highPriorityQueueThrottleTimeId = type.nameToId("highPriorityQueueThrottleTime");
        highPriorityQueueThrottleCountId = type.nameToId("highPriorityQueueThrottleCount");
        partitionedRegionQueueSizeId = type.nameToId("partitionedRegionQueueSize");
        partitionedRegionQueueThrottleTimeId = type.nameToId("partitionedRegionQueueThrottleTime");
        partitionedRegionQueueThrottleCountId = type.nameToId("partitionedRegionQueueThrottleCount");
        functionExecutionQueueSizeId = type.nameToId("functionExecutionQueueSize");
        functionExecutionQueueThrottleTimeId = type.nameToId("functionExecutionQueueThrottleTime");
        functionExecutionQueueThrottleCountId = type.nameToId("functionExecutionQueueThrottleCount");
        serialQueueSizeId = type.nameToId("serialQueueSize");
        serialQueueBytesId = type.nameToId("serialQueueBytes");
        serialPooledThreadId = type.nameToId("serialPooledThread");
        serialQueueThrottleTimeId = type.nameToId("serialQueueThrottleTime");
        serialQueueThrottleCountId = type.nameToId("serialQueueThrottleCount");
        serialThreadsId = type.nameToId("serialThreads");
        processingThreadsId = type.nameToId("processingThreads");
        highPriorityThreadsId = type.nameToId("highPriorityThreads");
        partitionedRegionThreadsId = type.nameToId("partitionedRegionThreads");
        functionExecutionThreadsId = type.nameToId("functionExecutionThreads");
        waitingThreadsId = type.nameToId("waitingThreads");
        replyWaitsInProgressId = type.nameToId("replyWaitsInProgress");
        replyWaitsCompletedId = type.nameToId("replyWaitsCompleted");
        replyWaitTimeId = type.nameToId("replyWaitTime");
        replyTimeoutsId = type.nameToId("replyTimeouts");
        replyWaitMaxTimeId = type.nameToId("replyWaitMaxTime");
        receiverConnectionsId = type.nameToId("receivers");
        failedAcceptsId = type.nameToId("failedAccepts");
        failedConnectsId = type.nameToId("failedConnects");
        reconnectAttemptsId = type.nameToId("reconnectAttempts");
        lostConnectionLeaseId = type.nameToId("senderTimeouts");
        sharedOrderedSenderConnectionsId = type.nameToId("sendersSO");
        sharedUnorderedSenderConnectionsId = type.nameToId("sendersSU");
        threadOrderedSenderConnectionsId = type.nameToId("sendersTO");
        threadUnorderedSenderConnectionsId = type.nameToId("sendersTU");
        syncSocketWritesInProgressId = type.nameToId("syncSocketWritesInProgress");
        syncSocketWriteTimeId = type.nameToId("syncSocketWriteTime");
        syncSocketWritesId = type.nameToId("syncSocketWrites");
        syncSocketWriteBytesId = type.nameToId("syncSocketWriteBytes");
        ucastReadsId = type.nameToId("ucastReads");
        ucastReadBytesId = type.nameToId("ucastReadBytes");
        ucastWriteTimeId = type.nameToId("ucastWriteTime");
        ucastWritesId = type.nameToId("ucastWrites");
        ucastWriteBytesId = type.nameToId("ucastWriteBytes");
        ucastRetransmitsId = type.nameToId("ucastRetransmits");
        mcastReadsId = type.nameToId("mcastReads");
        mcastReadBytesId = type.nameToId("mcastReadBytes");
        mcastWriteTimeId = type.nameToId("mcastWriteTime");
        mcastWritesId = type.nameToId("mcastWrites");
        mcastWriteBytesId = type.nameToId("mcastWriteBytes");
        mcastRetransmitsId = type.nameToId("mcastRetransmits");
        mcastRetransmitRequestsId = type.nameToId("mcastRetransmitRequests");
        serializationTimeId = type.nameToId("serializationTime");
        serializationsId = type.nameToId("serializations");
        serializedBytesId = type.nameToId("serializedBytes");
        deserializationTimeId = type.nameToId("deserializationTime");
        deserializationsId = type.nameToId("deserializations");
        deserializedBytesId = type.nameToId("deserializedBytes");
        pdxSerializationsId = type.nameToId("pdxSerializations");
        pdxSerializedBytesId = type.nameToId("pdxSerializedBytes");
        pdxDeserializationsId = type.nameToId("pdxDeserializations");
        pdxDeserializedBytesId = type.nameToId("pdxDeserializedBytes");
        pdxInstanceDeserializationsId = type.nameToId("pdxInstanceDeserializations");
        pdxInstanceDeserializationTimeId = type.nameToId("pdxInstanceDeserializationTime");
        pdxInstanceCreationsId = type.nameToId("pdxInstanceCreations");
        msgSerializationTimeId = type.nameToId("msgSerializationTime");
        msgDeserializationTimeId = type.nameToId("msgDeserializationTime");
        batchSendTimeId = type.nameToId("batchSendTime");
        batchCopyTimeId = type.nameToId("batchCopyTime");
        batchWaitTimeId = type.nameToId("batchWaitTime");
        batchFlushTimeId = type.nameToId("batchFlushTime");
        ucastFlushesId = type.nameToId("ucastFlushes");
        ucastFlushTimeId = type.nameToId("ucastFlushTime");
        flowControlRequestsId = type.nameToId("flowControlRequests");
        flowControlResponsesId = type.nameToId("flowControlResponses");
        flowControlWaitsInProgressId = type.nameToId("flowControlWaitsInProgress");
        flowControlThrottleWaitsInProgressId = type.nameToId("flowControlThrottleWaitsInProgress");
        jgUNICASTdataReceivedTimeId = type.nameToId("jgUNICASTdataReceivedTime");
        jgReceivedMessagesSizeId = type.nameToId("jgNAKACKreceivedMessages");
        jgSentMessagesPoolSizeId = type.nameToId("jgNAKACKsentMessages");
        jgQueuedMessagesSizeId = type.nameToId("jgQueuedMessages");
        jgSTABLEsuspendTimeId = type.nameToId("jgSTABLEsuspendTime");
        jgSTABLEmessagesId = type.nameToId("jgSTABLEmessages");
        jgSTABLEmessagesSentId = type.nameToId("jgSTABLEmessagesSent");
        jgSTABILITYmessagesId = type.nameToId("jgSTABILITYmessages");
        jgFragmentationsPerformedId = type.nameToId("jgFragmentationsPerformed");
        jgFragmentsCreatedId = type.nameToId("jgFragmentsCreated");
        jgUcastReceivedMessagesSizeId = type.nameToId("jgUNICASTreceivedMessages");
        jgUcastSentMessagesSizeId = type.nameToId("jgUNICASTsentMessages");
        jgUcastSentHighPriorityMessagesSizeId = type.nameToId("jgUNICASTsentHighPriorityMessages");
        jgDownTimeId = type.nameToId("jgDownTime");
        jgUpTimeId = type.nameToId("jgUpTime");
        jChannelUpTimeId = type.nameToId("jChannelUpTime");
        jgFCsendBlocksId = type.nameToId("jgFCsendBlocks");
        jgFCautoRequestsId = type.nameToId("jgFCautoRequests");
        jgFCreplenishId = type.nameToId("jgFCreplenish");
        jgFCresumesId = type.nameToId("jgFCresumes");
        jgFCsentCreditsId = type.nameToId("jgFCsentCredits");
        jgFCsentThrottleRequestsId = type.nameToId("jgFCsentThrottleRequests");
        asyncSocketWritesInProgressId = type.nameToId("asyncSocketWritesInProgress");
        asyncSocketWritesId = type.nameToId("asyncSocketWrites");
        asyncSocketWriteRetriesId = type.nameToId("asyncSocketWriteRetries");
        asyncSocketWriteTimeId = type.nameToId("asyncSocketWriteTime");
        asyncSocketWriteBytesId = type.nameToId("asyncSocketWriteBytes");
        asyncQueueAddTimeId = type.nameToId("asyncQueueAddTime");
        asyncQueueRemoveTimeId = type.nameToId("asyncQueueRemoveTime");
        asyncQueuesId = type.nameToId("asyncQueues");
        asyncQueueFlushesInProgressId = type.nameToId("asyncQueueFlushesInProgress");
        asyncQueueFlushesCompletedId = type.nameToId("asyncQueueFlushesCompleted");
        asyncQueueFlushTimeId = type.nameToId("asyncQueueFlushTime");
        asyncQueueTimeoutExceededId = type.nameToId("asyncQueueTimeoutExceeded");
        asyncQueueSizeExceededId = type.nameToId("asyncQueueSizeExceeded");
        asyncDistributionTimeoutExceededId = type.nameToId("asyncDistributionTimeoutExceeded");
        asyncQueueSizeId = type.nameToId("asyncQueueSize");
        asyncQueuedMsgsId = type.nameToId("asyncQueuedMsgs");
        asyncDequeuedMsgsId = type.nameToId("asyncDequeuedMsgs");
        asyncConflatedMsgsId = type.nameToId("asyncConflatedMsgs");
        asyncThreadsId = type.nameToId("asyncThreads");
        asyncThreadInProgressId = type.nameToId("asyncThreadInProgress");
        asyncThreadCompletedId = type.nameToId("asyncThreadCompleted");
        asyncThreadTimeId = type.nameToId("asyncThreadTime");
        jgNAKACKwaitsId = type.nameToId("jgNAKACKwaits");
        threadOwnedReceiversId = type.nameToId("receiversTO");
        threadOwnedReceiversId2 = type.nameToId("receiversTO2");
        receiverDirectBufferSizeId = type.nameToId("receiverDirectBufferSize");
        receiverHeapBufferSizeId = type.nameToId("receiverHeapBufferSize");
        senderDirectBufferSizeId = type.nameToId("senderDirectBufferSize");
        senderHeapBufferSizeId = type.nameToId("senderHeapBufferSize");
        socketLocksInProgressId = type.nameToId("socketLocksInProgress");
        socketLocksId = type.nameToId("socketLocks");
        socketLockTimeId = type.nameToId("socketLockTime");
        bufferAcquiresInProgressId = type.nameToId("bufferAcquiresInProgress");
        bufferAcquiresId = type.nameToId("bufferAcquires");
        bufferAcquireTimeId = type.nameToId("bufferAcquireTime");
        messagesBeingReceivedId = type.nameToId("messagesBeingReceived");
        messageBytesBeingReceivedId = type.nameToId("messageBytesBeingReceived");
        serialThreadStartsId = type.nameToId("serialThreadStarts");
        viewThreadStartsId = type.nameToId("viewThreadStarts");
        processingThreadStartsId = type.nameToId("processingThreadStarts");
        highPriorityThreadStartsId = type.nameToId("highPriorityThreadStarts");
        waitingThreadStartsId = type.nameToId("waitingThreadStarts");
        partitionedRegionThreadStartsId = type.nameToId("partitionedRegionThreadStarts");
        functionExecutionThreadStartsId = type.nameToId("functionExecutionThreadStarts");
        serialPooledThreadStartsId = type.nameToId("serialPooledThreadStarts");
        TOSentMsgId = type.nameToId("TOSentMsgs");
        replyHandoffTimeId = type.nameToId("replyHandoffTime");
        partitionedRegionThreadJobsId = type.nameToId("partitionedRegionThreadJobs");
        functionExecutionThreadJobsId = type.nameToId("functionExecutionThreadJobs");
        viewThreadsId = type.nameToId("viewThreads");
        serialThreadJobsId = type.nameToId("serialThreadJobs");
        viewProcessorThreadJobsId = type.nameToId("viewThreadJobs");
        serialPooledThreadJobsId = type.nameToId("serialPooledThreadJobs");
        pooledMessageThreadJobsId = type.nameToId("processingThreadJobs");
        highPriorityThreadJobsId = type.nameToId("highPriorityThreadJobs");
        waitingPoolThreadJobsId = type.nameToId("waitingThreadJobs");
        eldersId = type.nameToId("elders");
        initialImageMessagesInFlightId = type.nameToId("initialImageMessagesInFlight");
        initialImageRequestsInProgressId = type.nameToId("initialImageRequestsInProgress");
    }
}

