/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.distributed.internal.QueueStatHelper;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class OverflowQueueWithDMStats
extends LinkedBlockingQueue {
    private static final long serialVersionUID = -1846248853494394996L;
    protected final QueueStatHelper stats;

    public OverflowQueueWithDMStats(QueueStatHelper stats) {
        this.stats = stats;
    }

    public OverflowQueueWithDMStats(int capacity, QueueStatHelper stats) {
        super(capacity);
        this.stats = stats;
    }

    @Override
    public boolean add(Object e) {
        this.preAdd(e);
        if (super.add(e)) {
            this.stats.add();
            return true;
        }
        this.postRemove(e);
        return false;
    }

    @Override
    public boolean offer(Object e) {
        this.preAdd(e);
        if (super.offer(e)) {
            this.stats.add();
            return true;
        }
        this.postRemove(e);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object e) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.preAddInterruptibly(e);
        boolean didOp = false;
        try {
            super.put(e);
            didOp = true;
            this.stats.add();
        }
        finally {
            if (!didOp) {
                this.postRemove(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.preAddInterruptibly(e);
        boolean didOp = false;
        try {
            if (super.offer(e, timeout, unit)) {
                didOp = true;
                this.stats.add();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (!didOp) {
                this.postRemove(e);
            }
        }
    }

    @Override
    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object result = super.take();
        this.postRemove(result);
        this.stats.remove();
        return result;
    }

    @Override
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object result = super.poll(timeout, unit);
        if (result != null) {
            this.postRemove(result);
            this.stats.remove();
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            this.stats.remove();
            this.postRemove(o);
            return true;
        }
        return false;
    }

    @Override
    public int drainTo(Collection c) {
        int result = super.drainTo(c);
        if (result > 0) {
            this.stats.remove(result);
            this.postDrain(c);
        }
        return result;
    }

    @Override
    public int drainTo(Collection c, int maxElements) {
        int result = super.drainTo(c, maxElements);
        if (result > 0) {
            this.stats.remove(result);
            this.postDrain(c);
        }
        return result;
    }

    protected void preAddInterruptibly(Object o) throws InterruptedException {
    }

    protected void preAdd(Object o) {
    }

    protected void postRemove(Object o) {
    }

    protected void postDrain(Collection c) {
    }
}

