/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.StringTokenizer;

class StartupMessageData {
    static final String SUPPORTED_VERSION = "6.6.3";
    static final String HOSTED_LOCATORS = "HL";
    static final String COMMA_DELIMITER = ",";
    static final String MCAST_PORT = "MP";
    static final String MCAST_HOST_ADDRESS = "MHA";
    static final String IS_SHARED_CONFIG_ENABLED = "ISCE";
    private final Properties optionalFields;

    StartupMessageData() {
        this.optionalFields = new Properties();
    }

    StartupMessageData(DataInput in, String version) throws ClassNotFoundException, IOException {
        this.optionalFields = (Properties)DataSerializer.readObject(in);
    }

    Collection<String> readHostedLocators() {
        if (this.optionalFields == null || this.optionalFields.isEmpty()) {
            return null;
        }
        ArrayList<String> hostedLocators = null;
        String hostedLocatorsString = this.optionalFields.getProperty(HOSTED_LOCATORS);
        if (hostedLocatorsString != null && !hostedLocatorsString.isEmpty()) {
            StringTokenizer st = new StringTokenizer(hostedLocatorsString, COMMA_DELIMITER);
            hostedLocators = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                String locatorString = st.nextToken();
                if (locatorString == null || locatorString.isEmpty()) continue;
                hostedLocators.add(locatorString);
            }
            if (hostedLocators.isEmpty()) {
                hostedLocators = null;
            }
        }
        return hostedLocators;
    }

    boolean readIsSharedConfigurationEnabled() {
        if (this.optionalFields == null || this.optionalFields.isEmpty()) {
            return false;
        }
        return Boolean.parseBoolean(this.optionalFields.getProperty(IS_SHARED_CONFIG_ENABLED));
    }

    void writeHostedLocators(Collection<String> hostedLocators) {
        String hostedLocatorsString;
        if (this.optionalFields == null) {
            return;
        }
        if (hostedLocators != null && !hostedLocators.isEmpty() && (hostedLocatorsString = StartupMessageData.asCommaDelimitedString(hostedLocators)) != null && !hostedLocatorsString.isEmpty()) {
            this.optionalFields.setProperty(HOSTED_LOCATORS, hostedLocatorsString);
        }
    }

    void writeIsSharedConfigurationEnabled(boolean isSharedConfigurationEnabled) {
        if (this.optionalFields == null) {
            return;
        }
        this.optionalFields.setProperty(IS_SHARED_CONFIG_ENABLED, Boolean.toString(isSharedConfigurationEnabled));
    }

    int readMcastPort() {
        String resultString;
        int result = 0;
        if (this.optionalFields != null && (resultString = this.optionalFields.getProperty(MCAST_PORT)) != null && !resultString.isEmpty()) {
            result = Integer.parseInt(resultString);
        }
        return result;
    }

    void writeMcastPort(int mcastPort) {
        if (this.optionalFields != null && mcastPort != 0) {
            this.optionalFields.setProperty(MCAST_PORT, Integer.toString(mcastPort));
        }
    }

    String readMcastHostAddress() {
        String result = null;
        if (this.optionalFields != null) {
            result = this.optionalFields.getProperty(MCAST_HOST_ADDRESS);
        }
        return result;
    }

    void writeMcastHostAddress(String addr) {
        if (this.optionalFields != null && addr != null && !addr.isEmpty()) {
            this.optionalFields.setProperty(MCAST_HOST_ADDRESS, addr);
        }
    }

    void toData(DataOutput out) throws IOException {
        if (this.optionalFields.isEmpty()) {
            DataSerializer.writeObject(null, out);
        } else {
            DataSerializer.writeObject(this.optionalFields, out);
        }
    }

    Properties getOptionalFields() {
        return this.optionalFields;
    }

    public static String asCommaDelimitedString(Collection<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(COMMA_DELIMITER);
            }
            sb.append(string);
        }
        return sb.toString();
    }
}

