/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.StartupMessageData;
import com.gemstone.gemfire.distributed.internal.StartupResponseMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.logging.log4j.Logger;

public class StartupResponseWithVersionMessage
extends StartupResponseMessage {
    private static final Logger logger = LogService.getLogger();
    private String version;
    private Collection<String> hostedLocators;
    private boolean isSharedConfigurationEnabled;
    private static Version[] serializationVersions = new Version[]{Version.GFE_80};

    public StartupResponseWithVersionMessage() {
    }

    StartupResponseWithVersionMessage(DistributionManager dm, int processorId, InternalDistributedMember recipient, String rejectionMessage, boolean responderIsAdmin) {
        super(dm, processorId, recipient, rejectionMessage, responderIsAdmin);
        this.version = GemFireVersion.getGemFireVersion();
        this.hostedLocators = InternalLocator.getLocatorStrings();
        InternalLocator locator = InternalLocator.getLocator();
        if (locator != null) {
            this.isSharedConfigurationEnabled = locator.isSharedConfigurationEnabled();
        }
    }

    @Override
    protected void process(DistributionManager dm) {
        super.process(dm);
        if (this.hostedLocators != null) {
            dm.addHostedLocators(this.getSender(), this.hostedLocators, this.isSharedConfigurationEnabled);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Received StartupResponseWithVersionMessage from a member with version: {}", this.version);
        }
    }

    @Override
    public int getDSFID() {
        return 146;
    }

    @Override
    public String toString() {
        return super.toString() + " version=" + this.version;
    }

    @Override
    public Version[] getSerializationVersions() {
        return serializationVersions;
    }

    @Override
    public void toDataPre_GFE_8_0_0_0(DataOutput out) throws IOException {
        super.toDataPre_GFE_8_0_0_0(out);
        this.cmnToData(out);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        this.cmnToData(out);
    }

    public void cmnToData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.version, out);
        StartupMessageData data = new StartupMessageData();
        data.writeHostedLocators(this.hostedLocators);
        data.writeIsSharedConfigurationEnabled(this.isSharedConfigurationEnabled);
        data.toData(out);
    }

    @Override
    public void fromDataPre_GFE_8_0_0_0(DataInput in) throws IOException, ClassNotFoundException {
        super.fromDataPre_GFE_8_0_0_0(in);
        this.cmnFromData(in);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cmnFromData(in);
    }

    public void cmnFromData(DataInput in) throws IOException, ClassNotFoundException {
        this.version = DataSerializer.readString(in);
        StartupMessageData data = new StartupMessageData(in, this.version);
        this.hostedLocators = data.readHostedLocators();
        this.isSharedConfigurationEnabled = data.readIsSharedConfigurationEnabled();
    }
}

