/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyGraph;
import com.gemstone.gemfire.distributed.internal.deadlock.DependencyMonitorManager;
import com.gemstone.gemfire.distributed.internal.deadlock.LocalLockInfo;
import com.gemstone.gemfire.distributed.internal.deadlock.LocalThread;
import com.gemstone.gemfire.distributed.internal.deadlock.ThreadReference;
import java.io.Serializable;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DeadlockDetector {
    DependencyGraph graph = new DependencyGraph();

    public void addDependencies(Set<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            this.graph.addEdge(dep);
        }
    }

    public LinkedList<Dependency> findDeadlock() {
        return this.graph.findCycle();
    }

    public DependencyGraph getDependencyGraph() {
        return this.graph;
    }

    public DependencyGraph findDependencyGraph(ThreadReference thread) {
        return this.graph.getSubGraph(thread);
    }

    public static Set<Dependency> collectAllDependencies(Serializable locality) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] infos = bean.dumpAllThreads(true, true);
        HashSet<Dependency> results = new HashSet<Dependency>();
        HashMap<Long, ThreadInfo> threadInfos = new HashMap<Long, ThreadInfo>();
        for (ThreadInfo info : infos) {
            Dependency<LocalLockInfo, LocalThread> dependency;
            if (info == null) continue;
            for (MonitorInfo monitor : info.getLockedMonitors()) {
                dependency = new Dependency<LocalLockInfo, LocalThread>(new LocalLockInfo(locality, monitor), new LocalThread(locality, info));
                results.add(dependency);
            }
            for (LockInfo sync : info.getLockedSynchronizers()) {
                dependency = new Dependency<LocalLockInfo, LocalThread>(new LocalLockInfo(locality, sync), new LocalThread(locality, info));
                results.add(dependency);
            }
            LockInfo waitingFor = info.getLockInfo();
            if (waitingFor != null) {
                Dependency<LocalThread, LocalLockInfo> dependency2 = new Dependency<LocalThread, LocalLockInfo>(new LocalThread(locality, info), new LocalLockInfo(locality, waitingFor));
                results.add(dependency2);
            }
            threadInfos.put(info.getThreadId(), info);
        }
        Set<Dependency> monitoredDependencies = DeadlockDetector.collectFromDependencyMonitor(bean, locality, threadInfos);
        results.addAll(monitoredDependencies);
        return results;
    }

    public static String prettyFormat(Collection<Dependency> deadlock) {
        StringBuilder text = new StringBuilder();
        LinkedHashSet<LocalThread> threads = new LinkedHashSet<LocalThread>();
        for (Dependency dep : deadlock) {
            Object depender = dep.getDepender();
            Object dependsOn = dep.getDependsOn();
            if (depender instanceof LocalThread) {
                text.append(depender + " is waiting on " + dependsOn + "\n");
                threads.add((LocalThread)depender);
                continue;
            }
            if (dependsOn instanceof LocalThread) {
                text.append(depender + " is held by " + dependsOn + "\n");
                threads.add((LocalThread)dependsOn);
                continue;
            }
            text.append(depender + " is waiting for " + dependsOn + "\n");
        }
        text.append("\nStack traces for involved threads\n");
        for (LocalThread threadInfo : threads) {
            text.append(threadInfo.getLocatility() + ":" + threadInfo.getThreadStack()).append("\n\n");
        }
        return text.toString();
    }

    public static String prettyFormat(DependencyGraph graph) {
        return DeadlockDetector.prettyFormat(graph.getEdges());
    }

    public static ThreadReference getThreadReference(String locality, Thread thread) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfo info = bean.getThreadInfo(thread.getId(), Integer.MAX_VALUE);
        return new LocalThread((Serializable)((Object)locality), info);
    }

    private static Set<Dependency> collectFromDependencyMonitor(ThreadMXBean bean, Serializable locality, Map<Long, ThreadInfo> threadInfos) {
        ThreadInfo info;
        HashSet<Dependency> results = new HashSet<Dependency>();
        Set<Dependency<Serializable, Thread>> heldResources = DependencyMonitorManager.getHeldResources();
        for (Dependency<Serializable, Thread> dep : heldResources) {
            Thread thread = dep.getDependsOn();
            Serializable resource = dep.getDepender();
            info = threadInfos.get(thread.getId());
            if (info == null) {
                info = bean.getThreadInfo(thread.getId());
            }
            if (info == null) continue;
            results.add(new Dependency<Serializable, LocalThread>(resource, new LocalThread(locality, info)));
        }
        Set<Dependency<Thread, Serializable>> blockedThreads = DependencyMonitorManager.getBlockedThreads();
        for (Dependency<Thread, Serializable> dep : blockedThreads) {
            Thread thread = dep.getDepender();
            info = threadInfos.get(thread.getId());
            if (info == null) {
                info = bean.getThreadInfo(thread.getId());
            }
            Serializable resource = dep.getDependsOn();
            results.add(new Dependency<LocalThread, Serializable>(new LocalThread(locality, info), resource));
        }
        return results;
    }
}

