/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.deadlock;

import com.gemstone.gemfire.distributed.internal.deadlock.Dependency;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DependencyGraph
implements Serializable {
    private static final long serialVersionUID = -6794339771271587648L;
    private Map<Object, Set<Dependency>> vertices = new LinkedHashMap<Object, Set<Dependency>>();
    private Set<Dependency> edges = new LinkedHashSet<Dependency>();

    public void addEdge(Dependency dependency) {
        this.edges.add(dependency);
        Set<Dependency> outboundEdges = this.vertices.get(dependency.getDepender());
        if (outboundEdges == null) {
            outboundEdges = new HashSet<Dependency>();
            this.vertices.put(dependency.getDepender(), outboundEdges);
        }
        outboundEdges.add(dependency);
        if (this.vertices.get(dependency.getDependsOn()) == null) {
            this.vertices.put(dependency.getDependsOn(), new HashSet());
        }
    }

    public LinkedList<Dependency> findCycle() {
        HashSet<Object> unvisited = new HashSet<Object>(this.vertices.keySet());
        HashSet<Object> finished = new HashSet<Object>(this.vertices.size());
        while (unvisited.size() > 0) {
            CycleHolder cycle;
            Object start = unvisited.iterator().next();
            boolean foundCycle = this.visitCycle(start, unvisited, finished, cycle = new CycleHolder());
            if (!foundCycle) continue;
            return cycle.cycle;
        }
        return null;
    }

    private boolean visitCycle(Object start, Set<Object> unvisited, Set<Object> finished, CycleHolder cycle) {
        if (finished.contains(start)) {
            return false;
        }
        if (!unvisited.remove(start)) {
            return true;
        }
        boolean foundCycle = false;
        for (Dependency dep : this.vertices.get(start)) {
            if (!(foundCycle |= this.visitCycle(dep.getDependsOn(), unvisited, finished, cycle))) continue;
            cycle.add(dep);
            break;
        }
        finished.add(start);
        return foundCycle;
    }

    public DependencyGraph getSubGraph(Object start) {
        DependencyGraph result = new DependencyGraph();
        this.populateSubGraph(start, result);
        return result;
    }

    private void populateSubGraph(Object start, DependencyGraph result) {
        if (result.vertices.keySet().contains(start)) {
            return;
        }
        if (this.vertices.get(start) == null) {
            return;
        }
        result.addVertex(start, this.vertices.get(start));
        for (Dependency dep : result.vertices.get(start)) {
            this.populateSubGraph(dep.getDependsOn(), result);
        }
    }

    private void addVertex(Object start, Set<Dependency> set) {
        this.vertices.put(start, set);
        this.edges.addAll(set);
    }

    public Collection<Dependency> getEdges() {
        return this.edges;
    }

    public Collection<Object> getVertices() {
        return this.vertices.keySet();
    }

    private static class CycleHolder {
        private LinkedList<Dependency> cycle = new LinkedList();
        private boolean cycleDone;

        private CycleHolder() {
        }

        public void add(Dependency dep) {
            if (this.cycleDone) {
                return;
            }
            this.cycle.addFirst(dep);
            Object lastVertex = this.cycle.getLast().getDependsOn();
            if (dep.depender.equals(lastVertex)) {
                this.cycleDone = true;
            }
        }
    }
}

