/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.locks.DLockToken;
import com.gemstone.gemfire.distributed.internal.locks.RemoteThread;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DLockRemoteToken
implements DataSerializableFixedID {
    private final Object name;
    private final int leaseId;
    private final long leaseExpireTime;
    private final RemoteThread lesseeThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DLockRemoteToken createFromDLockToken(DLockToken token) {
        DLockToken dLockToken = token;
        synchronized (dLockToken) {
            return new DLockRemoteToken(token.getName(), token.getLesseeThread(), token.getLeaseId(), token.getLeaseExpireTime());
        }
    }

    public static DLockRemoteToken createFromDataInput(DataInput in) throws IOException, ClassNotFoundException {
        Object name = DataSerializer.readObject(in);
        RemoteThread lesseeThread = null;
        InternalDistributedMember lessee = (InternalDistributedMember)DataSerializer.readObject(in);
        lesseeThread = new RemoteThread(lessee, in.readInt());
        int leaseId = in.readInt();
        long leaseExpireTime = in.readLong();
        return new DLockRemoteToken(name, lesseeThread, leaseId, leaseExpireTime);
    }

    public static DLockRemoteToken create(Object name, RemoteThread lesseeThread, int leaseId, long leaseExpireTime) {
        return new DLockRemoteToken(name, lesseeThread, leaseId, leaseExpireTime);
    }

    public DLockRemoteToken() {
        throw new UnsupportedOperationException("Use DLockRemoteToken#createFromDataInput(DataInput) instead.");
    }

    private DLockRemoteToken(Object name, RemoteThread lesseeThread, int leaseId, long leaseExpireTime) {
        this.name = name;
        this.lesseeThread = lesseeThread;
        this.leaseId = leaseId;
        this.leaseExpireTime = leaseExpireTime;
    }

    public Object getName() {
        return this.name;
    }

    public RemoteThread getLesseeThread() {
        return this.lesseeThread;
    }

    public DistributedMember getLessee() {
        if (this.lesseeThread == null) {
            return null;
        }
        return this.lesseeThread.getDistributedMember();
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public long getLeaseExpireTime() {
        return this.leaseExpireTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DLockRemoteToken@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(", name: ").append(this.name);
        sb.append(", lesseeThread: ").append(this.lesseeThread);
        sb.append(", leaseId: ").append(this.leaseId);
        sb.append(", leaseExpireTime: ").append(this.leaseExpireTime);
        return sb.toString();
    }

    @Override
    public int getDSFID() {
        return 117;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.name, out);
        DataSerializer.writeObject(this.lesseeThread.getDistributedMember(), out);
        out.writeInt(this.lesseeThread.getThreadId());
        out.writeInt(this.leaseId);
        out.writeLong(this.leaseExpireTime);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Use DLockRemoteToken#createFromDataInput(DataInput) instead.");
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

