/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.LockGrantorId;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.logging.log4j.Logger;

public class DeposeGrantorProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();

    static void send(String serviceName, InternalDistributedMember oldGrantor, InternalDistributedMember newGrantor, long newGrantorVersion, int newGrantorSerialNumber, DM dm) {
        InternalDistributedMember elder = dm.getId();
        if (elder.equals(oldGrantor)) {
            DeposeGrantorProcessor.doOldGrantorWork(serviceName, elder, newGrantor, newGrantorVersion, newGrantorSerialNumber, dm, null);
        } else {
            DeposeGrantorProcessor processor = new DeposeGrantorProcessor(dm, oldGrantor);
            DeposeGrantorMessage.send(serviceName, oldGrantor, newGrantor, newGrantorVersion, newGrantorSerialNumber, dm, processor);
            try {
                processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleAsUnexpected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void doOldGrantorWork(String serviceName, InternalDistributedMember elder, InternalDistributedMember youngTurk, long newGrantorVersion, int newGrantorSerialNumber, DM dm, DeposeGrantorMessage msg) {
        try {
            DLockService svc = DLockService.getInternalServiceNamed(serviceName);
            if (svc != null) {
                LockGrantorId newLockGrantorId = new LockGrantorId(dm, youngTurk, newGrantorVersion, newGrantorSerialNumber);
                svc.deposeOlderLockGrantorId(newLockGrantorId);
            }
        }
        finally {
            if (msg != null) {
                msg.reply(dm);
            }
        }
    }

    private DeposeGrantorProcessor(DM dm, InternalDistributedMember oldGrantor) {
        super(dm, oldGrantor);
    }

    public static final class DeposeGrantorMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private String serviceName;
        private InternalDistributedMember newGrantor;
        private long newGrantorVersion;
        private int newGrantorSerialNumber;

        protected static void send(String serviceName, InternalDistributedMember oldGrantor, InternalDistributedMember newGrantor, long newGrantorVersion, int newGrantorSerialNumber, DM dm, ReplyProcessor21 proc) {
            DeposeGrantorMessage msg = new DeposeGrantorMessage();
            msg.serviceName = serviceName;
            msg.newGrantor = newGrantor;
            msg.newGrantorVersion = newGrantorVersion;
            msg.newGrantorSerialNumber = newGrantorSerialNumber;
            msg.processorId = proc.getProcessorId();
            msg.setRecipient(oldGrantor);
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "DeposeGrantorMessage sending {} to {}", msg, oldGrantor);
            }
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        void reply(DM dm) {
            ReplyMessage.send(this.getSender(), this.getProcessorId(), null, (ReplySender)dm);
        }

        @Override
        protected void process(DistributionManager dm) {
            InternalDistributedMember elder = this.getSender();
            InternalDistributedMember youngTurk = this.newGrantor;
            DeposeGrantorProcessor.doOldGrantorWork(this.serviceName, elder, youngTurk, this.newGrantorVersion, this.newGrantorSerialNumber, dm, this);
        }

        @Override
        public int getDSFID() {
            return 114;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
            this.serviceName = DataSerializer.readString(in);
            this.newGrantor = (InternalDistributedMember)DataSerializer.readObject(in);
            this.newGrantorVersion = in.readLong();
            this.newGrantorSerialNumber = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
            DataSerializer.writeString(this.serviceName, out);
            DataSerializer.writeObject(this.newGrantor, out);
            out.writeLong(this.newGrantorVersion);
            out.writeInt(this.newGrantorSerialNumber);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("DeposeGrantorMessage (serviceName='").append(this.serviceName).append("' processorId=").append(this.processorId).append(" newGrantor=").append(this.newGrantor).append(" newGrantorVersion=").append(this.newGrantorVersion).append(" newGrantorSerialNumber=").append(this.newGrantorSerialNumber).append(")");
            return buff.toString();
        }
    }
}

