/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.RemoteThread;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public final class DistributedMemberLock
implements Lock {
    public static final long NON_EXPIRING_LEASE = -1L;
    final DLockService dls;
    final Serializable key;
    final long leaseTimeout;
    final LockReentryPolicy reentryPolicy;
    final DLockService.ThreadRequestState threadState;

    public DistributedMemberLock(DistributedLockService dls, Serializable key2) {
        this(dls, key2, -1L, LockReentryPolicy.ALLOW);
    }

    public DistributedMemberLock(DistributedLockService dls, Serializable key2, long leaseTimeout, LockReentryPolicy reentryPolicy) {
        if (dls == null || key2 == null) {
            throw new NullPointerException();
        }
        this.dls = (DLockService)dls;
        this.key = key2;
        this.leaseTimeout = leaseTimeout;
        this.reentryPolicy = reentryPolicy;
        RemoteThread rThread = new RemoteThread(this.getDM().getId(), this.dls.incThreadSequence());
        this.threadState = new DLockService.ThreadRequestState(rThread.getThreadId(), true);
    }

    @Override
    public synchronized void lock() {
        this.executeOperation(new Operation(){

            @Override
            public boolean operate() {
                if (DistributedMemberLock.this.holdsLock() && DistributedMemberLock.this.reentryPolicy.preventReentry(DistributedMemberLock.this)) {
                    return true;
                }
                boolean locked = DistributedMemberLock.this.dls.lock(DistributedMemberLock.this.key, -1L, DistributedMemberLock.this.leaseTimeout);
                Assert.assertTrue(locked, "Failed to lock " + this.toString());
                return locked;
            }
        });
    }

    @Override
    public synchronized void lockInterruptibly() throws InterruptedException {
        this.executeOperationInterruptibly(new Operation(){

            @Override
            public boolean operate() throws InterruptedException {
                if (DistributedMemberLock.this.holdsLock() && DistributedMemberLock.this.reentryPolicy.preventReentry(DistributedMemberLock.this)) {
                    return true;
                }
                boolean locked = DistributedMemberLock.this.dls.lockInterruptibly(DistributedMemberLock.this.key, -1L, DistributedMemberLock.this.leaseTimeout);
                Assert.assertTrue(locked, "Failed to lockInterruptibly " + this);
                return locked;
            }
        });
    }

    @Override
    public synchronized boolean tryLock() {
        return this.executeOperation(new Operation(){

            @Override
            public boolean operate() {
                if (DistributedMemberLock.this.holdsLock() && DistributedMemberLock.this.reentryPolicy.preventReentry(DistributedMemberLock.this)) {
                    return true;
                }
                return DistributedMemberLock.this.dls.lock(DistributedMemberLock.this.key, 0L, DistributedMemberLock.this.leaseTimeout);
            }
        });
    }

    @Override
    public synchronized boolean tryLock(final long time, final TimeUnit unit) throws InterruptedException {
        return this.executeOperationInterruptibly(new Operation(){

            @Override
            public boolean operate() throws InterruptedException {
                if (DistributedMemberLock.this.holdsLock() && DistributedMemberLock.this.reentryPolicy.preventReentry(DistributedMemberLock.this)) {
                    return true;
                }
                return DistributedMemberLock.this.dls.lockInterruptibly(DistributedMemberLock.this.key, DistributedMemberLock.this.getLockTimeoutForLock(time, unit), DistributedMemberLock.this.leaseTimeout);
            }
        });
    }

    @Override
    public synchronized void unlock() {
        this.executeOperation(new Operation(){

            @Override
            public boolean operate() {
                DistributedMemberLock.this.dls.unlock(DistributedMemberLock.this.key);
                return true;
            }
        });
    }

    public synchronized boolean holdsLock() {
        return this.executeOperation(new Operation(){

            @Override
            public boolean operate() {
                return DistributedMemberLock.this.dls.isHeldByThreadId(DistributedMemberLock.this.key, DistributedMemberLock.this.threadState.threadId);
            }
        });
    }

    private boolean executeOperationInterruptibly(Operation lockOp) throws InterruptedException {
        return this.doExecuteOperation(lockOp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeOperation(Operation lockOp) {
        while (true) {
            this.dls.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                boolean bl = this.doExecuteOperation(lockOp, false);
                return bl;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecuteOperation(Operation lockOp, boolean interruptible) throws InterruptedException {
        DLockService.ThreadRequestState oldThreadState = (DLockService.ThreadRequestState)this.dls.getThreadRequestState().get();
        try {
            this.threadState.interruptible = interruptible;
            this.dls.getThreadRequestState().set(this.threadState);
            boolean bl = lockOp.operate();
            return bl;
        }
        finally {
            this.threadState.interruptible = false;
            this.dls.getThreadRequestState().set(oldThreadState);
        }
    }

    private DM getDM() {
        return this.dls.getDistributionManager();
    }

    long getLockTimeoutForLock(long time, TimeUnit unit) {
        if (time == -1L) {
            return -1L;
        }
        return TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public String toString() {
        String identity = super.toString();
        identity = identity.substring(identity.lastIndexOf(".") + 1);
        StringBuffer sb = new StringBuffer("[" + identity + ": ");
        sb.append("dls=").append(this.dls.getName());
        sb.append("key=").append(this.key);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException(LocalizedStrings.DistributedMemberLock_NOT_IMPLEMENTED.toLocalizedString());
    }

    private static interface Operation {
        public boolean operate() throws InterruptedException;
    }

    public static enum LockReentryPolicy {
        ALLOW,
        THROW_ERROR,
        PREVENT_SILENTLY;


        boolean preventReentry(DistributedMemberLock lock) {
            switch (this) {
                case ALLOW: {
                    return false;
                }
                case THROW_ERROR: {
                    throw new IllegalStateException("Attempted to reenter held lock " + lock);
                }
                case PREVENT_SILENTLY: {
                    return true;
                }
            }
            throw new AssertionError((Object)("Unknown LockReentryPolicy: " + (Object)((Object)this)));
        }

        public String toString() {
            String myToString = "Unknown";
            switch (this) {
                case ALLOW: {
                    myToString = "ALLOW";
                    break;
                }
                case THROW_ERROR: {
                    myToString = "THROW_ERROR";
                    break;
                }
                case PREVENT_SILENTLY: {
                    myToString = "PREVENT_SILENTLY";
                    break;
                }
            }
            return myToString;
        }
    }
}

