/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.locks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.MessageWithReply;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import com.gemstone.gemfire.distributed.internal.locks.GrantorInfo;
import com.gemstone.gemfire.distributed.internal.locks.GrantorRequestProcessor;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ElderInitProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private final HashMap grantors;
    private final HashSet crashedGrantors;

    static void init(DM dm, HashMap map) {
        Set others;
        HashSet crashedGrantors = new HashSet();
        if (!dm.isAdam() && !(others = dm.getOtherDistributionManagerIds()).isEmpty()) {
            ElderInitProcessor processor = new ElderInitProcessor(dm, others, map, crashedGrantors);
            ElderInitMessage.send(others, dm, processor);
            try {
                processor.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                e.handleAsUnexpected();
            }
        }
        GrantorRequestProcessor.readyForElderRecovery(dm.getSystem(), null, null);
        DLockService.recoverLocalElder(dm, map, crashedGrantors);
        Iterator it = crashedGrantors.iterator();
        while (it.hasNext()) {
            map.put(it.next(), new GrantorInfo(null, 0L, 0, true));
        }
    }

    private ElderInitProcessor(DM dm, Set others, HashMap grantors, HashSet crashedGrantors) {
        super(dm, (Collection)others);
        this.grantors = grantors;
        this.crashedGrantors = crashedGrantors;
    }

    private synchronized void processData(ArrayList rmtGrantors, ArrayList rmtGrantorVersions, ArrayList rmtGrantorSerialNumbers, ArrayList rmtNonGrantors, InternalDistributedMember rmtId) {
        Iterator iterGrantorServices = rmtGrantors.iterator();
        Iterator iterGrantorVersions = rmtGrantorVersions.iterator();
        Iterator iterGrantorSerialNumbers = rmtGrantorSerialNumbers.iterator();
        while (iterGrantorServices.hasNext()) {
            String serviceName = (String)iterGrantorServices.next();
            long versionId = (Long)iterGrantorVersions.next();
            int serialNumber = (Integer)iterGrantorSerialNumbers.next();
            GrantorInfo oldgi = (GrantorInfo)this.grantors.get(serviceName);
            if (oldgi != null && oldgi.getVersionId() >= versionId) continue;
            this.grantors.put(serviceName, new GrantorInfo(rmtId, versionId, serialNumber, false));
            this.crashedGrantors.remove(serviceName);
        }
        for (String serviceName : rmtNonGrantors) {
            if (this.grantors.containsKey(serviceName)) continue;
            this.crashedGrantors.add(serviceName);
        }
    }

    @Override
    public void process(DistributionMessage msg) {
        if (msg instanceof ElderInitReplyMessage) {
            ElderInitReplyMessage eiMsg = (ElderInitReplyMessage)msg;
            this.processData(eiMsg.getGrantors(), eiMsg.getGrantorVersions(), eiMsg.getGrantorSerialNumbers(), eiMsg.getNonGrantors(), eiMsg.getSender());
        } else {
            Assert.assertTrue(false, "Expected instance of ElderInitReplyMessage but got " + msg.getClass());
        }
        super.process(msg);
    }

    public static final class ElderInitReplyMessage
    extends ReplyMessage {
        private ArrayList grantors;
        private ArrayList grantorVersions;
        private ArrayList grantorSerialNumbers;
        private ArrayList nonGrantors;

        public static void send(MessageWithReply reqMsg, DM dm, ArrayList grantors, ArrayList grantorVersions, ArrayList grantorSerialNumbers, ArrayList nonGrantors) {
            ElderInitReplyMessage m = new ElderInitReplyMessage();
            m.grantors = grantors;
            m.grantorVersions = grantorVersions;
            m.grantorSerialNumbers = grantorSerialNumbers;
            m.nonGrantors = nonGrantors;
            m.processorId = reqMsg.getProcessorId();
            m.setRecipient(reqMsg.getSender());
            dm.putOutgoing(m);
        }

        public ArrayList getGrantors() {
            return this.grantors;
        }

        public ArrayList getGrantorVersions() {
            return this.grantorVersions;
        }

        public ArrayList getGrantorSerialNumbers() {
            return this.grantorSerialNumbers;
        }

        public ArrayList getNonGrantors() {
            return this.nonGrantors;
        }

        @Override
        public int getDSFID() {
            return 113;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.grantors = DataSerializer.readArrayList(in);
            this.grantorVersions = DataSerializer.readArrayList(in);
            this.grantorSerialNumbers = DataSerializer.readArrayList(in);
            this.nonGrantors = DataSerializer.readArrayList(in);
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeArrayList(this.grantors, out);
            DataSerializer.writeArrayList(this.grantorVersions, out);
            DataSerializer.writeArrayList(this.grantorSerialNumbers, out);
            DataSerializer.writeArrayList(this.nonGrantors, out);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("ElderInitReplyMessage").append("; sender=").append(this.getSender()).append("; processorId=").append(this.processorId).append("; grantors=").append(this.grantors).append("; grantorVersions=").append(this.grantorVersions).append("; grantorSerialNumbers=").append(this.grantorSerialNumbers).append("; nonGrantors=").append(this.nonGrantors).append(")");
            return buff.toString();
        }
    }

    public static final class ElderInitMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;

        protected static void send(Set others, DM dm, ReplyProcessor21 proc) {
            ElderInitMessage msg = new ElderInitMessage();
            msg.processorId = proc.getProcessorId();
            msg.setRecipients(others);
            if (logger.isTraceEnabled(LogMarker.DLS)) {
                logger.trace(LogMarker.DLS, "ElderInitMessage sending {} to {}", msg, others);
            }
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        private void reply(DM dm, ArrayList grantors, ArrayList grantorVersions, ArrayList grantorSerialNumbers, ArrayList nonGrantors) {
            ElderInitReplyMessage.send(this, dm, grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
        }

        @Override
        protected void process(DistributionManager dm) {
            ArrayList grantors = new ArrayList();
            ArrayList grantorVersions = new ArrayList();
            ArrayList grantorSerialNumbers = new ArrayList();
            ArrayList nonGrantors = new ArrayList();
            if (dm.waitForElder(this.getSender())) {
                GrantorRequestProcessor.readyForElderRecovery(dm.getSystem(), this.getSender(), null);
                DLockService.recoverRmtElder(grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
                this.reply(dm, grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
            } else if (dm.getOtherNormalDistributionManagerIds().isEmpty()) {
                logger.info(LogMarker.DLS, LocalizedMessage.create(LocalizedStrings.ElderInitProcessor__0_RETURNING_EMPTY_LISTS_BECAUSE_I_KNOW_OF_NO_OTHER_MEMBERS, this));
                this.reply(dm, grantors, grantorVersions, grantorSerialNumbers, nonGrantors);
            } else {
                logger.info(LogMarker.DLS, LocalizedMessage.create(LocalizedStrings.ElderInitProcessor_0_DISREGARDING_REQUEST_FROM_DEPARTED_MEMBER, this));
            }
        }

        @Override
        public int getDSFID() {
            return 112;
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.processorId = in.readInt();
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.processorId);
        }

        @Override
        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append("ElderInitMessage (processorId='").append(this.processorId).append(")");
            return buff.toString();
        }
    }
}

