/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.membership.InternalRole;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.distributed.internal.membership.MemberFactory;
import com.gemstone.gemfire.distributed.internal.membership.NetMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.org.jgroups.stack.IpAddress;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class InternalDistributedMember
implements DistributedMember,
Externalizable,
DataSerializableFixedID,
DistributionAdvisor.ProfileId,
VersionSource<DistributedMember> {
    private static final long serialVersionUID = -2785249969777296507L;
    protected NetMember ipAddr;
    private int dcPort = -1;
    private int vmPid = -1;
    private int vmKind = -1;
    private int vmViewId = -1;
    private boolean isPartial;
    private String[] groups;
    private volatile Set<Role> rolesSet = null;
    private final Object rolesLock = new Object();
    private String name = null;
    private String uniqueTag = null;
    private static final int SB_ENABLED_MASK = 1;
    private static final int COORD_ENABLED_MASK = 2;
    private static final int PARTIAL_ID_MASK = 4;
    private static final int VERSION_MASK = 8;
    private String hostName = null;
    private transient short version = Version.CURRENT_ORDINAL;
    private transient Version versionObj = Version.CURRENT;
    private DurableClientAttributes durableClientAttributes = null;
    private static final Version[] dsfidVersions = new Version[]{Version.GFE_71};
    private transient String cachedToString;

    private void defaultToCurrentHost() {
        int defaultDcPort;
        this.dcPort = defaultDcPort = MemberAttributes.DEFAULT.getPort();
        this.vmKind = MemberAttributes.DEFAULT.getVmKind();
        this.vmPid = MemberAttributes.DEFAULT.getVmPid();
        this.name = MemberAttributes.DEFAULT.getName();
        this.groups = MemberAttributes.DEFAULT.getGroups();
        this.vmViewId = MemberAttributes.DEFAULT.getVmViewId();
        this.durableClientAttributes = MemberAttributes.DEFAULT.getDurableClientAttributes();
        if (this.ipAddr instanceof JGroupMember) {
            ((JGroupMember)this.ipAddr).getAddress().setProcessId(this.vmPid);
        }
        try {
            this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(SocketCreator.getLocalHost()) : SocketCreator.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ee) {
            throw new InternalGemFireError(ee);
        }
    }

    public InternalDistributedMember() {
        this.groups = new String[0];
    }

    public InternalDistributedMember(InetAddress i, int p, boolean splitBrainEnabled, boolean canBeCoordinator, MemberAttributes attr) {
        this.dcPort = attr.getPort();
        this.vmPid = attr.getVmPid();
        this.vmKind = attr.getVmKind();
        this.vmViewId = attr.getVmViewId();
        this.name = attr.getName();
        this.groups = attr.getGroups();
        this.durableClientAttributes = attr.getDurableClientAttributes();
        this.ipAddr = MemberFactory.newNetMember(i, p, splitBrainEnabled, canBeCoordinator, attr);
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(i) : i.getHostAddress();
    }

    public InternalDistributedMember(NetMember m) {
        this.ipAddr = m;
        MemberAttributes attr = m.getAttributes();
        String string = this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(m.getIpAddress()) : m.getIpAddress().getHostAddress();
        if (attr != null) {
            this.dcPort = attr.getPort();
            this.vmPid = attr.getVmPid();
            this.vmKind = attr.getVmKind();
            this.vmViewId = attr.getVmViewId();
            this.name = attr.getName();
            this.groups = attr.getGroups();
            this.durableClientAttributes = attr.getDurableClientAttributes();
        }
        IpAddress addr = ((JGroupMember)m).getAddress();
        this.version = addr.getVersionOrdinal();
        try {
            this.versionObj = Version.fromOrdinal(this.version, false);
        }
        catch (UnsupportedVersionException e) {
            this.versionObj = Version.CURRENT;
        }
        this.cachedToString = null;
    }

    public InternalDistributedMember(String i, int p) throws UnknownHostException {
        this.ipAddr = MemberFactory.newNetMember(i, p);
        this.defaultToCurrentHost();
        this.vmKind = 10;
        ((JGroupMember)this.ipAddr).getAddress().setGemFireAttributes(MemberAttributes.DEFAULT);
    }

    public InternalDistributedMember(String i, int p, String n, String u) throws UnknownHostException {
        this.ipAddr = MemberFactory.newNetMember(i, p);
        this.defaultToCurrentHost();
        ((JGroupMember)this.ipAddr).getAddress().setGemFireAttributes(MemberAttributes.DEFAULT);
        this.name = n;
        this.uniqueTag = u;
    }

    public InternalDistributedMember(InetAddress i, int p) {
        this.ipAddr = MemberFactory.newNetMember(i, p);
        this.defaultToCurrentHost();
    }

    public InternalDistributedMember(InetAddress addr, int p, boolean isCurrentHost) {
        this.ipAddr = MemberFactory.newNetMember(addr, p);
        if (isCurrentHost) {
            this.defaultToCurrentHost();
        }
    }

    public InetAddress getIpAddress() {
        return this.ipAddr.getIpAddress();
    }

    public NetMember getNetMember() {
        return this.ipAddr;
    }

    public int getPort() {
        return this.ipAddr.getPort();
    }

    public int getDirectChannelPort() {
        assert (!this.isPartial);
        return this.dcPort;
    }

    public int getVmKind() {
        return this.vmKind;
    }

    public int getVmViewId() {
        return this.vmViewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Role> getRoles() {
        Set<Role> tmpRolesSet = this.rolesSet;
        if (tmpRolesSet != null) {
            return tmpRolesSet;
        }
        assert (!this.isPartial);
        Object object = this.rolesLock;
        synchronized (object) {
            tmpRolesSet = this.rolesSet;
            if (tmpRolesSet == null) {
                String[] tmpRoles = this.groups;
                if (tmpRoles.length == 0) {
                    tmpRolesSet = Collections.emptySet();
                } else {
                    tmpRolesSet = new HashSet<Role>(tmpRoles.length);
                    for (int i = 0; i < tmpRoles.length; ++i) {
                        tmpRolesSet.add(InternalRole.getRole(tmpRoles[i]));
                    }
                    tmpRolesSet = Collections.unmodifiableSet(tmpRolesSet);
                }
                this.rolesSet = tmpRolesSet;
            }
        }
        Assert.assertTrue(tmpRolesSet != null);
        return tmpRolesSet;
    }

    @Override
    public List<String> getGroups() {
        return Collections.unmodifiableList(Arrays.asList(this.groups));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGroups(String[] newGroups) {
        assert (!this.isPartial);
        assert (newGroups != null);
        Object object = this.rolesLock;
        synchronized (object) {
            this.groups = newGroups;
            this.synchPayload();
            this.rolesSet = null;
            this.cachedToString = null;
        }
    }

    private void synchPayload() {
        this.ipAddr.setAttributes(new MemberAttributes(this.dcPort, this.vmPid, this.vmKind, this.vmViewId, this.name, this.groups, this.durableClientAttributes));
    }

    public void setVmKind(int p) {
        this.vmKind = p;
        this.synchPayload();
        this.cachedToString = null;
    }

    public void setVmViewId(int p) {
        this.vmViewId = p;
        this.synchPayload();
    }

    public int getVmPid() {
        return this.vmPid;
    }

    public void setVmPid(int p) {
        this.vmPid = p;
        this.synchPayload();
        this.cachedToString = null;
    }

    @Override
    public String getName() {
        String result = this.name;
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Override
    public DurableClientAttributes getDurableClientAttributes() {
        assert (!this.isPartial);
        return this.durableClientAttributes;
    }

    @Override
    public int compareTo(DistributedMember o) {
        int i;
        byte[] otherBytes;
        int otherPort;
        if (this == o) {
            return 0;
        }
        if (o == null || !(o instanceof InternalDistributedMember)) {
            throw new ClassCastException(LocalizedStrings.InternalDistributedMember_INTERNALDISTRIBUTEDMEMBERCOMPARETO_COMPARISON_BETWEEN_DIFFERENT_CLASSES.toLocalizedString());
        }
        InternalDistributedMember other = (InternalDistributedMember)o;
        int myPort = this.getPort();
        if (myPort < (otherPort = other.getPort())) {
            return -1;
        }
        if (myPort > otherPort) {
            return 1;
        }
        InetAddress myAddr = this.getIpAddress();
        InetAddress otherAddr = other.getIpAddress();
        if (myAddr == null && otherAddr == null) {
            if (myPort < otherPort) {
                return -1;
            }
            if (myPort > otherPort) {
                return 1;
            }
            return 0;
        }
        if (myAddr == null) {
            return -1;
        }
        if (otherAddr == null) {
            return 1;
        }
        byte[] myBytes = myAddr.getAddress();
        if (myBytes != (otherBytes = otherAddr.getAddress())) {
            for (i = 0; i < myBytes.length; ++i) {
                if (i >= otherBytes.length) {
                    return -1;
                }
                if (myBytes[i] < otherBytes[i]) {
                    return -1;
                }
                if (myBytes[i] <= otherBytes[i]) continue;
                return 1;
            }
            if (myBytes.length > otherBytes.length) {
                return 1;
            }
        }
        if (this.name != null || other.name != null) {
            if (this.name == null) {
                return -1;
            }
            if (other.name == null) {
                return 1;
            }
            i = this.name.compareTo(other.name);
            if (i != 0) {
                return i;
            }
        }
        if (this.uniqueTag == null && other.uniqueTag == null) {
            if (this.vmViewId < other.vmViewId) {
                return -1;
            }
            if (this.vmViewId > other.vmViewId) {
                return 1;
            }
        } else {
            if (this.uniqueTag == null) {
                return -1;
            }
            if (other.uniqueTag == null) {
                return 1;
            }
            i = this.uniqueTag.compareTo(other.uniqueTag);
            if (i != 0) {
                return i;
            }
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof InternalDistributedMember)) {
            return false;
        }
        return this.compareTo((InternalDistributedMember)obj) == 0;
    }

    public int hashCode() {
        int result = 0;
        result += this.ipAddr.getIpAddress().hashCode();
        return result += this.getPort();
    }

    private String shortName(String hostname) {
        if (hostname == null) {
            return "<null inet_addr hostname>";
        }
        int index2 = hostname.indexOf(46);
        if (index2 > 0 && !Character.isDigit(hostname.charAt(0))) {
            return hostname.substring(0, index2);
        }
        return hostname;
    }

    public String toString() {
        String result = this.cachedToString;
        if (result == null) {
            InetAddress add = this.getIpAddress();
            String host = add.isMulticastAddress() ? add.getHostAddress() : (SocketCreator.resolve_dns ? this.shortName(this.hostName) : this.hostName);
            StringBuilder sb = new StringBuilder();
            sb.append(host);
            String myName = this.getName();
            if (this.vmPid > 0 || this.vmKind != 10 || !"".equals(myName)) {
                sb.append("(");
                if (!"".equals(myName)) {
                    sb.append(myName);
                    if (this.vmPid > 0) {
                        sb.append(':');
                    }
                }
                if (this.vmPid > 0) {
                    sb.append(Integer.toString(this.vmPid));
                }
                String vmStr = "";
                switch (this.vmKind) {
                    case 10: {
                        break;
                    }
                    case 11: {
                        vmStr = ":locator";
                        break;
                    }
                    case 12: {
                        vmStr = ":admin";
                        break;
                    }
                    case 13: {
                        vmStr = ":loner";
                        break;
                    }
                    default: {
                        vmStr = ":<unknown:" + this.vmKind + ">";
                    }
                }
                sb.append(vmStr);
                sb.append(")");
            }
            if (this.ipAddr.splitBrainEnabled() && this.ipAddr.canBeCoordinator()) {
                sb.append("<ec>");
            }
            if (this.vmViewId >= 0) {
                sb.append("<v" + this.vmViewId + ">");
            }
            sb.append(":");
            sb.append(this.getPort());
            if (this.vmKind == 13) {
                if (this.uniqueTag != null && this.uniqueTag.length() != 0) {
                    sb.append(":").append(this.uniqueTag);
                }
                if (this.name != null && this.name.length() != 0) {
                    sb.append(":").append(this.name);
                }
            }
            if (this.version != Version.CURRENT.ordinal()) {
                sb.append("(version:").append(Version.toString(this.version)).append(')');
            }
            this.cachedToString = result = sb.toString();
        }
        return result;
    }

    private void readVersion(int flags, DataInput in) throws IOException {
        if ((flags & 8) != 0) {
            this.version = Version.readOrdinal(in);
            this.versionObj = Version.fromOrdinalNoThrow(this.version, false);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Assert.assertTrue(this.vmKind > 0);
        byte[] address = this.getIpAddress().getAddress();
        out.writeInt(address.length);
        out.write(address);
        out.writeInt(this.getPort());
        DataSerializer.writeString(this.hostName, out);
        int flags = 0;
        if (this.ipAddr.splitBrainEnabled()) {
            flags |= 1;
        }
        if (this.ipAddr.canBeCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial) {
            flags |= 4;
        }
        out.writeByte((byte)((flags |= 8) & 0xFF));
        out.writeInt(this.dcPort);
        out.writeInt(this.vmPid);
        out.writeInt(this.vmKind);
        out.writeInt(this.vmViewId);
        DataSerializer.writeStringArray(this.groups, out);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeString(this.uniqueTag, out);
        DataSerializer.writeString(this.durableClientAttributes == null ? "" : this.durableClientAttributes.getId(), out);
        DataSerializer.writeInteger(this.durableClientAttributes == null ? 300 : this.durableClientAttributes.getTimeout(), out);
        Version.writeOrdinal(out, this.version, true);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] addr = new byte[len];
        in.readFully(addr);
        InetAddress inetAddr = InetAddress.getByAddress(addr);
        int port = in.readInt();
        this.hostName = DataSerializer.readString(in);
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.isPartial = (flags & 4) != 0;
        this.dcPort = in.readInt();
        this.vmPid = in.readInt();
        this.vmKind = in.readInt();
        this.vmViewId = in.readInt();
        this.groups = DataSerializer.readStringArray(in);
        this.name = DataSerializer.readString(in);
        this.uniqueTag = DataSerializer.readString(in);
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        this.durableClientAttributes = new DurableClientAttributes(durableId, durableTimeout);
        this.readVersion(flags, in);
        this.ipAddr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, new MemberAttributes(this.dcPort, this.vmPid, this.vmKind, this.vmViewId, this.name, this.groups, this.durableClientAttributes));
        ((JGroupMember)this.ipAddr).getAddress().setVersionOrdinal(this.version);
        Assert.assertTrue(this.vmKind > 0);
    }

    @Override
    public int getDSFID() {
        return 92;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        Assert.assertTrue(this.vmKind > 0);
        DataSerializer.writeInetAddress(this.getIpAddress(), out);
        out.writeInt(this.getPort());
        DataSerializer.writeString(this.hostName, out);
        int flags = 0;
        if (this.ipAddr.splitBrainEnabled()) {
            flags |= 1;
        }
        if (this.ipAddr.canBeCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial) {
            flags |= 4;
        }
        out.writeByte((byte)((flags |= 8) & 0xFF));
        out.writeInt(this.dcPort);
        out.writeInt(this.vmPid);
        out.writeByte(this.vmKind);
        DataSerializer.writeStringArray(this.groups, out);
        DataSerializer.writeString(this.name, out);
        if (this.vmKind == 13) {
            DataSerializer.writeString(this.uniqueTag, out);
        } else {
            DataSerializer.writeString(String.valueOf(this.vmViewId), out);
        }
        DataSerializer.writeString(this.durableClientAttributes == null ? "" : this.durableClientAttributes.getId(), out);
        DataSerializer.writeInteger(this.durableClientAttributes == null ? 300 : this.durableClientAttributes.getTimeout(), out);
        Version.writeOrdinal(out, this.version, true);
    }

    public void toDataPre_GFE_7_1_0_0(DataOutput out) throws IOException {
        Assert.assertTrue(this.vmKind > 0);
        DataSerializer.writeInetAddress(this.getIpAddress(), out);
        out.writeInt(this.getPort());
        DataSerializer.writeString(this.hostName, out);
        int flags = 0;
        if (this.ipAddr.splitBrainEnabled()) {
            flags |= 1;
        }
        if (this.ipAddr.canBeCoordinator()) {
            flags |= 2;
        }
        if (this.isPartial) {
            flags |= 4;
        }
        out.writeByte((byte)(flags & 0xFF));
        out.writeInt(this.dcPort);
        out.writeInt(this.vmPid);
        out.writeByte(this.vmKind);
        DataSerializer.writeStringArray(this.groups, out);
        DataSerializer.writeString(this.name, out);
        if (this.vmKind == 13) {
            DataSerializer.writeString(this.uniqueTag, out);
        } else {
            DataSerializer.writeString(String.valueOf(this.vmViewId), out);
        }
        DataSerializer.writeString(this.durableClientAttributes == null ? "" : this.durableClientAttributes.getId(), out);
        DataSerializer.writeInteger(this.durableClientAttributes == null ? 300 : this.durableClientAttributes.getTimeout(), out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = DataSerializer.readInetAddress(in);
        int port = in.readInt();
        this.hostName = DataSerializer.readString(in);
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getCanonicalHostName(inetAddr, this.hostName) : inetAddr.getHostAddress();
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.isPartial = (flags & 4) != 0;
        this.dcPort = in.readInt();
        this.vmPid = in.readInt();
        this.vmKind = in.readUnsignedByte();
        this.groups = DataSerializer.readStringArray(in);
        this.name = DataSerializer.readString(in);
        if (this.vmKind == 13) {
            this.uniqueTag = DataSerializer.readString(in);
        } else {
            String str = DataSerializer.readString(in);
            if (str != null) {
                this.vmViewId = Integer.parseInt(str);
            }
        }
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        this.durableClientAttributes = new DurableClientAttributes(durableId, durableTimeout);
        this.readVersion(flags, in);
        MemberAttributes attr = new MemberAttributes(this.dcPort, this.vmPid, this.vmKind, this.vmViewId, this.name, this.groups, this.durableClientAttributes);
        this.ipAddr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, attr);
        ((JGroupMember)this.ipAddr).getAddress().setVersionOrdinal(this.version);
        this.synchPayload();
        Assert.assertTrue(this.vmKind > 0);
    }

    public void fromDataPre_GFE_7_1_0_0(DataInput in) throws IOException, ClassNotFoundException {
        InetAddress inetAddr = DataSerializer.readInetAddress(in);
        int port = in.readInt();
        this.hostName = DataSerializer.readString(in);
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getCanonicalHostName(inetAddr, this.hostName) : inetAddr.getHostAddress();
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.isPartial = (flags & 4) != 0;
        this.dcPort = in.readInt();
        this.vmPid = in.readInt();
        this.vmKind = in.readUnsignedByte();
        this.groups = DataSerializer.readStringArray(in);
        this.name = DataSerializer.readString(in);
        if (this.vmKind == 13) {
            this.uniqueTag = DataSerializer.readString(in);
        } else {
            String str = DataSerializer.readString(in);
            if (str != null) {
                this.vmViewId = Integer.parseInt(str);
            }
        }
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        this.durableClientAttributes = new DurableClientAttributes(durableId, durableTimeout);
        MemberAttributes attr = new MemberAttributes(this.dcPort, this.vmPid, this.vmKind, this.vmViewId, this.name, this.groups, this.durableClientAttributes);
        this.ipAddr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, attr);
        this.synchPayload();
        Assert.assertTrue(this.vmKind > 0);
    }

    public static InternalDistributedMember readEssentialData(DataInput in) throws IOException, ClassNotFoundException {
        InternalDistributedMember mbr = new InternalDistributedMember();
        mbr._readEssentialData(in);
        return mbr;
    }

    private void _readEssentialData(DataInput in) throws IOException, ClassNotFoundException {
        this.isPartial = true;
        InetAddress inetAddr = DataSerializer.readInetAddress(in);
        int port = in.readInt();
        this.hostName = SocketCreator.resolve_dns ? SocketCreator.getHostName(inetAddr) : inetAddr.getHostAddress();
        int flags = in.readUnsignedByte();
        boolean sbEnabled = (flags & 1) != 0;
        boolean elCoord = (flags & 2) != 0;
        this.vmKind = in.readUnsignedByte();
        if (this.vmKind == 13) {
            this.uniqueTag = DataSerializer.readString(in);
        } else {
            String str = DataSerializer.readString(in);
            if (str != null) {
                this.vmViewId = Integer.parseInt(str);
            }
        }
        this.name = DataSerializer.readString(in);
        MemberAttributes attr = new MemberAttributes(this.dcPort, this.vmPid, this.vmKind, this.vmViewId, this.name, this.groups, this.durableClientAttributes);
        this.ipAddr = MemberFactory.newNetMember(inetAddr, port, sbEnabled, elCoord, attr);
        this.synchPayload();
    }

    @Override
    public void writeEssentialData(DataOutput out) throws IOException {
        Assert.assertTrue(this.vmKind > 0);
        DataSerializer.writeInetAddress(this.getIpAddress(), out);
        out.writeInt(this.getPort());
        int flags = 0;
        if (this.ipAddr.splitBrainEnabled()) {
            flags |= 1;
        }
        if (this.ipAddr.canBeCoordinator()) {
            flags |= 2;
        }
        out.writeByte((byte)((flags |= 4) & 0xFF));
        out.writeByte(this.vmKind);
        if (this.vmKind == 13) {
            DataSerializer.writeString(this.uniqueTag, out);
        } else {
            DataSerializer.writeString(String.valueOf(this.vmViewId), out);
        }
        DataSerializer.writeString(this.name, out);
    }

    public void setDirectChannelPort(int p) {
        this.dcPort = p;
        this.synchPayload();
    }

    public void setPort(int p) {
        assert (this.vmKind == 13);
        this.ipAddr.setPort(p);
        this.synchPayload();
        this.cachedToString = null;
    }

    public void dropCachedString() {
        this.cachedToString = null;
    }

    @Override
    public String getHost() {
        return this.ipAddr.getIpAddress().getCanonicalHostName();
    }

    @Override
    public int getProcessId() {
        return this.vmPid;
    }

    @Override
    public String getId() {
        return this.toString();
    }

    public final Version getVersionObject() {
        return this.versionObj;
    }

    @Override
    public Version[] getSerializationVersions() {
        return dsfidVersions;
    }
}

