/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MemberAttributes
implements DataSerializable {
    private static final long serialVersionUID = -3257772958884802693L;
    public static final MemberAttributes INVALID;
    public static MemberAttributes DEFAULT;
    private int dcPort;
    private int vmPid;
    private int vmKind;
    private int vmViewId;
    private String name;
    private String[] groups;
    private DurableClientAttributes durableClientAttributes;
    private byte[] byteInfo;

    public static void setDefaults(int dcPort, int vmPid, int vmKind, int vmViewId, String name, String[] groups, DurableClientAttributes durableClientAttributes) {
        DEFAULT = new MemberAttributes(dcPort, vmPid, vmKind, vmViewId, name, groups, durableClientAttributes);
    }

    public MemberAttributes(int dcPort, int vmPid, int vmKind, int vmViewId, String p_name, String[] p_groups, DurableClientAttributes durableClientAttributes) {
        String[] l_groups = p_groups;
        this.dcPort = dcPort;
        this.vmPid = vmPid;
        this.vmKind = vmKind;
        this.vmViewId = vmViewId;
        if (l_groups == null) {
            l_groups = new String[]{};
        }
        this.name = p_name == null ? "" : p_name;
        this.groups = l_groups;
        this.durableClientAttributes = durableClientAttributes;
    }

    public MemberAttributes(byte[] b) throws IOException, ClassNotFoundException {
        this.byteInfo = b;
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        this.fromData(in);
    }

    public MemberAttributes(MemberAttributes other) {
        this.dcPort = other.dcPort;
        this.vmPid = other.vmPid;
        this.vmKind = other.vmKind;
        this.name = other.name;
        this.groups = other.groups;
        this.durableClientAttributes = other.durableClientAttributes;
    }

    public int getPort() {
        return this.dcPort;
    }

    public int getVmPid() {
        return this.vmPid;
    }

    public int getVmKind() {
        return this.vmKind;
    }

    public String getName() {
        return this.name;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public DurableClientAttributes getDurableClientAttributes() {
        return this.durableClientAttributes;
    }

    public static String[] parseGroups(String csv) {
        if (csv == null || csv.length() == 0) {
            return new String[0];
        }
        ArrayList<String> groups = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            String groupName = st.nextToken().trim();
            if (groups.contains(groupName)) continue;
            groups.add(groupName);
        }
        return groups.toArray(new String[groups.size()]);
    }

    public static String[] parseGroups(String csvRoles, String csvGroups) {
        ArrayList<String> groups = new ArrayList<String>();
        MemberAttributes.parseCsv(groups, csvRoles);
        MemberAttributes.parseCsv(groups, csvGroups);
        return groups.toArray(new String[groups.size()]);
    }

    private static void parseCsv(List<String> groups, String csv) {
        if (csv == null || csv.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            String groupName = st.nextToken().trim();
            if (groups.contains(groupName)) continue;
            groups.add(groupName);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.dcPort);
        out.writeInt(this.vmPid);
        out.writeInt(this.vmKind);
        DataSerializer.writeString(this.name, out);
        DataSerializer.writeStringArray(this.groups, out);
        DataSerializer.writeString(this.durableClientAttributes == null ? "" : this.durableClientAttributes.getId(), out);
        DataSerializer.writeInteger(this.durableClientAttributes == null ? 300 : this.durableClientAttributes.getTimeout(), out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.dcPort = in.readInt();
        this.vmPid = in.readInt();
        this.vmKind = in.readInt();
        this.name = DataSerializer.readString(in);
        this.groups = DataSerializer.readStringArray(in);
        String durableId = DataSerializer.readString(in);
        int durableTimeout = DataSerializer.readInteger(in);
        this.durableClientAttributes = new DurableClientAttributes(durableId, durableTimeout);
    }

    public byte[] toByteArray() {
        if (this.byteInfo != null) {
            return this.byteInfo;
        }
        try {
            HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
            this.toData(hdos);
            this.byteInfo = hdos.toByteArray();
            return this.byteInfo;
        }
        catch (IOException e) {
            throw new InternalGemFireError(LocalizedStrings.MemberAttributes_IOEXCEPTION_ON_A_BYTE_ARRAY_0.toLocalizedString(e));
        }
    }

    public static MemberAttributes fromByteArray(byte[] bytes) {
        try {
            return new MemberAttributes(bytes);
        }
        catch (IOException e) {
            throw new InternalGemFireError(LocalizedStrings.MemberAttributes_IOEXCEPTION_ON_A_BYTE_ARRAY_0.toLocalizedString(e));
        }
        catch (ClassNotFoundException e) {
            throw new InternalGemFireError(LocalizedStrings.MemberAttributes_CLASSNOTFOUNDEXCEPTION_IN_DESERIALIZATION_0.toLocalizedString(e));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[MemberAttributes: ");
        sb.append("dcPort=").append(this.dcPort);
        sb.append(", vmPid=").append(this.vmPid);
        sb.append(", vmKind=").append(this.vmKind);
        sb.append(", name=").append(this.name);
        sb.append(", groups=").append("(");
        for (int i = 0; i < this.groups.length; ++i) {
            sb.append(this.groups[i]);
        }
        sb.append(")");
        sb.append(", durableClientAttributes=").append(this.durableClientAttributes);
        sb.append("]");
        return sb.toString();
    }

    public static void setDefaultVmPid(int uniqueID) {
        MemberAttributes.setDefaults(MemberAttributes.DEFAULT.dcPort, uniqueID, MemberAttributes.DEFAULT.vmKind, MemberAttributes.DEFAULT.vmViewId, MemberAttributes.DEFAULT.name, MemberAttributes.DEFAULT.groups, MemberAttributes.DEFAULT.durableClientAttributes);
    }

    public int getVmViewId() {
        return this.vmViewId;
    }

    static {
        DEFAULT = INVALID = new MemberAttributes(-1, -1, -1, -1, null, null, null);
    }
}

