/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.jgroup;

import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.distributed.DurableClientAttributes;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.distributed.internal.membership.NetMember;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.org.jgroups.stack.IpAddress;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;

public class JGroupMember
implements NetMember {
    private transient IpAddress ipAddr;

    public JGroupMember() {
    }

    public IpAddress getAddress() {
        return this.ipAddr;
    }

    @Override
    public MemberAttributes getAttributes() {
        return new MemberAttributes(this.ipAddr.getDirectPort(), this.ipAddr.getProcessId(), this.ipAddr.getVmKind(), this.ipAddr.getBirthViewId(), this.ipAddr.getName(), this.ipAddr.getRoles(), (DurableClientAttributes)this.ipAddr.getDurableClientAttributes());
    }

    @Override
    public void setAttributes(MemberAttributes p_attr) {
        MemberAttributes attr = p_attr;
        if (attr == null) {
            attr = MemberAttributes.INVALID;
        }
        this.ipAddr.setGemFireAttributes(attr);
    }

    public JGroupMember(IpAddress base) {
        this.ipAddr = base;
    }

    public JGroupMember(JGroupMember m) {
        this.ipAddr = m.ipAddr;
    }

    public JGroupMember(String i, int p) {
        this.ipAddr = new IpAddress(i, p);
    }

    public JGroupMember(InetAddress i, int p, boolean splitBrainEnabled, boolean canBeCoordinator) {
        this.ipAddr = new IpAddress(i, p);
        this.ipAddr.splitBrainEnabled(splitBrainEnabled);
        this.ipAddr.shouldntBeCoordinator(!canBeCoordinator);
    }

    public JGroupMember(int port) {
        this.ipAddr = new IpAddress(port);
    }

    @Override
    public InetAddress getIpAddress() {
        return this.ipAddr.getIpAddress();
    }

    @Override
    public int getPort() {
        return this.ipAddr.getPort();
    }

    @Override
    public boolean isMulticastAddress() {
        return this.ipAddr.isMulticastAddress();
    }

    @Override
    public boolean splitBrainEnabled() {
        return this.ipAddr.splitBrainEnabled();
    }

    @Override
    public boolean canBeCoordinator() {
        return this.ipAddr.preferredForCoordinator();
    }

    @Override
    public int compare(NetMember other) {
        return this.compareTo(other);
    }

    @Override
    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o == null || !(o instanceof JGroupMember)) {
            throw new ClassCastException(LocalizedStrings.JGroupMember_JGROUPMEMBERCOMPARETO_COMPARISON_BETWEEN_DIFFERENT_CLASSES.toLocalizedString());
        }
        return this.ipAddr.compareTo(((JGroupMember)o).ipAddr);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof JGroupMember)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    @Override
    public int hashCode() {
        return this.ipAddr.hashCode();
    }

    @Override
    public String toString() {
        return this.ipAddr.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.ipAddr == null) {
            throw new InternalGemFireError(LocalizedStrings.JGroupMember_ATTEMPT_TO_EXTERNALIZE_NULL_IP_ADDRESS.toLocalizedString());
        }
        byte[] address = this.ipAddr.getIpAddress().getAddress();
        out.writeInt(address.length);
        out.write(address);
        out.writeInt(this.ipAddr.getPort());
        out.write(this.ipAddr.getFlags());
        Version.writeOrdinal(out, this.ipAddr.getVersionOrdinal(), true);
        byte[] bytes = new MemberAttributes(this.ipAddr.getDirectPort(), this.ipAddr.getProcessId(), this.ipAddr.getVmKind(), this.ipAddr.getBirthViewId(), this.ipAddr.getName(), this.ipAddr.getRoles(), (DurableClientAttributes)this.ipAddr.getDurableClientAttributes()).toByteArray();
        if (bytes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        byte[] addr = new byte[len];
        in.readFully(addr);
        InetAddress ia = InetAddress.getByAddress(addr);
        int port = in.readInt();
        byte flags = in.readByte();
        this.ipAddr = new IpAddress(ia, port);
        this.ipAddr.setFlags(flags);
        this.ipAddr.readVersion(flags, in);
        len = in.readInt();
        if (len != 0) {
            byte[] bytes = new byte[len];
            in.readFully(bytes);
            this.ipAddr.setGemFireAttributes(new MemberAttributes(bytes));
        }
    }

    @Override
    public void setPort(int p) {
        IpAddress i = new IpAddress(this.ipAddr.getIpAddress(), p);
        i.setFlags(this.ipAddr.getFlags());
        i.setVmKind(this.ipAddr.getVmKind());
        i.setDirectPort(this.ipAddr.getDirectPort());
        i.setProcessId(this.ipAddr.getProcessId());
        i.setRoles(this.ipAddr.getRoles());
        i.setDurableClientAttributes(this.ipAddr.getDurableClientAttributes());
        i.setVersionOrdinal(this.ipAddr.getVersionOrdinal());
        this.ipAddr = i;
    }
}

