/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.jgroup;

import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.DistributedMembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.distributed.internal.membership.MemberServices;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.NetMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.tcp.ConnectionException;
import java.net.InetAddress;

public class JGroupMemberFactory
implements MemberServices {
    @Override
    public NetMember newNetMember(InetAddress i, int p, boolean splitBrainEnabled, boolean canBeCoordinator, MemberAttributes attr) {
        JGroupMember result = new JGroupMember(i, p, splitBrainEnabled, canBeCoordinator);
        result.setAttributes(attr);
        return result;
    }

    private MemberAttributes getDefaultAttributes() {
        if (MemberAttributes.DEFAULT.getVmPid() == -1 || MemberAttributes.DEFAULT.getVmKind() == -1) {
            MemberAttributes.setDefaults(-1, OSProcess.getId(), -1, DistributionManager.getDistributionManagerType(), null, null, null);
        }
        return MemberAttributes.DEFAULT;
    }

    @Override
    public NetMember newNetMember(InetAddress i, int p) {
        JGroupMember result = new JGroupMember(i, p, false, true);
        result.setAttributes(this.getDefaultAttributes());
        return result;
    }

    @Override
    public NetMember newNetMember(String s, int p) {
        JGroupMember result = new JGroupMember(s, p);
        result.setAttributes(this.getDefaultAttributes());
        return result;
    }

    @Override
    public NetMember newNetMember() {
        return new JGroupMember();
    }

    @Override
    public MembershipManager newMembershipManager(DistributedMembershipListener listener, DistributionConfig config, RemoteTransportConfig transport, DMStats stats) throws DistributionException {
        try {
            return new JGroupMembershipManager().initialize(listener, config, transport, stats);
        }
        catch (ConnectionException e) {
            throw new DistributionException(LocalizedStrings.JGroupMemberFactory_UNABLE_TO_CREATE_MEMBERSHIP_MANAGER.toLocalizedString(), e);
        }
    }
}

