/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.jgroup;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.ForcedDisconnectException;
import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.ToDataException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.util.BoundedLinkedHashMap;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.SizeableRunnable;
import com.gemstone.gemfire.distributed.internal.StartupMessage;
import com.gemstone.gemfire.distributed.internal.ThrottlingMemLinkedQueueWithDMStats;
import com.gemstone.gemfire.distributed.internal.direct.DirectChannel;
import com.gemstone.gemfire.distributed.internal.membership.DistributedMembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.MembershipTestHook;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.QuorumChecker;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMember;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.QuorumCheckerImpl;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.ViewMessage;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.AlertAppender;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.shared.StringPrintWriter;
import com.gemstone.gemfire.internal.tcp.ConnectExceptions;
import com.gemstone.gemfire.internal.tcp.ConnectionException;
import com.gemstone.gemfire.internal.tcp.MemberShunnedException;
import com.gemstone.gemfire.internal.tcp.Stub;
import com.gemstone.gemfire.internal.tcp.TCPConduit;
import com.gemstone.gemfire.internal.util.Breadcrumbs;
import com.gemstone.gnu.trove.TIntObjectHashMap;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Channel;
import com.gemstone.org.jgroups.ChannelClosedException;
import com.gemstone.org.jgroups.ChannelNotConnectedException;
import com.gemstone.org.jgroups.JChannel;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.Receiver;
import com.gemstone.org.jgroups.ShunnedAddressException;
import com.gemstone.org.jgroups.SuspectMember;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.oswego.concurrent.Latch;
import com.gemstone.org.jgroups.protocols.FD;
import com.gemstone.org.jgroups.protocols.FD_SOCK;
import com.gemstone.org.jgroups.protocols.TCP;
import com.gemstone.org.jgroups.protocols.TP;
import com.gemstone.org.jgroups.protocols.UDP;
import com.gemstone.org.jgroups.protocols.UNICAST;
import com.gemstone.org.jgroups.protocols.VERIFY_SUSPECT;
import com.gemstone.org.jgroups.protocols.pbcast.GMS;
import com.gemstone.org.jgroups.protocols.pbcast.NAKACK;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.NotSerializableException;
import java.io.PrintWriter;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;

public class JGroupMembershipManager
implements MembershipManager {
    private static final Logger logger = LogService.getLogger();
    volatile boolean disableMulticastForRollingUpgrade;
    boolean wasReconnectingSystem;
    private volatile QuorumCheckerImpl quorumChecker;
    private volatile DatagramSocket oldDSMembershipSocket;
    private ThreadLocal<Boolean> forceUseJGroups = new ThreadLocal();
    private Timer timer = new Timer("Membership Timer", true);
    public static final String JAVAGROUPS_CONFIG = System.getProperty("DistributionManager.JAVAGROUPS_CONFIG");
    private static final String DEFAULT_JAVAGROUPS_TCP_CONFIG = "com/gemstone/gemfire/distributed/internal/javagroups-config.txt";
    private static final String DEFAULT_JAVAGROUPS_MCAST_CONFIG = "com/gemstone/gemfire/distributed/internal/javagroups-mcast.txt";
    public static boolean DEBUG_JAVAGROUPS = Boolean.getBoolean("DistributionManager.DEBUG_JAVAGROUPS");
    private static boolean isMcastDiscovery = false;
    private static boolean isMcastEnabled = false;
    public static final boolean DISABLE_UCAST_FLUSH = !Boolean.getBoolean("p2p.enableUcastFlush");
    private int membershipCheckTimeout = 1000;
    protected volatile JChannel channel;
    protected final EventProcessingLock startupLock = new EventProcessingLock();
    protected NetView latestView = new NetView();
    protected ViewLock latestViewLock = new ViewLock();
    protected DistributedMembershipListener listener;
    List membershipTestHooks;
    protected InternalDistributedMember myMemberId = null;
    protected DirectChannel directChannel;
    protected TCPConduit conduit;
    protected MyDCReceiver dcReceiver;
    private DistributionConfig dconfig;
    volatile boolean isJoining;
    volatile boolean hasConnected;
    protected final Map memberToStubMap = new ConcurrentHashMap();
    protected final Map stubToMemberMap = new ConcurrentHashMap();
    private final Map ipAddrToMemberMap = new ConcurrentHashMap();
    protected final Map shunnedMembers = new ConcurrentHashMap();
    private final Map shutdownMembers = new BoundedLinkedHashMap(1000);
    protected final HashSet shunnedAndWarnedMembers = new HashSet();
    protected final Map<InternalDistributedMember, Long> surpriseMembers = new ConcurrentHashMap<InternalDistributedMember, Long>();
    protected int surpriseMemberTimeout;
    private final Map<InternalDistributedMember, Long> suspectedMembers = new ConcurrentHashMap<InternalDistributedMember, Long>();
    private final long suspectMemberTimeout = 180000L;
    private long channelPause = 0L;
    private boolean enableJgStackStats = Boolean.getBoolean("p2p.enableJgStackStats");
    private static final int SHUNNED_SUNSET = Integer.getInteger("gemfire.shunned-member-timeout", 300);
    protected volatile boolean channelInitialized = false;
    protected volatile boolean shutdownInProgress = false;
    protected volatile boolean processingEvents = false;
    long lastViewId = -1L;
    UNICAST ucastProtocol;
    VERIFY_SUSPECT verifySuspectProtocol;
    FD fdProtocol;
    UDP udpProtocol;
    TCP tcpProtocol;
    NAKACK nakAckProtocol;
    FD_SOCK fdSockProtocol;
    private Object sendSuspendMutex = new Object();
    private boolean sendSuspended = false;
    DMStats stats;
    protected LinkedList startupMessages = new LinkedList();
    int vmKind;
    private final HashMap memberLatch = new HashMap();
    Puller puller;
    volatile Exception shutdownCause;
    private SystemTimer cleanupTimer;
    private final Object startupMutex = new Object();
    GMS gmsProtocol;
    private static volatile boolean emergencyClassesLoaded = false;
    protected static volatile boolean inhibitForceDisconnectLogging;
    boolean beingSick;
    boolean playingDead;

    public static void setDebugJGroups(boolean flag) {
        GemFireTracer.DEBUG = flag;
        Protocol.trace = flag;
    }

    public void enableNetworkPartitionDetection() {
        if (logger.isDebugEnabled()) {
            logger.debug("Network partition detection is being enabled");
        }
        this.dconfig.setEnableNetworkPartitionDetection(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processView(long newViewId, NetView newView) {
        if (logger.isInfoEnabled(LogMarker.DM_VIEWS)) {
            StringBuffer msg = new StringBuffer(200);
            msg.append("Membership: Processing view (id = ");
            msg.append(newViewId).append(") {");
            msg.append(DistributionManager.printView(newView));
            if (newView.getCrashedMembers().size() > 0) {
                msg.append(" with unexpected departures [");
                Iterator it = newView.getCrashedMembers().iterator();
                while (it.hasNext()) {
                    msg.append(it.next());
                    if (!it.hasNext()) continue;
                    msg.append(',');
                }
                msg.append(']');
            }
            msg.append("} on " + this.myMemberId.toString());
            if (logger.isDebugEnabled()) {
                logger.trace(LogMarker.DM_VIEWS, (Object)msg);
            }
            if (!newView.contains(this.myMemberId)) {
                logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_THE_MEMBER_WITH_ID_0_IS_NO_LONGER_IN_MY_OWN_VIEW_1, new Object[]{this.myMemberId, newView}));
            }
        }
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            InternalDistributedMember m;
            Map.Entry<InternalDistributedMember, Long> entry;
            InternalDistributedMember m2;
            Version itsVersion;
            Version version = Version.CURRENT;
            Iterator<Map.Entry<InternalDistributedMember, Long>> it = this.surpriseMembers.entrySet().iterator();
            while (it.hasNext()) {
                InternalDistributedMember mbr = it.next().getKey();
                itsVersion = mbr.getVersionObject();
                if (itsVersion == null || version.compareTo(itsVersion) >= 0) continue;
                version = itsVersion;
            }
            for (InternalDistributedMember mbr : newView) {
                itsVersion = mbr.getVersionObject();
                if (itsVersion == null || itsVersion.compareTo(version) >= 0) continue;
                version = mbr.getVersionObject();
            }
            boolean bl = this.disableMulticastForRollingUpgrade = !version.equals(Version.CURRENT);
            if (newViewId < this.lastViewId) {
                if (newViewId < this.lastViewId && logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                    logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: Ignoring view (with id {}) since it is older than the last view (with id {}); ignoredView={}", newViewId, this.lastViewId, DistributionManager.printView(newView));
                }
                return;
            }
            NetView priorView = this.latestView;
            this.lastViewId = newViewId;
            this.latestView = newView;
            HashSet warnShuns = new HashSet();
            for (int i = 0; i < newView.size(); ++i) {
                Object oldStub;
                Latch currentLatch;
                boolean isSecure;
                m2 = (InternalDistributedMember)newView.elementAt(i);
                boolean wasSurprise = this.surpriseMembers.remove(m2) != null;
                this.suspectedMembers.remove(m2);
                if (priorView.contains(m2) || wasSurprise) continue;
                String authInit = this.dconfig.getSecurityPeerAuthInit();
                boolean bl2 = isSecure = authInit != null && authInit.length() != 0;
                if (isSecure && (currentLatch = (Latch)this.memberLatch.get(m2)) != null) {
                    currentLatch.release();
                }
                if ((oldStub = this.memberToStubMap.remove(m2)) != null) {
                    this.stubToMemberMap.remove(oldStub);
                }
                if (this.shutdownInProgress()) {
                    logger.info(LogMarker.DM_VIEWS, LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_SHUNNING_MEMBER__0__DURING_OUR_SHUTDOWN, m2));
                    this.addShunnedMember(m2);
                    continue;
                }
                boolean wasShunned = this.endShun(m2);
                if (wasShunned && logger.isTraceEnabled(LogMarker.DM_VIEWS)) {
                    logger.debug("No longer shunning {} as it is in the current membership view", m2);
                }
                logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_PROCESSING_ADDITION__0_, m2));
                try {
                    this.listener.newMemberConnected(m2, this.getStubForMember(m2));
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (DistributedSystemDisconnectedException e) {
                    continue;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_FAULT_WHILE_PROCESSING_VIEW_ADDITION_OF__0, m2), t);
                }
            }
            Iterator it2 = warnShuns.iterator();
            while (it2.hasNext()) {
                this.warnShun((DistributedMember)it2.next());
            }
            for (int i = 0; i < priorView.size(); ++i) {
                m2 = (InternalDistributedMember)priorView.elementAt(i);
                if (newView.contains(m2) || this.surpriseMembers.containsKey(m2)) continue;
                try {
                    logger.info(LogMarker.DM_VIEWS, LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_PROCESSING_DEPARTING_MEMBER__0_, m2));
                    this.removeWithViewLock(m2, newView.getCrashedMembers().contains(m2) || this.suspectedMembers.containsKey(m2), "departed JGroups view");
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_FAULT_WHILE_PROCESSING_VIEW_REMOVAL_OF__0, m2), t);
                }
            }
            long oldestAllowed = System.currentTimeMillis() - (long)this.surpriseMemberTimeout;
            Iterator<Map.Entry<InternalDistributedMember, Long>> it3 = this.surpriseMembers.entrySet().iterator();
            while (it3.hasNext()) {
                entry = it3.next();
                Long birthtime = entry.getValue();
                if (birthtime < oldestAllowed) {
                    it3.remove();
                    m = entry.getKey();
                    logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_EXPIRING_MEMBERSHIP_OF_SURPRISE_MEMBER_0, m));
                    this.removeWithViewLock(m, true, "not seen in membership view in " + this.surpriseMemberTimeout + "ms");
                    continue;
                }
                if (this.latestView.contains(entry.getKey())) continue;
                this.latestView.add(entry.getKey());
            }
            oldestAllowed = System.currentTimeMillis() - this.suspectMemberTimeout;
            it3 = this.suspectedMembers.entrySet().iterator();
            while (it3.hasNext()) {
                entry = it3.next();
                Long birthtime = entry.getValue();
                if (birthtime >= oldestAllowed) continue;
                m = entry.getKey();
                it3.remove();
                if (!logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) continue;
                logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: expiring suspect member <{}>", m);
            }
            try {
                this.listener.viewInstalled(this.latestView);
                this.startCleanupTimer();
            }
            catch (DistributedSystemDisconnectedException se) {
                // empty catch block
            }
        }
        logger.info(LogMarker.DM_VIEWS, LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_FINISHED_VIEW_PROCESSING_VIEWID___0, newViewId));
    }

    protected static NetView viewToMemberView(View v) {
        Vector vmem = v.getMembers();
        NetView members = new NetView(v.getMembers().size(), v.getVid().getId());
        Address leadmember = v.getLeadMember();
        Address creator = v.getCreator();
        for (int i = 0; i < vmem.size(); ++i) {
            IpAddress a = (IpAddress)vmem.get(i);
            JGroupMember m = new JGroupMember(a);
            InternalDistributedMember d = new InternalDistributedMember(m);
            members.add(d);
            if (leadmember != null && leadmember.equals(a)) {
                members.setLeadMember(m);
            }
            if (creator == null || !creator.equals(a)) continue;
            members.setCreator(m);
        }
        Set smem = v.getSuspectedMembers();
        if (smem != null) {
            HashSet<InternalDistributedMember> snmem = new HashSet<InternalDistributedMember>(smem.size());
            for (IpAddress a : smem) {
                JGroupMember m = new JGroupMember(a);
                InternalDistributedMember d = new InternalDistributedMember(m);
                snmem.add(d);
            }
            members.setCrashedMembers(snmem);
        }
        return members;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JChannel createChannel(RemoteTransportConfig transport, DistributionConfig theConfig) {
        String properties;
        InputStream is;
        this.shutdownCause = null;
        isMcastDiscovery = transport.isMcastDiscovery();
        isMcastEnabled = transport.isMcastEnabled();
        if (JAVAGROUPS_CONFIG != null) {
            File file = new File(JAVAGROUPS_CONFIG);
            if (!file.exists()) {
                throw new GemFireConfigException(LocalizedStrings.JGroupMembershipManager_JGROUPS_CONFIGURATION_FILE_0_DOES_NOT_EXIST.toLocalizedString(JAVAGROUPS_CONFIG));
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Reading Jgroups config from {}", file);
                }
                is = new FileInputStream(file);
            }
            catch (IOException ex) {
                throw new GemFireConfigException(LocalizedStrings.JGroupMembershipManager_AN_IOEXCEPTION_WAS_THROWN_WHILE_OPENING_0.toLocalizedString(file), ex);
            }
        } else {
            String r = null;
            r = isMcastEnabled ? DEFAULT_JAVAGROUPS_MCAST_CONFIG : DEFAULT_JAVAGROUPS_TCP_CONFIG;
            is = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), r);
            if (is == null) {
                throw new GemFireConfigException(LocalizedStrings.JGroupMembershipManager_CANNOT_FIND_0.toLocalizedString(r));
            }
        }
        try {
            String input;
            StringBuffer sb = new StringBuffer(3000);
            BufferedReader br = JAVAGROUPS_CONFIG != null ? new BufferedReader(new InputStreamReader(is)) : new BufferedReader(new InputStreamReader(is, "US-ASCII"));
            while ((input = br.readLine()) != null) {
                sb.append(input);
            }
            br.close();
            properties = sb.toString();
        }
        catch (Exception ex) {
            throw new GemFireConfigException(LocalizedStrings.JGroupMembershipManager_AN_EXCEPTION_WAS_THROWN_WHILE_READING_JGROUPS_CONFIG.toLocalizedString(), ex);
        }
        long fdTimeout = Long.getLong("gemfire.FD_TIMEOUT", 0L);
        if (isMcastEnabled) {
            properties = JGroupMembershipManager.replaceStrings(properties, "MULTICAST_PORT", String.valueOf(transport.getMcastId().getPort()));
            properties = JGroupMembershipManager.replaceStrings(properties, "MULTICAST_HOST", transport.getMcastId().getHost().getHostAddress());
            properties = JGroupMembershipManager.replaceStrings(properties, "MULTICAST_TTL", String.valueOf(theConfig.getMcastTtl()));
            properties = JGroupMembershipManager.replaceStrings(properties, "MULTICAST_SEND_BUFFER_SIZE", String.valueOf(theConfig.getMcastSendBufferSize()));
            properties = JGroupMembershipManager.replaceStrings(properties, "MULTICAST_RECV_BUFFER_SIZE", String.valueOf(theConfig.getMcastRecvBufferSize()));
            properties = JGroupMembershipManager.replaceStrings(properties, "RETRANSMIT_LIMIT", String.valueOf(theConfig.getUdpFragmentSize() - 256));
            properties = JGroupMembershipManager.replaceStrings(properties, "MAX_SENT_MSGS_SIZE", System.getProperty("p2p.maxSentMsgsSize", "0"));
        }
        properties = Boolean.getBoolean("p2p.simulateDiscard") ? JGroupMembershipManager.replaceStrings(properties, "DISCARD", "com.gemstone.org.jgroups.protocols.DISCARD(down_thread=false; up_thread=false;up=" + System.getProperty("p2p.simulateDiscard.received", "0") + ";" + "down=" + System.getProperty("p2p.simulateDiscard.sent", "0.05") + ")?") : JGroupMembershipManager.replaceStrings(properties, "DISCARD", "");
        if (!isMcastDiscovery) {
            boolean disableCoord;
            if (isMcastEnabled) {
                properties = JGroupMembershipManager.replaceStrings(properties, "OPTIONAL_GOSSIP_PROTOCOL", "com.gemstone.org.jgroups.protocols.TCPGOSSIP(num_ping_requests=NUM_PING_REQUESTS;timeout=DISCOVERY_TIMEOUT;split-brain-detection=PARTITION_DETECTION;gossip_refresh_rate=GOSSIP_REFRESH_RATE;initial_hosts=INITIAL_HOSTS;gossip_server_wait_time=GOSSIP_SERVER_WAIT_TIME;num_initial_members=2;up_thread=false;down_thread=false)?");
                properties = JGroupMembershipManager.replaceStrings(properties, "OPTIONAL_PING_PROTOCOL", "");
            }
            properties = JGroupMembershipManager.replaceStrings(properties, "INITIAL_HOSTS", transport.locatorsString());
            properties = JGroupMembershipManager.replaceStrings(properties, "NUM_INITIAL_MEMBERS", System.getProperty("p2p.numInitialMembers", "1"));
            boolean bl = disableCoord = !Boolean.getBoolean("p2p.enableInitialCoordinator");
            if (theConfig.getStartLocator() != null) {
                disableCoord = false;
            }
            properties = JGroupMembershipManager.replaceStrings(properties, "DISABLE_COORD", String.valueOf(disableCoord));
        } else {
            properties = JGroupMembershipManager.replaceStrings(properties, "OPTIONAL_GOSSIP_PROTOCOL", "");
            properties = JGroupMembershipManager.replaceStrings(properties, "OPTIONAL_PING_PROTOCOL", "com.gemstone.org.jgroups.protocols.PING(timeout=DISCOVERY_TIMEOUT;down_thread=false;up_thread=false;num_initial_members=NUM_INITIAL_MEMBERS;num_ping_requests=NUM_PING_REQUESTS)?");
            properties = System.getProperty("p2p.enableInitialCoordinator") != null ? JGroupMembershipManager.replaceStrings(properties, "DISABLE_COORD", String.valueOf(!Boolean.getBoolean("p2p.enableInitialCoordinator"))) : JGroupMembershipManager.replaceStrings(properties, "DISABLE_COORD", "false");
            properties = JGroupMembershipManager.replaceStrings(properties, "NUM_INITIAL_MEMBERS", System.getProperty("p2p.numInitialMembers", "2"));
        }
        long burstLimit = theConfig.getMcastFlowControl().getByteAllowance() / 4;
        burstLimit = Long.getLong("p2p.retransmit-burst-limit", burstLimit);
        properties = JGroupMembershipManager.replaceStrings(properties, "RETRANSMIT_BURST_LIMIT", String.valueOf(burstLimit));
        long discoveryTimeout = Long.getLong("p2p.discoveryTimeout", 5000L);
        properties = JGroupMembershipManager.replaceStrings(properties, "DISCOVERY_TIMEOUT", "" + discoveryTimeout);
        int defaultJoinTimeout = 17000;
        int defaultNumPings = 1;
        if (theConfig.getLocators().length() > 0 && !Locator.hasLocators()) {
            defaultJoinTimeout = 60000;
        }
        int joinTimeout = Integer.getInteger("p2p.joinTimeout", defaultJoinTimeout);
        int numPings = Integer.getInteger("p2p.discoveryProbes", defaultNumPings);
        properties = JGroupMembershipManager.replaceStrings(properties, "JOIN_TIMEOUT", "" + joinTimeout);
        properties = JGroupMembershipManager.replaceStrings(properties, "NUM_PING_REQUESTS", "" + numPings);
        properties = JGroupMembershipManager.replaceStrings(properties, "LEAVE_TIMEOUT", System.getProperty("p2p.leaveTimeout", "5000"));
        properties = JGroupMembershipManager.replaceStrings(properties, "SOCKET_TIMEOUT", System.getProperty("p2p.socket_timeout", "60000"));
        if (theConfig.getEnableNetworkPartitionDetection() && !SocketCreator.FORCE_DNS_USE) {
            IpAddress.resolve_dns = false;
            SocketCreator.resolve_dns = false;
        }
        String gossipRefreshRate = System.getProperty("p2p.gossipRefreshRate", "57123");
        properties = JGroupMembershipManager.replaceStrings(properties, "GOSSIP_REFRESH_RATE", gossipRefreshRate);
        properties = isMcastEnabled || transport.isTcpDisabled() || theConfig.getUdpRecvBufferSize() != 0x100000 ? JGroupMembershipManager.replaceStrings(properties, "UDP_RECV_BUFFER_SIZE", "" + theConfig.getUdpRecvBufferSize()) : JGroupMembershipManager.replaceStrings(properties, "UDP_RECV_BUFFER_SIZE", "65535");
        properties = JGroupMembershipManager.replaceStrings(properties, "LOOPBACK", "" + !Boolean.getBoolean("p2p.DISABLE_LOOPBACK"));
        int[] range = theConfig.getMembershipPortRange();
        properties = JGroupMembershipManager.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE_START", "" + range[0]);
        properties = JGroupMembershipManager.replaceStrings(properties, "MEMBERSHIP_PORT_RANGE_END", "" + range[1]);
        properties = JGroupMembershipManager.replaceStrings(properties, "UDP_SEND_BUFFER_SIZE", "" + theConfig.getUdpSendBufferSize());
        properties = JGroupMembershipManager.replaceStrings(properties, "UDP_FRAGMENT_SIZE", "" + theConfig.getUdpFragmentSize());
        properties = JGroupMembershipManager.replaceStrings(properties, "MAX_BUNDLE_SIZE", "" + (theConfig.getUdpFragmentSize() + 3072));
        properties = JGroupMembershipManager.replaceStrings(properties, "FC_MAX_CREDITS", "" + theConfig.getMcastFlowControl().getByteAllowance());
        properties = JGroupMembershipManager.replaceStrings(properties, "FC_THRESHOLD", "" + theConfig.getMcastFlowControl().getRechargeThreshold());
        properties = JGroupMembershipManager.replaceStrings(properties, "FC_MAX_BLOCK", "" + theConfig.getMcastFlowControl().getRechargeBlockMs());
        long fdt = fdTimeout > 0L ? fdTimeout : (long)theConfig.getMemberTimeout();
        String fdts = String.valueOf(fdt);
        properties = JGroupMembershipManager.replaceStrings(properties, "MEMBER_TIMEOUT", fdts);
        properties = JGroupMembershipManager.replaceStrings(properties, "CONNECT_TIMEOUT", fdts);
        int ackCollectionTimeout = theConfig.getMemberTimeout() * 2 * 12437 / 10000;
        if (ackCollectionTimeout < 1500) {
            ackCollectionTimeout = 1500;
        } else if (ackCollectionTimeout > 12437) {
            ackCollectionTimeout = 12437;
        }
        ackCollectionTimeout = Integer.getInteger("gemfire.VIEW_ACK_TIMEOUT", ackCollectionTimeout);
        properties = JGroupMembershipManager.replaceStrings(properties, "ACK_COLLECTION_TIMEOUT", "" + ackCollectionTimeout);
        properties = JGroupMembershipManager.replaceStrings(properties, "MAX_TRIES", System.getProperty("gemfire.FD_MAX_TRIES", "1"));
        properties = JGroupMembershipManager.replaceStrings(properties, "VIEW_SYNC_INTERVAL", String.valueOf(fdt));
        if (!Boolean.getBoolean("p2p.enableBatching")) {
            properties = JGroupMembershipManager.replaceStrings(properties, "ENABLE_BUNDLING", "false");
            properties = JGroupMembershipManager.replaceStrings(properties, "BUNDLING_TIMEOUT", "30");
        } else {
            properties = JGroupMembershipManager.replaceStrings(properties, "ENABLE_BUNDLING", "true");
            properties = JGroupMembershipManager.replaceStrings(properties, "BUNDLING_TIMEOUT", System.getProperty("p2p.batchFlushTime", "30"));
        }
        properties = JGroupMembershipManager.replaceStrings(properties, "OUTGOING_PACKET_HANDLER", String.valueOf(Boolean.getBoolean("p2p.outgoingPacketHandler")));
        properties = JGroupMembershipManager.replaceStrings(properties, "INCOMING_PACKET_HANDLER", String.valueOf(Boolean.getBoolean("p2p.incomingPacketHandler")));
        properties = JGroupMembershipManager.replaceStrings(properties, "PARTITION_DETECTION", String.valueOf(theConfig.getEnableNetworkPartitionDetection()));
        int threshold = Integer.getInteger("gemfire.network-partition-threshold", 51);
        if (threshold < 51) {
            threshold = 51;
        }
        if (threshold > 100) {
            threshold = 100;
        }
        properties = JGroupMembershipManager.replaceStrings(properties, "PARTITION_THRESHOLD", String.valueOf(threshold));
        int weight = Integer.getInteger("gemfire.member-weight", 0);
        properties = JGroupMembershipManager.replaceStrings(properties, "MEMBER_WEIGHT", String.valueOf(weight));
        properties = JGroupMembershipManager.replaceStrings(properties, "GOSSIP_SERVER_WAIT_TIME", "" + theConfig.getLocatorWaitTime());
        if (logger.isDebugEnabled()) {
            logger.debug("Jgroups configuration: {}", properties);
        }
        JChannel myChannel = null;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            try {
                View v;
                boolean reattempt;
                this.isJoining = true;
                long start = System.currentTimeMillis();
                String channelName = "GF7";
                boolean debugConnect = Boolean.getBoolean("p2p.debugConnect");
                this.puller = new Puller();
                do {
                    reattempt = false;
                    myChannel = new JChannel(properties);
                    myChannel.setOpt(4, Boolean.TRUE);
                    myChannel.setOpt(6, Boolean.FALSE);
                    myChannel.setOpt(3, Boolean.FALSE);
                    this.channelInitialized = true;
                    myChannel.setReceiver(this.puller);
                    myChannel.installGemFireStats(this, this.stats, DistributionStats.enableClockStats, this.enableJgStackStats);
                    if (debugConnect) {
                        JGroupMembershipManager.setDebugJGroups(true);
                    }
                    try {
                        myChannel.connect(channelName);
                    }
                    catch (ShunnedAddressException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Address was shunned by membership coordinator - will reattempt");
                        }
                        myChannel.close();
                        reattempt = true;
                    }
                } while (reattempt);
                long delta = System.currentTimeMillis() - start;
                if (debugConnect) {
                    JGroupMembershipManager.setDebugJGroups(false);
                }
                if (logger.isTraceEnabled(LogMarker.JGROUPS)) {
                    logger.trace(LogMarker.JGROUPS, "Connected JGroups stack: {}", myChannel.printProtocolSpec(false));
                }
                if ((v = myChannel.getView()) == null) {
                    throw new DistributionException(LocalizedStrings.JGroupMembershipManager_NULL_VIEW_FROM_JGROUPS.toLocalizedString(), new InternalGemFireError(LocalizedStrings.JGroupMembershipManager_NO_VIEW.toLocalizedString()));
                }
                if (this.directChannel != null) {
                    this.directChannel.setMembershipSize(v.getMembers().size());
                }
                this.lastViewId = v.getVid().getId();
                this.latestView = JGroupMembershipManager.viewToMemberView(v);
                if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                    logger.trace(LogMarker.DISTRIBUTION_VIEWS, "JGroups: initial view is {}", DistributionManager.printView(this.latestView));
                }
                logger.info(LogMarker.DISTRIBUTION, LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_CONNECTED_TO_JGROUPS_CHANNEL_TOOK__0__MS, delta));
                this.ucastProtocol = (UNICAST)myChannel.getProtocolStack().findProtocol("UNICAST");
                Assert.assertTrue(this.ucastProtocol != null, "Malformed protocol stack is missing UNICAST");
                this.fdProtocol = (FD)myChannel.getProtocolStack().findProtocol("FD");
                this.verifySuspectProtocol = (VERIFY_SUSPECT)myChannel.getProtocolStack().findProtocol("VERIFY_SUSPECT");
                this.fdSockProtocol = (FD_SOCK)myChannel.getProtocolStack().findProtocol("FD_SOCK");
                this.udpProtocol = (UDP)myChannel.getProtocolStack().findProtocol("UDP");
                this.tcpProtocol = (TCP)myChannel.getProtocolStack().findProtocol("TCP");
                this.nakAckProtocol = (NAKACK)myChannel.getProtocolStack().findProtocol("NAKACK");
                this.gmsProtocol = (GMS)myChannel.getProtocolStack().findProtocol("GMS");
                JChannel jChannel = myChannel;
                return jChannel;
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (ex.getCause() != null && ex.getCause().getCause() instanceof SystemConnectException) {
                    throw (SystemConnectException)ex.getCause().getCause();
                }
                throw new DistributionException(LocalizedStrings.JGroupMembershipManager_AN_EXCEPTION_WAS_THROWN_WHILE_CONNECTING_TO_JGROUPS.toLocalizedString(), ex);
            }
            finally {
                this.isJoining = false;
            }
        }
    }

    public JGroupMembershipManager initialize(DistributedMembershipListener listener, DistributionConfig config, RemoteTransportConfig transport, DMStats stats) throws ConnectionException {
        Assert.assertTrue(listener != null);
        Assert.assertTrue(config != null);
        this.stats = stats;
        this.listener = listener;
        this.dconfig = config;
        this.membershipCheckTimeout = config.getSecurityPeerMembershipTimeout();
        this.wasReconnectingSystem = transport.getIsReconnectingDS();
        this.oldDSMembershipSocket = (DatagramSocket)transport.getOldDSMembershipInfo();
        if (!config.getDisableTcp()) {
            this.dcReceiver = new MyDCReceiver(listener);
            this.directChannel = new DirectChannel(this, this.dcReceiver, config, null);
        }
        int dcPort = 0;
        if (!config.getDisableTcp()) {
            dcPort = this.directChannel.getPort();
        }
        MemberAttributes.setDefaults(dcPort, MemberAttributes.DEFAULT.getVmPid(), MemberAttributes.DEFAULT.getVmKind(), MemberAttributes.DEFAULT.getVmViewId(), MemberAttributes.DEFAULT.getName(), MemberAttributes.DEFAULT.getGroups(), MemberAttributes.DEFAULT.getDurableClientAttributes());
        this.vmKind = MemberAttributes.DEFAULT.getVmKind();
        this.surpriseMemberTimeout = Math.max(100000, 20 * config.getMemberTimeout());
        this.surpriseMemberTimeout = Integer.getInteger("gemfire.surprise-member-timeout", this.surpriseMemberTimeout);
        try {
            this.channel = this.createChannel(transport, config);
        }
        catch (RuntimeException e) {
            if (this.directChannel != null) {
                this.directChannel.disconnect(e);
            }
            throw e;
        }
        IpAddress myAddr = (IpAddress)this.channel.getLocalAddress();
        MemberAttributes.setDefaults(dcPort, MemberAttributes.DEFAULT.getVmPid(), MemberAttributes.DEFAULT.getVmKind(), myAddr.getBirthViewId(), MemberAttributes.DEFAULT.getName(), MemberAttributes.DEFAULT.getGroups(), MemberAttributes.DEFAULT.getDurableClientAttributes());
        if (this.directChannel != null) {
            this.directChannel.getConduit().setVmViewID(myAddr.getBirthViewId());
        }
        this.myMemberId = new InternalDistributedMember(myAddr.getIpAddress(), myAddr.getPort(), myAddr.splitBrainEnabled(), myAddr.preferredForCoordinator(), MemberAttributes.DEFAULT);
        logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_entered_into_membership_in_group_0_with_id_1, new Object[]{this.myMemberId}));
        if (!this.dconfig.getDisableTcp()) {
            this.conduit = this.directChannel.getConduit();
            this.directChannel.setLocalAddr(this.myMemberId);
            Stub stub = this.conduit.getId();
            this.memberToStubMap.put(this.myMemberId, stub);
            this.stubToMemberMap.put(stub, this.myMemberId);
        }
        this.hasConnected = true;
        return this;
    }

    public void quorumLost(Set failures, List remaining) {
        boolean notify;
        boolean bl = notify = failures.size() > 1;
        if (!notify) {
            JChannel ch = this.channel;
            Address localAddr = ch != null ? ch.getLocalAddress() : null;
            boolean bl2 = notify = localAddr != null && localAddr.splitBrainEnabled();
        }
        if (notify) {
            if (inhibitForceDisconnectLogging && logger.isDebugEnabled()) {
                logger.debug("<ExpectedException action=add>Possible loss of quorum</ExpectedException>");
            }
            logger.fatal(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_POSSIBLE_LOSS_OF_QUORUM_DETECTED, new Object[]{failures.size(), failures}));
            if (inhibitForceDisconnectLogging && logger.isDebugEnabled()) {
                logger.debug("<ExpectedException action=remove>Possible loss of quorum</ExpectedException>");
            }
            HashSet<InternalDistributedMember> idmFailures = new HashSet<InternalDistributedMember>();
            for (IpAddress ipaddr : failures) {
                JGroupMember jgm = new JGroupMember(ipaddr);
                InternalDistributedMember mbr = new InternalDistributedMember(jgm);
                idmFailures.add(mbr);
            }
            ArrayList<InternalDistributedMember> idmRemaining = new ArrayList<InternalDistributedMember>(remaining.size());
            for (IpAddress ipaddr : remaining) {
                JGroupMember jgm = new JGroupMember(ipaddr);
                InternalDistributedMember mbr = new InternalDistributedMember(jgm);
                idmRemaining.add(mbr);
            }
            this.listener.quorumLost(idmFailures, idmRemaining);
        }
    }

    @Override
    public boolean testMulticast() {
        if (isMcastEnabled) {
            return this.udpProtocol.testMulticast(this.dconfig.getMemberTimeout());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferRemove(InternalDistributedMember dm, boolean crashed, String reason) {
        EventProcessingLock eventProcessingLock = this.startupLock;
        synchronized (eventProcessingLock) {
            if (!this.processingEvents) {
                this.startupMessages.add(new StartupEvent(dm, crashed, reason));
                return;
            }
        }
        this.removeMember(dm, crashed, reason);
    }

    protected void removeWithViewLock(InternalDistributedMember dm, boolean crashed, String reason) {
        boolean wasShunned = this.isShunned(dm);
        this.destroyMember(dm, crashed, reason);
        if (wasShunned) {
            return;
        }
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
            logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: dispatching uplevel departure event for < {} >", dm);
        }
        try {
            this.listener.memberDeparted(dm, crashed, reason);
        }
        catch (DistributedSystemDisconnectedException se) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMember(InternalDistributedMember dm, boolean crashed, String reason) {
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("Membership: removing <").append(dm).append(">; crashed = ").append(crashed).append("; reason = ");
            if (reason != null && reason.indexOf("NoSuchMemberException") >= 0) {
                sb.append("tcp/ip connections closed");
            } else {
                sb.append(reason);
            }
            logger.trace(LogMarker.DISTRIBUTION_VIEWS, (Object)sb);
        }
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            this.removeWithViewLock(dm, crashed, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferSurpriseConnect(InternalDistributedMember member, Stub stub) {
        EventProcessingLock eventProcessingLock = this.startupLock;
        synchronized (eventProcessingLock) {
            if (!this.processingEvents) {
                this.startupMessages.add(new StartupEvent(member, stub));
                return;
            }
        }
        this.processSurpriseConnect(member, stub);
    }

    @Override
    public void startupMessageFailed(DistributedMember mbr, String failureMessage) {
        this.addShunnedMember((InternalDistributedMember)mbr);
        try {
            this.listener.memberDeparted((InternalDistributedMember)mbr, true, "failed to pass startup checks");
        }
        catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSurpriseMember(DistributedMember dm, Stub stub) {
        final InternalDistributedMember member = (InternalDistributedMember)dm;
        Stub s = null;
        boolean warn = false;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.latestView.contains(member)) {
                return true;
            }
            if (this.surpriseMembers.containsKey(member)) {
                return true;
            }
            if (this.latestView.getViewNumber() > (long)member.getVmViewId()) {
                new Thread(Thread.currentThread().getThreadGroup(), "Removing shunned GemFire node " + member){

                    @Override
                    public void run() {
                        logger.fatal(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_Invalid_Surprise_Member, new Object[]{member, JGroupMembershipManager.this.latestView}));
                        JGroupMembershipManager.this.requestMemberRemoval(member, "this member is no longer in the view but is initiating connections");
                    }
                }.start();
                this.addShunnedMember(member);
                return false;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: Received message from surprise member: <{}>.  My view number is {} it is {}", member, this.latestView.getViewNumber(), member.getVmViewId());
            }
            this.surpriseMembers.put(member, System.currentTimeMillis());
            if (this.shutdownInProgress()) {
                if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                    logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: new member during shutdown ignored: <{}>", member);
                }
                String msg = LocalizedStrings.JGroupMembershipManager_THIS_DISTRIBUTED_SYSTEM_IS_SHUTTING_DOWN.toLocalizedString();
                if (this.directChannel != null) {
                    try {
                        this.directChannel.closeEndpoint(member, msg);
                    }
                    catch (DistributedSystemDisconnectedException e) {
                        // empty catch block
                    }
                }
                this.destroyMember(member, false, msg);
                return true;
            }
            if (this.isShunned(member)) {
                warn = true;
                this.surpriseMembers.remove(member);
            } else {
                Object oldStub;
                if (logger.isTraceEnabled(LogMarker.DM_VIEWS)) {
                    logger.trace(LogMarker.DM_VIEWS, "Membership: Processing surprise addition <{}>", member);
                }
                if (this.cleanupTimer == null) {
                    this.startCleanupTimer();
                }
                if ((oldStub = this.memberToStubMap.remove(member)) != null) {
                    this.stubToMemberMap.remove(oldStub);
                }
                s = stub == null ? this.getStubForMember(member) : stub;
                this.addChannel(member, s);
                NetView newMembers = new NetView(this.latestView, this.latestView.getViewNumber());
                newMembers.add(member);
                this.latestView = newMembers;
            }
        }
        if (warn) {
            logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_IGNORING_SURPRISE_CONNECT_FROM_SHUNNED_MEMBER_0, member));
        } else {
            this.listener.newMemberConnected(member, s);
        }
        return !warn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCleanupTimer() {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.cleanupTimer != null) {
                return;
            }
            InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
            if (ds != null && ((DistributedSystem)ds).isConnected()) {
                this.cleanupTimer = new SystemTimer(ds, true);
                SystemTimer.SystemTimerTask st = new SystemTimer.SystemTimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run2() {
                        ViewLock viewLock = JGroupMembershipManager.this.latestViewLock;
                        synchronized (viewLock) {
                            long oldestAllowed = System.currentTimeMillis() - (long)JGroupMembershipManager.this.surpriseMemberTimeout;
                            Iterator<Map.Entry<InternalDistributedMember, Long>> it = JGroupMembershipManager.this.surpriseMembers.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry<InternalDistributedMember, Long> entry = it.next();
                                Long birthtime = entry.getValue();
                                if (birthtime >= oldestAllowed) continue;
                                it.remove();
                                InternalDistributedMember m = entry.getKey();
                                logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_EXPIRING_MEMBERSHIP_OF_SURPRISE_MEMBER_0, m));
                                JGroupMembershipManager.this.removeWithViewLock(m, true, "not seen in membership view in " + JGroupMembershipManager.this.surpriseMemberTimeout + "ms");
                            }
                        }
                    }
                };
                this.cleanupTimer.scheduleAtFixedRate(st, this.surpriseMemberTimeout, this.surpriseMemberTimeout / 3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferMessage(DistributionMessage msg) {
        EventProcessingLock eventProcessingLock = this.startupLock;
        synchronized (eventProcessingLock) {
            if (!this.processingEvents) {
                this.startupMessages.add(new StartupEvent(msg));
                return;
            }
        }
        this.processMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warnShun(DistributedMember m) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (!this.shunnedMembers.containsKey(m)) {
                return;
            }
            if (this.shunnedAndWarnedMembers.contains(m)) {
                return;
            }
            this.shunnedAndWarnedMembers.add(m);
        }
        logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_DISREGARDING_SHUNNED_MEMBER_0, m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(DistributionMessage msg) {
        boolean isNew = false;
        InternalDistributedMember m = msg.getSender();
        boolean shunned = false;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.isShunned(m)) {
                if (msg instanceof StartupMessage) {
                    this.endShun(m);
                } else {
                    shunned = true;
                }
            }
            if (!shunned) {
                boolean bl = isNew = !this.latestView.contains(m) && !this.surpriseMembers.containsKey(m);
                if (isNew) {
                    shunned = !this.addSurpriseMember(m, this.getStubForMember(m));
                }
            }
        }
        if (shunned) {
            this.warnShun(m);
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: Ignoring message from shunned member <{}>:{}", m, msg);
            }
            throw new MemberShunnedException(this.getStubForMember(m));
        }
        this.listener.messageReceived(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferViewEvent(View viewArg) {
        if (this.isJoining) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                this.startupMessages.add(new StartupEvent(viewArg));
                return;
            }
        }
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (!this.processingEvents) {
                    this.startupMessages.add(new StartupEvent(viewArg));
                    return;
                }
            }
            NetView newView = JGroupMembershipManager.viewToMemberView(viewArg);
            long newId = viewArg.getVid().getId();
            if (logger.isTraceEnabled(LogMarker.DM_VIEWS)) {
                logger.trace(LogMarker.DM_VIEWS, "Membership: queuing new view for processing, id = {}, view = {}", newId, newView);
            }
            ViewMessage v = new ViewMessage(this.myMemberId, newId, newView, this);
            this.listener.messageReceived(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleOrDeferSuspect(SuspectMember suspectInfo) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (!this.processingEvents) {
                    return;
                }
            }
            InternalDistributedMember suspect = this.getMemberFromIpAddress((IpAddress)suspectInfo.suspectedMember, true);
            InternalDistributedMember who = this.getMemberFromIpAddress((IpAddress)suspectInfo.whoSuspected, true);
            this.suspectedMembers.put(suspect, System.currentTimeMillis());
            try {
                this.listener.memberSuspect(suspect, who);
            }
            catch (DistributedSystemDisconnectedException se) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSurpriseConnect(InternalDistributedMember member, Stub stub) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            this.addSurpriseMember(member, stub);
        }
    }

    private void processStartupEvent(StartupEvent o) {
        if (o.isDistributionMessage()) {
            try {
                this.processMessage(o.dmsg);
            }
            catch (MemberShunnedException memberShunnedException) {}
        } else if (o.isJgView()) {
            this.processView(o.jgView.getVid().getId(), JGroupMembershipManager.viewToMemberView(o.jgView));
        } else if (o.isDepartureEvent()) {
            this.removeMember(o.member, o.crashed, o.reason);
        } else if (o.isConnect()) {
            this.processSurpriseConnect(o.member, o.stub);
        } else {
            throw new InternalGemFireError(LocalizedStrings.JGroupMembershipManager_UNKNOWN_STARTUP_EVENT_0.toLocalizedString(o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startEventProcessing() {
        Object object = this.startupMutex;
        synchronized (object) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: draining startup events.");
            }
            while (true) {
                StartupEvent ev;
                EventProcessingLock eventProcessingLock = this.startupLock;
                synchronized (eventProcessingLock) {
                    int remaining = this.startupMessages.size();
                    if (remaining == 0) {
                        this.processingEvents = true;
                        this.startupLock.notifyAll();
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 7, 9] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                        if (!logger.isDebugEnabled()) return;
                        logger.debug("Membership: finished processing startup events.");
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Membership: {} remaining startup message(s)", remaining);
                    }
                    ev = (StartupEvent)this.startupMessages.removeFirst();
                }
                try {
                    this.processStartupEvent(ev);
                    continue;
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_ERROR_HANDLING_STARTUP_EVENT), t);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForEventProcessing() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.processingEvents) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: waiting until the system is ready for events");
        }
        while (true) {
            this.conduit.getCancelCriterion().checkCancelInProgress(null);
            EventProcessingLock eventProcessingLock = this.startupLock;
            synchronized (eventProcessingLock) {
                if (this.processingEvents) {
                    break;
                }
                boolean interrupted = Thread.interrupted();
                try {
                    this.startupLock.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    this.conduit.getCancelCriterion().checkCancelInProgress(e);
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: continuing");
        }
    }

    @Override
    public Object getViewLock() {
        return this.latestViewLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetView getView() {
        NetView v;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            v = this.latestView;
        }
        NetView result = new NetView(v.size(), v.getViewNumber());
        result.setCreator(v.getCreator());
        for (int i = 0; i < v.size(); ++i) {
            InternalDistributedMember m = (InternalDistributedMember)v.elementAt(i);
            if (this.isShunned(m)) continue;
            result.add(m);
        }
        result.setLeadMember(v.getLeadMember());
        return result;
    }

    public DistributedMember getLeadMember() {
        if (this.gmsProtocol == null) {
            return null;
        }
        IpAddress jlead = (IpAddress)this.gmsProtocol.getLeadMember();
        InternalDistributedMember leader = jlead == null ? null : this.getMemberFromIpAddress(jlead, true);
        return leader;
    }

    public DistributedMember getCoordinator() {
        IpAddress jcoord = (IpAddress)this.gmsProtocol.determineCoordinator();
        InternalDistributedMember dm = jcoord == null ? null : this.getMemberFromIpAddress(jcoord, true);
        return dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean memberExists(InternalDistributedMember m) {
        NetView v;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            v = this.latestView;
        }
        return v.contains(m);
    }

    @Override
    public InternalDistributedMember getLocalMember() {
        return this.myMemberId;
    }

    @Override
    public void postConnect() {
        if (this.channelPause > 0L) {
            logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_PAUSING_TO_ALLOW_OTHER_CONCURRENT_PROCESSES_TO_JOIN_THE_DISTRIBUTED_SYSTEM));
            try {
                Thread.sleep(this.channelPause);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.channelPause = 0L;
        }
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        FD_SOCK.loadEmergencyClasses();
        FD.loadEmergencyClasses();
        DirectChannel.loadEmergencyClasses();
        ProtocolStack.loadEmergencyClasses();
        UDP.loadEmergencyClasses();
        TP.loadEmergencyClasses();
    }

    @Override
    public void emergencyClose() {
        ProtocolStack ps;
        boolean DEBUG = false;
        this.setShutdown();
        this.puller = null;
        if (this.fdSockProtocol != null) {
            this.fdSockProtocol.emergencyClose();
        }
        if (this.fdProtocol != null) {
            this.fdProtocol.emergencyClose();
        }
        if (this.directChannel != null) {
            this.directChannel.emergencyClose();
        }
        if (this.udpProtocol != null) {
            this.udpProtocol.emergencyClose();
        }
        if (this.tcpProtocol != null) {
            this.tcpProtocol.emergencyClose();
        }
        if ((ps = this.channel.getProtocolStack()) != null) {
            ps.emergencyClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownMessageReceived(InternalDistributedMember id, String reason) {
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: recording shutdown status of {}", id);
        }
        Map map = this.shutdownMembers;
        synchronized (map) {
            this.shutdownMembers.put(id, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isShuttingDown(IpAddress addr) {
        InternalDistributedMember mbr = (InternalDistributedMember)this.ipAddrToMemberMap.get(addr);
        if (mbr == null) {
            JGroupMember m = new JGroupMember(addr);
            mbr = new InternalDistributedMember(m);
        }
        Map map = this.shutdownMembers;
        synchronized (map) {
            return this.shutdownMembers.containsKey(mbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.setShutdown();
        this.puller = null;
        if (this.channel != null && this.channel.isConnected()) {
            try {
                this.channel.closeAsync();
            }
            catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                // empty catch block
            }
        }
        if (this.directChannel != null) {
            this.directChannel.disconnect(null);
            ViewLock viewLock = this.latestViewLock;
            synchronized (viewLock) {
                this.destroyMember(this.myMemberId, false, "orderly shutdown");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Membership: channel closed");
        }
    }

    @Override
    public void uncleanShutdown(String reason, Exception e) {
        JGroupMembershipManager.inhibitForcedDisconnectLogging(false);
        if (this.channel != null && !this.channel.closing()) {
            try {
                this.channel.shutdown();
            }
            catch (DistributedSystemDisconnectedException se) {
                // empty catch block
            }
        }
        if (this.directChannel != null) {
            this.directChannel.disconnect(e);
        }
        this.emergencyClose();
        if (e != null) {
            try {
                List l;
                if (this.membershipTestHooks != null) {
                    l = this.membershipTestHooks;
                    for (MembershipTestHook dml : l) {
                        dml.beforeMembershipFailure(reason, e);
                    }
                }
                this.listener.membershipFailure(reason, e);
                if (this.membershipTestHooks != null) {
                    l = this.membershipTestHooks;
                    for (MembershipTestHook dml : l) {
                        dml.afterMembershipFailure(reason, e);
                    }
                }
            }
            catch (RuntimeException re) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_EXCEPTION_CAUGHT_WHILE_SHUTTING_DOWN), (Throwable)re);
            }
        }
    }

    private void saveCacheXmlForReconnect() {
        GemFireCacheImpl cache;
        if (!(this.dconfig.getDisableAutoReconnect() || (cache = GemFireCacheImpl.getInstance()) == null || !(cache instanceof Cache) || Boolean.getBoolean("gemfire.autoReconnect-useCacheXMLFile") || cache.isSqlfSystem() || this.dconfig.getUseSharedConfiguration())) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("generating XML to rebuild the cache after reconnect completes");
                }
                StringPrintWriter pw = new StringPrintWriter();
                CacheXmlGenerator.generate((Cache)cache, (PrintWriter)pw, true, false);
                String cacheXML = pw.toString();
                cache.getCacheConfig().setCacheXMLDescription(cacheXML);
                if (logger.isDebugEnabled()) {
                    logger.debug("XML generation completed: {}", cacheXML);
                }
            }
            catch (CancelException e) {
                logger.info(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_PROBLEM_GENERATING_CACHE_XML), (Throwable)e);
            }
        }
    }

    @Override
    public boolean requestMemberRemoval(DistributedMember mbr, String reason) {
        if (mbr.equals(this.myMemberId)) {
            return false;
        }
        if (this.gmsProtocol == null) {
            return false;
        }
        IpAddress jcoord = (IpAddress)this.gmsProtocol.determineCoordinator();
        if (jcoord == null) {
            logger.fatal(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_REQUEST_INITIATED_TO_REMOVE_MEMBER_0_BUT_THERE_IS_NO_GROUP_COORDINATOR, mbr));
            return false;
        }
        logger.fatal(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_REQUESTING_REMOVAL_OF_0_REASON_1, new Object[]{mbr, reason}));
        Message msg = new Message();
        msg.setDest(jcoord);
        msg.isHighPriority = true;
        InternalDistributedMember imbr = (InternalDistributedMember)mbr;
        msg.putHeader("GMS", new GMS.GmsHeader(13, ((JGroupMember)imbr.getNetMember()).getAddress(), reason));
        Exception problem = null;
        try {
            this.channel.send(msg);
        }
        catch (ChannelClosedException e) {
            Throwable cause = e.getCause();
            problem = cause instanceof ForcedDisconnectException ? (Exception)cause : e;
        }
        catch (ChannelNotConnectedException e) {
            problem = e;
        }
        catch (IllegalArgumentException e) {
            problem = e;
        }
        if (problem != null) {
            if (this.shutdownCause != null) {
                Exception cause = this.shutdownCause;
                if (cause instanceof ForcedDisconnectException) {
                    problem = cause;
                } else {
                    Throwable ne = problem;
                    while (ne.getCause() != null) {
                        ne = ne.getCause();
                    }
                    try {
                        ne.initCause(this.shutdownCause);
                    }
                    catch (IllegalArgumentException selfCausation) {
                        // empty catch block
                    }
                }
            }
            this.saveCacheXmlForReconnect();
            this.listener.membershipFailure("Channel closed", problem);
            throw new DistributedSystemDisconnectedException("Channel closed", problem);
        }
        return true;
    }

    @Override
    public void suspectMembers(Set members, String reason) {
        Iterator it = members.iterator();
        while (it.hasNext()) {
            this.suspectMember((DistributedMember)it.next(), reason);
        }
    }

    @Override
    public void suspectMember(DistributedMember mbr, String reason) {
        if (mbr != null) {
            IpAddress jgmbr = ((JGroupMember)((InternalDistributedMember)mbr).getNetMember()).getAddress();
            this.fdSockProtocol.suspect(jgmbr, false, reason);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Attempt to suspect member with null ID detected.  This usually means that the target has left membership during startup.");
        }
    }

    public void suspectMember(Stub mbr, String reason) {
        InternalDistributedMember idm = this.getMemberForStub(mbr, false);
        if (idm != null) {
            IpAddress jgmbr = ((JGroupMember)idm.getNetMember()).getAddress();
            this.fdSockProtocol.suspect(jgmbr, false, reason);
        }
    }

    @Override
    public boolean verifyMember(DistributedMember mbr, String reason) {
        if (mbr != null && this.memberExists((InternalDistributedMember)mbr)) {
            IpAddress jgmbr = ((JGroupMember)((InternalDistributedMember)mbr).getNetMember()).getAddress();
            return this.fdSockProtocol.checkSuspect(jgmbr, reason);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set directChannelSend(InternalDistributedMember[] destinations, DistributionMessage content, DistributionStats theStats) throws NotSerializableException {
        InternalDistributedMember[] keys;
        boolean allDestinations;
        if (content.forAll()) {
            allDestinations = true;
            ViewLock viewLock = this.latestViewLock;
            synchronized (viewLock) {
                Set keySet = this.memberToStubMap.keySet();
                keys = new InternalDistributedMember[keySet.size()];
                keys = keySet.toArray(keys);
            }
        } else {
            allDestinations = false;
            keys = destinations;
        }
        int sentBytes = 0;
        try {
            sentBytes = this.directChannel.send(this, keys, content, this.dconfig.getAckWaitThreshold(), this.dconfig.getAckSevereAlertThreshold());
            if (theStats != null) {
                theStats.incSentBytes(sentBytes);
            }
        }
        catch (DistributedSystemDisconnectedException ex) {
            if (this.shutdownCause != null) {
                throw new DistributedSystemDisconnectedException("DistributedSystem is shutting down", this.shutdownCause);
            }
            throw ex;
        }
        catch (ConnectExceptions ex) {
            if (allDestinations) {
                return null;
            }
            List members = ex.getMembers();
            NetView view = this.getView();
            Iterator it_mem = members.iterator();
            Iterator it_causes = ex.getCauses().iterator();
            while (it_mem.hasNext()) {
                InternalDistributedMember member = (InternalDistributedMember)it_mem.next();
                Throwable th = (Throwable)it_causes.next();
                if (!view.contains(member)) continue;
                logger.fatal(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_FAILED_TO_SEND_MESSAGE_0_TO_MEMBER_1_VIEW_2, new Object[]{content, member, view}), th);
            }
            return new HashSet(members);
        }
        catch (ToDataException e) {
            throw e;
        }
        catch (CancelException e) {
            throw e;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", e.getMessage(), e);
            }
            if (e instanceof NotSerializableException) {
                throw (NotSerializableException)e;
            }
        }
        catch (RuntimeException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", e.getMessage(), e);
            }
            throw e;
        }
        catch (Error e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: directChannelSend caught exception: {}", e.getMessage(), e);
            }
            throw e;
        }
        return null;
    }

    @Override
    public boolean isConnected() {
        if (this.channel != null && this.channel.isConnected()) {
            return true;
        }
        return !this.channelInitialized;
    }

    public boolean isReconnectingDS() {
        if (this.hasConnected) {
            return false;
        }
        return this.wasReconnectingSystem;
    }

    public QuorumCheckerImpl getQuorumCheckerImpl() {
        return this.quorumChecker;
    }

    public DatagramSocket getMembershipSocketForUDP() {
        return this.oldDSMembershipSocket;
    }

    @Override
    public QuorumChecker getQuorumChecker() {
        if (!(this.shutdownCause instanceof ForcedDisconnectException)) {
            return null;
        }
        if (this.gmsProtocol == null || this.udpProtocol == null) {
            return null;
        }
        if (this.quorumChecker != null) {
            return this.quorumChecker;
        }
        QuorumCheckerImpl impl = new QuorumCheckerImpl(this.gmsProtocol.getLastView(), this.gmsProtocol.getPartitionThreshold(), this.udpProtocol.getMembershipSocket());
        impl.initialize();
        this.quorumChecker = impl;
        return impl;
    }

    @Override
    public void releaseQuorumChecker(QuorumChecker checker) {
        DatagramSocket sock;
        ((QuorumCheckerImpl)checker).teardown();
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (!(system != null && system.isConnected() || (sock = (DatagramSocket)checker.getMembershipInfo()) == null || sock.isClosed())) {
            sock.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set send(InternalDistributedMember[] destinations, DistributionMessage msg, DistributionStats theStats) throws NotSerializableException {
        Set<InternalDistributedMember> result = null;
        boolean allDestinations = msg.forAll();
        if (!this.channel.isConnected()) {
            if (this.channelInitialized) {
                Exception cause = this.shutdownCause;
                if (cause == null && this.channel.exitEvent != null && this.channel.exitEvent.getArg() instanceof Exception) {
                    cause = (Exception)this.channel.exitEvent.getArg();
                }
                throw new DistributedSystemDisconnectedException("Distributed System is shutting down", cause);
            }
            if (allDestinations) {
                return null;
            }
            result = new HashSet<InternalDistributedMember>();
            int i = 0;
            while (true) {
                if (i >= destinations.length) {
                    return result;
                }
                result.add(destinations[i]);
                ++i;
            }
        }
        if (destinations == null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Message send: returning early because null set passed in: '{}'", msg);
            }
            return null;
        }
        if (destinations.length == 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("Membership: Message send: returning early because empty destination list passed in: '{}'", msg);
            }
            return null;
        }
        msg.setSender(this.myMemberId);
        msg.setBreadcrumbsInSender();
        Breadcrumbs.setProblem(null);
        boolean useMcast = false;
        if (isMcastEnabled) {
            useMcast = !this.disableMulticastForRollingUpgrade && (msg.getMulticast() || allDestinations);
        }
        boolean sendViaJGroups = this.isForceUDPCommunications();
        if (this.sendSuspended) {
            Object object = this.sendSuspendMutex;
            synchronized (object) {
                while (this.sendSuspended) {
                    this.conduit.getCancelCriterion().checkCancelInProgress(null);
                    boolean bl = Thread.interrupted();
                    try {
                        this.sendSuspendMutex.wait(10L);
                        this.conduit.getCancelCriterion().checkCancelInProgress(null);
                    }
                    catch (InterruptedException e) {
                        bl = true;
                        this.conduit.getCancelCriterion().checkCancelInProgress(e);
                    }
                    finally {
                        if (!bl) continue;
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        if (!(useMcast || this.dconfig.getDisableTcp() || sendViaJGroups)) {
            result = this.directChannelSend(destinations, msg, theStats);
            if (allDestinations) {
                return null;
            }
            return result;
        }
        Address local2 = this.channel.getLocalAddress();
        if (useMcast) {
            void var9_18;
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "Membership: sending < {} > via multicast", msg);
            }
            if (!DISABLE_UCAST_FLUSH && this.ucastProtocol != null && this.ucastProtocol.getNumberOfUnackedMessages() > 0) {
                this.flushUnicast();
            }
            Object var9_12 = null;
            try {
                long startSer = theStats.startMsgSerialization();
                Vector mbrs = this.channel.getView().getMembers();
                Message jmsg = new Message(msg, local2, Version.CURRENT_ORDINAL);
                theStats.endMsgSerialization(startSer);
                theStats.incSentBytes(jmsg.getLength());
                this.channel.send(jmsg);
            }
            catch (ChannelClosedException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof ForcedDisconnectException) {
                    Exception exception = (Exception)throwable;
                } else {
                    ChannelClosedException channelClosedException = e;
                }
            }
            catch (ChannelNotConnectedException e) {
                ChannelNotConnectedException channelNotConnectedException = e;
            }
            catch (IllegalArgumentException e) {
                IllegalArgumentException illegalArgumentException = e;
            }
            if (var9_18 != null) {
                void var9_20;
                if (this.shutdownCause != null) {
                    Exception cause = this.shutdownCause;
                    if (cause instanceof ForcedDisconnectException) {
                        Exception exception = cause;
                    } else {
                        void var11_36;
                        void var11_35 = var9_18;
                        while (var11_36.getCause() != null) {
                            Throwable throwable = var11_36.getCause();
                        }
                        var11_36.initCause(this.shutdownCause);
                    }
                }
                String channelClosed = LocalizedStrings.JGroupMembershipManager_CHANNEL_CLOSED.toLocalizedString();
                this.listener.membershipFailure(channelClosed, (Throwable)var9_20);
                throw new DistributedSystemDisconnectedException(channelClosed, (Throwable)var9_20);
            }
        } else {
            LinkedList<JGroupMember> calculatedMembers;
            int n = destinations.length;
            if (n == 1 && destinations[0] == DistributionMessage.ALL_RECIPIENTS) {
                NetView v = this.getView();
                int n2 = v.size();
                calculatedMembers = new LinkedList();
                for (int i = 0; i < n2; ++i) {
                    InternalDistributedMember m = (InternalDistributedMember)v.elementAt(i);
                    calculatedMembers.add((JGroupMember)m.getNetMember());
                }
            } else {
                int n3 = n;
                calculatedMembers = new LinkedList<JGroupMember>();
                for (int i = 0; i < n3; ++i) {
                    calculatedMembers.add((JGroupMember)destinations[i].getNetMember());
                }
            }
            TIntObjectHashMap messages = new TIntObjectHashMap();
            long startSer = theStats.startMsgSerialization();
            boolean firstMessage = true;
            for (JGroupMember mbr : calculatedMembers) {
                short version = mbr.getAddress().getVersionOrdinal();
                if (messages.containsKey(version)) continue;
                Message jmsg = new Message(msg, local2, version);
                messages.put(version, jmsg);
                if (!firstMessage) continue;
                theStats.incSentBytes(jmsg.getLength());
                firstMessage = false;
            }
            theStats.endMsgSerialization(startSer);
            Collections.shuffle(calculatedMembers);
            int i = 0;
            for (JGroupMember mbr : calculatedMembers) {
                void var22_58;
                IpAddress to = mbr.getAddress();
                short version = to.getVersionOrdinal();
                Message jmsg = (Message)messages.get(version);
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "Membership: Sending '{}' to '{}' via udp unicast", msg, mbr);
                }
                Object var22_59 = null;
                try {
                    void var11_40;
                    Message tmp = i < var11_40 - true ? jmsg.copy(true) : jmsg;
                    tmp.setDest(to);
                    this.channel.send(tmp);
                }
                catch (ChannelClosedException e) {
                    Throwable throwable = e.getCause();
                    if (throwable instanceof ForcedDisconnectException) {
                        Exception exception = (Exception)throwable;
                    } else {
                        ChannelClosedException channelClosedException = e;
                    }
                }
                catch (ChannelNotConnectedException e) {
                    ChannelNotConnectedException channelNotConnectedException = e;
                }
                catch (IllegalArgumentException e) {
                    IllegalArgumentException illegalArgumentException = e;
                }
                if (var22_58 != null) {
                    void var22_66;
                    if (this.shutdownCause != null) {
                        Exception cause = this.shutdownCause;
                        if (cause instanceof ForcedDisconnectException) {
                            Exception exception = cause;
                        } else {
                            void var24_73;
                            void var24_72 = var22_58;
                            while (var24_73.getCause() != null) {
                                Throwable throwable = var24_73.getCause();
                            }
                            var24_73.initCause(this.shutdownCause);
                        }
                    }
                    this.listener.membershipFailure("Channel closed", (Throwable)var22_66);
                    throw new DistributedSystemDisconnectedException("Channel closed", (Throwable)var22_66);
                }
                ++i;
            }
        }
        if (allDestinations) {
            return null;
        }
        result = new HashSet();
        NetView netView = this.getView();
        for (int i = 0; i < destinations.length; ++i) {
            InternalDistributedMember internalDistributedMember = destinations[i];
            if (netView.contains(internalDistributedMember)) continue;
            result.add(internalDistributedMember);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public void reset() throws DistributionException {
        if (this.conduit != null) {
            try {
                this.conduit.restart();
            }
            catch (ConnectionException e) {
                throw new DistributionException(LocalizedStrings.JGroupMembershipManager_UNABLE_TO_RESTART_CONDUIT.toLocalizedString(), e);
            }
        }
    }

    @Override
    public void forceUDPMessagingForCurrentThread() {
        this.forceUseJGroups.set(Boolean.TRUE);
    }

    @Override
    public void releaseUDPMessagingForCurrentThread() {
        this.forceUseJGroups.set(null);
    }

    private boolean isForceUDPCommunications() {
        Boolean forced = this.forceUseJGroups.get();
        return forced == Boolean.TRUE;
    }

    public void establishChannelPause(long period) {
        this.channelPause = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stub getStubForMember(InternalDistributedMember m) {
        if (this.shutdownInProgress) {
            throw new DistributedSystemDisconnectedException(LocalizedStrings.JGroupMembershipManager_DISTRIBUTEDSYSTEM_IS_SHUTTING_DOWN.toLocalizedString(), this.shutdownCause);
        }
        if (this.conduit == null) {
            return new Stub(m.getIpAddress(), m.getPort(), m.getVmViewId());
        }
        Stub result = (Stub)this.memberToStubMap.get(m);
        if (result != null) {
            return result;
        }
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.shutdownInProgress()) {
                return null;
            }
            if (this.isShunned(m)) {
                return null;
            }
            result = this.directChannel.createConduitStub(m);
            this.addChannel(m, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalDistributedMember getMemberForStub(Stub s, boolean validated) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.shutdownInProgress) {
                throw new DistributedSystemDisconnectedException(LocalizedStrings.JGroupMembershipManager_DISTRIBUTEDSYSTEM_IS_SHUTTING_DOWN.toLocalizedString(), this.shutdownCause);
            }
            InternalDistributedMember result = (InternalDistributedMember)this.stubToMemberMap.get(s);
            if (result != null && validated && !this.latestView.contains(result)) {
                if (!this.surpriseMembers.containsKey(result)) {
                    this.stubToMemberMap.remove(s);
                    this.memberToStubMap.remove(result);
                }
                result = null;
            }
            if (result == null) {
                for (InternalDistributedMember idm : this.latestView) {
                    if (!idm.getIpAddress().equals(s.getInetAddress()) || idm.getDirectChannelPort() != s.getPort()) continue;
                    this.addChannel(idm, s);
                    return idm;
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShutdown() {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            this.shutdownInProgress = true;
        }
    }

    @Override
    public boolean shutdownInProgress() {
        return this.shutdownInProgress || this.listener.getDM().shutdownInProgress();
    }

    protected void addChannel(InternalDistributedMember member, Stub theChannel) {
        if (theChannel != null) {
            this.memberToStubMap.put(member, theChannel);
            this.stubToMemberMap.put(theChannel, member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushUnicast() {
        if (this.ucastProtocol != null) {
            long flushStart = 0L;
            if (DistributionStats.enableClockStats) {
                flushStart = this.stats.startUcastFlush();
            }
            try {
                this.suspendSends();
                long start = System.currentTimeMillis();
                while (this.ucastProtocol.getNumberOfUnackedMessages() > 0) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    if (System.currentTimeMillis() - start <= (long)this.dconfig.getMemberTimeout()) continue;
                    break;
                }
            }
            finally {
                if (DistributionStats.enableClockStats) {
                    this.stats.endUcastFlush(flushStart);
                }
                this.resumeSends();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void suspendSends() {
        Object object = this.sendSuspendMutex;
        synchronized (object) {
            this.sendSuspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeSends() {
        Object object = this.sendSuspendMutex;
        synchronized (object) {
            this.sendSuspended = false;
            this.sendSuspendMutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyMember(final InternalDistributedMember member, boolean crashed, final String reason) {
        DirectChannel dc;
        Stub theChannel;
        if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
            logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: destroying < {} >", member);
        }
        if ((theChannel = (Stub)this.memberToStubMap.remove(member)) != null) {
            this.stubToMemberMap.remove(theChannel);
        }
        this.ipAddrToMemberMap.remove(new IpAddress(member.getIpAddress(), member.getPort()));
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.latestView.contains(member)) {
                NetView newView = new NetView(this.latestView, this.latestView.getViewNumber());
                newView.remove(member);
                this.latestView = newView;
            }
        }
        this.surpriseMembers.remove(member);
        if (!this.isShunned(member)) {
            this.addShunnedMember(member);
        }
        if ((dc = this.directChannel) != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(Integer.getInteger("p2p.disconnectDelay", 3000).intValue());
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Membership: closing connections for departed member {}", member);
                    }
                    dc.closeEndpoint(member, reason, false);
                }
            };
            t.setDaemon(true);
            t.setName("disconnect thread for " + member);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stub getDirectChannel() {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            return (Stub)this.memberToStubMap.get(this.myMemberId);
        }
    }

    private static String replaceStrings(String properties, String property2, String value2) {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int index2 = properties.indexOf(property2);
        while (index2 != -1) {
            sb.append(properties.substring(start, index2));
            sb.append(value2);
            start = index2 + property2.length();
            index2 = properties.indexOf(property2, start);
        }
        sb.append(properties.substring(start));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShunned(DistributedMember m) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            long now;
            if (!this.shunnedMembers.containsKey(m)) {
                return false;
            }
            long shunTime = (Long)this.shunnedMembers.get(m);
            if (shunTime + (long)(SHUNNED_SUNSET * 1000) > (now = System.currentTimeMillis())) {
                return true;
            }
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                logger.debug("Membership: no longer shunning <  {} >", m);
            }
            this.endShun(m);
            return false;
        }
    }

    public boolean isShunnedMemberNoSync(IpAddress addr) {
        InternalDistributedMember mbr = (InternalDistributedMember)this.ipAddrToMemberMap.get(addr);
        if (mbr == null) {
            return false;
        }
        return this.shunnedMembers.containsKey(mbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSurpriseMember(DistributedMember m) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.surpriseMembers.containsKey(m)) {
                long now;
                long birthTime = this.surpriseMembers.get(m);
                boolean bl = birthTime >= (now = System.currentTimeMillis()) - (long)this.surpriseMemberTimeout;
                return bl;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSurpriseMemberForTesting(DistributedMember m, long birthTime) {
        if (logger.isDebugEnabled()) {
            logger.debug("test hook is adding surprise member {} birthTime={}", m, birthTime);
        }
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            this.surpriseMembers.put((InternalDistributedMember)m, birthTime);
        }
    }

    public int getSurpriseMemberTimeout() {
        return this.surpriseMemberTimeout;
    }

    public int getShunnedMemberTimeout() {
        return SHUNNED_SUNSET * 1000;
    }

    private boolean endShun(DistributedMember m) {
        boolean wasShunned = this.shunnedMembers.remove(m) != null;
        this.shunnedAndWarnedMembers.remove(m);
        return wasShunned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addShunnedMember(InternalDistributedMember m) {
        long deathTime = System.currentTimeMillis() - (long)(SHUNNED_SUNSET * 1000);
        this.surpriseMembers.remove(m);
        if (!this.isShunned(m)) {
            this.shunnedMembers.put(m, System.currentTimeMillis());
            if (logger.isTraceEnabled(LogMarker.DISTRIBUTION_VIEWS)) {
                logger.trace(LogMarker.DISTRIBUTION_VIEWS, "Membership: added shunned member < {} >", m);
            }
        }
        HashSet oldMembers = new HashSet(this.shunnedMembers.entrySet());
        HashSet<InternalDistributedMember> removedMembers = new HashSet<InternalDistributedMember>();
        for (Map.Entry viewLock : oldMembers) {
            long ll = (Long)viewLock.getValue();
            if (ll >= deathTime) continue;
            InternalDistributedMember mm = (InternalDistributedMember)viewLock.getKey();
            if (this.latestView.contains(mm)) {
                this.destroyMember(mm, true, "shunned but never disconnected");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Membership: finally removed shunned member entry <{}>", mm);
            }
            removedMembers.add(mm);
        }
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            for (InternalDistributedMember idm : removedMembers) {
                this.endShun(idm);
                this.ipAddrToMemberMap.remove(new IpAddress(idm.getIpAddress(), idm.getPort()));
            }
        }
    }

    public Object getThreadLocalData() {
        HashMap result = new HashMap();
        return result;
    }

    public void setThreadLocalData(Object data) {
        Map dataMap = (Map)data;
        Object td = dataMap.get("DirAck");
    }

    public int getDirectChannelPort() {
        return this.directChannel == null ? 0 : this.directChannel.getPort();
    }

    public int getSerialQueueThrottleTime(Address sender) {
        IpAddress senderAddr = (IpAddress)sender;
        InternalDistributedMember member = this.getMemberFromIpAddress(senderAddr, true);
        ThrottlingMemLinkedQueueWithDMStats serialQueue = this.listener.getDM().getSerialQueue(member);
        if (serialQueue == null) {
            return 0;
        }
        return serialQueue.getThrottleTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalDistributedMember getMemberFromIpAddress(IpAddress sender, boolean createIfAbsent) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            InternalDistributedMember mbr = (InternalDistributedMember)this.ipAddrToMemberMap.get(sender);
            if (mbr == null && createIfAbsent) {
                JGroupMember jgm = new JGroupMember(sender);
                mbr = new InternalDistributedMember(jgm);
                if (sender.getVmKind() != 0) {
                    this.ipAddrToMemberMap.put(sender, mbr);
                }
            }
            return mbr;
        }
    }

    @Override
    public HashMap getChannelStates(DistributedMember member, boolean includeMulticast) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        Stub stub = (Stub)this.memberToStubMap.get(member);
        DirectChannel dc = this.directChannel;
        if (stub != null && dc != null) {
            dc.getChannelStates(stub, result);
        }
        if (includeMulticast) {
            result.put("JGroups.MCast", this.channel.getMulticastState());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForChannelState(DistributedMember otherMember, HashMap channelState) throws InterruptedException {
        Stub stub;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        DirectChannel dc = this.directChannel;
        Long mcastState = (Long)channelState.remove("JGroups.MCast");
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            stub = (Stub)this.memberToStubMap.get(otherMember);
        }
        if (dc != null && stub != null) {
            dc.waitForChannelState(stub, channelState);
        }
        if (mcastState != null) {
            InternalDistributedMember idm = (InternalDistributedMember)otherMember;
            JGroupMember jgm = (JGroupMember)idm.getNetMember();
            IpAddress other = jgm.getAddress();
            this.channel.waitForMulticastState(other, mcastState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean waitForDeparture(DistributedMember mbr) throws TimeoutException, InterruptedException {
        boolean wait;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean result = false;
        DirectChannel dc = this.directChannel;
        InternalDistributedMember idm = (InternalDistributedMember)mbr;
        Stub stub = new Stub(idm.getIpAddress(), idm.getPort(), idm.getVmViewId());
        int memberTimeout = this.dconfig.getMemberTimeout();
        long pauseTime = memberTimeout < 1000 ? 100L : (long)(memberTimeout / 10);
        int numWaits = 0;
        do {
            ThrottlingMemLinkedQueueWithDMStats serialQueue;
            wait = false;
            if (dc != null) {
                if (dc.hasReceiversFor(stub)) {
                    wait = true;
                }
                if (wait && logger.isDebugEnabled()) {
                    logger.debug("waiting for receivers for {} to shut down", mbr);
                }
            }
            if (!wait) {
                ViewLock viewLock = this.latestViewLock;
                // MONITORENTER : viewLock
                wait = this.latestView.contains(idm);
                // MONITOREXIT : viewLock
                if (wait && logger.isDebugEnabled()) {
                    logger.debug("waiting for {} to leave the membership view", mbr);
                }
            }
            if (!wait && (serialQueue = this.listener.getDM().getSerialQueue(idm)) != null) {
                boolean[] done = new boolean[1];
                final FlushingMessage msg = new FlushingMessage(done);
                serialQueue.add(new SizeableRunnable(100){

                    @Override
                    public void run() {
                        msg.invoke();
                    }

                    public String toString() {
                        return "Processing fake message";
                    }
                });
                boolean[] blArray = done;
                // MONITORENTER : done
                while (!done[0]) {
                    done.wait(10L);
                }
                result = true;
                // MONITOREXIT : blArray
            }
            if (!wait) continue;
            if (++numWaits > 40) {
                throw new TimeoutException("waited too long for " + idm + " to be removed");
            }
            Thread.sleep(pauseTime);
        } while (wait && (this.channel.isOpen() || dc != null && dc.isOpen()));
        if (!logger.isDebugEnabled()) return result;
        logger.debug("operations for {} should all be in the cache at this point", mbr);
        return result;
    }

    public DistributionConfig getDistributionConfig() {
        return this.dconfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean memberExists(IpAddress mbr) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            InternalDistributedMember idm = this.getMemberFromIpAddress(mbr, true);
            if (idm == null) {
                return true;
            }
            return this.memberExists(idm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warnShun(IpAddress mbr) {
        InternalDistributedMember idm;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            idm = this.getMemberFromIpAddress(mbr, true);
        }
        if (idm == null) {
            return;
        }
        this.warnShun(idm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForMembershipCheck(InternalDistributedMember remoteId) {
        boolean foundRemoteId = false;
        Latch currentLatch = null;
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.latestView != null) {
                if (this.latestView.contains(remoteId)) {
                    foundRemoteId = true;
                } else {
                    currentLatch = (Latch)this.memberLatch.get(remoteId);
                    if (currentLatch == null) {
                        currentLatch = new Latch();
                        this.memberLatch.put(remoteId, currentLatch);
                    }
                }
            }
        }
        if (!foundRemoteId) {
            try {
                if (currentLatch.attempt(this.membershipCheckTimeout)) {
                    foundRemoteId = true;
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_THE_MEMBERSHIP_CHECK_WAS_TERMINATED_WITH_AN_EXCEPTION));
            }
        }
        return foundRemoteId;
    }

    @Override
    public Throwable getShutdownCause() {
        return this.shutdownCause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTestHook(MembershipTestHook mth) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.membershipTestHooks == null) {
                this.membershipTestHooks = Collections.singletonList(mth);
            } else {
                ArrayList<MembershipTestHook> l = new ArrayList<MembershipTestHook>(this.membershipTestHooks);
                l.add(mth);
                this.membershipTestHooks = l;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterTestHook(MembershipTestHook mth) {
        ViewLock viewLock = this.latestViewLock;
        synchronized (viewLock) {
            if (this.membershipTestHooks != null) {
                if (this.membershipTestHooks.size() == 1) {
                    this.membershipTestHooks = null;
                } else {
                    ArrayList l = new ArrayList(this.membershipTestHooks);
                    l.remove(mth);
                }
            }
        }
    }

    protected synchronized void beSick() {
        if (!this.beingSick) {
            this.beingSick = true;
            if (logger.isDebugEnabled()) {
                logger.debug("JGroupMembershipManager.beSick invoked for {} - simulating sickness", this.myMemberId);
            }
            this.fdProtocol.beSick();
            this.fdSockProtocol.beSick();
            if (this.directChannel != null) {
                this.directChannel.beSick();
            }
        }
    }

    protected synchronized void playDead() {
        if (!this.playingDead) {
            this.playingDead = true;
            if (logger.isDebugEnabled()) {
                logger.debug("JGroupMembershipManager.playDead invoked for {}", this.myMemberId);
            }
            this.verifySuspectProtocol.playDead(true);
            this.fdProtocol.beSick();
            this.fdSockProtocol.beSick();
        }
    }

    protected synchronized void beHealthy() {
        if (this.beingSick || this.playingDead) {
            this.beingSick = false;
            this.playingDead = false;
            if (logger.isDebugEnabled()) {
                logger.debug("JGroupMembershipManager.beHealthy invoked for {} - recovering health now", this.myMemberId);
            }
            this.fdSockProtocol.beHealthy();
            this.fdProtocol.beHealthy();
            if (this.directChannel != null) {
                this.directChannel.beHealthy();
            }
            this.verifySuspectProtocol.playDead(false);
        }
    }

    @Override
    public boolean isBeingSick() {
        return this.beingSick;
    }

    public static void inhibitForcedDisconnectLogging(boolean b) {
        inhibitForceDisconnectLogging = true;
    }

    public void setUniqueID(int uniqueID) {
        MemberAttributes.setDefaultVmPid(uniqueID);
    }

    public NAKACK getNakAck() {
        return this.nakAckProtocol;
    }

    public void setCacheTimeOffset(Address src, long timeOffset, boolean isJoin) {
        InternalDistributedMember coord = (InternalDistributedMember)this.ipAddrToMemberMap.get(src);
        if (coord == null && src != null) {
            JGroupMember jgm = new JGroupMember((IpAddress)src);
            coord = new InternalDistributedMember(jgm);
        }
        if (this.listener != null) {
            DistributionManager dm = this.listener.getDM();
            dm.getSystem().getClock().setCacheTimeOffset(coord, timeOffset, isJoin);
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    static class FlushingMessage
    extends DistributionMessage {
        boolean[] done;

        FlushingMessage(boolean[] done) {
            this.done = done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke() {
            boolean[] blArray = this.done;
            synchronized (this.done) {
                this.done[0] = true;
                this.done.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        protected void process(DistributionManager dm) {
        }

        @Override
        public int getDSFID() {
            return 0;
        }

        @Override
        public int getProcessorType() {
            return 74;
        }
    }

    class Puller
    implements Receiver {
        Puller() {
        }

        @Override
        public void receive(Message jgmsg) {
            InternalDistributedMember dm;
            if (JGroupMembershipManager.this.shutdownInProgress()) {
                return;
            }
            Object o = null;
            int messageLength = jgmsg.getLength();
            if (messageLength == 0) {
                return;
            }
            if (DistributionStats.enableClockStats && jgmsg.timeStamp > 0L) {
                JGroupMembershipManager.this.stats.incMessageChannelTime(DistributionStats.getStatTime() - jgmsg.timeStamp);
            }
            if (JGroupMembershipManager.this.vmKind == 12 && jgmsg.getIsDistributedCacheOperation()) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "Membership: admin VM discarding cache operation message {}", jgmsg.getObject());
                }
                return;
            }
            try {
                o = jgmsg.getObject();
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    logger.error(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_EXCEPTION_DESERIALIZING_MESSAGE_PAYLOAD_0, jgmsg), e.getCause());
                    return;
                }
                throw e;
            }
            if (o == null) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_GEMFIRE_RECEIVED_NULL_MESSAGE_FROM__0, String.valueOf(jgmsg)));
                logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_MESSAGE_HEADERS__0, jgmsg.printObjectHeaders()));
                return;
            }
            DistributionMessage msg = o;
            msg.resetTimestamp();
            msg.setBytesRead(messageLength);
            IpAddress sender = (IpAddress)jgmsg.getSrc();
            if (sender == null) {
                Exception e = new Exception(LocalizedStrings.JGroupMembershipManager_NULL_SENDER.toLocalizedString());
                logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_GEMFIRE_RECEIVED_A_MESSAGE_WITH_NO_SENDER_ADDRESS), (Throwable)e);
            }
            if (JGroupMembershipManager.this.isConnected()) {
                dm = JGroupMembershipManager.this.getMemberFromIpAddress(sender, true);
            } else {
                JGroupMember jgm = new JGroupMember(sender);
                dm = new InternalDistributedMember(jgm);
            }
            msg.setSender(dm);
            try {
                JGroupMembershipManager.this.handleOrDeferMessage(msg);
            }
            catch (MemberShunnedException e) {
                // empty catch block
            }
        }

        @Override
        public byte[] getState() {
            return new byte[0];
        }

        @Override
        public void setState(byte[] state) {
        }

        @Override
        public void viewAccepted(View viewArg) {
            JGroupMembershipManager.this.handleOrDeferViewEvent(viewArg);
        }

        @Override
        public void suspect(SuspectMember suspectInfo) {
            if (!JGroupMembershipManager.this.shutdownInProgress()) {
                JGroupMembershipManager.this.handleOrDeferSuspect(suspectInfo);
            }
        }

        @Override
        public void block() {
        }

        @Override
        public void channelClosing(Channel c, Exception e) {
            if (e instanceof ShunnedAddressException) {
                return;
            }
            if (JGroupMembershipManager.this.shutdownInProgress) {
                return;
            }
            JGroupMembershipManager.this.saveCacheXmlForReconnect();
            if (JGroupMembershipManager.this.puller != null && JGroupMembershipManager.this.channel != null) {
                List<Locator> locs;
                String reason;
                JGroupMembershipManager.this.shutdownCause = e;
                AlertAppender.getInstance().shuttingDown();
                Exception logException = e;
                if (e instanceof ForcedDisconnectException) {
                    reason = "Channel closed: " + e;
                    logException = null;
                } else {
                    reason = "Channel closed";
                }
                if (!inhibitForceDisconnectLogging) {
                    logger.fatal(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_SERVICE_FAILURE_0, reason), (Throwable)logException);
                }
                if ((locs = Locator.getLocators()).size() > 0) {
                    for (InternalLocator internalLocator : locs) {
                        internalLocator.stop(!JGroupMembershipManager.this.dconfig.getDisableAutoReconnect(), false);
                    }
                }
                JGroupMembershipManager.this.uncleanShutdown(reason, e);
            }
        }
    }

    class MyDCReceiver
    implements DistributedMembershipListener {
        DistributedMembershipListener upCall;

        MyDCReceiver(DistributedMembershipListener up) {
            this.upCall = up;
        }

        @Override
        public void messageReceived(DistributionMessage msg) {
            IpAddress addr = ((JGroupMember)msg.getSender().getNetMember()).getAddress();
            if (JGroupMembershipManager.this.fdProtocol != null) {
                JGroupMembershipManager.this.fdProtocol.messageReceivedFrom(addr);
            }
            if (JGroupMembershipManager.this.verifySuspectProtocol != null) {
                if (addr.getBirthViewId() < 0) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Membership: invalid address found in sender of {}", msg);
                    }
                } else {
                    JGroupMembershipManager.this.verifySuspectProtocol.unsuspect(addr);
                }
            }
            JGroupMembershipManager.this.handleOrDeferMessage(msg);
        }

        @Override
        public void newMemberConnected(InternalDistributedMember member, Stub id) {
            JGroupMembershipManager.this.handleOrDeferSurpriseConnect(member, id);
        }

        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed, String reason) {
            try {
                JGroupMembershipManager.this.handleOrDeferRemove(id, crashed, reason);
            }
            catch (DistributedSystemDisconnectedException ignore) {
            }
            catch (RuntimeException e) {
                logger.warn(LocalizedMessage.create(LocalizedStrings.JGroupMembershipManager_MEMBERSHIP_ERROR_HANDLING_MEMBER_DEPARTURE__0), (Throwable)e);
            }
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        @Override
        public void memberSuspect(InternalDistributedMember suspect, InternalDistributedMember whoSuspected) {
        }

        @Override
        public boolean isShutdownMsgSent() {
            return this.upCall.isShutdownMsgSent();
        }

        @Override
        public void membershipFailure(String reason, Throwable t) {
            this.upCall.membershipFailure(reason, t);
        }

        @Override
        public void viewInstalled(NetView view) {
            this.upCall.viewInstalled(view);
        }

        @Override
        public DistributionManager getDM() {
            return this.upCall.getDM();
        }
    }

    static class StartupEvent {
        static final int DEPARTURE = 1;
        static final int CONNECT = 2;
        static final int VIEW = 3;
        static final int MESSAGE = 4;
        private int kind;
        InternalDistributedMember member;
        boolean crashed;
        String reason;
        DistributionMessage dmsg;
        Stub stub;
        View jgView;

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("kind=");
            switch (this.kind) {
                case 1: {
                    sb.append("departure; member = <").append(this.member).append(">; crashed = ").append(this.crashed).append("; reason = ");
                    if (this.reason != null && this.reason.indexOf("NoSuchMemberException") >= 0) {
                        sb.append(LocalizedStrings.JGroupMembershipManager_TCPIP_CONNECTIONS_CLOSED.toLocalizedString());
                        break;
                    }
                    sb.append(this.reason);
                    break;
                }
                case 2: {
                    sb.append("connect; member = <" + this.member + ">; stub = " + this.stub);
                    break;
                }
                case 3: {
                    String text = DistributionManager.printView(JGroupMembershipManager.viewToMemberView(this.jgView));
                    sb.append("view <" + text + ">");
                    break;
                }
                case 4: {
                    sb.append("message <" + this.dmsg + ">");
                    break;
                }
                default: {
                    sb.append("unknown=<" + this.kind + ">");
                }
            }
            return sb.toString();
        }

        StartupEvent(InternalDistributedMember dm, boolean crashed, String reason) {
            this.kind = 1;
            this.member = dm;
            this.crashed = crashed;
            this.reason = reason;
        }

        boolean isDepartureEvent() {
            return this.kind == 1;
        }

        StartupEvent(InternalDistributedMember member, Stub id) {
            this.kind = 2;
            this.member = member;
            this.stub = id;
        }

        boolean isConnect() {
            return this.kind == 2;
        }

        StartupEvent(View v) {
            this.kind = 3;
            this.jgView = v;
        }

        boolean isJgView() {
            return this.kind == 3;
        }

        StartupEvent(DistributionMessage d) {
            this.kind = 4;
            this.dmsg = d;
        }

        boolean isDistributionMessage() {
            return this.kind == 4;
        }
    }

    static class ViewLock {
    }

    static class EventProcessingLock {
    }
}

