/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.i18n;

import com.gemstone.gemfire.internal.i18n.AbstractStringIdResourceBundle;
import java.text.MessageFormat;
import java.util.Locale;

public class StringId {
    private static final String RESOURCE_CLASS = "com/gemstone/gemfire/internal/i18n/StringIdResourceBundle";
    public final int id;
    private final String text;
    private static volatile AbstractStringIdResourceBundle rb = null;
    private static volatile Locale currentLocale = null;
    private static boolean includeMsgIDs;
    public static final StringId LITERAL;

    public static void setLocale(Locale l) {
        Locale locale = l;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != currentLocale) {
            AbstractStringIdResourceBundle tempResourceBundle = StringId.getBundle(locale);
            currentLocale = locale;
            rb = tempResourceBundle;
            includeMsgIDs = !rb.usingRawMode();
        }
    }

    private static AbstractStringIdResourceBundle getBundle(Locale l) {
        return AbstractStringIdResourceBundle.getBundle(RESOURCE_CLASS, l);
    }

    public StringId(int id, String text) {
        this.id = id;
        this.text = text;
    }

    public String getRawText() {
        return this.text;
    }

    public String toString() {
        return MessageFormat.format(this.text, null);
    }

    public String toString(Object ... params) {
        return MessageFormat.format(this.text, params);
    }

    public String toLocalizedString() {
        String idStr = "";
        if (includeMsgIDs) {
            idStr = "msgID " + this.id + ": ";
        }
        return MessageFormat.format(idStr + rb.getString(this), null);
    }

    public String toLocalizedString(Object ... params) {
        String idStr = "";
        if (includeMsgIDs) {
            idStr = "msgID " + this.id + ": ";
        }
        return MessageFormat.format(idStr + rb.getString(this), params);
    }

    static Locale getCurrentLocale() {
        return currentLocale;
    }

    static AbstractStringIdResourceBundle getActiveResourceBundle() {
        return rb;
    }

    static {
        LITERAL = new StringId(1, "{0}");
        StringId.setLocale(Locale.getDefault());
    }
}

