/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.LocalStatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractStatisticsFactory
implements StatisticsFactory,
StatisticsManager {
    private final long id;
    private final String name;
    private final List<Statistics> statsList;
    private int statsListModCount = 0;
    private long statsListUniqueId = 1L;
    private final Object statsListUniqueIdLock;
    private final StatisticsTypeFactory tf;
    private final long startTime;

    public AbstractStatisticsFactory(long id, String name, long startTime) {
        this.id = id;
        this.name = name;
        this.startTime = startTime;
        this.statsList = new ArrayList<Statistics>();
        this.statsListUniqueIdLock = new Object();
        this.tf = StatisticsTypeFactoryImpl.singleton();
    }

    public void close() {
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final long getStartTime() {
        return this.startTime;
    }

    @Override
    public final int getStatListModCount() {
        return this.statsListModCount;
    }

    @Override
    public final List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public final int getStatisticsCount() {
        int result = 0;
        List<Statistics> statsList = this.statsList;
        if (statsList != null) {
            result = statsList.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statistics findStatistics(long id) {
        List<Statistics> statsList;
        List<Statistics> list = statsList = this.statsList;
        synchronized (list) {
            for (Statistics s : statsList) {
                if (s.getUniqueId() != id) continue;
                return s;
            }
        }
        throw new RuntimeException(LocalizedStrings.PureStatSampler_COULD_NOT_FIND_STATISTICS_INSTANCE.toLocalizedString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean statisticsExists(long id) {
        List<Statistics> statsList;
        List<Statistics> list = statsList = this.statsList;
        synchronized (list) {
            for (Statistics s : statsList) {
                if (s.getUniqueId() != id) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statistics[] getStatistics() {
        List<Statistics> statsList;
        List<Statistics> list = statsList = this.statsList;
        synchronized (list) {
            return statsList.toArray(new Statistics[statsList.size()]);
        }
    }

    @Override
    public final Statistics createStatistics(StatisticsType type) {
        return this.createOsStatistics(type, null, 0L, 0);
    }

    @Override
    public final Statistics createStatistics(StatisticsType type, String textId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    @Override
    public final Statistics createStatistics(StatisticsType type, String textId, long numericId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        long myUniqueId;
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        LocalStatisticsImpl result = new LocalStatisticsImpl(type, textId, numericId, myUniqueId, false, osStatFlags, this);
        List<Statistics> list = this.statsList;
        synchronized (list) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statistics[] findStatisticsByType(StatisticsType type) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        List<Statistics> list = this.statsList;
        synchronized (list) {
            for (Statistics s : this.statsList) {
                if (type != s.getType()) continue;
                hits.add(s);
            }
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statistics[] findStatisticsByTextId(String textId) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        List<Statistics> list = this.statsList;
        synchronized (list) {
            for (Statistics s : this.statsList) {
                if (!s.getTextId().equals(textId)) continue;
                hits.add(s);
            }
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Statistics[] findStatisticsByNumericId(long numericId) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        List<Statistics> list = this.statsList;
        synchronized (list) {
            for (Statistics s : this.statsList) {
                if (numericId != s.getNumericId()) continue;
                hits.add(s);
            }
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Statistics findStatisticsByUniqueId(long uniqueId) {
        List<Statistics> list = this.statsList;
        synchronized (list) {
            for (Statistics s : this.statsList) {
                if (uniqueId != s.getUniqueId()) continue;
                return s;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroyStatistics(Statistics stats) {
        List<Statistics> list = this.statsList;
        synchronized (list) {
            if (this.statsList.remove(stats)) {
                ++this.statsListModCount;
            }
        }
    }

    @Override
    public final Statistics createAtomicStatistics(StatisticsType type) {
        return this.createAtomicStatistics(type, null, 0L);
    }

    @Override
    public final Statistics createAtomicStatistics(StatisticsType type, String textId) {
        return this.createAtomicStatistics(type, textId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        long myUniqueId;
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        Statistics result = StatisticsImpl.createAtomicNoOS(type, textId, numericId, myUniqueId, this);
        List<Statistics> list = this.statsList;
        synchronized (list) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    @Override
    public final StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.tf.createType(name, description, stats);
    }

    @Override
    public final StatisticsType findType(String name) {
        return this.tf.findType(name);
    }

    @Override
    public final StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return this.tf.createTypesFromXml(reader);
    }

    @Override
    public final StatisticDescriptor createIntCounter(String name, String description, String units) {
        return this.tf.createIntCounter(name, description, units);
    }

    @Override
    public final StatisticDescriptor createLongCounter(String name, String description, String units) {
        return this.tf.createLongCounter(name, description, units);
    }

    @Override
    public final StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return this.tf.createDoubleCounter(name, description, units);
    }

    @Override
    public final StatisticDescriptor createIntGauge(String name, String description, String units) {
        return this.tf.createIntGauge(name, description, units);
    }

    @Override
    public final StatisticDescriptor createLongGauge(String name, String description, String units) {
        return this.tf.createLongGauge(name, description, units);
    }

    @Override
    public final StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return this.tf.createDoubleGauge(name, description, units);
    }

    @Override
    public final StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createIntCounter(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createIntGauge(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public final StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createDoubleGauge(name, description, units, largerBetter);
    }
}

