/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.OSProcess;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Banner {
    private Banner() {
    }

    private static void prettyPrintPath(String path, PrintWriter out) {
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                out.println("  " + st.nextToken());
            }
        }
    }

    private static void print(PrintWriter out, String[] args) {
        TreeMap<Object, Object> sp = new TreeMap<Object, Object>((Properties)System.getProperties().clone());
        int processId = -1;
        String SEPERATOR = "---------------------------------------------------------------------------";
        try {
            processId = OSProcess.getId();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
        }
        out.println();
        String productName = GemFireVersion.getProductName();
        out.println("---------------------------------------------------------------------------");
        out.println();
        out.println("  Copyright (C) 1997-2015 Pivotal Software, Inc. All rights reserved. This");
        out.println("  product is protected by U.S. and international copyright and intellectual");
        out.println("  property laws. Pivotal products are covered by one or more patents listed");
        out.println("  at http://www.pivotal.io/patents.  Pivotal is a registered trademark");
        out.println("  of trademark of Pivotal Software, Inc. in the United States and/or other");
        out.println("  jurisdictions.  All other marks and names mentioned herein may be");
        out.println("  trademarks of their respective companies.");
        out.println();
        out.println("---------------------------------------------------------------------------");
        GemFireVersion.print(out);
        out.println("Process ID: " + processId);
        out.println("User: " + sp.get("user.name"));
        sp.remove("user.name");
        sp.remove("os.name");
        sp.remove("os.arch");
        out.println("Current dir: " + sp.get("user.dir"));
        sp.remove("user.dir");
        out.println("Home dir: " + sp.get("user.home"));
        sp.remove("user.home");
        ArrayList<String> allArgs = new ArrayList<String>();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        if (runtimeBean != null) {
            allArgs.addAll(runtimeBean.getInputArguments());
        }
        if (args != null && args.length != 0) {
            for (int i = 0; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
        }
        if (!allArgs.isEmpty()) {
            out.println("Command Line Parameters:");
            for (String arg : allArgs) {
                out.println("  " + arg);
            }
        }
        out.println("Class Path:");
        Banner.prettyPrintPath((String)sp.get("java.class.path"), out);
        sp.remove("java.class.path");
        out.println("Library Path:");
        Banner.prettyPrintPath((String)sp.get("java.library.path"), out);
        sp.remove("java.library.path");
        if (Boolean.getBoolean("gemfire.disableSystemPropertyLogging")) {
            out.println("System property logging disabled.");
        } else {
            out.println("System Properties:");
            for (Map.Entry me : sp.entrySet()) {
                String key2 = me.getKey().toString();
                if (!(key2.startsWith("gemfire.security-") || key2.startsWith("gemfire.sys.security-") || key2.toLowerCase().contains("password"))) {
                    out.println("    " + key2 + " = " + me.getValue());
                    continue;
                }
                out.println("    " + key2 + " = " + "********");
            }
        }
        out.println("---------------------------------------------------------------------------");
    }

    public static String getString(String[] args) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Banner.print(pw, args);
        pw.close();
        return sw.toString();
    }
}

