/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.OsStatisticsFactory;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.StatSamplerStats;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.VMStatsContract;
import com.gemstone.gemfire.internal.VMStatsContractFactory;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.statistics.SampleCollector;
import com.gemstone.gemfire.internal.statistics.StatArchiveHandlerConfig;
import com.gemstone.gemfire.internal.statistics.StatisticsSampler;
import com.gemstone.gemfire.internal.util.concurrent.StoppableCountDownLatch;
import java.io.File;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.logging.log4j.Logger;

public abstract class HostStatSampler
implements Runnable,
StatisticsSampler,
StatArchiveHandlerConfig {
    private static final Logger logger = LogService.getLogger();
    public static final String TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY = "gemfire.stats.test.fileSizeLimitInKB";
    public static final String OS_STATS_DISABLED_PROPERTY = "osStatsDisabled";
    protected static final String INITIALIZATION_TIMEOUT_PROPERTY = "gemfire.statSamplerInitializationTimeout";
    protected static final int INITIALIZATION_TIMEOUT_DEFAULT = 3000;
    protected static final long INITIALIZATION_TIMEOUT_MILLIS = Long.getLong("gemfire.statSamplerInitializationTimeout", 3000L);
    private static final long STAT_SAMPLER_DELAY_THRESHOLD = Long.getLong("gemfire.statSamplerDelayThreshold", 3000L);
    private static final long STAT_SAMPLER_DELAY_THRESHOLD_NANOS = NanoTimer.millisToNanos(STAT_SAMPLER_DELAY_THRESHOLD);
    private static final int MIN_MS_SLEEP = 1;
    private static final int WAIT_FOR_SLEEP_INTERVAL = 10;
    private static Thread statThread = null;
    private volatile boolean stopRequested = false;
    private final boolean osStatsDisabled = Boolean.getBoolean("osStatsDisabled");
    private final boolean fileSizeLimitInKB;
    private final StatSamplerStats samplerStats;
    private VMStatsContract vmStats;
    private SampleCollector sampleCollector;
    private final StoppableCountDownLatch statSamplerInitializedLatch;
    private final CancelCriterion stopper;

    protected HostStatSampler(CancelCriterion stopper, StatSamplerStats samplerStats) {
        this.stopper = stopper;
        this.statSamplerInitializedLatch = new StoppableCountDownLatch(this.stopper, 1);
        this.samplerStats = samplerStats;
        this.fileSizeLimitInKB = Boolean.getBoolean(TEST_FILE_SIZE_LIMIT_IN_KB_PROPERTY);
    }

    public final StatSamplerStats getStatSamplerStats() {
        return this.samplerStats;
    }

    @Override
    public final int getStatisticsModCount() {
        return this.getStatisticsManager().getStatListModCount();
    }

    @Override
    public final Statistics[] getStatistics() {
        return this.getStatisticsManager().getStatistics();
    }

    @Override
    public final long getSystemId() {
        return this.getStatisticsManager().getId();
    }

    @Override
    public final long getSystemStartTime() {
        return this.getStatisticsManager().getStartTime();
    }

    @Override
    public final String getSystemDirectoryPath() {
        try {
            return SocketCreator.getHostName(SocketCreator.getLocalHost());
        }
        catch (UnknownHostException ignore) {
            return "";
        }
    }

    @Override
    public boolean waitForSample(long timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout;
        int startSampleCount = this.samplerStats.getSampleCount();
        while (System.currentTimeMillis() < endTime && this.samplerStats.getSampleCount() <= startSampleCount) {
            Thread.sleep(10L);
        }
        return this.samplerStats.getSampleCount() > startSampleCount;
    }

    @Override
    public SampleCollector waitForSampleCollector(long timeout) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeout;
        while (System.currentTimeMillis() < endTime && this.sampleCollector == null || !this.sampleCollector.isInitialized()) {
            Thread.sleep(10L);
        }
        return this.sampleCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        NanoTimer timer = new NanoTimer();
        boolean isDebugEnabled_STATISTICS = logger.isTraceEnabled(LogMarker.STATISTICS);
        if (isDebugEnabled_STATISTICS) {
            logger.trace(LogMarker.STATISTICS, "HostStatSampler started");
        }
        boolean latchCountedDown = false;
        try {
            this.initSpecialStats();
            this.sampleCollector = new SampleCollector(this);
            this.sampleCollector.initialize(this, NanoTimer.getTime());
            this.statSamplerInitializedLatch.countDown();
            latchCountedDown = true;
            timer.reset();
            long nanosLastTimeStamp = timer.getLastResetTime() - this.getNanoRate();
            while (!this.stopRequested()) {
                SystemFailure.checkFailure();
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                long nanosBeforeSleep = timer.getLastResetTime();
                long nanosToDelay = nanosLastTimeStamp + this.getNanoRate();
                this.delay(timer, nanosToDelay);
                nanosLastTimeStamp = timer.getLastResetTime();
                if (!this.stopRequested() && this.isSamplingEnabled()) {
                    long nanosTimeStamp = timer.getLastResetTime();
                    long nanosElapsedSleeping = nanosTimeStamp - nanosBeforeSleep;
                    this.checkElapsedSleepTime(nanosElapsedSleeping);
                    if (this.stopRequested()) {
                        break;
                    }
                    this.sampleSpecialStats(false);
                    if (this.stopRequested()) {
                        break;
                    }
                    this.checkListeners();
                    if (this.stopRequested()) {
                        break;
                    }
                    this.sampleCollector.sample(nanosTimeStamp);
                    long nanosSpentWorking = timer.reset();
                    this.accountForTimeSpentWorking(nanosSpentWorking, nanosElapsedSleeping);
                    continue;
                }
                if (this.stopRequested() || this.isSamplingEnabled()) continue;
                this.sampleSpecialStats(true);
            }
        }
        catch (InterruptedException ex) {
        }
        catch (CancelException ex) {
        }
        catch (RuntimeException ex) {
            logger.fatal(LogMarker.STATISTICS, ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error ex) {
            SystemFailure.checkFailure();
            logger.fatal(LogMarker.STATISTICS, ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            try {
                this.closeSpecialStats();
                if (this.sampleCollector != null) {
                    this.sampleCollector.close();
                }
            }
            finally {
                if (!latchCountedDown) {
                    this.statSamplerInitializedLatch.countDown();
                }
            }
            if (isDebugEnabled_STATISTICS) {
                logger.trace(LogMarker.STATISTICS, "HostStatSampler stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Class<HostStatSampler> clazz = HostStatSampler.class;
        synchronized (HostStatSampler.class) {
            if (statThread != null) {
                try {
                    int msToWait = this.getSampleRate() + 100;
                    statThread.join(msToWait);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (statThread.isAlive()) {
                    throw new IllegalStateException(LocalizedStrings.HostStatSampler_STATISTICS_SAMPLING_THREAD_IS_ALREADY_RUNNING_INDICATING_AN_INCOMPLETE_SHUTDOWN_OF_A_PREVIOUS_CACHE.toLocalizedString());
                }
            }
            LoggingThreadGroup group = LoggingThreadGroup.createThreadGroup("StatSampler Threads");
            statThread = new Thread((ThreadGroup)group, this);
            statThread.setName(statThread.getName() + " StatSampler");
            statThread.setPriority(10);
            statThread.setDaemon(true);
            statThread.start();
            try {
                this.waitForInitialization(INITIALIZATION_TIMEOUT_MILLIS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void stop() {
        Class<HostStatSampler> clazz = HostStatSampler.class;
        // MONITORENTER : com.gemstone.gemfire.internal.HostStatSampler.class
        if (statThread == null) {
            // MONITOREXIT : clazz
            return;
        }
        this.stopRequested = true;
        HostStatSampler hostStatSampler = this;
        // MONITORENTER : hostStatSampler
        this.notify();
        // MONITOREXIT : hostStatSampler
        try {
            statThread.join();
            return;
        }
        catch (InterruptedException ignore) {
            try {
                statThread.join(2000L);
                Thread.currentThread().interrupt();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
            finally {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            if (statThread.isAlive()) {
                logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.HostStatSampler_HOSTSTATSAMPLER_WAS_INTERRUPTED_DURRING_SHUTDOWN));
            } else {
                this.stopRequested = false;
                statThread = null;
            }
        }
    }

    public final boolean isAlive() {
        return statThread.isAlive();
    }

    public final void waitForInitialization() throws InterruptedException {
        this.statSamplerInitializedLatch.await();
    }

    public final boolean waitForInitialization(long ms) throws InterruptedException {
        return this.statSamplerInitializedLatch.await(ms);
    }

    public final void changeArchive(File newFile) {
        this.sampleCollector.changeArchive(newFile, NanoTimer.getTime());
    }

    public final VMStatsContract getVMStats() {
        return this.vmStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this));
        return sb.toString();
    }

    protected abstract void checkListeners();

    protected abstract int getSampleRate();

    public abstract boolean isSamplingEnabled();

    protected abstract StatisticsManager getStatisticsManager();

    protected OsStatisticsFactory getOsStatisticsFactory() {
        return null;
    }

    protected void initProcessStats(long id) {
    }

    protected void sampleProcessStats(boolean prepareOnly) {
    }

    protected void closeProcessStats() {
    }

    protected long getSpecialStatsId() {
        return this.getStatisticsManager().getId();
    }

    protected final boolean fileSizeLimitInKB() {
        return this.fileSizeLimitInKB;
    }

    protected final boolean osStatsDisabled() {
        return this.osStatsDisabled;
    }

    protected final boolean stopRequested() {
        return this.stopper.cancelInProgress() != null || this.stopRequested;
    }

    public final SampleCollector getSampleCollector() {
        return this.sampleCollector;
    }

    private synchronized void initSpecialStats() {
        long id = this.getSpecialStatsId();
        this.vmStats = VMStatsContractFactory.create(this.getStatisticsManager(), id);
        this.initProcessStats(id);
    }

    private synchronized void closeSpecialStats() {
        if (this.vmStats != null) {
            this.vmStats.close();
        }
        this.closeProcessStats();
    }

    private void accountForTimeSpentWorking(long nanosSpentWorking, long nanosSpentSleeping) {
        this.samplerStats.tookSample(nanosSpentWorking, this.getStatisticsManager().getStatisticsCount(), nanosSpentSleeping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delay(NanoTimer timer, long nanosToDelay) throws InterruptedException {
        timer.reset();
        long now = timer.getLastResetTime();
        long remainingNanos = nanosToDelay - now;
        if (remainingNanos <= 0L) {
            remainingNanos = NanoTimer.millisToNanos(1L);
        }
        while (remainingNanos > 0L && !this.stopRequested()) {
            long ms = NanoTimer.nanosToMillis(remainingNanos);
            if (ms <= 0L) {
                Thread.yield();
            } else {
                if (ms > 1L) {
                    --ms;
                }
                HostStatSampler hostStatSampler = this;
                synchronized (hostStatSampler) {
                    if (this.stopRequested()) {
                        return;
                    }
                    this.wait(ms);
                }
            }
            timer.reset();
            now = timer.getLastResetTime();
            remainingNanos = nanosToDelay - now;
        }
    }

    private long getNanoRate() {
        return NanoTimer.millisToNanos(this.getSampleRate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleSpecialStats(boolean prepareOnly) {
        List<Statistics> statsList;
        List<Statistics> list = statsList = this.getStatisticsManager().getStatsList();
        synchronized (list) {
            for (Statistics s : statsList) {
                if (this.stopRequested()) {
                    return;
                }
                if (!(s instanceof StatisticsImpl)) continue;
                ((StatisticsImpl)s).prepareForSample();
            }
        }
        if (!prepareOnly && this.vmStats != null) {
            if (this.stopRequested()) {
                return;
            }
            this.vmStats.refresh();
        }
        this.sampleProcessStats(prepareOnly);
    }

    private void checkElapsedSleepTime(long elapsedSleepTime) {
        long wakeupDelay;
        if (STAT_SAMPLER_DELAY_THRESHOLD > 0L && (wakeupDelay = elapsedSleepTime - this.getNanoRate()) > STAT_SAMPLER_DELAY_THRESHOLD_NANOS) {
            this.samplerStats.incJvmPauses();
            logger.warn(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.HostStatSampler_STATISTICS_SAMPLING_THREAD_DETECTED_A_WAKEUP_DELAY_OF_0_MS_INDICATING_A_POSSIBLE_RESOURCE_ISSUE, NanoTimer.nanosToMillis(wakeupDelay)));
        }
    }
}

