/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.Logger;

public class JarClassLoader
extends ClassLoader {
    private static final Logger logger = LogService.getLogger();
    private static final MessageDigest messageDigest;
    private final String jarName;
    private final File file;
    private final byte[] md5hash;
    private final FileLock fileLock;
    private final Collection<Function> registeredFunctions = new ArrayList<Function>();
    private final ThreadLocal<Boolean> alreadyScanned = new ThreadLocal();
    static final ReentrantLock channelLock;
    private byte[] jarByteContent;

    public JarClassLoader(File file, String jarName, byte[] jarBytes) throws IOException {
        Assert.assertTrue(file != null, "file cannot be null");
        Assert.assertTrue(jarName != null, "jarName cannot be null");
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.fileLock = fileInputStream.getChannel().lock(0L, file.length(), true);
            if (isDebugEnabled) {
                logger.debug("Acquired shared file lock w/ channel: {}, for JAR: {}", this.fileLock.channel(), file.getAbsolutePath());
            }
            if (file.length() == 0L) {
                throw new FileNotFoundException("JAR file was truncated prior to obtaining a lock: " + jarName);
            }
            byte[] fileContent = this.getJarContent();
            if (!Arrays.equals(fileContent, jarBytes)) {
                throw new FileNotFoundException("JAR file: " + file.getAbsolutePath() + ", was modified prior to obtaining a lock: " + jarName);
            }
            if (!JarClassLoader.isValidJarContent(jarBytes)) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock.channel().close();
                    if (isDebugEnabled) {
                        logger.debug("Prematurely releasing shared file lock due to bad content for JAR file: {}, w/ channel: {}", file.getAbsolutePath(), this.fileLock.channel());
                    }
                }
                throw new IllegalArgumentException("File does not contain valid JAR content: " + file.getAbsolutePath());
            }
            Assert.assertTrue(jarBytes != null, "jarBytes cannot be null");
            this.jarByteContent = jarBytes;
            this.md5hash = (byte[])(messageDigest != null ? messageDigest.digest(this.jarByteContent) : null);
            this.file = file;
            this.jarName = jarName;
        }
        catch (FileNotFoundException fnfex) {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock.channel().close();
                if (isDebugEnabled) {
                    logger.debug("Prematurely releasing shared file lock due to file not found for JAR file: {}, w/ channel: {}", file.getAbsolutePath(), this.fileLock.channel());
                }
            }
            throw fnfex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasValidJarContent(InputStream inputStream) {
        JarInputStream jarInputStream = null;
        boolean valid = false;
        try {
            jarInputStream = new JarInputStream(inputStream);
            valid = jarInputStream.getNextJarEntry() != null;
        }
        catch (IOException ignore) {
        }
        finally {
            try {
                jarInputStream.close();
            }
            catch (IOException ioex) {}
        }
        return valid;
    }

    public static boolean isValidJarContent(byte[] jarBytes) {
        return JarClassLoader.hasValidJarContent(new ByteArrayInputStream(jarBytes));
    }

    public static boolean hasValidJarContent(File jarFile) {
        try {
            return JarClassLoader.hasValidJarContent(new FileInputStream(jarFile));
        }
        catch (IOException ioex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadClassesAndRegisterFunctions() throws ClassNotFoundException {
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Registering functions with JarClassLoader: {}", this);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.jarByteContent);
        JarInputStream jarInputStream = null;
        try {
            jarInputStream = new JarInputStream(byteArrayInputStream);
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().endsWith(".class")) {
                    if (isDebugEnabled) {
                        logger.debug("Attempting to load class: {}, from JAR file: {}", jarEntry.getName(), this.file.getAbsolutePath());
                    }
                    String className = jarEntry.getName().replaceAll("/", "\\.").substring(0, jarEntry.getName().length() - 6);
                    try {
                        Class<?> clazz = this.loadClass(className, true, false);
                        Collection<Function> registerableFunctions = this.getRegisterableFunctionsFromClass(clazz);
                        for (Function function : registerableFunctions) {
                            FunctionService.registerFunction(function);
                            if (isDebugEnabled) {
                                logger.debug("Registering function class: {}, from JAR file: {}", className, this.file.getAbsolutePath());
                            }
                            this.registeredFunctions.add(function);
                        }
                    }
                    catch (ClassNotFoundException cnfex) {
                        logger.error("Unable to load all classes from JAR file: {}", this.file.getAbsolutePath(), cnfex);
                        throw cnfex;
                    }
                    catch (NoClassDefFoundError ncdfex) {
                        logger.error("Unable to load all classes from JAR file: {}", this.file.getAbsolutePath(), ncdfex);
                        throw ncdfex;
                    }
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
        }
        catch (IOException ioex) {
            logger.error("Exception when trying to read class from ByteArrayInputStream", (Throwable)ioex);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException ioex) {
                    logger.error("Exception attempting to close JAR input stream", (Throwable)ioex);
                }
            }
        }
        this.jarByteContent = new byte[0];
    }

    synchronized void cleanUp() {
        for (Function function : this.registeredFunctions) {
            FunctionService.unregisterFunction(function.getId());
        }
        this.registeredFunctions.clear();
        try {
            TypeRegistry typeRegistry = ((GemFireCacheImpl)CacheFactory.getAnyInstance()).getPdxRegistry();
            if (typeRegistry != null) {
                typeRegistry.flushCache();
            }
        }
        catch (CacheClosedException ccex) {
            // empty catch block
        }
        try {
            this.fileLock.release();
            this.fileLock.channel().close();
            if (logger.isDebugEnabled()) {
                logger.debug("Released shared file lock on JAR file: {}, w/ channel: {}", this.file.getAbsolutePath(), this.fileLock.channel());
            }
        }
        catch (IOException ioex) {
            logger.error("Could not release the shared lock for JAR file: {}", this.file.getAbsolutePath(), ioex);
        }
    }

    public boolean hasSameContent(byte[] compareToBytes) {
        if (messageDigest == null || this.md5hash == null) {
            return false;
        }
        byte[] compareToMd5 = messageDigest.digest(compareToBytes);
        if (logger.isDebugEnabled()) {
            logger.debug("For JAR file: {}, Comparing MD5 hash {} to {}", this.file.getAbsolutePath(), new String(this.md5hash), new String(compareToMd5));
        }
        return Arrays.equals(this.md5hash, compareToMd5);
    }

    private boolean alreadyScanned() {
        if (this.alreadyScanned.get() == null) {
            this.alreadyScanned.set(Boolean.FALSE);
        }
        return this.alreadyScanned.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected URL findResource(String resourceName) {
        URL returnURL = null;
        ZipInputStream jarInputStream = null;
        try {
            ChannelInputStream channelInputStream = new ChannelInputStream(this.fileLock.channel());
            jarInputStream = new JarInputStream(channelInputStream);
            JarEntry jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            while (jarEntry != null && !jarEntry.getName().equals(resourceName)) {
                jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            }
            if (jarEntry != null) {
                try {
                    returnURL = new URL("jar", "", this.file.toURI().toURL() + "!/" + jarEntry.getName());
                }
                catch (MalformedURLException muex) {
                    logger.error("Could not create resource URL from file URL", (Throwable)muex);
                }
            }
        }
        catch (IOException ioex) {
            logger.error("Exception when trying to read class from ByteArrayInputStream", (Throwable)ioex);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException ioex) {
                    logger.error("Unable to close JAR input stream when finding resource", (Throwable)ioex);
                }
            }
        }
        return returnURL;
    }

    @Override
    protected Enumeration<URL> findResources(final String resourceName) {
        return new Enumeration<URL>(){
            private URL element;
            {
                this.element = JarClassLoader.this.findResource(resourceName);
            }

            @Override
            public boolean hasMoreElements() {
                return this.element != null;
            }

            @Override
            public URL nextElement() {
                if (this.element != null) {
                    URL element = this.element;
                    this.element = null;
                    return element;
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, true);
    }

    @Override
    public Class<?> loadClass(String className, boolean resolveIt) throws ClassNotFoundException {
        return this.loadClass(className, resolveIt, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<?> loadClass(String className, boolean resolveIt, boolean useClassPathLoader) throws ClassNotFoundException {
        Class<?> clazz;
        block8: {
            clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            try {
                clazz = this.findClass(className);
                if (resolveIt) {
                    this.resolveClass(clazz);
                }
            }
            catch (ClassNotFoundException cnfex) {
                if (useClassPathLoader) break block8;
                throw cnfex;
            }
        }
        if (clazz == null) {
            try {
                this.alreadyScanned.set(true);
                Class<?> clazz2 = this.forName(className, ClassPathLoader.getLatest().getClassLoaders());
                return clazz2;
            }
            finally {
                this.alreadyScanned.set(false);
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        String formattedClassName = className.replaceAll("\\.", "/") + ".class";
        ZipInputStream jarInputStream = null;
        if (this.jarByteContent.length == 0) {
            throw new ClassNotFoundException(className);
        }
        try {
            String pkgName;
            Package pkg;
            jarInputStream = new JarInputStream(new ByteArrayInputStream(this.jarByteContent));
            JarEntry jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            while (jarEntry != null && !jarEntry.getName().equals(formattedClassName)) {
                jarEntry = ((JarInputStream)jarInputStream).getNextJarEntry();
            }
            if (jarEntry == null) throw new ClassNotFoundException(className);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(buffer.length);
            int bytesRead = -1;
            while ((bytesRead = jarInputStream.read(buffer)) != -1) {
                byteOutStream.write(buffer, 0, bytesRead);
            }
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1 && (pkg = this.getPackage(pkgName = className.substring(0, lastDotIndex))) == null) {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            byte[] classBytes = byteOutStream.toByteArray();
            File file = this.file;
            synchronized (file) {
                Class<?> clazz = this.findLoadedClass(className);
                if (clazz == null) {
                    clazz = this.defineClass(className, classBytes, 0, classBytes.length, null);
                }
                Class<?> clazz2 = clazz;
                return clazz2;
            }
        }
        catch (IOException ioex) {
            logger.error("Exception when trying to read class from ByteArrayInputStream", (Throwable)ioex);
            throw new ClassNotFoundException(className);
        }
        finally {
            if (jarInputStream != null) {
                try {
                    jarInputStream.close();
                }
                catch (IOException ioex) {
                    logger.error("Exception attempting to close JAR input stream", (Throwable)ioex);
                }
            }
        }
    }

    private Collection<Function> getRegisterableFunctionsFromClass(Class<?> clazz) {
        ArrayList<Function> registerableFunctions;
        block8: {
            registerableFunctions = new ArrayList<Function>();
            try {
                Function function;
                if (!Function.class.isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) break block8;
                boolean registerUninitializedFunction = true;
                if (Declarable.class.isAssignableFrom(clazz)) {
                    try {
                        List<Properties> propertiesList = ((GemFireCacheImpl)CacheFactory.getAnyInstance()).getDeclarableProperties(clazz.getName());
                        if (!propertiesList.isEmpty()) {
                            registerUninitializedFunction = false;
                            for (Properties properties : propertiesList) {
                                Function function2 = this.newFunction(clazz, true);
                                if (function2 == null) continue;
                                ((Declarable)((Object)function2)).init(properties);
                                if (function2.getId() == null) continue;
                                registerableFunctions.add(function2);
                            }
                        }
                    }
                    catch (CacheClosedException ccex) {
                        // empty catch block
                    }
                }
                if (registerUninitializedFunction && (function = this.newFunction(clazz, false)) != null && function.getId() != null) {
                    registerableFunctions.add(function);
                }
            }
            catch (Exception ex) {
                logger.error("Attempting to register function from JAR file: " + this.file.getAbsolutePath(), (Throwable)ex);
            }
        }
        return registerableFunctions;
    }

    private Class<?> forName(String className, Collection<ClassLoader> classLoaders) throws ClassNotFoundException {
        Class<?> clazz = null;
        for (ClassLoader classLoader : classLoaders) {
            try {
                if (classLoader instanceof JarClassLoader) {
                    if (!((JarClassLoader)classLoader).alreadyScanned()) {
                        clazz = ((JarClassLoader)classLoader).loadClass(className, true, false);
                    }
                } else {
                    clazz = Class.forName(className, true, classLoader);
                }
                if (clazz == null) continue;
                return clazz;
            }
            catch (SecurityException sex) {
            }
            catch (ClassNotFoundException cnfex) {
            }
        }
        throw new ClassNotFoundException(className);
    }

    private Function newFunction(Class<Function> clazz, boolean errorOnNoSuchMethod) {
        try {
            Constructor<Function> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException nsmex) {
            if (errorOnNoSuchMethod) {
                logger.error("Zero-arg constructor is required, but not found for class: {}", clazz.getName(), nsmex);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Not registering function because it doesn't have a zero-arg constructor: {}", clazz.getName());
            }
        }
        catch (SecurityException sex) {
            logger.error("Zero-arg constructor of function not accessible for class: {}", clazz.getName(), sex);
        }
        catch (IllegalAccessException iae) {
            logger.error("Zero-arg constructor of function not accessible for class: {}", clazz.getName(), iae);
        }
        catch (InvocationTargetException ite) {
            logger.error("Error when attempting constructor for function for class: {}", clazz.getName(), ite);
        }
        catch (InstantiationException ie) {
            logger.error("Unable to instantiate function for class: {}", clazz.getName(), ie);
        }
        catch (ExceptionInInitializerError eiiex) {
            logger.error("Error during function initialization for class: {}", clazz.getName(), eiiex);
        }
        return null;
    }

    private byte[] getJarContent() throws IOException {
        int bytesRead;
        ChannelInputStream channelInputStream = new ChannelInputStream(this.fileLock.channel());
        ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
        byte[] bytes = new byte[4096];
        while ((bytesRead = channelInputStream.read(bytes)) != -1) {
            byteOutStream.write(bytes, 0, bytesRead);
        }
        channelInputStream.close();
        return byteOutStream.toByteArray();
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getFileCanonicalPath() throws IOException {
        return this.file.getCanonicalPath();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.jarName == null ? 0 : this.jarName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JarClassLoader other = (JarClassLoader)obj;
        return !(this.jarName == null ? other.jarName != null : !this.jarName.equals(other.jarName));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("jarName=").append(this.jarName);
        sb.append(",file=").append(this.file.getAbsolutePath());
        sb.append(",md5hash=").append(Arrays.toString(this.md5hash));
        sb.append(",fileLock=").append(this.fileLock);
        sb.append("}");
        return sb.toString();
    }

    static {
        channelLock = new ReentrantLock();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest = md;
    }

    private class ChannelInputStream
    extends InputStream {
        private final FileChannel fileChannel;
        private final ByteBuffer byteBuffer = ByteBuffer.allocateDirect(1);

        ChannelInputStream(FileChannel fileChannel) throws IOException {
            channelLock.lock();
            this.fileChannel = fileChannel;
            this.fileChannel.position(0L);
        }

        @Override
        public int read() throws IOException {
            this.byteBuffer.rewind();
            if (this.fileChannel.read(this.byteBuffer) <= 0) {
                return -1;
            }
            this.byteBuffer.rewind();
            return this.byteBuffer.get() & 0xFF;
        }

        @Override
        public void close() {
            channelLock.unlock();
        }
    }
}

