/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;

public class JarDeployer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogService.getLogger();
    public static final String JAR_PREFIX = "vf.gf#";
    private static final Lock lock = new ReentrantLock();
    public static final Pattern versionedPattern = Pattern.compile("^(.*)#(\\d++)$");
    private final File deployDirectory;

    public JarDeployer() {
        this.deployDirectory = new File(System.getProperty("user.dir"));
    }

    public JarDeployer(File deployDirectory) {
        this.deployDirectory = deployDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPreviouslyDeployedJars() {
        ArrayList<JarClassLoader> jarClassLoaders = new ArrayList<JarClassLoader>();
        lock.lock();
        try {
            try {
                this.verifyWritableDeployDirectory();
                Set<String> jarNames = this.findDistinctDeployedJars();
                if (!jarNames.isEmpty()) {
                    for (String jarName : jarNames) {
                        JarClassLoader jarClassLoader;
                        File[] jarFiles;
                        block15: {
                            jarFiles = this.findSortedOldVersionsOfJar(jarName);
                            if (jarFiles.length == 0) continue;
                            jarClassLoader = this.findJarClassLoader(jarName);
                            try {
                                byte[] jarBytes = this.getJarContent(jarFiles[0]);
                                if (!JarClassLoader.isValidJarContent(jarBytes)) {
                                    logger.warn("Invalid JAR file found and deleted: {}", jarFiles[0].getAbsolutePath());
                                    jarFiles[0].delete();
                                } else if (jarClassLoader == null || !jarClassLoader.getFileName().equals(jarFiles[0].getName())) {
                                    jarClassLoader = new JarClassLoader(jarFiles[0], jarName, jarBytes);
                                    ClassPathLoader.getLatest().addOrReplaceAndSetLatest(jarClassLoader);
                                    jarClassLoaders.add(jarClassLoader);
                                }
                            }
                            catch (IOException ioex) {
                                if (!logger.isDebugEnabled()) break block15;
                                logger.debug("Failed attempt to use JAR to create JarClassLoader for: {}", jarName);
                            }
                        }
                        for (File jarFile : jarFiles) {
                            if (!jarFile.exists() || jarClassLoader != null && jarClassLoader.getFileName().equals(jarFile.getName())) continue;
                            this.attemptFileLockAndDelete(jarFile);
                        }
                    }
                }
                for (JarClassLoader jarClassLoader : jarClassLoaders) {
                    jarClassLoader.loadClassesAndRegisterFunctions();
                }
            }
            catch (VirtualMachineError e) {
                SystemFailure.initiateFailure(e);
                throw e;
            }
            catch (Throwable th) {
                SystemFailure.checkFailure();
                logger.error("Error when attempting to deploy JAR files on load.", th);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JarClassLoader[] deploy(String[] jarNames, byte[][] jarBytes) throws IOException, ClassNotFoundException {
        JarClassLoader[] jarClassLoaders = new JarClassLoader[jarNames.length];
        this.verifyWritableDeployDirectory();
        lock.lock();
        try {
            int i;
            for (i = 0; i < jarNames.length; ++i) {
                if (JarClassLoader.isValidJarContent(jarBytes[i])) continue;
                throw new IllegalArgumentException("File does not contain valid JAR content: " + jarNames[i]);
            }
            for (i = 0; i < jarNames.length; ++i) {
                jarClassLoaders[i] = this.deployWithoutRegistering(jarNames[i], jarBytes[i]);
            }
            for (JarClassLoader jarClassLoader : jarClassLoaders) {
                if (jarClassLoader == null) continue;
                jarClassLoader.loadClassesAndRegisterFunctions();
            }
        }
        finally {
            lock.unlock();
        }
        return jarClassLoaders;
    }

    private JarClassLoader deployWithoutRegistering(String jarName, byte[] jarBytes) throws IOException {
        JarClassLoader oldJarClassLoader = this.findJarClassLoader(jarName);
        boolean isDebugEnabled = logger.isDebugEnabled();
        if (isDebugEnabled) {
            logger.debug("Deploying {}: {}", jarName, oldJarClassLoader == null ? ": not yet deployed" : ": already deployed as " + oldJarClassLoader.getFileCanonicalPath());
        }
        if (oldJarClassLoader != null && oldJarClassLoader.hasSameContent(jarBytes)) {
            return null;
        }
        JarClassLoader newJarClassLoader = null;
        do {
            File[] oldJarFiles = this.findSortedOldVersionsOfJar(jarName);
            try {
                File nextVersionJarFile;
                if (oldJarFiles.length == 0) {
                    if (isDebugEnabled) {
                        logger.debug("There were no pre-existing versions for JAR: {}", jarName);
                    }
                    if (this.writeJarBytesToFile(nextVersionJarFile = this.getNextVersionJarFile(jarName), jarBytes)) {
                        newJarClassLoader = new JarClassLoader(nextVersionJarFile, jarName, jarBytes);
                        if (isDebugEnabled) {
                            logger.debug("Successfully created initial JarClassLoader at file: {}", nextVersionJarFile.getAbsolutePath());
                        }
                    } else if (isDebugEnabled) {
                        logger.debug("Unable to write contents for first version of JAR to file: {}", nextVersionJarFile.getAbsolutePath());
                    }
                } else if (this.doesFileMatchBytes(oldJarFiles[0], jarBytes)) {
                    if (isDebugEnabled) {
                        logger.debug("A version on disk was an exact match for the JAR being deployed: {}", oldJarFiles[0].getAbsolutePath());
                    }
                    newJarClassLoader = new JarClassLoader(oldJarFiles[0], jarName, jarBytes);
                    if (isDebugEnabled) {
                        logger.debug("Successfully reused JAR to create JarClassLoader from file: {}", oldJarFiles[0].getAbsolutePath());
                    }
                } else {
                    if (isDebugEnabled) {
                        logger.debug("Need to create a new version for JAR: {}", jarName);
                    }
                    if (this.writeJarBytesToFile(nextVersionJarFile = this.getNextVersionJarFile(oldJarFiles[0].getName()), jarBytes)) {
                        newJarClassLoader = new JarClassLoader(nextVersionJarFile, jarName, jarBytes);
                        if (isDebugEnabled) {
                            logger.debug("Successfully created next JarClassLoader at file: {}", nextVersionJarFile.getAbsolutePath());
                        }
                    } else if (isDebugEnabled) {
                        logger.debug("Unable to write contents for next version of JAR to file: {}", nextVersionJarFile.getAbsolutePath());
                    }
                }
            }
            catch (IOException ioex) {
                logger.info("Failed attempt to use JAR to create JarClassLoader for: {} : {}", jarName, ioex.getMessage());
            }
            if (!isDebugEnabled) continue;
            if (newJarClassLoader == null) {
                logger.debug("Unable to determine a JAR file location, will loop and try again: {}", jarName);
                continue;
            }
            logger.debug("Exiting loop for JarClassLoader creation using file: {}", newJarClassLoader.getFileName());
        } while (newJarClassLoader == null);
        ClassPathLoader.getLatest().addOrReplaceAndSetLatest(newJarClassLoader);
        if (oldJarClassLoader != null) {
            this.attemptFileLockAndDelete(new File(this.deployDirectory, oldJarClassLoader.getFileName()));
        }
        return newJarClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String undeploy(String jarName) throws IOException {
        JarClassLoader jarClassLoader = null;
        this.verifyWritableDeployDirectory();
        lock.lock();
        try {
            jarClassLoader = this.findJarClassLoader(jarName);
            if (jarClassLoader == null) {
                throw new IllegalArgumentException("JAR not deployed");
            }
            ClassPathLoader.getLatest().removeAndSetLatest(jarClassLoader);
            this.attemptFileLockAndDelete(new File(this.deployDirectory, jarClassLoader.getFileName()));
            String string = jarClassLoader.getFileCanonicalPath();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    public List<JarClassLoader> findJarClassLoaders() {
        ArrayList<JarClassLoader> returnList = new ArrayList<JarClassLoader>();
        Collection<ClassLoader> classLoaders = ClassPathLoader.getLatest().getClassLoaders();
        for (ClassLoader classLoader : classLoaders) {
            if (!(classLoader instanceof JarClassLoader)) continue;
            returnList.add((JarClassLoader)classLoader);
        }
        return returnList;
    }

    public void suspendAll() {
        lock.lock();
    }

    public void resumeAll() {
        lock.unlock();
    }

    private File getNextVersionJarFile(String latestJarName) {
        Matcher matcher = versionedPattern.matcher(latestJarName);
        String newFileName = matcher.find() ? matcher.group(1) + "#" + (Integer.parseInt(matcher.group(2)) + 1) : JAR_PREFIX + latestJarName + "#1";
        if (logger.isDebugEnabled()) {
            logger.debug("Next version file name will be: {}", newFileName);
        }
        return new File(this.deployDirectory, newFileName);
    }

    private boolean writeJarBytesToFile(File file, byte[] jarBytes) {
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            if (file.createNewFile()) {
                if (isDebugEnabled) {
                    logger.debug("Successfully created new JAR file: {}", file.getAbsolutePath());
                }
                FileOutputStream outStream = new FileOutputStream(file);
                ((OutputStream)outStream).write(jarBytes);
                ((OutputStream)outStream).close();
                return true;
            }
            return this.doesFileMatchBytes(file, jarBytes);
        }
        catch (IOException ioex) {
            if (isDebugEnabled) {
                logger.debug("IOException while trying to write JAR content to file: {}", (Throwable)ioex);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesFileMatchBytes(File file, byte[] bytes) throws IOException {
        String absolutePath = file.getAbsolutePath();
        boolean keepTrying = true;
        boolean isDebugEnabled = logger.isDebugEnabled();
        while (file.length() < (long)bytes.length && keepTrying) {
            if (isDebugEnabled) {
                logger.debug("Loop waiting for another to write file: {}", absolutePath);
            }
            long startingFileLength = file.length();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
            if (startingFileLength != file.length()) continue;
            if (isDebugEnabled) {
                logger.debug("Done waiting for another to write file: {}", absolutePath);
            }
            keepTrying = false;
        }
        if (file.length() != (long)bytes.length) {
            if (isDebugEnabled) {
                logger.debug("Unmatching file length when waiting for another to write file: {}", absolutePath);
            }
            return false;
        }
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));){
            for (int index2 = 0; index2 < bytes.length; ++index2) {
                if ((byte)inStream.read() == bytes[index2]) continue;
                if (isDebugEnabled) {
                    logger.debug("Did not find a match when waiting for another to write file: {}", absolutePath);
                }
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void attemptFileLockAndDelete(File file) throws IOException {
        String absolutePath = file.getAbsolutePath();
        FileOutputStream fileOutputStream = new FileOutputStream(file, true);
        boolean isDebugEnabled = logger.isDebugEnabled();
        try {
            FileLock fileLock = null;
            try {
                block27: {
                    block26: {
                        fileLock = fileOutputStream.getChannel().tryLock();
                        if (fileLock == null) break block26;
                        if (isDebugEnabled) {
                            logger.debug("Tried and acquired exclusive lock for file: {}, w/ channel {}", absolutePath, fileLock.channel());
                        }
                        if (file.delete()) {
                            if (isDebugEnabled) {
                                logger.debug("Deleted file with name: {}", absolutePath);
                            }
                            break block27;
                        } else {
                            if (isDebugEnabled) {
                                logger.debug("Could not delete file, will truncate instead and delete on exit: {}", absolutePath);
                            }
                            file.deleteOnExit();
                            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                            try {
                                randomAccessFile.setLength(0L);
                            }
                            finally {
                                try {
                                    randomAccessFile.close();
                                }
                                catch (IOException ioex) {
                                    logger.error("Could not close file when attempting to set zero length", (Throwable)ioex);
                                }
                            }
                        }
                    }
                    if (isDebugEnabled) {
                        logger.debug("Will not delete file since exclusive lock unavailable: {}", absolutePath);
                    }
                }
                if (fileLock == null) return;
            }
            catch (Throwable throwable) {
                if (fileLock == null) throw throwable;
                try {
                    fileLock.release();
                    fileLock.channel().close();
                    if (!isDebugEnabled) throw throwable;
                    logger.debug("Released file lock for file: {}, w/ channel: {}", absolutePath, fileLock.channel());
                    throw throwable;
                }
                catch (IOException ioex) {
                    logger.error("Could not close channel on JAR lock file", (Throwable)ioex);
                }
                throw throwable;
            }
            try {
                fileLock.release();
                fileLock.channel().close();
                if (!isDebugEnabled) return;
                logger.debug("Released file lock for file: {}, w/ channel: {}", absolutePath, fileLock.channel());
                return;
            }
            catch (IOException ioex) {
                logger.error("Could not close channel on JAR lock file", (Throwable)ioex);
                return;
            }
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException ioex) {
                logger.error("Could not close output stream on JAR file", (Throwable)ioex);
            }
        }
    }

    int extractVersionFromFilename(File file) {
        Matcher matcher = versionedPattern.matcher(file.getAbsolutePath());
        matcher.find();
        return Integer.parseInt(matcher.group(2));
    }

    private Set<String> findDistinctDeployedJars() {
        final Pattern pattern = Pattern.compile("^vf.gf#(.*)#\\d++$");
        File[] oldFiles = this.deployDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return pattern.matcher(name).matches();
            }
        });
        HashSet<String> jarNames = new HashSet<String>();
        for (File oldFile : oldFiles) {
            Matcher matcher = pattern.matcher(oldFile.getName());
            matcher.find();
            jarNames.add(matcher.group(1));
        }
        return jarNames;
    }

    private File[] findSortedOldVersionsOfJar(String jarFilename) {
        final Pattern pattern = Pattern.compile("^vf.gf#" + jarFilename + "#\\d++$");
        File[] oldJarFiles = this.deployDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return pattern.matcher(name).matches();
            }
        });
        Arrays.sort(oldJarFiles, new Comparator<File>(){

            @Override
            public int compare(File file1, File file2) {
                int file1Version = JarDeployer.this.extractVersionFromFilename(file1);
                int file2Version = JarDeployer.this.extractVersionFromFilename(file2);
                return file2Version - file1Version;
            }
        });
        return oldJarFiles;
    }

    private JarClassLoader findJarClassLoader(String jarName) {
        Collection<ClassLoader> classLoaders = ClassPathLoader.getLatest().getClassLoaders();
        for (ClassLoader classLoader : classLoaders) {
            if (!(classLoader instanceof JarClassLoader) || !((JarClassLoader)classLoader).getJarName().equals(jarName)) continue;
            return (JarClassLoader)classLoader;
        }
        return null;
    }

    private void verifyWritableDeployDirectory() throws IOException {
        Exception exception = null;
        int tryCount = 0;
        do {
            try {
                if (this.deployDirectory.canWrite()) {
                    return;
                }
            }
            catch (Exception ex) {
                exception = ex;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException iex) {
                logger.error("Interrupted while testing writable deploy directory", (Throwable)iex);
            }
        } while (tryCount++ < 20);
        if (exception != null) {
            throw new IOException("Unable to write to deploy directory", exception);
        }
        throw new IOException("Unable to write to deploy directory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getJarContent(File jarFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(jarFile);){
            int bytesRead;
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[4096];
            while ((bytesRead = ((InputStream)inputStream).read(bytes)) != -1) {
                byteOutStream.write(bytes, 0, bytesRead);
            }
            byte[] byArray = byteOutStream.toByteArray();
            return byArray;
        }
    }
}

