/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

class LinuxProcFsStatistics {
    private static final int DEFAULT_PAGESIZE = 4096;
    private static final int OneMeg = 0x100000;
    private static final String pageSizeProperty = "gemfire.statistics.linux.pageSize";
    private static CpuStat cpuStatSingleton;
    private static int pageSize;
    private static int sys_cpus;
    private static boolean hasProcVmStat;
    private static boolean hasDiskStats;
    static SpaceTokenizer st;
    private static int nonPidFilesInProc;
    private static final String CPU_TOKEN = "cpu ";
    private static final String PAGE = "page ";
    private static final String SWAP = "swap ";
    private static final String CTXT = "ctxt ";
    private static final String PROCESSES = "processes ";
    private static final String PGPGIN = "pgpgin ";
    private static final String PGPGOUT = "pgpgout ";
    private static final String PSWPIN = "pswpin ";
    private static final String PSWPOUT = "pswpout ";

    private LinuxProcFsStatistics() {
    }

    static int init() {
        nonPidFilesInProc = LinuxProcFsStatistics.getNumberOfNonProcessProcFiles();
        sys_cpus = Runtime.getRuntime().availableProcessors();
        pageSize = Integer.getInteger(pageSizeProperty, 4096);
        cpuStatSingleton = new CpuStat();
        hasProcVmStat = new File("/proc/vmstat").exists();
        hasDiskStats = new File("/proc/diskstats").exists();
        st = new SpaceTokenizer();
        return 0;
    }

    static void close() {
        cpuStatSingleton = null;
        st = null;
    }

    static void readyRefresh() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshProcess(int pid, int[] ints, long[] longs, double[] doubles) {
        if (pid == 0) {
            return;
        }
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            File file = new File("/proc/" + pid + "/stat");
            isr = new InputStreamReader(new FileInputStream(file));
            br = new BufferedReader(isr, 2048);
            String line = br.readLine();
            if (line == null) {
                return;
            }
            st.setString(line);
            st.skipTokens(22);
            ints[0] = (int)(st.nextTokenAsLong() / 0x100000L);
            ints[1] = (int)(st.nextTokenAsLong() * (long)pageSize / 0x100000L);
        }
        catch (NoSuchElementException nsee) {
        }
        catch (IOException ioe) {
        }
        finally {
            st.releaseResources();
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void refreshSystem(int[] ints, long[] longs, double[] doubles) {
        ints[14] = LinuxProcFsStatistics.getProcessCount();
        ints[11] = sys_cpus;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(new FileInputStream("/proc/stat"));
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.startsWith(CPU_TOKEN)) {
                        int[] cpuData = cpuStatSingleton.calculateStats(line);
                        ints[4] = cpuData[CPU.IDLE.ordinal()];
                        ints[5] = cpuData[CPU.NICE.ordinal()];
                        ints[6] = cpuData[CPU.SYSTEM.ordinal()];
                        ints[7] = cpuData[CPU.USER.ordinal()];
                        ints[8] = cpuData[CPU.IOWAIT.ordinal()];
                        ints[9] = cpuData[CPU.IRQ.ordinal()];
                        ints[10] = cpuData[CPU.SOFTIRQ.ordinal()];
                        ints[3] = 100 - cpuData[CPU.IDLE.ordinal()];
                        ints[18] = cpuData[CPU.OTHER.ordinal()] + cpuData[CPU.SYSTEM.ordinal()] + cpuData[CPU.IOWAIT.ordinal()] + cpuData[CPU.IRQ.ordinal()] + cpuData[CPU.SOFTIRQ.ordinal()];
                        continue;
                    }
                    if (!hasProcVmStat && line.startsWith(PAGE)) {
                        int secondIndex = line.indexOf(" ", PAGE.length());
                        longs[13] = SpaceTokenizer.parseAsLong(line.substring(PAGE.length(), secondIndex));
                        longs[14] = SpaceTokenizer.parseAsLong(line.substring(secondIndex + 1));
                        continue;
                    }
                    if (!hasProcVmStat && line.startsWith(SWAP)) {
                        int secondIndex = line.indexOf(" ", SWAP.length());
                        longs[15] = SpaceTokenizer.parseAsLong(line.substring(SWAP.length(), secondIndex));
                        longs[16] = SpaceTokenizer.parseAsLong(line.substring(secondIndex + 1));
                        continue;
                    }
                    if (line.startsWith(CTXT)) {
                        longs[11] = SpaceTokenizer.parseAsLong(line.substring(CTXT.length()));
                        continue;
                    }
                    if (!line.startsWith(PROCESSES)) continue;
                    longs[12] = SpaceTokenizer.parseAsInt(line.substring(PROCESSES.length()));
                }
                catch (NoSuchElementException nsee) {}
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
        LinuxProcFsStatistics.getLoadAvg(doubles);
        LinuxProcFsStatistics.getMemInfo(ints);
        LinuxProcFsStatistics.getDiskStats(longs);
        LinuxProcFsStatistics.getNetStats(longs);
        if (hasProcVmStat) {
            LinuxProcFsStatistics.getVmStats(longs);
        }
        st.releaseResources();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getLoadAvg(double[] doubles) {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(new FileInputStream("/proc/loadavg"));
            br = new BufferedReader(isr, 512);
            String line = br.readLine();
            if (line == null) {
                return;
            }
            st.setString(line);
            doubles[0] = st.nextTokenAsDouble();
            doubles[2] = st.nextTokenAsDouble();
            doubles[1] = st.nextTokenAsDouble();
        }
        catch (NoSuchElementException nsee) {
        }
        catch (IOException ioe) {
        }
        finally {
            st.releaseResources();
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getMemInfo(int[] ints) {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(new FileInputStream("/proc/meminfo"));
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                try {
                    if (line.startsWith("MemTotal: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[13] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("MemFree: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[12] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("SharedMem: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[2] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("Buffers: ")) {
                        st.setString(line);
                        st.nextToken();
                        ints[1] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("SwapTotal: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[0] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("SwapFree: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[15] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("Cached: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[16] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (line.startsWith("Dirty: ")) {
                        st.setString(line);
                        st.skipToken();
                        ints[17] = (int)(st.nextTokenAsLong() / 1024L);
                        continue;
                    }
                    if (!line.startsWith("Inact_dirty: ")) continue;
                    st.setString(line);
                    st.skipToken();
                    ints[17] = (int)(st.nextTokenAsLong() / 1024L);
                }
                catch (NoSuchElementException nsee) {}
            }
        }
        catch (IOException ioe) {
        }
        finally {
            st.releaseResources();
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getNetStats(long[] longs) {
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(new FileInputStream("/proc/net/dev"));
            br = new BufferedReader(isr);
            br.readLine();
            br.readLine();
            long lo_recv_packets = 0L;
            long lo_recv_bytes = 0L;
            long other_recv_packets = 0L;
            long other_recv_bytes = 0L;
            long other_recv_errs = 0L;
            long other_recv_drop = 0L;
            long other_xmit_packets = 0L;
            long other_xmit_bytes = 0L;
            long other_xmit_errs = 0L;
            long other_xmit_drop = 0L;
            long other_xmit_colls = 0L;
            String line = null;
            while ((line = br.readLine()) != null) {
                int index2 = line.indexOf(":");
                boolean isloopback = line.indexOf("lo:") != -1;
                st.setString(line.substring(index2 + 1).trim());
                long recv_bytes = st.nextTokenAsLong();
                long recv_packets = st.nextTokenAsLong();
                long recv_errs = st.nextTokenAsLong();
                long recv_drop = st.nextTokenAsLong();
                st.skipTokens(4);
                long xmit_bytes = st.nextTokenAsLong();
                long xmit_packets = st.nextTokenAsLong();
                long xmit_errs = st.nextTokenAsLong();
                long xmit_drop = st.nextTokenAsLong();
                st.skipToken();
                long xmit_colls = st.nextTokenAsLong();
                if (isloopback) {
                    lo_recv_packets = recv_packets;
                    lo_recv_bytes = recv_bytes;
                } else {
                    other_recv_packets += recv_packets;
                    other_recv_bytes += recv_bytes;
                }
                other_recv_errs += recv_errs;
                other_recv_drop += recv_drop;
                if (!isloopback) {
                    other_xmit_packets += xmit_packets;
                    other_xmit_bytes += xmit_bytes;
                }
                other_xmit_errs += xmit_errs;
                other_xmit_drop += xmit_drop;
                other_xmit_colls += xmit_colls;
            }
            longs[0] = lo_recv_packets;
            longs[1] = lo_recv_bytes;
            longs[2] = other_recv_packets;
            longs[3] = other_recv_bytes;
            longs[4] = other_recv_errs;
            longs[5] = other_recv_drop;
            longs[6] = other_xmit_packets;
            longs[7] = other_xmit_bytes;
            longs[8] = other_xmit_errs;
            longs[9] = other_xmit_drop;
            longs[10] = other_xmit_colls;
        }
        catch (NoSuchElementException nsee) {
        }
        catch (IOException ioe) {
        }
        finally {
            st.releaseResources();
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getDiskStats(long[] longs) {
        InputStreamReader isr = null;
        BufferedReader br = null;
        String line = null;
        try {
            isr = hasDiskStats ? new InputStreamReader(new FileInputStream("/proc/diskstats")) : new InputStreamReader(new FileInputStream("/proc/partitions"));
            br = new BufferedReader(isr);
            long readsCompleted = 0L;
            long readsMerged = 0L;
            long sectorsRead = 0L;
            long timeReading = 0L;
            long writesCompleted = 0L;
            long writesMerged = 0L;
            long sectorsWritten = 0L;
            long timeWriting = 0L;
            long iosInProgress = 0L;
            long timeIosInProgress = 0L;
            long ioTime = 0L;
            if (!hasDiskStats) {
                br.readLine();
                br.readLine();
            }
            while ((line = br.readLine()) != null) {
                st.setString(line);
                String tok = st.nextToken();
                if (tok.length() == 0 || Character.isWhitespace(tok.charAt(0))) {
                    tok = st.nextToken();
                }
                tok = st.nextToken();
                tok = st.nextToken();
                if (!hasDiskStats) {
                    tok = st.nextToken();
                }
                if (Character.isDigit(tok.charAt(tok.length() - 1))) continue;
                long tmp_readsCompleted = st.nextTokenAsLong();
                long tmp_readsMerged = st.nextTokenAsLong();
                long tmp_sectorsRead = st.nextTokenAsLong();
                long tmp_timeReading = st.nextTokenAsLong();
                if (!st.hasMoreTokens()) continue;
                long tmp_writesCompleted = st.nextTokenAsLong();
                long tmp_writesMerged = st.nextTokenAsLong();
                long tmp_sectorsWritten = st.nextTokenAsLong();
                long tmp_timeWriting = st.nextTokenAsLong();
                long tmp_iosInProgress = st.nextTokenAsLong();
                long tmp_timeIosInProgress = st.nextTokenAsLong();
                long tmp_ioTime = st.nextTokenAsLong();
                readsCompleted += tmp_readsCompleted;
                readsMerged += tmp_readsMerged;
                sectorsRead += tmp_sectorsRead;
                timeReading += tmp_timeReading;
                writesCompleted += tmp_writesCompleted;
                writesMerged += tmp_writesMerged;
                sectorsWritten += tmp_sectorsWritten;
                timeWriting += tmp_timeWriting;
                iosInProgress += tmp_iosInProgress;
                timeIosInProgress += tmp_timeIosInProgress;
                ioTime += tmp_ioTime;
            }
            int SECTOR_SIZE = 512;
            longs[17] = readsCompleted;
            longs[18] = readsMerged;
            longs[19] = sectorsRead * 512L;
            longs[20] = timeReading;
            longs[21] = writesCompleted;
            longs[22] = writesMerged;
            longs[23] = sectorsWritten * 512L;
            longs[24] = timeWriting;
            longs[25] = iosInProgress;
            longs[26] = timeIosInProgress;
            longs[27] = ioTime;
        }
        catch (NoSuchElementException nsee) {
        }
        catch (IOException ioe) {
        }
        finally {
            st.releaseResources();
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getVmStats(long[] longs) {
        assert (hasProcVmStat) : "getVmStats called when hasVmStat was false";
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            isr = new InputStreamReader(new FileInputStream("/proc/vmstat"));
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(PGPGIN)) {
                    longs[13] = SpaceTokenizer.parseAsLong(line.substring(PGPGIN.length()));
                    continue;
                }
                if (line.startsWith(PGPGOUT)) {
                    longs[14] = SpaceTokenizer.parseAsLong(line.substring(PGPGOUT.length()));
                    continue;
                }
                if (line.startsWith(PSWPIN)) {
                    longs[15] = SpaceTokenizer.parseAsLong(line.substring(PSWPIN.length()));
                    continue;
                }
                if (!line.startsWith(PSWPOUT)) continue;
                longs[16] = SpaceTokenizer.parseAsLong(line.substring(PSWPOUT.length()));
            }
        }
        catch (NoSuchElementException nsee) {
        }
        catch (IOException ioe) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private static int getNumberOfNonProcessProcFiles() {
        File proc = new File("/proc");
        String[] procFiles = proc.list();
        int count = 0;
        if (procFiles != null) {
            for (String filename : procFiles) {
                char c2;
                char c = filename.charAt(0);
                if (Character.isDigit(c) || c == '.' && filename.length() > 1 && Character.isDigit(c2 = filename.charAt(1))) continue;
                ++count;
            }
        }
        return count;
    }

    private static int getProcessCount() {
        File proc = new File("/proc");
        String[] procFiles = proc.list();
        if (procFiles == null) {
            return 0;
        }
        return procFiles.length - nonPidFilesInProc;
    }

    private static class SpaceTokenizer {
        private String str;
        private char[] rawChars;
        private int beginIdx;
        private int endIdx = -1;
        private int nextIdx = -1;

        protected SpaceTokenizer() {
        }

        protected void releaseResources() {
            this.str = null;
            this.rawChars = null;
            this.endIdx = -1;
            this.nextIdx = -1;
        }

        private void nextIdx() {
            int origin = this.nextIdx;
            if (this.endIdx == this.rawChars.length || this.beginIdx == -1) {
                this.endIdx = -1;
                this.nextIdx = -1;
                return;
            }
            this.endIdx = -1;
            this.nextIdx = -1;
            for (int i = origin + 1; i < this.rawChars.length; ++i) {
                char c = this.rawChars[i];
                if (c == ' ' || c == '\t' || c == '\n' || c == '\r') {
                    if (this.endIdx != -1) continue;
                    this.endIdx = i;
                    continue;
                }
                if (this.endIdx == -1) continue;
                this.nextIdx = i;
                return;
            }
            if (this.endIdx == -1) {
                this.endIdx = this.rawChars.length;
            }
        }

        protected boolean hasMoreTokens() {
            return this.endIdx != -1;
        }

        protected void setString(String data) {
            this.str = data;
            this.rawChars = new char[this.str.length()];
            this.str.getChars(0, this.str.length(), this.rawChars, 0);
            this.beginIdx = 0;
            this.endIdx = -1;
            this.nextIdx = -1;
            this.nextIdx();
        }

        protected boolean skipToken() {
            if (this.hasMoreTokens()) {
                this.beginIdx = this.nextIdx;
                this.nextIdx();
                return true;
            }
            return false;
        }

        protected String nextToken() {
            if (this.hasMoreTokens()) {
                String ret = this.str.substring(this.beginIdx, this.endIdx);
                this.beginIdx = this.nextIdx;
                this.nextIdx();
                return ret;
            }
            throw new NoSuchElementException();
        }

        protected String peekToken() {
            if (this.hasMoreTokens()) {
                return this.str.substring(this.beginIdx, this.endIdx);
            }
            throw new NoSuchElementException();
        }

        protected void skipTokens(int numberToSkip) {
            int remaining = numberToSkip + 1;
            while (--remaining > 0 && this.skipToken()) {
            }
        }

        protected static long parseAsLong(String number) {
            long l = 0L;
            try {
                l = Long.parseLong(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return l;
        }

        protected static int parseAsInt(String number) {
            int i = 0;
            try {
                i = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return i;
        }

        protected int nextTokenAsInt() {
            int i = 0;
            try {
                i = Integer.parseInt(this.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return i;
        }

        protected long nextTokenAsLong() {
            long l = 0L;
            try {
                l = Long.parseLong(this.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return l;
        }

        protected double nextTokenAsDouble() {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return d;
        }
    }

    private static class CpuStat {
        private static boolean lastCpuStatsInvalid;
        private static List<Long> lastCpuStats;

        public CpuStat() {
            lastCpuStatsInvalid = true;
        }

        public int[] calculateStats(String newStatLine) {
            int i;
            st.setString(newStatLine);
            st.skipToken();
            int MAX_CPU_STATS = CPU.values().length;
            ArrayList<Long> newStats = new ArrayList<Long>(8);
            ArrayList<Long> diffs = new ArrayList<Long>(8);
            long total_change = 0L;
            int actualCpuStats = 0;
            long unaccountedCpuUtilization = 0L;
            while (st.hasMoreTokens()) {
                newStats.add(st.nextTokenAsLong());
                ++actualCpuStats;
            }
            if (lastCpuStatsInvalid) {
                lastCpuStats = newStats;
                lastCpuStatsInvalid = false;
                for (i = 0; i < MAX_CPU_STATS; ++i) {
                    diffs.add(0L);
                }
                diffs.set(CPU.IDLE.ordinal(), 100L);
            } else {
                for (i = 0; i < actualCpuStats; ++i) {
                    diffs.add((Long)newStats.get(i) - lastCpuStats.get(i));
                    total_change += ((Long)diffs.get(i)).longValue();
                    lastCpuStats.set(i, (Long)newStats.get(i));
                }
                if (total_change == 0L) {
                    total_change = 1L;
                }
                for (i = 0; i < MAX_CPU_STATS; ++i) {
                    if (i >= actualCpuStats) continue;
                    diffs.set(i, (Long)diffs.get(i) * 100L / total_change);
                }
                for (i = MAX_CPU_STATS; i < actualCpuStats; ++i) {
                    unaccountedCpuUtilization += (Long)diffs.get(i) * 100L / total_change;
                }
            }
            int[] ret = new int[MAX_CPU_STATS];
            for (int i2 = 0; i2 < MAX_CPU_STATS; ++i2) {
                if (i2 >= actualCpuStats) continue;
                ret[i2] = ((Long)diffs.get(i2)).intValue();
            }
            int n = CPU.OTHER.ordinal();
            ret[n] = ret[n] + (int)unaccountedCpuUtilization;
            return ret;
        }
    }

    private static enum CPU {
        USER,
        NICE,
        SYSTEM,
        IDLE,
        IOWAIT,
        IRQ,
        SOFTIRQ,
        OTHER;

    }
}

