/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.MigrationServer;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;

public class MigrationClient {
    static final boolean VERBOSE = MigrationServer.VERBOSE;
    static final int VERSION = 551;
    protected static final int CODE_ERROR = 0;
    protected static final int CODE_ENTRY = 1;
    protected static final int CODE_COMPLETED = 2;
    private InetAddress serverAddress;
    private int port;
    private DistributedSystem distributedSystem;
    private File cacheXmlFile;
    private Cache cache;
    private Socket server;
    private int serverVersion;
    private DataInputStream dis;
    private DataOutputStream dos;

    public static void main(String[] args) throws Exception {
        int argIdx = 0;
        String cacheXmlFileName = null;
        String regionName = null;
        String bindAddressName = null;
        int serverPort = 10533;
        if (args.length <= argIdx + 1) {
            System.err.println("MigrationClient regionName [cache-xml-file] [server-port] [server-address]");
            return;
        }
        regionName = args[argIdx++];
        cacheXmlFileName = args[argIdx++];
        if (args.length > argIdx) {
            serverPort = Integer.parseInt(args[argIdx++]);
        }
        if (args.length > argIdx) {
            bindAddressName = args[argIdx++];
        }
        MigrationClient instance = null;
        try {
            instance = new MigrationClient(cacheXmlFileName, bindAddressName, serverPort);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        instance.createDistributedSystem();
        instance.createCache();
        instance.getRegion(regionName);
    }

    public MigrationClient(String bindAddressName, int serverPort) {
        this.port = serverPort;
        try {
            this.serverAddress = InetAddress.getByName(bindAddressName);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error - bind address cannot be resolved: '" + bindAddressName + "'");
        }
    }

    private MigrationClient(String cacheXmlFileName, String bindAddressName, int serverPort) {
        this(bindAddressName, serverPort);
        this.cacheXmlFile = new File(cacheXmlFileName);
        if (!this.cacheXmlFile.exists()) {
            System.err.println("Warning - file not found in local directory: '" + cacheXmlFileName + "'");
        }
    }

    private void createDistributedSystem() throws Exception {
        Properties dsProps = new Properties();
        if (System.getProperty("gemfire.mcast-port") == null && System.getProperty("gemfire.locators") == null) {
            dsProps.put("mcast-port", "0");
        }
        dsProps.put("log-file", "migrationClient.log");
        if (this.cacheXmlFile != null) {
            dsProps.put("cache-xml-file", this.cacheXmlFile.getName());
        }
        this.distributedSystem = DistributedSystem.connect(dsProps);
    }

    private void createCache() throws Exception {
        if (this.distributedSystem == null) {
            this.distributedSystem = InternalDistributedSystem.getConnectedInstance();
        }
        this.cache = CacheFactory.create(this.distributedSystem);
    }

    private void initDSAndCache() {
        if (this.distributedSystem == null) {
            this.distributedSystem = InternalDistributedSystem.getConnectedInstance();
        }
        if (this.cache == null) {
            this.cache = GemFireCacheImpl.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion(String regionName) throws IOException, ClassNotFoundException {
        this.initDSAndCache();
        Region<Object, Object> region = null;
        region = this.cache.getRegion(regionName);
        try {
            this.connectToServer();
            if (this.serverVersion != 551) {
                System.out.println("Don't know how to deal with version " + this.serverVersion);
                throw new IOException("Server has incompatible version of MigrationServer");
            }
            this.dos.writeShort(1);
            this.dos.writeUTF(regionName);
            this.dos.flush();
            boolean done = false;
            while (!done) {
                int responseCode = -1;
                try {
                    responseCode = this.dis.readShort();
                }
                catch (EOFException e) {
                    // empty catch block
                }
                switch (responseCode) {
                    case -1: {
                        throw new IOException("Server socket was closed while receiving entries");
                    }
                    case 2: {
                        done = true;
                        break;
                    }
                    case 0: {
                        String errorString = this.dis.readUTF();
                        System.err.println("Server responded with error: '" + errorString + "'");
                        throw new IOException(errorString);
                    }
                    case 1: {
                        Object key2 = new ObjectInputStream(this.server.getInputStream()).readObject();
                        Object value2 = new ObjectInputStream(this.server.getInputStream()).readObject();
                        if (VERBOSE) {
                            System.out.println("received " + key2);
                        }
                        region.put(key2, value2);
                    }
                }
            }
        }
        finally {
            if (this.server != null && !this.server.isClosed()) {
                this.server.close();
            }
        }
        return region;
    }

    private void connectToServer() throws IOException {
        this.server = new Socket();
        InetSocketAddress addr = this.serverAddress != null ? new InetSocketAddress(this.serverAddress, this.port) : new InetSocketAddress(SocketCreator.getLocalHost(), this.port);
        if (VERBOSE) {
            System.out.println("connecting to " + addr);
        }
        this.server.connect(addr);
        this.dos = new DataOutputStream(this.server.getOutputStream());
        this.dos.writeShort(551);
        this.dis = new DataInputStream(this.server.getInputStream());
        this.serverVersion = this.dis.readShort();
    }
}

