/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class OneTaskOnlyExecutor {
    private final ScheduledExecutorService ex;
    private ScheduledFuture<?> future = null;
    private ConflatedTaskListener listener;

    public OneTaskOnlyExecutor(ScheduledExecutorService ex) {
        this(ex, new ConflatedTaskListenerAdapter());
    }

    public OneTaskOnlyExecutor(ScheduledExecutorService ex, ConflatedTaskListener listener) {
        this.ex = ex;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        OneTaskOnlyExecutor oneTaskOnlyExecutor = this;
        synchronized (oneTaskOnlyExecutor) {
            if (this.future == null || this.future.isCancelled() || this.future.isDone() || this.future.getDelay(unit) > delay) {
                if (this.future != null && !this.future.isDone()) {
                    this.future.cancel(false);
                    this.listener.taskDropped();
                }
                this.future = this.ex.schedule(new DelegatingRunnable(runnable), delay, unit);
            } else {
                this.listener.taskDropped();
            }
        }
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ScheduledFuture<?> schedule(Callable<T> callable, long delay, TimeUnit unit) {
        OneTaskOnlyExecutor oneTaskOnlyExecutor = this;
        synchronized (oneTaskOnlyExecutor) {
            if (this.future == null || this.future.isCancelled() || this.future.isDone() || this.future.getDelay(unit) > delay) {
                if (this.future != null && !this.future.isDone()) {
                    this.future.cancel(false);
                    this.listener.taskDropped();
                }
                this.future = this.ex.schedule(new DelegatingCallable<T>(callable), delay, unit);
            } else {
                this.listener.taskDropped();
            }
        }
        return this.future;
    }

    public void purge() {
        ((ScheduledThreadPoolExecutor)this.ex).purge();
    }

    public static class ConflatedTaskListenerAdapter
    implements ConflatedTaskListener {
        @Override
        public void taskDropped() {
        }
    }

    public static interface ConflatedTaskListener {
        public void taskDropped();
    }

    private class DelegatingCallable<T>
    implements Callable<T> {
        private final Callable<T> callable;

        public DelegatingCallable(Callable<T> callable) {
            this.callable = callable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            OneTaskOnlyExecutor oneTaskOnlyExecutor = OneTaskOnlyExecutor.this;
            synchronized (oneTaskOnlyExecutor) {
                OneTaskOnlyExecutor.this.future = null;
            }
            return this.callable.call();
        }
    }

    private class DelegatingRunnable
    implements Runnable {
        private final Runnable runnable;

        public DelegatingRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OneTaskOnlyExecutor oneTaskOnlyExecutor = OneTaskOnlyExecutor.this;
            synchronized (oneTaskOnlyExecutor) {
                OneTaskOnlyExecutor.this.future = null;
            }
            this.runnable.run();
        }
    }
}

