/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.internal.HostStatSampler;
import com.gemstone.gemfire.internal.StatSamplerStats;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.File;
import org.apache.logging.log4j.Logger;

public class SimpleStatSampler
extends HostStatSampler {
    private static final Logger logger = LogService.getLogger();
    public static final String ARCHIVE_FILE_NAME_PROPERTY = "stats.archive-file";
    public static final String FILE_SIZE_LIMIT_PROPERTY = "stats.file-size-limit";
    public static final String DISK_SPACE_LIMIT_PROPERTY = "stats.disk-space-limit";
    public static final String SAMPLE_RATE_PROPERTY = "stats.sample-rate";
    public static final String DEFAULT_ARCHIVE_FILE_NAME = "stats.gfs";
    public static final long DEFAULT_FILE_SIZE_LIMIT = 0L;
    public static final long DEFAULT_DISK_SPACE_LIMIT = 0L;
    public static final int DEFAULT_SAMPLE_RATE = 1000;
    private final File archiveFileName = new File(System.getProperty("stats.archive-file", "stats.gfs"));
    private final long archiveFileSizeLimit = Long.getLong("stats.file-size-limit", 0L) * 0x100000L;
    private final long archiveDiskSpaceLimit = Long.getLong("stats.disk-space-limit", 0L) * 0x100000L;
    private final int sampleRate = Integer.getInteger("stats.sample-rate", 1000);
    private final StatisticsManager sm;

    public SimpleStatSampler(CancelCriterion stopper, StatisticsManager sm) {
        super(stopper, new StatSamplerStats(sm, sm.getId()));
        this.sm = sm;
        logger.info(LogMarker.STATISTICS, LocalizedMessage.create(LocalizedStrings.SimpleStatSampler_STATSSAMPLERATE_0, this.getSampleRate()));
    }

    @Override
    protected void checkListeners() {
    }

    @Override
    public File getArchiveFileName() {
        return this.archiveFileName;
    }

    @Override
    public long getArchiveFileSizeLimit() {
        if (this.fileSizeLimitInKB()) {
            return this.archiveFileSizeLimit / 1024L;
        }
        return this.archiveFileSizeLimit;
    }

    @Override
    public long getArchiveDiskSpaceLimit() {
        if (this.fileSizeLimitInKB()) {
            return this.archiveDiskSpaceLimit / 1024L;
        }
        return this.archiveDiskSpaceLimit;
    }

    @Override
    public String getProductDescription() {
        return "Unknown product";
    }

    @Override
    protected StatisticsManager getStatisticsManager() {
        return this.sm;
    }

    @Override
    protected int getSampleRate() {
        return this.sampleRate;
    }

    @Override
    public boolean isSamplingEnabled() {
        return true;
    }
}

