/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.PureJavaMode;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class SmHelper {
    static final boolean pureMode = PureJavaMode.isPure();
    private static Map zeroArgConstructorCache = new HashMap();
    private static Map publicConstructorCache = new HashMap();

    public static int pointerSizeBytes() {
        if (pureMode) {
            throw new IllegalStateException(LocalizedStrings.SmHelper_POINTERSIZEBYTES_UNAVAILABLE_IN_PURE_MODE.toLocalizedString());
        }
        return SmHelper._pointerSizeBytes();
    }

    private static native int _pointerSizeBytes();

    private static native void _nanosleep(int var0);

    public static void nanosleep(long nanos) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (nanos <= 0L) {
            return;
        }
        if (nanos >= 1000000L) {
            Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
        } else if (pureMode) {
            Thread.yield();
        } else {
            SmHelper._nanosleep((int)nanos);
        }
    }

    public static String getNativeVersion() {
        if (pureMode) {
            return LocalizedStrings.SmHelper_NATIVE_CODE_UNAVAILABLE.toLocalizedString();
        }
        return SmHelper._getNativeVersion();
    }

    private static native String _getNativeVersion();

    public static String getSystemId() {
        if (pureMode) {
            return "pureJavaMode";
        }
        return SmHelper._getSystemId();
    }

    private static native String _getSystemId();

    public static Object allocateJOMObject(Class c, Class initClass) throws IllegalAccessException, InvalidClassException {
        if (c.isPrimitive()) {
            throw new InvalidClassException(LocalizedStrings.SmHelper_IS_PRIMITIVE.toLocalizedString(), c.getName());
        }
        if (initClass.isPrimitive()) {
            throw new InvalidClassException(LocalizedStrings.SmHelper_IS_PRIMITIVE.toLocalizedString(), initClass.getName());
        }
        if (!zeroArgConstructorCache.containsKey(initClass)) {
            try {
                initClass.getDeclaredConstructor(new Class[0]);
                if (Modifier.isPublic(initClass.getModifiers())) {
                    publicConstructorCache.put(initClass, Boolean.TRUE);
                }
                publicConstructorCache.put(initClass, Boolean.FALSE);
            }
            catch (NoSuchMethodException ex) {
                zeroArgConstructorCache.put(initClass, Boolean.FALSE);
                throw new NoSuchMethodError();
            }
        } else {
            Boolean b = (Boolean)zeroArgConstructorCache.get(initClass);
            if (!b.booleanValue()) {
                throw new NoSuchMethodError();
            }
        }
        return SmHelper._allocateJOMObject(c, initClass);
    }

    private static native Object _allocateJOMObject(Class var0, Class var1);

    public static native void _setObjectField(Object var0, Field var1, Object var2);
}

